package net.m3tte.tactical_imbuements.procedures;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.m3tte.tactical_imbuements.definitions.ImbuementDefinitions;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent.LivingTickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@EventBusSubscriber
public class TickProcedure {

   public static int defaultMaxTime = 600;


   @SubscribeEvent
   public static void onEntityTick(LivingTickEvent event) {
      LivingEntity living = event.getEntity();
      execute(event, living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_(), living);
   }

   public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
      execute((Event)null, world, x, y, z, entity);
   }

   private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
      if(!(entity instanceof LivingEntity)) {
         System.out.println(entity.getClass());
      }

      if(entity instanceof LivingEntity) {
         LivingEntity living = (LivingEntity)entity;
         oncePerHand(world);
      }
   }

   private static void oncePerHand(Consumer c) {
      c.accept(InteractionHand.MAIN_HAND);
      c.accept(InteractionHand.OFF_HAND);
   }

   private static void clearImbuement(LivingEntity entity, InteractionHand hand) {
      System.out.println(entity.m_9236_().m_5776_());
      ItemStack item = entity.m_21120_(hand);
      item.m_41749_("imbueCounter");
      item.m_41749_("maxImbueTime");
      item.m_41749_("imbueType");
   }

   private static LinkedList offsetCalculator(ItemStack item) {
      byte length = 3;
      if(item.m_204117_(ItemTags.create(new ResourceLocation("tactical_imbuements:length_medium")))) {
         length = 4;
      }

      if(item.m_204117_(ItemTags.create(new ResourceLocation("tactical_imbuements:length_long")))) {
         length = 5;
      }

      LinkedList offsets = new LinkedList();

      for(int i = 1; i < length + 1; ++i) {
         offsets.add(new Vec3(0.0D, -0.02D * (double)i, -0.3D * (double)i));
      }

      return offsets;
   }

   private static void doArmatureParticle(Joint j, LivingEntityPatch entityPatch, SimpleParticleType particle, float amount, Vec3 particleSpeed, LinkedList offsets) {
      Level l = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
      RandomSource r = l.f_46441_;

      for(float i = 1.0F; i <= 9.0F; i += 2.0F) {
         Pose middlePose = entityPatch.getAnimator().getPose((i + (float)r.m_188503_(3) - 1.0F) / 10.0F);
         Vec3 posMid = ((LivingEntity)entityPatch.getOriginal()).m_20318_((i + (float)r.m_188503_(3) - 1.0F) / 10.0F);
         OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)posMid.f_82479_, (float)posMid.f_82480_, (float)posMid.f_82481_).mulBack(OpenMatrix4f.createRotatorDeg(180.0F, Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix((i + (float)r.m_188503_(3) - 1.0F) / 10.0F)));
         OpenMatrix4f middleJointTf = entityPatch.getArmature().getBindedTransformFor(middlePose, j).mulFront(middleModelTf);
         Iterator var13 = offsets.iterator();

         while(var13.hasNext()) {
            Vec3 modifier = (Vec3)var13.next();
            if(r.m_188503_((int)(100.0F / amount)) < 40) {
               modifier = modifier.m_82520_((double)(r.m_188501_() * 0.2F) - 0.1D, (double)(r.m_188501_() * 0.2F) - 0.1D, (double)(r.m_188501_() * 0.2F) - 0.1D);
               Vec3 particlePos = OpenMatrix4f.transform(middleJointTf, modifier);
               l.m_7106_(particle, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleSpeed.f_82479_, particleSpeed.f_82480_, particleSpeed.f_82481_);
            }
         }
      }

   }

   private static void particleImbueEffectCheck(LivingEntity entity, InteractionHand hand, String imbueType) {
      LivingEntityPatch entitypatch = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, (Direction)null).orElse((Object)null);
      if(entitypatch != null) {
         if(entitypatch.getValidItemInHand(hand) != null) {
            Joint toolL = entitypatch.getArmature().searchJointByName("Tool_L");
            Joint toolR = entitypatch.getArmature().searchJointByName("Tool_R");
            if(hand == InteractionHand.MAIN_HAND) {
               if(toolR != null && imbueType.length() > 2) {
                  doArmatureParticle(toolR, entitypatch, trailParticleGetter(imbueType), particleAmount(imbueType), particleSpeed(imbueType), offsetCalculator(entity.m_21120_(hand)));
               }
            } else if(toolL != null && imbueType.length() > 2) {
               doArmatureParticle(toolL, entitypatch, trailParticleGetter(imbueType), particleAmount(imbueType), particleSpeed(imbueType), offsetCalculator(entity.m_21120_(hand)));
            }

         }
      }
   }

   private static SimpleParticleType trailParticleGetter(String type) {
      byte var2 = -1;
      switch(type.hashCode()) {
      case -1266402665:
         if(type.equals("freeze")) {
            var2 = 3;
         }
         break;
      case 97513267:
         if(type.equals("flame")) {
            var2 = 0;
         }
         break;
      case 109638365:
         if(type.equals("spark")) {
            var2 = 2;
         }
         break;
      case 112093629:
         if(type.equals("venom")) {
            var2 = 1;
         }
      }

      switch(var2) {
      case 0:
         return ImbuementDefinitions.FLAME.getEmitParticle();
      case 1:
         return ImbuementDefinitions.VENOM.getEmitParticle();
      case 2:
         return ImbuementDefinitions.SPARK.getEmitParticle();
      case 3:
         return ImbuementDefinitions.FREEZE.getEmitParticle();
      default:
         return null;
      }
   }

   private static Vec3 particleSpeed(String type) {
      Random r = new Random();
      byte var3 = -1;
      switch(type.hashCode()) {
      case 109638365:
         if(type.equals("spark")) {
            var3 = 0;
         }
      default:
         switch(var3) {
         case 0:
            return new Vec3(0.02D * (double)inverter(r), 0.02D * (double)inverter(r), 0.02D * (double)inverter(r));
         default:
            return new Vec3(0.0D, 0.0D, 0.0D);
         }
      }
   }

   private static float inverter(Random r) {
      return r.nextFloat() * 2.0F - 1.0F;
   }

   private static float particleAmount(String type) {
      byte var2 = -1;
      switch(type.hashCode()) {
      case -1266402665:
         if(type.equals("freeze")) {
            var2 = 1;
         }
         break;
      case 109638365:
         if(type.equals("spark")) {
            var2 = 2;
         }
         break;
      case 112093629:
         if(type.equals("venom")) {
            var2 = 0;
         }
      }

      switch(var2) {
      case 0:
      case 1:
         return 0.3F;
      case 2:
         return 0.6F;
      default:
         return 1.0F;
      }
   }

   // $FF: synthetic method
   private static void lambda$execute$0(LivingEntity living, Entity entity, LevelAccessor world, InteractionHand hand) {
      ItemStack handItem = living.m_21120_(hand);
      if(handItem.m_204117_(ItemTags.create(new ResourceLocation("tactical_imbuements:applicable")))) {
         double timeout = 0.0D;
         timeout += handItem.m_41784_().m_128459_("imbueCounter") - (double)entity.f_19797_;
         if(timeout > (double)(defaultMaxTime + 60) && !world.m_5776_()) {
            clearImbuement(living, hand);
         }

         if(handItem.m_41783_() != null) {
            String imbueType = handItem.m_41783_().m_128461_("imbueType");
            if(timeout > 1.0D && timeout < (double)(defaultMaxTime + 60)) {
               if(imbueType.length() > 2) {
                  particleImbueEffectCheck(living, hand, imbueType);
               }
            } else if((timeout > 0.0D || imbueType.length() > 2) && !world.m_5776_()) {
               clearImbuement(living, hand);
            }

         }
      }
   }

}
