package net.m3tte.tactical_imbuements.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import net.m3tte.tactical_imbuements.procedures.TickProcedure;
import net.m3tte.tactical_imbuements.renderer.GlintRenderers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin({ItemRenderer.class})
public abstract class ItemRendererMixin implements ResourceManagerReloadListener {

   @Redirect(
      at =          @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/renderer/entity/ItemRenderer;getFoilBufferDirect(Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/renderer/RenderType;ZZ)Lcom/mojang/blaze3d/vertex/VertexConsumer;"
         ),
      method = {"render"}
   )
   public VertexConsumer overlayRendererDirect(MultiBufferSource multiBuffer, RenderType p_115224_, boolean p_115225_, boolean p_115226_, ItemStack item, ItemDisplayContext context, boolean bool) {
      LocalPlayer localplayer = Minecraft.m_91087_().f_91074_;
      if(localplayer != null && item.m_41783_() != null) {
         int timeout = (int)item.m_41784_().m_128459_("imbueCounter") - localplayer.f_19797_;
         if(item.m_41784_().m_128461_("imbueType").length() > 2 && timeout < TickProcedure.defaultMaxTime + 60 && timeout > 0) {
            if(context != ItemDisplayContext.GUI && !context.m_269069_() && item.m_41720_() instanceof BlockItem) {
               Block block = ((BlockItem)item.m_41720_()).m_40614_();
               boolean var10000;
               if(!(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock)) {
                  var10000 = true;
               } else {
                  var10000 = false;
               }
            } else {
               boolean flag1 = true;
            }

            return getEffectFoilBufferDirect(item, multiBuffer, p_115224_, true, true);
         }
      }

      return ItemRenderer.m_115222_(multiBuffer, p_115224_, true, item.m_41790_());
   }

   private static VertexConsumer getEffectFoilBuffer(ItemStack item, MultiBufferSource p_115212_, RenderType p_115213_, boolean p_115214_, boolean hasFoil) {
      return !hasFoil?p_115212_.m_6299_(p_115213_):(Minecraft.m_91085_() && p_115213_ == Sheets.m_110791_()?VertexMultiConsumer.m_86168_(p_115212_.m_6299_(RenderType.m_110487_()), p_115212_.m_6299_(p_115213_)):VertexMultiConsumer.m_86168_(p_115212_.m_6299_(p_115214_?RenderType.m_110490_():RenderType.m_110496_()), p_115212_.m_6299_(p_115213_)));
   }

   private static VertexConsumer getEffectFoilBufferDirect(ItemStack item, MultiBufferSource mbs, RenderType p_115224_, boolean p_115225_, boolean hasFoil) {
      String imbuetype = item.m_41784_().m_128461_("imbueType");
      VertexConsumer cons = hasFoil?VertexMultiConsumer.m_86168_(mbs.m_6299_(p_115225_?GlintRenderers.getDirectGlintRender(imbuetype):GlintRenderers.getEntityGlintDirect(imbuetype)), mbs.m_6299_(p_115224_)):mbs.m_6299_(p_115224_);
      return cons;
   }

   public void blit(PoseStack poseStack, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
      this.innerBlit(poseStack, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
   }

   public void blit(PoseStack poseStack, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
      this.blit(poseStack, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
   }

   private void innerBlit(PoseStack p_93188_, int p_93189_, int p_93190_, int p_93191_, int p_93192_, int p_93193_, int p_93194_, int p_93195_, float p_93196_, float p_93197_, int p_93198_, int p_93199_) {
      this.innerBlit(p_93188_.m_85850_().m_252922_(), p_93189_, p_93190_, p_93191_, p_93192_, p_93193_, (p_93196_ + 0.0F) / (float)p_93198_, (p_93196_ + (float)p_93194_) / (float)p_93198_, (p_93197_ + 0.0F) / (float)p_93199_, (p_93197_ + (float)p_93195_) / (float)p_93199_);
   }

   private void innerBlit(Matrix4f param1, int param2, int param3, int param4, int param5, int param6, float param7, float param8, float param9, float param10) {
      // $FF: Couldn't be decompiled
   }
}
