package net.m3tte.tactical_imbuements.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class GlassshardparticleParticle extends TextureSheetParticle {

   private final SpriteSet spriteSet;
   private float angularVelocity;
   private float angularAcceleration;


   public static GlassshardparticleParticle.GlassshardparticleParticleProvider provider(SpriteSet spriteSet) {
      return new GlassshardparticleParticle.GlassshardparticleParticleProvider(spriteSet);
   }

   protected GlassshardparticleParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
      super(world, x, y, z);
      this.spriteSet = spriteSet;
      this.m_107250_(0.35F, 0.35F);
      this.f_107225_ = 200;
      this.f_107226_ = 0.8F;
      this.f_107219_ = true;
      this.f_107215_ = vx * 1.0D;
      this.f_107216_ = vy * 1.0D;
      this.f_107217_ = vz * 1.0D;
      this.f_107231_ = (float)Math.toRadians((double)(this.f_107223_.m_188501_() * 360.0F));
      this.f_107204_ = this.f_107231_;
      this.angularVelocity = this.f_107223_.m_188501_() * 0.2F - 0.1F;
      this.angularAcceleration = 0.0F;
      this.m_108335_(spriteSet);
   }

   public ParticleRenderType m_7556_() {
      return ParticleRenderType.f_107430_;
   }

   public void m_5989_() {
      super.m_5989_();
      this.f_107204_ = this.f_107231_;
      this.f_107231_ += this.angularVelocity;
      if(this.f_107218_) {
         this.angularVelocity = 0.0F;
         this.f_107231_ = (float)Math.toRadians((double)this.f_107231_ * 57.295779513D - (double)this.f_107231_ * 57.295779513D % 45.0D + 22.0D);
      }

      this.angularVelocity += this.angularAcceleration;
   }

   public static class GlassshardparticleParticleProvider implements ParticleProvider {

      private final SpriteSet spriteSet;


      public GlassshardparticleParticleProvider(SpriteSet spriteSet) {
         this.spriteSet = spriteSet;
      }

      public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
         return new GlassshardparticleParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
      }
   }
}
