/*
 * Decompiled with CFR 0.152.
 */
package uap.iweb.wf.vo;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.core.service.TimeService;
import nc.bs.logging.Logger;
import nc.bs.ml.NCLangResOnserver;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.wfengine.engine.ActivityInstance;
import nc.itf.uap.pf.IPFConfig;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.jdbc.framework.JdbcSession;
import nc.jdbc.framework.PersistenceManager;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.exception.DbException;
import nc.jdbc.framework.mapping.IMappingMeta;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.BeanListProcessor;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.pubitf.bd.accessor.IGeneralAccessor;
import nc.vo.bd.accessor.IBDData;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.mobileapp.MobileAppUtil;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.pf.AssignableInfo;
import nc.vo.pub.pf.PFClientBizRetVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.trade.sqlutil.IInSqlBatchCallBack;
import nc.vo.trade.sqlutil.InSqlBatchCaller;
import nc.vo.uap.pf.OrganizeUnit;
import nc.vo.uap.wfmonitor.ProcessRouteRes;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.parser.UfXPDLParser;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.transition.BasicTransitionEx;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.ActivityTypeEnum;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WFTask;
import nc.vo.wfengine.pub.WFTaskMappingMeta;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import uap.iweb.wf.vo.WFActivityInfo;
import uap.iweb.wf.vo.WFApproveInfo;
import uap.iweb.wf.vo.WFAssignInfo;
import uap.iweb.wf.vo.WFProInsVO;
import uap.iweb.wf.vo.WFUserVO;
import uap.iweb.wf.vo.WorkNoteVO;

public class WorkFlowQueryUtil {
    public Map<String, Object> queryWorkflowInfoByBillID(String billID, String userid, String billtype) throws BusinessException {
        return this.queryWorkflowInfo(billID, userid, billtype, null, false);
    }

    public Map<String, Object> queryWorkflowInfoByTask(WorkflownoteVO workflownote) throws BusinessException {
        return this.queryWorkflowInfo(workflownote.getBillVersionPK(), workflownote.getCheckman(), workflownote.getPk_billtype(), workflownote, true);
    }

    private Map<String, Object> queryWorkflowInfo(String billID, String userid, String billtype, WorkflownoteVO currTask, boolean filterFinishTask) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WFProInsVO proins = this.queryProcessInsByBillID(billID, billtype);
        if (proins == null) {
            return result;
        }
        IPFWorkflowQry qryService = (IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class);
        WorkflownoteVO[] pfWorknotes = qryService.queryWorkitems(billID, billtype, proins.getWorkflow_type(), 0);
        WFApproveInfo info = this.getTaskActionInfo(currTask, userid, pfWorknotes, proins);
        if (pfWorknotes != null) {
            Map<String, WFTask> taskMap = this.queryTask(billID, billtype);
            long waittime = 0L;
            ArrayList<WorkNoteVO> finishTasks = new ArrayList<WorkNoteVO>();
            ArrayList<WFUserVO> todoUsers = new ArrayList<WFUserVO>();
            HashSet<String> todoTaskIDs = new HashSet<String>();
            finishTasks.add(this.createCommitWorkNote(proins, pfWorknotes, info.isFlag()));
            for (WorkflownoteVO noteVO : pfWorknotes) {
                if (noteVO.getApprovestatus().intValue() == WfTaskOrInstanceStatus.Started.getIntValue()) {
                    todoTaskIDs.add(noteVO.getPk_wf_task());
                    WFUserVO user = this.getWfUser(noteVO);
                    todoUsers.add(user);
                    long newWaittime = this.getWaitMillis(noteVO);
                    waittime = newWaittime > waittime ? newWaittime : waittime;
                    continue;
                }
                if (!this.isFinish(noteVO, filterFinishTask)) continue;
                WorkNoteVO worknoteVO = this.convertToWebVO(noteVO, taskMap);
                worknoteVO.setAddApproveStatus(this.getAddApproveStatus(noteVO, pfWorknotes));
                finishTasks.add(worknoteVO);
            }
            Collections.sort(finishTasks);
            if (info.isFlag()) {
                finishTasks.add(info.getWorkNoteVO());
            }
            result.put("history_task", finishTasks);
            result.put("todo_users", todoUsers);
            result.put("wait_time", waittime);
            result.put("wait_commit", this.hasMakebillTask(pfWorknotes));
            result.put("todo_action_info", info);
            result.put("error_msg", info.getErrmsg());
            result.put("addApproveStatus", this.getAddApproveStatus(info.getWorkflownote(), pfWorknotes));
            result.put("todo_activity", this.getCurrentActivity(todoTaskIDs, taskMap));
        }
        return result;
    }

    private boolean isFinish(WorkflownoteVO noteVO, boolean filterFinishTask) {
        if (filterFinishTask) {
            return noteVO.getApprovestatus().intValue() == WfTaskOrInstanceStatus.Finished.getIntValue() && noteVO.getDealdate() != null;
        }
        return noteVO.getDealdate() != null;
    }

    private String getCurrentActivity(Set<String> todoTaskIDs, Map<String, WFTask> taskMap) {
        if (todoTaskIDs.size() == 1) {
            WFTask task = taskMap.get(todoTaskIDs.iterator().next());
            return this.getActivityName(task.getWfProcessDefPK(), task.getActivityID());
        }
        return null;
    }

    private Map<String, WFTask> queryTask(String billID, String billtype) throws BusinessException {
        HashMap<String, WFTask> taskMap = new HashMap<String, WFTask>();
        try {
            Collection result = new BaseDAO().retrieveByClause(WFTask.class, (IMappingMeta)new WFTaskMappingMeta(), "pk_wf_instance in (select pk_wf_instance from pub_wf_instance where billversionpk='" + billID + "' and billtype='" + billtype + "')");
            for (WFTask wfTask : result) {
                taskMap.put(wfTask.getTaskPK(), wfTask);
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        return taskMap;
    }

    private boolean hasMakebillTask(WorkflownoteVO[] pfWorknotes) {
        for (WorkflownoteVO workflownoteVO : pfWorknotes) {
            if (!workflownoteVO.getActiontype().startsWith("MAKEBILL") || WfTaskOrInstanceStatus.Finished.getIntValue() == workflownoteVO.getApprovestatus().intValue() || WfTaskOrInstanceStatus.Terminated.getIntValue() == workflownoteVO.getApprovestatus().intValue() || WfTaskOrInstanceStatus.Inefficient.getIntValue() == workflownoteVO.getApprovestatus().intValue()) continue;
            return true;
        }
        return false;
    }

    private long getWaitMillis(WorkflownoteVO noteVO) {
        long currentTime = TimeService.getInstance().getTime();
        if (noteVO.getSenddate() != null) {
            return currentTime - noteVO.getSenddate().getMillis();
        }
        return 0L;
    }

    private WFUserVO getWfUser(WorkflownoteVO noteVO) {
        WFUserVO user = new WFUserVO();
        user.setPk_user(noteVO.getCheckman());
        user.setCode(this.getCheckManCode(noteVO));
        user.setName(this.getCheckManName(noteVO));
        return user;
    }

    private String getCheckManCode(WorkflownoteVO noteVO) {
        IGeneralAccessor useraccessor = GeneralAccessorFactory.getAccessor((String)"f6f9a473-56c0-432f-8bc7-fbf8fde54fee");
        IBDData user = useraccessor.getDocByPk(noteVO.getCheckman());
        return user == null ? null : user.getCode();
    }

    private IBDData getCheckManCode(String id) {
        IGeneralAccessor useraccessor = GeneralAccessorFactory.getAccessor((String)"f6f9a473-56c0-432f-8bc7-fbf8fde54fee");
        IBDData user = useraccessor.getDocByPk(id);
        return user == null ? null : user;
    }

    private String getCheckManName(WorkflownoteVO noteVO) {
        return StringUtils.isBlank((CharSequence)noteVO.getChecknameml()) ? noteVO.getCheckname() : noteVO.getChecknameml();
    }

    private WFApproveInfo getTaskActionInfo(WorkflownoteVO workflownote, String userid, WorkflownoteVO[] pfWorknotes, WFProInsVO proins) {
        try {
            if (workflownote != null) {
                return this.getTaskActionInfoByTask(workflownote);
            }
            return this.getTaskActionInfoByUser(userid, pfWorknotes, proins);
        }
        catch (BusinessException e) {
            return this.createNullApproveInfo(e.getMessage());
        }
    }

    private WFApproveInfo createNullApproveInfo(String errmsg) {
        WFApproveInfo info = new WFApproveInfo();
        info.setPk_workflownote(null);
        info.setShowCheckNote(false);
        info.setErrmsg(errmsg);
        return info;
    }

    private WFApproveInfo getTaskActionInfoByTask(WorkflownoteVO workflownote) throws BusinessException {
        WFApproveInfo info = new WFApproveInfo();
        info.setPk_workflownote(workflownote.getPk_checkflow());
        info.setActions(this.getActionByWorkflowNote(workflownote.getCheckman(), workflownote, null));
        info.setShowCheckNote(WfTaskOrInstanceStatus.Started.getIntValue() == workflownote.getApprovestatus().intValue());
        info.setWorkflownote(workflownote);
        return info;
    }

    private WFApproveInfo getTaskActionInfoByUser(String userid, WorkflownoteVO[] pfWorknotes, WFProInsVO proins) throws BusinessException {
        WorkflownoteVO waitDealTask = this.getWaitDealTask(pfWorknotes, userid);
        List<Map<String, Object>> waitDealActions = this.getActionByWorkflowNote(userid, waitDealTask, proins);
        WorkflownoteVO lastDoneTask = this.getLastDoneTask(pfWorknotes, userid);
        List<Map<String, Object>> lastDoneActions = this.getActionByWorkflowNote(userid, lastDoneTask, proins);
        WFApproveInfo info = new WFApproveInfo();
        if (waitDealTask != null && !waitDealActions.isEmpty()) {
            info.setPk_workflownote(waitDealTask.getPk_checkflow());
            info.setActions(waitDealActions);
            info.setShowCheckNote(true);
            info.setWorkflownote(waitDealTask);
        } else if (lastDoneTask != null && !lastDoneActions.isEmpty()) {
            info.setPk_workflownote(lastDoneTask.getPk_checkflow());
            info.setActions(lastDoneActions);
            info.setShowCheckNote(false);
            info.setWorkflownote(lastDoneTask);
        } else if (this.canRecall(userid, pfWorknotes, proins) && pfWorknotes.length > 0) {
            info.setPk_workflownote(proins.getPk_wf_instance());
            info.setActions(this.getRecalActions());
            info.setShowCheckNote(false);
            info.setWorkflownote(null);
        } else if (waitDealTask == null && lastDoneTask == null && pfWorknotes.length == 0) {
            info.setActions(waitDealActions);
            info.setShowCheckNote(true);
            info.setPk_workflownote("auto@" + proins.getBillversionpk() + "@" + proins.getBilltype());
            WorkNoteVO newvo = new WorkNoteVO();
            newvo.setPk_workflownote("auto@" + proins.getBillversionpk() + "@" + proins.getBilltype());
            newvo.setActiontype("agree");
            newvo.setCheckman(this.getCheckManCode(proins.getBillCommiter()).getName().getText());
            newvo.setApprovestatus(1);
            newvo.setCheckmanCode(this.getCheckManCode(proins.getBillCommiter()).getCode());
            newvo.setChecknote("\u81ea\u52a8\u5ba1\u6279");
            newvo.setActionname("\u5ba1\u6279");
            newvo.setDealDate(proins.getStartts().getMillis());
            info.setWorkNoteVO(newvo);
            info.setFlag(true);
        }
        return info;
    }

    private WorkflownoteVO getWaitDealTask(WorkflownoteVO[] pfWorknotes, String userid) {
        for (WorkflownoteVO workflownoteVO : pfWorknotes) {
            if (WfTaskOrInstanceStatus.Started.getIntValue() != workflownoteVO.getApprovestatus().intValue() || !workflownoteVO.getCheckman().equals(userid)) continue;
            return workflownoteVO;
        }
        return null;
    }

    private WorkflownoteVO getLastDoneTask(WorkflownoteVO[] pfWorknotes, String userid) {
        WorkflownoteVO lastDoneNote = null;
        for (WorkflownoteVO workflownoteVO : pfWorknotes) {
            if (WfTaskOrInstanceStatus.Finished.getIntValue() == workflownoteVO.getApprovestatus().intValue()) {
                if (!this.isNewTaskWorkNote(lastDoneNote, workflownoteVO)) continue;
                if (workflownoteVO.getCheckman().equals(userid)) {
                    lastDoneNote = workflownoteVO;
                    continue;
                }
                lastDoneNote = null;
                continue;
            }
            if (WfTaskOrInstanceStatus.Started.getIntValue() == workflownoteVO.getApprovestatus().intValue() || WfTaskOrInstanceStatus.Inefficient.getIntValue() == workflownoteVO.getApprovestatus().intValue()) continue;
            lastDoneNote = null;
        }
        return lastDoneNote;
    }

    private List<Map<String, Object>> getActionByWorkflowNote(String userid, WorkflownoteVO note, WFProInsVO proins) throws BusinessException {
        HashMap<String, Object> action;
        AggregatedValueObject billvo;
        List<WFTask> task;
        WorkflownoteVO[] checkedNoteVOs;
        ArrayList<Map<String, Object>> actions = new ArrayList<Map<String, Object>>();
        if (null != proins && ((checkedNoteVOs = this.queryWorkitemsCheckedIncludeAutoComplete(proins.getBilltype(), proins.getBillversionpk(), proins.getBillCommiter(), proins.getWorkflow_type())) == null || checkedNoteVOs.length == 0) && null != (task = this.getTaskByPKs(proins.getProcessdefid(), proins.getPk_wf_instance())) && task.size() > 0) {
            WFTask currentTask = task.get(0);
            ArrayList<String> nextactivit = new ArrayList<String>();
            this.nextlink(proins.getProcessdefid(), currentTask.getActivityID(), nextactivit);
            if (nextactivit.size() == 0) {
                HashMap<String, Object> action2 = MobileAppUtil.createHashMap();
                action2.put("action_code", "cancelApprove");
                actions.add(action2);
            }
        }
        if (note == null || note.getActiontype().startsWith("MAKEBILL")) {
            return actions;
        }
        if (this.isApprovWorkFlowNote(note)) {
            if (WfTaskOrInstanceStatus.Started.getIntValue() == note.getApprovestatus().intValue()) {
                HashMap<String, Object> action3;
                billvo = WorkFlowQueryUtil.queryBillVO(note);
                if (MobileAppUtil.canAgree(null, note = WorkFlowQueryUtil.checkWorkFlow(userid, note, billvo))) {
                    action3 = MobileAppUtil.createHashMap();
                    action3.put("action_code", "agree");
                    if (MobileAppUtil.canAssignWhenPassing(note)) {
                        action3.put("assign_flag", "Y");
                    } else {
                        action3.put("assign_flag", "N");
                    }
                    actions.add(action3);
                }
                if (MobileAppUtil.canReject(null, note)) {
                    action3 = MobileAppUtil.createHashMap();
                    action3.put("action_code", "reject");
                    actions.add(action3);
                }
                if (MobileAppUtil.canDisAgree(null, note)) {
                    action3 = MobileAppUtil.createHashMap();
                    action3.put("action_code", "disagree");
                    if (MobileAppUtil.canAssignWhenNoPass(note)) {
                        action3.put("assign_flag", "Y");
                    } else {
                        action3.put("assign_flag", "N");
                    }
                    actions.add(action3);
                }
                if (MobileAppUtil.canReassign(note)) {
                    action3 = MobileAppUtil.createHashMap();
                    action3.put("action_code", "reassign");
                    actions.add(action3);
                }
                if (MobileAppUtil.canAddApprover(note)) {
                    action3 = MobileAppUtil.createHashMap();
                    action3.put("action_code", "addApprove");
                    actions.add(action3);
                }
            } else if (WfTaskOrInstanceStatus.Finished.getIntValue() == note.getApprovestatus().intValue()) {
                action = MobileAppUtil.createHashMap();
                action.put("action_code", "cancelApprove");
                actions.add(action);
            }
        } else if (WfTaskOrInstanceStatus.Started.getIntValue() == note.getApprovestatus().intValue()) {
            HashMap<String, Object> action4;
            billvo = WorkFlowQueryUtil.queryBillVO(note);
            PFClientBizRetVO bizret = WorkFlowQueryUtil.getPFClientBizRet(note = WorkFlowQueryUtil.checkWorkFlow(userid, note, billvo), billvo);
            if (MobileAppUtil.canAgree(bizret, note)) {
                action4 = MobileAppUtil.createHashMap();
                action4.put("action_code", "agree");
                action4.put("assign_flag", "N");
                actions.add(action4);
            }
            if (MobileAppUtil.canReject(bizret, note)) {
                action4 = MobileAppUtil.createHashMap();
                action4.put("action_code", "reject");
                actions.add(action4);
            }
        } else if (WfTaskOrInstanceStatus.Finished.getIntValue() == note.getApprovestatus().intValue()) {
            action = MobileAppUtil.createHashMap();
            action.put("action_code", "cancelApprove");
            actions.add(action);
        }
        return actions;
    }

    public List<WFTask> getTaskByPKs(String processdefid, String pk_wf_instance) throws BusinessException {
        ArrayList<WFTask> tasks = new ArrayList<WFTask>();
        String condition = " processdefid = '" + processdefid + "'  and pk_wf_instance ='" + pk_wf_instance + "' and taskstatus =1";
        try {
            Collection taskCollection = new BaseDAO().retrieveByClause(WFTask.class, (IMappingMeta)new WFTaskMappingMeta(), condition);
            for (WFTask wfTask : taskCollection) {
                tasks.add(wfTask);
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        return tasks;
    }

    public WorkflownoteVO[] queryWorkitemsCheckedIncludeAutoComplete(String billType, String billId, String userPK, int iWorkflowOrApproveflow) throws DAOException {
        WorkflownoteVO[] workflownoteVOArray;
        String sql = "select * from pub_workflownote where pk_billtype=? and billversionpk=? " + this.getWorkflowTypeAndWhere(iWorkflowOrApproveflow, "") + " and approvestatus=" + WfTaskOrInstanceStatus.Finished.getIntValue() + " and approveresult is not null and actiontype like 'Z%' order by dealdate desc, senddate desc, ts desc,dealtimemillis desc";
        SQLParameter para = new SQLParameter();
        para.addParam(billType);
        para.addParam(billId);
        Collection co = (Collection)new BaseDAO().executeQuery(sql, para, (ResultSetProcessor)new BeanListProcessor(WorkflownoteVO.class));
        UFDateTime endtime = null;
        WorkflownoteVO resultvo = null;
        for (WorkflownoteVO vo : co.toArray(new WorkflownoteVO[co.size()])) {
            if (null != endtime) {
                if (!endtime.before(vo.getDealdate())) continue;
                resultvo = vo;
                continue;
            }
            endtime = vo.getDealdate();
            resultvo = vo;
        }
        if (resultvo == null) {
            workflownoteVOArray = null;
        } else {
            WorkflownoteVO[] workflownoteVOArray2 = new WorkflownoteVO[1];
            workflownoteVOArray = workflownoteVOArray2;
            workflownoteVOArray2[0] = resultvo;
        }
        return workflownoteVOArray;
    }

    public String getWorkflowTypeAndWhere(int iWorkflowOrApproveflow, String tableAlias) {
        String strWfTypeSql = "";
        if (StringUtil.isEmptyWithTrim((String)tableAlias)) {
            tableAlias = "";
        }
        strWfTypeSql = " and " + tableAlias + "workflow_type in" + WorkflowTypeEnum.getInstanceTypeInSql(iWorkflowOrApproveflow);
        return strWfTypeSql;
    }

    private void nextlink(String wfprocessdefpk, String activityid, ArrayList<String> al) throws BusinessException {
        BasicWorkflowProcess base = null;
        try {
            base = PfDataCache.getWorkflowProcess(wfprocessdefpk);
        }
        catch (XPDLParserException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ArrayList list = (ArrayList)base.findActivityByID(activityid).getWorkflowProcess().getTransitions();
        list.remove(null);
        for (BasicTransitionEx ex : list) {
            if (!activityid.equals(ex.getFrom())) continue;
            if (ex.getToActivity().getImplementation() instanceof Activity) {
                SubFlow sub = (SubFlow)ex.getToActivity().getImplementation();
                String pk = sub.getId();
                String apk = sub.getPk();
                this.nextlink(pk, apk, al);
                continue;
            }
            if (ex.getToActivity() instanceof Activity && ex.getToActivity().getActivityType() == ActivityTypeEnum.Route.getIntValue()) {
                Activity act = ex.getToActivity();
                this.nextlink(act.getWorkflowProcess().getPrimaryKey(), act.getId(), al);
                continue;
            }
            al.add(ex.getTo());
        }
    }

    private boolean isApprovWorkFlowNote(WorkflownoteVO note) {
        return note.getWorkflow_type().intValue() == WorkflowTypeEnum.Approveflow.getIntValue() || note.getWorkflow_type().intValue() == WorkflowTypeEnum.SubApproveflow.getIntValue() || note.getWorkflow_type().intValue() == WorkflowTypeEnum.SubWorkApproveflow.getIntValue();
    }

    public static PFClientBizRetVO getPFClientBizRet(WorkflownoteVO note, AggregatedValueObject billvo) throws BusinessException {
        PFClientBizRetVO bizret = null;
        bizret = MobileAppUtil.executeClientBiz(billvo, note);
        return bizret;
    }

    private boolean canRecall(String userid, WorkflownoteVO[] pfWorknotes, WFProInsVO proins) {
        return proins.getBillCommiter().equals(userid) && !this.hasDoneAndMakebillTask(pfWorknotes);
    }

    private boolean hasDoneAndMakebillTask(WorkflownoteVO[] pfWorknotes) {
        for (WorkflownoteVO workflownoteVO : pfWorknotes) {
            if (WfTaskOrInstanceStatus.Finished.getIntValue() == workflownoteVO.getApprovestatus().intValue()) {
                return true;
            }
            if (!workflownoteVO.getActiontype().startsWith("MAKEBILL")) continue;
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> getRecalActions() throws BusinessException {
        ArrayList<Map<String, Object>> actions = new ArrayList<Map<String, Object>>();
        HashMap<String, String> doBackMap = new HashMap<String, String>();
        doBackMap.put("action_code", "recall");
        actions.add(doBackMap);
        return actions;
    }

    private boolean isNewTaskWorkNote(WorkflownoteVO lastDoneNote, WorkflownoteVO workflownoteVO) {
        if (lastDoneNote == null) {
            return true;
        }
        return !lastDoneNote.getPk_wf_task().equals(workflownoteVO.getPk_wf_task()) && lastDoneNote.getDealdate().before(workflownoteVO.getDealdate());
    }

    private WFProInsVO queryProcessInsByBillID(String billID, String billtype) throws BusinessException {
        String cond = "billversionpk=? and billtype=? and procstatus!=? and workflow_type in (" + WorkflowTypeEnum.Approveflow.getIntValue() + "," + WorkflowTypeEnum.Workflow.getIntValue() + ") order by pk_wf_instance";
        SQLParameter param = new SQLParameter();
        param.addParam(billID);
        param.addParam(billtype);
        param.addParam(WfTaskOrInstanceStatus.Inefficient.getIntValue());
        Collection col = new BaseDAO().retrieveByClause(WFProInsVO.class, cond, param);
        if (col != null && col.size() > 0) {
            return (WFProInsVO)((Object)col.iterator().next());
        }
        return null;
    }

    private WorkNoteVO createCommitWorkNote(WFProInsVO proins, WorkflownoteVO[] pfWorknotes, boolean flag) {
        WorkNoteVO note = new WorkNoteVO();
        note.setPk_workflownote(proins.getPk_wf_instance());
        IGeneralAccessor accessor = GeneralAccessorFactory.getAccessor((String)"f6f9a473-56c0-432f-8bc7-fbf8fde54fee");
        note.setDealDate(proins.getStartts().getMillis());
        note.setActiontype("makeBill");
        note.setActionname(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "BillStatus-Committed"));
        note.setApprovestatus(WfTaskOrInstanceStatus.Finished.getIntValue());
        note.setActivityName(this.getCommitActivityName(proins.getProcessdefid()));
        if (flag) {
            IBDData data = accessor.getDocByPk(proins.getBillCommiter());
            note.setCheckmanCode(data.getCode());
            note.setCheckman(data.getName().toString());
        } else {
            for (WorkflownoteVO pfnote : pfWorknotes) {
                if (!pfnote.getActiontype().equals("Z") && !pfnote.getActiontype().equals("MAKEBILL")) continue;
                IBDData data = accessor.getDocByPk(pfnote.getSenderman());
                note.setCheckmanCode(data.getCode());
                note.setCheckman(data.getName().toString());
                break;
            }
        }
        return note;
    }

    private String getCommitActivityName(String processdefid) {
        BasicWorkflowProcess bwp = this.getWorkFlowProcess(processdefid);
        List activities = bwp.getActivities();
        for (Activity activity : activities) {
            if (!(activity instanceof GenericActivityEx)) continue;
            GenericActivityEx gae = (GenericActivityEx)activity;
            if (!ActivityTypeEnum.Makebill.getTag().equals(gae.getAppId())) continue;
            return gae.getName();
        }
        return null;
    }

    private String getActivityName(String processdefid, String activitydefid) {
        BasicWorkflowProcess bwp = this.getWorkFlowProcess(processdefid);
        Activity act = bwp.findActivityByID(activitydefid);
        return act.getName();
    }

    private BasicWorkflowProcess getWorkFlowProcess(String processdefid) {
        try {
            return PfDataCache.getWorkflowProcess(processdefid);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private WorkNoteVO convertToWebVO(WorkflownoteVO vo, Map<String, WFTask> taskMap) {
        WFTask task;
        WorkNoteVO note = new WorkNoteVO();
        note.setPk_workflownote(vo.getPk_checkflow());
        note.setCheckmanCode(this.getCheckManCode(vo));
        note.setCheckman(this.getCheckManName(vo));
        note.setDealDate(vo.getDealdate() != null ? vo.getDealdate().getMillis() : 0L);
        note.setChecknote(vo.getChecknote());
        this.setActionTypeAndName(vo, note);
        note.setApprovestatus(vo.getApprovestatus());
        if (taskMap != null && (task = taskMap.get(vo.getPk_wf_task())) != null) {
            String activityName = this.getActivityName(task.getWfProcessDefPK(), task.getActivityID());
            note.setActivityName(activityName);
        }
        return note;
    }

    private int getAddApproveStatus(WorkflownoteVO vo, WorkflownoteVO[] pfWorknotes) {
        if (vo == null || ArrayUtils.isEmpty((Object[])pfWorknotes)) {
            return 0;
        }
        int addApproveStatus = 0;
        for (WorkflownoteVO workflownoteVO : pfWorknotes) {
            if (!workflownoteVO.getActiontype().endsWith("_A") || !workflownoteVO.getPk_wf_task().equals(vo.getPk_wf_task()) || !vo.getCheckman().equals(workflownoteVO.getObserver())) continue;
            if (workflownoteVO.getApprovestatus().intValue() == WfTaskOrInstanceStatus.Started.getIntValue()) {
                return 1;
            }
            if (workflownoteVO.getApprovestatus().intValue() != WfTaskOrInstanceStatus.Finished.getIntValue()) continue;
            addApproveStatus = 2;
        }
        return addApproveStatus;
    }

    private void setActionTypeAndName(WorkflownoteVO vo, WorkNoteVO note) {
        if (vo.getActiontype().equals("MAKEBILL")) {
            note.setActiontype("makeBill");
            note.setActionname(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "BillStatus-Committed"));
        } else if (vo.getActiontype().startsWith("Z") && vo.getApproveresult() != null) {
            if ("Y".equals(vo.getApproveresult())) {
                note.setActiontype("agree");
                note.setActionname(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630100"));
            } else if ("N".equals(vo.getApproveresult())) {
                note.setActiontype("disagree");
                note.setActionname(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630101"));
            } else if ("R".equals(vo.getApproveresult())) {
                note.setActiontype("reject");
                note.setActionname(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630102"));
            } else if ("T".equals(vo.getApproveresult())) {
                note.setActiontype("reassign");
                note.setActionname(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630104"));
            }
        }
    }

    public List<WFAssignInfo> getAssignInfo(String pk_user, String pk_workflownote) throws BusinessException {
        WorkflownoteVO workFlownote = WorkFlowQueryUtil.queryWorkFlowNoteVO(pk_workflownote);
        workFlownote = WorkFlowQueryUtil.checkWorkFlow(pk_user, workFlownote);
        ArrayList<WFAssignInfo> result = new ArrayList<WFAssignInfo>();
        if (workFlownote.getActiontype().endsWith("_A")) {
            return result;
        }
        Vector assignInfos = workFlownote.getTaskInfo().getAssignableInfos();
        boolean assignablePostCondition = workFlownote.getTaskInfo().isAssignablePostCondition();
        if (assignInfos != null && assignInfos.size() > 0) {
            for (AssignableInfo assignInfo : assignInfos) {
                WFAssignInfo webAssgnInfo = new WFAssignInfo();
                webAssgnInfo.setActivityDefId(assignInfo.getActivityDefId());
                webAssgnInfo.setActivityDesc(assignInfo.getDesc());
                webAssgnInfo.setAllUsers(this.convertToUserVO(assignInfo.getOuUsers()));
                webAssgnInfo.setSelectedUsers(this.getSelectedUsers(webAssgnInfo.getAllUsers(), assignInfo.getAssignedOperatorPKs()));
                webAssgnInfo.setMustAssign(assignablePostCondition);
                result.add(webAssgnInfo);
            }
        }
        return result;
    }

    private List<WFUserVO> getSelectedUsers(List<WFUserVO> allUsers, Vector<String> selectedUserIDs) {
        ArrayList<WFUserVO> userVOs = new ArrayList<WFUserVO>();
        if (!CollectionUtils.isEmpty(selectedUserIDs) && !CollectionUtils.isEmpty(allUsers)) {
            for (WFUserVO user : allUsers) {
                if (!selectedUserIDs.contains(user.getPk_user())) continue;
                userVOs.add(user);
            }
        }
        return userVOs;
    }

    private List<WFUserVO> convertToUserVO(Vector<OrganizeUnit> vt) {
        ArrayList<WFUserVO> userVOs = new ArrayList<WFUserVO>();
        if (vt != null && vt.size() > 0) {
            for (OrganizeUnit ou : vt) {
                userVOs.add(this.convertToUserArray(ou));
            }
        }
        return userVOs;
    }

    private WFUserVO convertToUserArray(OrganizeUnit ou) {
        WFUserVO user = new WFUserVO();
        user.setPk_user(ou.getPk());
        user.setCode(ou.getCode());
        user.setName(ou.getName());
        return user;
    }

    public List<WFActivityInfo> getRejectActvity(String pk_user, String pk_workflownote) throws BusinessException {
        WorkflownoteVO workFlownote = WorkFlowQueryUtil.queryWorkFlowNoteVO(pk_workflownote);
        WFProInsVO proins = this.queryProcessInsByBillID((workFlownote = WorkFlowQueryUtil.checkWorkFlow(pk_user, workFlownote)).getBillVersionPK(), workFlownote.getPk_billtype());
        if (proins == null || workFlownote == null) {
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630099"));
        }
        ArrayList<WFActivityInfo> activities = new ArrayList<WFActivityInfo>();
        Map<String, WFActivityInfo> actID_act_map = this.getCheckedActivities(workFlownote);
        activities.add(this.getMakeBillActity(actID_act_map, proins));
        WorkflownoteVO[] workflownotes = ((IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class)).queryWorkitems(workFlownote.getBillVersionPK(), workFlownote.getPk_billtype(), proins.getWorkflow_type(), 0);
        Map<String, String[]> id_task_map = this.queryTaskToActDefMap(workflownotes);
        Map<String, String[]> proins_soureAct_map = this.querySubFlowToActIDMap(workFlownote);
        for (WorkflownoteVO workflownoteVO : workflownotes) {
            String[] task;
            if (workflownoteVO.getApprovestatus().intValue() != WfTaskOrInstanceStatus.Finished.getIntValue() || (task = id_task_map.get(workflownoteVO.getPk_wf_task())) == null) continue;
            WFActivityInfo info = actID_act_map.get(task[0]);
            if (info == null) {
                String actDefID = this.getMainFlowActivity(task[1], proins_soureAct_map);
                info = actID_act_map.get(actDefID);
            }
            if (info == null) continue;
            info.addWorkflowNote(this.convertToWebVO(workflownoteVO, null));
            if (activities.contains(info)) continue;
            activities.add(info);
        }
        return activities;
    }

    private String getMainFlowActivity(String proinsID, Map<String, String[]> proins_soureAct_map) {
        String[] actInfo = proins_soureAct_map.get(proinsID);
        if (actInfo != null) {
            if (proins_soureAct_map.get(actInfo[1]) == null) {
                return actInfo[0];
            }
            return this.getMainFlowActivity(actInfo[1], proins_soureAct_map);
        }
        return null;
    }

    private WFActivityInfo getMakeBillActity(Map<String, WFActivityInfo> actID_act_map, WFProInsVO proins) throws BusinessException {
        IPFWorkflowQry qryService = (IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class);
        WorkflownoteVO[] queryWorkitems = qryService.queryWorkitems(proins.getBillversionpk(), proins.getBilltype(), proins.getWorkflow_type(), 0);
        WorkNoteVO commitWorkNote = this.createCommitWorkNote(proins, queryWorkitems, false);
        WFActivityInfo actInfo = this.getCommitActInfo(actID_act_map);
        actInfo.addWorkflowNote(commitWorkNote);
        return actInfo;
    }

    private WFActivityInfo getCommitActInfo(Map<String, WFActivityInfo> actID_act_map) {
        for (WFActivityInfo actInfo : actID_act_map.values()) {
            if (!actInfo.isMakeBill()) continue;
            actInfo.setActivityDefId(actInfo.getActivityDefId());
            return actInfo;
        }
        WFActivityInfo actInfo = new WFActivityInfo();
        actInfo.setActivityDefId("");
        actInfo.setActivityDesc(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630107"));
        actInfo.setMakeBill(true);
        actInfo.setSubflow(false);
        return actInfo;
    }

    private Map<String, String[]> querySubFlowToActIDMap(WorkflownoteVO workFlownote) throws DAOException {
        String sql = "select f.pk_wf_instance,a.activitydefid,a.pk_wf_instance from pub_wf_instance f inner join pub_wf_actinstance a on a.pk_wf_actinstance = f.src_pk_actinstance where f.billversionpk = ? and f.billtype = ? and f.procstatus != ?";
        SQLParameter param = new SQLParameter();
        param.addParam(workFlownote.getBillVersionPK());
        param.addParam(workFlownote.getPk_billtype());
        param.addParam(WfTaskOrInstanceStatus.Inefficient.getIntValue());
        List result = (List)new BaseDAO().executeQuery(sql, param, (ResultSetProcessor)new ArrayListProcessor());
        HashMap<String, String[]> proins_actdef_map = new HashMap<String, String[]>();
        for (Object[] objs : result) {
            String pk_proins = (String)objs[0];
            String actdefID = (String)objs[1];
            String parentProinsID = (String)objs[2];
            proins_actdef_map.put(pk_proins, new String[]{actdefID, parentProinsID});
        }
        return proins_actdef_map;
    }

    private Map<String, String[]> queryTaskToActDefMap(WorkflownoteVO[] workflownotes) throws BusinessException {
        HashSet<String> taskIDs = new HashSet<String>();
        if (workflownotes == null) {
            return new HashMap<String, String[]>();
        }
        for (WorkflownoteVO wfnVO : workflownotes) {
            taskIDs.add(wfnVO.getPk_wf_task());
        }
        InSqlBatchCaller caller = new InSqlBatchCaller(taskIDs.toArray(new String[0]));
        try {
            return (Map)caller.execute(new IInSqlBatchCallBack(){
                private Map<String, String[]> id_task_map = new HashMap<String, String[]>();

                public Object doWithInSql(String inSql) throws BusinessException, SQLException {
                    String sql = "select pk_wf_task,pk_wf_instance,activitydefid from pub_wf_task where pk_wf_task in " + inSql;
                    List result = (List)new BaseDAO().executeQuery(sql, (ResultSetProcessor)new ArrayListProcessor());
                    for (Object[] objs : result) {
                        String taskID = (String)objs[0];
                        String proinsID = (String)objs[1];
                        String actdefID = (String)objs[2];
                        this.id_task_map.put(taskID, new String[]{actdefID, proinsID});
                    }
                    return this.id_task_map;
                }
            });
        }
        catch (SQLException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, WFActivityInfo> getCheckedActivities(WorkflownoteVO workFlownote) throws BusinessException {
        List<ProcessRouteRes> prrList = this.queryActivity(workFlownote);
        boolean subWorkFlownote = this.isSubWorkFlow(workFlownote);
        HashMap<String, WFActivityInfo> result = new HashMap<String, WFActivityInfo>();
        if (prrList != null) {
            for (ProcessRouteRes p : prrList) {
                ActivityInstance[] ais = p.getActivityInstance();
                WorkflowProcess wp = this.getWorkflowProcess1(p);
                if (wp == null) continue;
                for (ActivityInstance inst : ais) {
                    WFActivityInfo info = this.getWfActivityInfo(wp, inst);
                    if (info == null || subWorkFlownote && !info.isMakeBill()) continue;
                    result.put(info.getActivityDefId(), info);
                }
            }
        }
        return result;
    }

    private WFActivityInfo getWfActivityInfo(WorkflowProcess wp, ActivityInstance inst) {
        int workflowtype;
        if (inst.getStatus() != WfTaskOrInstanceStatus.Finished.getIntValue()) {
            return null;
        }
        Activity act = wp.findActivityByID(inst.getActivityID());
        if (act instanceof GenericActivityEx) {
            GenericActivityEx gae = (GenericActivityEx)act;
            WFActivityInfo info = new WFActivityInfo();
            info.setActivityDefId(gae.getId());
            info.setActivityDesc(gae.getName());
            info.setSubflow(false);
            if (ActivityTypeEnum.Makebill.getTag().equals(gae.getAppId())) {
                info.setMakeBill(true);
            } else {
                info.setMakeBill(false);
            }
            return info;
        }
        if (act.getImplementation() instanceof SubFlow && ((workflowtype = wp.getWorkflowType()) == WorkflowTypeEnum.Approveflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubApproveflow.getIntValue())) {
            WFActivityInfo info = new WFActivityInfo();
            info.setActivityDefId(act.getId());
            info.setActivityDesc(act.getName());
            info.setMakeBill(false);
            info.setSubflow(true);
            return info;
        }
        return null;
    }

    private boolean isSubWorkFlow(WorkflownoteVO workFlownote) {
        if (workFlownote.getWorkflow_type().intValue() == WorkflowTypeEnum.SubWorkflow.getIntValue()) {
            return true;
        }
        return workFlownote.getWorkflow_type().intValue() == WorkflowTypeEnum.SubWorkApproveflow.getIntValue();
    }

    private WorkflowProcess getWorkflowProcess1(ProcessRouteRes p) throws BusinessException {
        BasicWorkflowProcess wp = null;
        if (p.getXpdlString() != null) {
            try {
                wp = UfXPDLParser.getInstance().parseProcess(p.getXpdlString().toString());
            }
            catch (XPDLParserException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow1", "UfXPDLParser-000000", null, new String[]{e.getMessage()}), (Throwable)e);
            }
        }
        return wp;
    }

    private List<ProcessRouteRes> queryActivity(WorkflownoteVO workFlownote) throws BusinessException {
        IWorkflowDefine service = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
        ArrayList<ProcessRouteRes> prrList = new ArrayList<ProcessRouteRes>();
        int workflowType = workFlownote.getWorkflow_type();
        String billid = workFlownote.getBillVersionPK();
        String billtype = workFlownote.getPk_billtype();
        if (workflowType == WorkflowTypeEnum.SubApproveflow.getIntValue()) {
            ProcessRouteRes prr = service.queryProcessRoute(billid, billtype, null, WorkflowTypeEnum.Approveflow.getIntValue());
            prrList.add(prr);
            String pk_wf_instance = workFlownote.getTaskInfo().getTask().getWfProcessInstancePK();
            prr = service.queryProcessRoute(billid, billtype, pk_wf_instance, workflowType);
            prrList.add(prr);
        } else if (workflowType == WorkflowTypeEnum.Workflow.getIntValue()) {
            ProcessRouteRes prr = service.queryProcessRoute(billid, billtype, null, WorkflowTypeEnum.Workflow.getIntValue());
            prrList.add(prr);
        } else if (workflowType == WorkflowTypeEnum.Approveflow.getIntValue()) {
            ProcessRouteRes prr = service.queryProcessRoute(billid, billtype, null, WorkflowTypeEnum.Approveflow.getIntValue());
            prrList.add(prr);
        } else if (this.isSubWorkFlow(workFlownote)) {
            ProcessRouteRes prr = service.queryProcessRoute(billid, billtype, null, WorkflowTypeEnum.Workflow.getIntValue());
            prrList.add(prr);
        }
        return prrList;
    }

    public static WorkflownoteVO checkWorkFlow(String userid, WorkflownoteVO workflownote, AggregatedValueObject billvo) throws BusinessException {
        IWorkflowMachine service = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
        String actionName = null;
        actionName = WorkFlowQueryUtil.getActionNameByFlowType(workflownote.getWorkflow_type());
        return service.checkWorkFlow(actionName + userid, workflownote.getPk_billtype(), billvo, null);
    }

    private static String getActionNameByFlowType(int workflowtype) {
        if (workflowtype == WorkflowTypeEnum.Workflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkApproveflow.getIntValue()) {
            return "SIGNAL";
        }
        return "APPROVE";
    }

    public static WorkflownoteVO checkWorkFlow(String userid, WorkflownoteVO workflownote) throws BusinessException {
        AggregatedValueObject billvo = WorkFlowQueryUtil.queryBillVO(workflownote);
        return WorkFlowQueryUtil.checkWorkFlow(userid, workflownote, billvo);
    }

    public static AggregatedValueObject queryBillVO(WorkflownoteVO workflownote) throws BusinessException {
        AggregatedValueObject billvo = ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).queryBillDataVO(workflownote.getPk_billtype(), workflownote.getBillVersionPK());
        if (billvo == null) {
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("busitype", "busitypehint-000063"));
        }
        return billvo;
    }

    public static WorkflownoteVO queryWorkFlowNoteVO(String pk_workflownote) throws DAOException, BusinessException {
        WorkflownoteVO note = (WorkflownoteVO)new BaseDAO().retrieveByPK(WorkflownoteVO.class, pk_workflownote);
        if (note == null) {
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630099"));
        }
        return note;
    }

    public boolean canCommitOrStartFlow(String billID, String billtype) throws BusinessException {
        WFProInsVO proins = this.queryProcessInsByBillID(billID, billtype);
        if (proins == null) {
            return true;
        }
        IPFWorkflowQry qryService = (IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class);
        Object[] pfWorknotes = qryService.queryWorkitems(billID, billtype, proins.getWorkflow_type(), 0);
        if (!ArrayUtils.isEmpty((Object[])pfWorknotes)) {
            for (Object noteVO : pfWorknotes) {
                if (((WorkflownoteVO)noteVO).getApprovestatus().intValue() != WfTaskOrInstanceStatus.Started.getIntValue() || !((WorkflownoteVO)noteVO).getActiontype().startsWith("MAKEBILL")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean haveCheckedMessage(String billId, String billtype) throws BusinessException {
        String cond = "billversionpk=? and pk_billtype=? and approvestatus=" + WfTaskOrInstanceStatus.Finished.getIntValue() + " and approveresult is not null and actiontype not in('" + "BIZ" + "','" + "MAKEBILL" + "') ";
        SQLParameter para = new SQLParameter();
        para.addParam(billId);
        para.addParam(billtype);
        Collection wfNotes = null;
        try {
            wfNotes = new BaseDAO().retrieveByClause(WorkflownoteVO.class, cond, para);
        }
        catch (DAOException e) {
            throw new BusinessException((Throwable)e);
        }
        return wfNotes != null && wfNotes.size() > 0;
    }

    public boolean isCheckman(String billId, String billType, String userId) throws BusinessException {
        String sql = "select pk_wf_task from pub_workflownote where pk_wf_task !='~' and billversionpk=? and pk_billtype=? and checkman=? and approvestatus in(" + WfTaskOrInstanceStatus.getUnfinishedStatusSet() + ") and actiontype not in('" + "BIZ" + "') ";
        PersistenceManager persist = null;
        try {
            persist = PersistenceManager.getInstance();
            JdbcSession jdbc = persist.getJdbcSession();
            SQLParameter para = new SQLParameter();
            para.addParam(billId);
            para.addParam(billType);
            para.addParam(userId);
            Object obj = jdbc.executeQuery(sql, para, (ResultSetProcessor)new ColumnProcessor(1));
            if (obj == null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (DbException e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (persist != null) {
                persist.release();
            }
        }
        return true;
    }
}

