/*
 * Decompiled with CFR 0.152.
 */
package uap.iweb.wf.vo;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.ml.NCLangResOnserver;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pub.pf.PfUtilTools;
import nc.itf.uap.pf.IWorkflowAdmin;
import nc.itf.uap.pf.IplatFormEntry;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.mobileapp.MobileAppUtil;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.billtype2.ExtendedClassEnum;
import nc.vo.pub.pf.AssignableInfo;
import nc.vo.pub.pf.PFClientBizRetVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;
import nc.vo.wfengine.pub.WfTaskType;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.StringUtils;
import uap.iweb.wf.itf.IWorkflowExcutor;
import uap.iweb.wf.util.IWFHintMessageCallback;
import uap.iweb.wf.util.PFClientBizException;
import uap.iweb.wf.util.WFAlertExceptionUtil;
import uap.iweb.wf.util.WFAlertResult;
import uap.iweb.wf.vo.WFProInsVO;
import uap.iweb.wf.vo.WorkFlowQueryUtil;

public class WorkFlowExcutor
implements IWorkflowExcutor {
    @Override
    public WFAlertResult doAction(String actionCode, String pk_user, String pk_workflownote, String param) throws BusinessException {
        WFAlertResult ret = null;
        Map<String, Object> paramMap = this.readFromJson(param);
        HashMap eParam = (HashMap)paramMap.get("eParam");
        if ("agree".equals(actionCode)) {
            String note = (String)paramMap.get("param_note");
            Map task_userids_map = (Map)paramMap.get("param_assign_info");
            ret = this.doAgree(pk_user, pk_workflownote, note, task_userids_map, eParam);
        } else if ("disagree".equals(actionCode)) {
            String note = (String)paramMap.get("param_note");
            Map task_userids_map = (Map)paramMap.get("param_assign_info");
            ret = this.doDisAgree(pk_user, pk_workflownote, note, task_userids_map, eParam);
        } else if ("reject".equals(actionCode)) {
            String note = (String)paramMap.get("param_note");
            String pk_active = (String)paramMap.get("param_reject_activity");
            ret = this.doReject(pk_user, pk_workflownote, note, pk_active, eParam);
        } else if ("cancelApprove".equals(actionCode)) {
            this.doCancelApprove(pk_user, pk_workflownote, eParam);
        } else if ("reassign".equals(actionCode)) {
            String note = (String)paramMap.get("param_note");
            String reassigUser = (String)paramMap.get("param_reaassign_user");
            this.doReassign(pk_user, pk_workflownote, note, reassigUser);
        } else if ("addApprove".equals(actionCode)) {
            String note = (String)paramMap.get("param_note");
            List addUser = (List)paramMap.get("param_addApprove");
            this.doAddApprove(pk_user, pk_workflownote, note, addUser);
        } else if ("recall".equals(actionCode)) {
            this.doRecall(pk_user, pk_workflownote);
        }
        return ret;
    }

    private void checkForApprove(WorkflownoteVO workflownote) throws BusinessException {
        if (workflownote.getApprovestatus().intValue() != WfTaskOrInstanceStatus.Started.getIntValue()) {
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630099"));
        }
    }

    private void checkForCancelApprove(WorkflownoteVO workflownote) throws BusinessException {
        if (workflownote.getApprovestatus().intValue() != WfTaskOrInstanceStatus.Finished.getIntValue()) {
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630099"));
        }
    }

    private Map<String, Object> readFromJson(String param) {
        return (Map)new Gson().fromJson(param, Map.class);
    }

    public void doAgree(String pk_user, String pk_workflownote, String note, Map<String, List<String>> task_userids_map) throws BusinessException {
        note = StringUtils.isBlank((CharSequence)note) ? NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630100") : note;
        this.doApprove(pk_user, pk_workflownote, note, task_userids_map, "Y", null);
    }

    public void doDisAgree(String pk_user, String pk_workflownote, String note, Map<String, List<String>> task_userids_map) throws BusinessException {
        note = StringUtils.isBlank((CharSequence)note) ? NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630101") : note;
        this.doApprove(pk_user, pk_workflownote, note, task_userids_map, "N", null);
    }

    private WFAlertResult doApprove(String pk_user, String pk_workflownote, String note, Map<String, List<String>> task_userids_map, String checkResult, HashMap<String, Object> eParam) throws BusinessException {
        WorkflownoteVO workflownote = WorkFlowQueryUtil.queryWorkFlowNoteVO(pk_workflownote);
        this.checkForApprove(workflownote);
        AggregatedValueObject billvo = WorkFlowQueryUtil.queryBillVO(workflownote);
        workflownote = WorkFlowQueryUtil.checkWorkFlow(pk_user, workflownote, billvo);
        try {
            this.checkPFClientBiz(checkResult, workflownote, billvo, eParam);
            this.setCheckResultInfo(note, checkResult, workflownote);
            String actionName = this.getApproveActionName(workflownote.getWorkflow_type());
            if (!workflownote.getActiontype().endsWith("_A")) {
                this.setAssignableInfo(pk_user, checkResult, workflownote, task_userids_map);
            }
            this.setAlertForcePass(eParam, checkResult, billvo);
            IplatFormEntry pff = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class.getName());
            Object billVO = pff.processAction(actionName + pk_user, workflownote.getPk_billtype(), workflownote, billvo, null, eParam);
            return this.getAfterSucessHintMessage(billVO, workflownote.getPk_billtype());
        }
        catch (Exception e) {
            WFAlertResult result = this.handleAlterException(eParam, billvo, e);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    private WFAlertResult getAfterSucessHintMessage(Object billVO, String billtype) throws BusinessException {
        String hintMessage;
        IWFHintMessageCallback callback = this.getWFHintMessageCallback(billtype);
        if (callback != null && StringUtils.isNotBlank((CharSequence)(hintMessage = callback.getHintMessageAfterSucess(billVO)))) {
            WFAlertResult result = new WFAlertResult();
            result.setHintMessage(hintMessage);
            return result;
        }
        return null;
    }

    private IWFHintMessageCallback getWFHintMessageCallback(String billtype) {
        ArrayList<Billtype2VO> bt2VOs = PfDataCache.getBillType2Info(billtype, ExtendedClassEnum.AFTER_SUCESS_HINTMESSAGE_CALLBACK.getIntValue());
        for (Billtype2VO bt2VO : bt2VOs) {
            try {
                Object obj = PfUtilTools.findBizImplOfBilltype(billtype, bt2VO.getClassname());
                return (IWFHintMessageCallback)obj;
            }
            catch (Exception e) {
                Logger.error((Object)("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u524d\u53f0\u4e1a\u52a1\u63d2\u4ef6\u7c7bbillType=" + billtype + ",className=" + bt2VO.getClassname()), (Throwable)e);
            }
        }
        return null;
    }

    private void checkPFClientBiz(String checkResult, WorkflownoteVO workflownote, AggregatedValueObject billvo, HashMap<String, Object> eParam) throws BusinessException {
        boolean isForcePass = this.isPFClientBizForcePass(eParam);
        PFClientBizRetVO result = WorkFlowQueryUtil.getPFClientBizRet(workflownote, billvo);
        if (!isForcePass && result != null) {
            String hintMEssage = result.getHintMessage();
            if (!this.isActionEnable(checkResult, result)) {
                throw new BusinessException(hintMEssage);
            }
            if (StringUtils.isNotBlank((CharSequence)hintMEssage)) {
                throw new PFClientBizException(hintMEssage);
            }
        }
    }

    private boolean isActionEnable(String checkResult, PFClientBizRetVO result) {
        if ("Y".equalsIgnoreCase(checkResult) && result.isShowPass()) {
            return true;
        }
        if ("N".equalsIgnoreCase(checkResult) && result.isShowNoPass()) {
            return true;
        }
        if ("R".equalsIgnoreCase(checkResult) && result.isShowReject()) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)checkResult);
    }

    private boolean isPFClientBizForcePass(HashMap<String, Object> eParam) {
        List exceptionClassList;
        if (eParam != null && !CollectionUtils.isEmpty((Collection)(exceptionClassList = (List)eParam.get("alter_force_pass")))) {
            for (String exceptionClass : exceptionClassList) {
                if (!this.isPFClientBizException(exceptionClass)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPFClientBizException(String exceptionClass) {
        return PFClientBizException.class.getName().equals(exceptionClass);
    }

    private String getApproveActionName(int workflowtype) {
        if (workflowtype == WorkflowTypeEnum.Workflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkApproveflow.getIntValue()) {
            return "SIGNAL";
        }
        return "APPROVE";
    }

    private void setCheckResultInfo(String note, String checkResult, WorkflownoteVO workflownote) throws BusinessException {
        if (workflownote != null) {
            workflownote.setChecknote(note);
            if ("Y".equalsIgnoreCase(checkResult)) {
                workflownote.setApproveresult("Y");
            } else if ("N".equalsIgnoreCase(checkResult)) {
                workflownote.setApproveresult("N");
            } else if ("R".equalsIgnoreCase(checkResult)) {
                workflownote.getTaskInfo().getTask().setTaskType(WfTaskType.Backward.getIntValue());
                workflownote.getTaskInfo().getTask().setBackToFirstActivity(true);
            } else {
                throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("busitype", "busitypehint-000064"));
            }
        }
    }

    private void setAssignableInfo(String userid, String checkResult, WorkflownoteVO workflownote, Map<String, List<String>> task_userids_map) throws BusinessException {
        task_userids_map = task_userids_map == null ? new HashMap() : task_userids_map;
        Vector assignInfos = workflownote.getTaskInfo().getAssignableInfos();
        boolean mustAssignAll = workflownote.getTaskInfo().isAssignablePostCondition();
        ArrayList<String> unAssignActivityDesc = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)assignInfos)) {
            for (AssignableInfo assignInfo : assignInfos) {
                if (!this.isActiveEnable(checkResult, assignInfo)) continue;
                List userList = (List)task_userids_map.get(assignInfo.getActivityDefId());
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    assignInfo.getAssignedOperatorPKs();
                    for (String userId : userList) {
                        if (assignInfo.getAssignedOperatorPKs().contains(userId)) continue;
                        assignInfo.getAssignedOperatorPKs().add(userId);
                    }
                    continue;
                }
                if (!mustAssignAll) continue;
                unAssignActivityDesc.add(assignInfo.getDesc());
            }
            if (!unAssignActivityDesc.isEmpty()) {
                throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630105", null, new String[]{StringUtil.toString(unAssignActivityDesc, (String)",")}));
            }
        }
    }

    private boolean isActiveEnable(String checkResult, AssignableInfo assignInfo) {
        String strCriterion = assignInfo.getCheckResultCriterion();
        if ("Y".equals(checkResult)) {
            return AssignableInfo.CRITERION_NOTGIVEN.equals(strCriterion) || AssignableInfo.CRITERION_PASS.equals(strCriterion);
        }
        if ("N".equals(checkResult)) {
            return AssignableInfo.CRITERION_NOTGIVEN.equals(strCriterion) || AssignableInfo.CRITERION_NOPASS.equals(strCriterion);
        }
        return false;
    }

    public void doReject(String pk_user, String pk_workflownote, String note, String pk_active) throws BusinessException {
        this.doRejectAction(pk_user, pk_workflownote, note, pk_active, null);
    }

    private WFAlertResult doRejectAction(String pk_user, String pk_workflownote, String note, String pk_active, HashMap<String, Object> eParam) throws BusinessException, BusinessException {
        WorkflownoteVO workflownote = WorkFlowQueryUtil.queryWorkFlowNoteVO(pk_workflownote);
        this.checkForApprove(workflownote);
        AggregatedValueObject billvo = WorkFlowQueryUtil.queryBillVO(workflownote);
        workflownote = WorkFlowQueryUtil.checkWorkFlow(pk_user, workflownote, billvo);
        try {
            this.checkPFClientBiz("R", workflownote, billvo, eParam);
            note = StringUtils.isBlank((CharSequence)note) ? NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630102") : note;
            this.addRejectInfo(note, pk_active, workflownote);
            String actionName = this.getApproveActionName(workflownote.getWorkflow_type());
            this.setAlertForcePass(eParam, "R", billvo);
            IplatFormEntry entry = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class);
            Object billVO = entry.processAction(actionName + pk_user, workflownote.getPk_billtype(), workflownote, billvo, null, eParam);
            return this.getAfterSucessHintMessage(billVO, workflownote.getPk_billtype());
        }
        catch (Exception e) {
            WFAlertResult result = this.handleAlterException(eParam, billvo, e);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    private WFAlertResult handleAlterException(HashMap<String, Object> eParam, AggregatedValueObject billvo, Exception e) throws BusinessException {
        if (eParam != null) {
            WFAlertResult result = null;
            if (this.isPFClientBizException(e.getClass().getName())) {
                result = new WFAlertResult();
                result.addExceptionClass(e.getClass().getName());
                result.setMessage(e.getMessage());
            } else {
                result = WFAlertExceptionUtil.getInstance().getAlertMessageByException(e, billvo);
            }
            if (result != null) {
                this.appendLastExceptionClass(eParam, result);
                return result;
            }
        }
        return null;
    }

    private void appendLastExceptionClass(HashMap<String, Object> eParam, WFAlertResult result) {
        List exceptionClass = (List)eParam.get("alter_force_pass");
        if (exceptionClass != null && !exceptionClass.isEmpty()) {
            result.getExceptionClass().addAll(exceptionClass);
        }
    }

    private void addRejectInfo(String note, String pk_active, WorkflownoteVO worknoteVO) {
        worknoteVO.setChecknote(note);
        worknoteVO.setApproveresult("R");
        worknoteVO.getTaskInfo().getTask().setTaskType(WfTaskType.Backward.getIntValue());
        worknoteVO.getTaskInfo().getTask().setSubmit2RjectTache(false);
        if (StringUtil.isEmptyWithTrim((String)pk_active)) {
            worknoteVO.getTaskInfo().getTask().setBackToFirstActivity(true);
            worknoteVO.getTaskInfo().getTask().setJumpToActivity(null);
        } else {
            worknoteVO.getTaskInfo().getTask().setBackToFirstActivity(false);
            worknoteVO.getTaskInfo().getTask().setJumpToActivity(pk_active);
        }
    }

    @Override
    public void doAddApprove(String pk_user, String pk_workflownote, String note, List<String> addUser) throws BusinessException {
        note = StringUtils.isBlank((CharSequence)note) ? NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630103") : note;
        WorkflownoteVO workflownote = WorkFlowQueryUtil.queryWorkFlowNoteVO(pk_workflownote);
        this.checkForApprove(workflownote);
        IWorkflowAdmin srv = (IWorkflowAdmin)NCLocator.getInstance().lookup(IWorkflowAdmin.class);
        List<String> addUserList = this.checkAndTranUser(pk_user, addUser);
        workflownote.setExtApprovers(addUserList);
        workflownote.setChecknote(note);
        srv.addApprover(workflownote);
    }

    private List<String> checkAndTranUser(String pk_user, List<String> userIDs) throws BusinessException {
        if (userIDs == null || userIDs.size() == 0) {
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630106"));
        }
        for (String userID : userIDs) {
            if (!userID.equals(pk_user)) continue;
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "UPPpfworkflow-000827"));
        }
        List<String> addUserList = userIDs;
        return addUserList;
    }

    public void doCancelApprove(String pk_user, String pk_workflownote) throws BusinessException {
        this.doCancelApprove(pk_user, pk_workflownote, null);
    }

    @Override
    public WFAlertResult doCancelApprove(String pk_user, String pk_workflownote, HashMap<String, Object> eParam) throws BusinessException {
        Object billVO = null;
        String pk_billtype = null;
        IplatFormEntry pff = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class.getName());
        if (pk_workflownote.indexOf("@") > -1) {
            String[] str = pk_workflownote.split("@");
            pk_billtype = str[2];
            eParam.put("auto", true);
            AggregatedValueObject billvo = MobileAppUtil.queryBillEntity(pk_billtype, str[1]);
            billVO = pff.processAction("UNAPPROVE" + pk_user, pk_billtype, null, billvo, null, eParam);
        } else {
            WorkflownoteVO workflownote = WorkFlowQueryUtil.queryWorkFlowNoteVO(pk_workflownote);
            AggregatedValueObject billvo = MobileAppUtil.queryBillEntity(workflownote.getPk_billtype(), workflownote.getBillVersionPK());
            this.checkForCancelApprove(workflownote);
            String actionName = this.getCancelApproveActionName(workflownote.getWorkflow_type());
            pk_billtype = workflownote.getPk_billtype();
            try {
                this.setAlertForcePass(eParam, "C", billvo);
                billVO = pff.processAction(actionName + pk_user, workflownote.getPk_billtype(), null, billvo, null, eParam);
            }
            catch (Exception e) {
                WFAlertResult result = this.handleAlterException(eParam, billvo, e);
                if (result != null) {
                    return result;
                }
                throw e;
            }
        }
        return this.getAfterSucessHintMessage(billVO, pk_billtype);
    }

    private String getCancelApproveActionName(int workflowtype) {
        if (workflowtype == WorkflowTypeEnum.Workflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkApproveflow.getIntValue()) {
            return "ROLLBACK";
        }
        return "UNAPPROVE";
    }

    @Override
    public void doReassign(String pk_user, String pk_workflownote, String note, String pk_reassignUser) throws BusinessException {
        note = StringUtils.isBlank((CharSequence)note) ? NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630104") : note;
        WorkflownoteVO workflownote = WorkFlowQueryUtil.queryWorkFlowNoteVO(pk_workflownote);
        this.checkForApprove(workflownote);
        try {
            this.checkReassignUser(pk_user, pk_reassignUser);
            IWorkflowAdmin srv = (IWorkflowAdmin)NCLocator.getInstance().lookup(IWorkflowAdmin.class);
            srv.appointWorkitem(workflownote.getBillVersionPK(), workflownote.getPk_checkflow(), pk_user, pk_reassignUser, note);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkReassignUser(String userid, String pk_reassignUser) throws BusinessException {
        if (pk_reassignUser.equals(userid)) {
            throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "UPPpfworkflow-000014"));
        }
    }

    @Override
    public void doRecall(String pk_user, String pk_wf_instance) throws BusinessException {
        WFProInsVO proins = (WFProInsVO)((Object)new BaseDAO().retrieveByPK(WFProInsVO.class, pk_wf_instance));
        AggregatedValueObject billvo = MobileAppUtil.queryBillEntity(proins.getBilltype(), proins.getBillversionpk());
        IplatFormEntry pff = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class.getName());
        String actionName = this.getRecallActionName(proins.getWorkflow_type());
        pff.processAction(actionName + pk_user, proins.getBilltype(), null, billvo, null, null);
    }

    private String getRecallActionName(int workflowtype) {
        if (workflowtype == WorkflowTypeEnum.Workflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkflow.getIntValue() || workflowtype == WorkflowTypeEnum.SubWorkApproveflow.getIntValue()) {
            return "RECALL";
        }
        return "UNSAVE";
    }

    @Override
    public WFAlertResult doAgree(String pk_user, String pk_workflownote, String note, Map<String, List<String>> task_userids_map, HashMap<String, Object> eParam) throws BusinessException {
        note = StringUtils.isBlank((CharSequence)note) ? NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630100") : note;
        eParam = eParam == null ? new HashMap<String, Object>() : eParam;
        return this.doApprove(pk_user, pk_workflownote, note, task_userids_map, "Y", eParam);
    }

    @Override
    public WFAlertResult doDisAgree(String pk_user, String pk_workflownote, String note, Map<String, List<String>> task_userids_map, HashMap<String, Object> eParam) throws BusinessException {
        note = StringUtils.isBlank((CharSequence)note) ? NCLangResOnserver.getInstance().getStrByID("pfworkflow63", "0pfworkflow630101") : note;
        eParam = eParam == null ? new HashMap<String, Object>() : eParam;
        return this.doApprove(pk_user, pk_workflownote, note, task_userids_map, "N", eParam);
    }

    @Override
    public WFAlertResult doReject(String pk_user, String pk_workflownote, String note, String pk_active, HashMap<String, Object> eParam) throws BusinessException {
        eParam = eParam == null ? new HashMap<String, Object>() : eParam;
        return this.doRejectAction(pk_user, pk_workflownote, note, pk_active, eParam);
    }

    private void setAlertForcePass(HashMap<String, Object> eParam, String checkResult, AggregatedValueObject billvo) throws BusinessException {
        WFAlertExceptionUtil util = WFAlertExceptionUtil.getInstance();
        if (eParam == null) {
            return;
        }
        List exceptionClassList = (List)eParam.get("alter_force_pass");
        if (!CollectionUtils.isEmpty((Collection)exceptionClassList)) {
            for (String exceptionClass : exceptionClassList) {
                if (this.isPFClientBizException(exceptionClass)) continue;
                util.setAlertForcePass(exceptionClass, checkResult, billvo, eParam);
            }
        }
    }
}

