/*
 * Decompiled with CFR 0.152.
 */
package uap.iweb.wf.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.framework.core.util.ObjectCreator;
import nc.bs.logging.Logger;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.bd.pub.BDCacheMiscUtil;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.BusinessRuntimeException;
import uap.iweb.wf.util.IWFAlertExceptionHandler;
import uap.iweb.wf.util.IWFAlertExceptionHandler2;
import uap.iweb.wf.util.WFAlertResult;

public class WFAlertExceptionUtil {
    private static Map<String, WFAlertExceptionUtil> dsName_instance_map = new ConcurrentHashMap<String, WFAlertExceptionUtil>();
    private Map<String, IWFAlertExceptionHandler> handler_map = null;

    private WFAlertExceptionUtil() throws BusinessException {
        this.initCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WFAlertExceptionUtil getInstance() throws BusinessException {
        String dsName = BDCacheMiscUtil.getCurrentDatasourceName();
        WFAlertExceptionUtil instance = dsName_instance_map.get(dsName);
        Map<String, WFAlertExceptionUtil> map = dsName_instance_map;
        synchronized (map) {
            instance = dsName_instance_map.get(dsName);
            if (null == instance) {
                if (!RuntimeEnv.getInstance().isRunningInServer()) {
                    dsName_instance_map.clear();
                }
                instance = new WFAlertExceptionUtil();
                dsName_instance_map.put(dsName, instance);
            }
        }
        return instance;
    }

    public WFAlertResult getAlertMessageByException(Exception ex, Object billVO) throws BusinessException {
        BusinessException bizEx = this.findBusinessExceptionName(ex);
        if (bizEx == null) {
            return null;
        }
        String exceptionClass = ((Object)((Object)bizEx)).getClass().getName();
        IWFAlertExceptionHandler handler = this.getHandler(exceptionClass);
        if (handler == null) {
            return null;
        }
        String alertHiniMsg = null;
        alertHiniMsg = handler instanceof IWFAlertExceptionHandler2 ? ((IWFAlertExceptionHandler2)handler).getAlertMessageByException(bizEx, billVO) : handler.getAlertMessageByException(bizEx);
        WFAlertResult result = this.createWFAlertResult(exceptionClass, alertHiniMsg);
        return result;
    }

    private WFAlertResult createWFAlertResult(String exceptionClass, String alertHiniMsg) {
        WFAlertResult result = new WFAlertResult();
        result.setMessage(alertHiniMsg);
        result.addExceptionClass(exceptionClass);
        return result;
    }

    public void setAlertForcePass(String exceptionClass, String checkResult, AggregatedValueObject billvo, Map<String, Object> param) throws BusinessException {
        IWFAlertExceptionHandler handler = this.getHandler(exceptionClass);
        if (handler == null) {
            throw new BusinessException("Can't find WFAlertExceptionHandler,please check exception class:" + exceptionClass);
        }
        if (handler instanceof IWFAlertExceptionHandler2) {
            ((IWFAlertExceptionHandler2)handler).setAlertForcePass(checkResult, billvo, param);
        } else {
            handler.setAlertForcePass(checkResult, billvo);
        }
    }

    private IWFAlertExceptionHandler getHandler(String exceptionClass) throws BusinessException {
        if (this.handler_map == null || this.handler_map.isEmpty()) {
            this.initCache();
        }
        return this.handler_map.get(exceptionClass);
    }

    private Map<String, IWFAlertExceptionHandler> getHandler_map() throws BusinessException {
        if (this.handler_map == null || this.handler_map.isEmpty()) {
            this.initCache();
        }
        return this.handler_map;
    }

    private BusinessException findBusinessExceptionName(Exception e) throws BusinessException {
        if (e instanceof BusinessException) {
            if (this.getHandler_map().containsKey(e.getClass().getName())) {
                return (BusinessException)((Object)e);
            }
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                return this.findBusinessExceptionName((Exception)e.getCause());
            }
            return null;
        }
        if (e instanceof RuntimeException) {
            if (e instanceof BusinessExceptionAdapter) {
                return this.findBusinessExceptionName((Exception)((Object)((BusinessExceptionAdapter)e).originalException));
            }
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                return this.findBusinessExceptionName((Exception)e.getCause());
            }
        }
        return null;
    }

    private void initCache() throws BusinessException {
        List list = (List)new BaseDAO().executeQuery("select exceptionclass,module,pluginclass from pub_wf_alertctrl", (ResultSetProcessor)new ArrayListProcessor());
        this.handler_map = new HashMap<String, IWFAlertExceptionHandler>();
        for (Object[] objs : list) {
            String exceptionclass = (String)objs[0];
            String module = (String)objs[1];
            String pluginclassname = (String)objs[2];
            IWFAlertExceptionHandler plugin = WFAlertExceptionUtil.createInstance(pluginclassname, module);
            this.handler_map.put(exceptionclass, plugin);
        }
    }

    private static IWFAlertExceptionHandler createInstance(String className, String devModuleCode) {
        IWFAlertExceptionHandler instance = null;
        className = className.trim();
        try {
            if (StringUtil.isEmptyWithTrim((String)devModuleCode)) {
                instance = (IWFAlertExceptionHandler)ObjectCreator.newInstance((String)className);
            } else {
                try {
                    instance = (IWFAlertExceptionHandler)ObjectCreator.newInstance((String)devModuleCode, (String)className);
                }
                catch (Exception e) {
                    Logger.error((Object)("cann't create instance. ClassName: " + className + ", devModuleCode:" + devModuleCode + ". Please check register info in table pub_wf_alertctrl\n"));
                    Logger.error((Object)"try to create instance without devModuleCode.");
                    instance = (IWFAlertExceptionHandler)ObjectCreator.newInstance((String)className);
                }
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException("cann't create instance in all devModuleCode. ClassName: " + className + ". Please check register info in table pub_wf_alertctrl");
        }
        return instance;
    }
}

