/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import nc.vo.wfengine.core.WFElement;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.ShapeStyle;
import nc.vo.wfengine.core.util.CoreUtilities;
import nccloud.riawf.flowchar.NccFlowChart;
import nccloud.riawf.flowchar.NccIWorkflowCell;
import nccloud.riawf.flowchar.graph.NccLinkable;
import nccloud.riawf.flowchar.graph.NccTransitionCell;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.Port;

public abstract class NccAbstractFlowCell
extends DefaultGraphCell
implements NccIWorkflowCell,
NccLinkable {
    protected int activityVisualType = 0;
    private ShapeStyle _shapeStyle = ShapeStyle.RECTANGLE;

    public NccAbstractFlowCell() {
        this(null);
    }

    public NccAbstractFlowCell(Object userObject) {
        super(userObject);
    }

    public void setShapeStyle(ShapeStyle shape) {
        this._shapeStyle = shape;
    }

    public ShapeStyle getShapeStyle() {
        return this._shapeStyle;
    }

    private List getPorts() {
        ArrayList list = new ArrayList();
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            Object child = e.nextElement();
            if (!(child instanceof DefaultPort)) continue;
            list.add(child);
        }
        return list;
    }

    public Set getIncomingTransitions() {
        HashSet<NccTransitionCell> inputTransitions = new HashSet<NccTransitionCell>();
        List ports = this.getPorts();
        for (DefaultPort port : ports) {
            Iterator i = port.edges();
            while (i.hasNext()) {
                NccTransitionCell l = (NccTransitionCell)i.next();
                TreeNode target = ((DefaultPort)l.getTarget()).getParent();
                if (this != target) continue;
                inputTransitions.add(l);
            }
        }
        return inputTransitions;
    }

    public Set getOutgoingTransitions() {
        HashSet<NccTransitionCell> outputTransitions = new HashSet<NccTransitionCell>();
        List ports = this.getPorts();
        for (DefaultPort port : ports) {
            Iterator i = port.edges();
            while (i.hasNext()) {
                NccTransitionCell l = (NccTransitionCell)i.next();
                TreeNode source = ((DefaultPort)l.getSource()).getParent();
                if (this != source) continue;
                outputTransitions.add(l);
            }
        }
        return outputTransitions;
    }

    public void updateCell(NccFlowChart graph, Activity activity, boolean shapeChanged) {
        ArrayList<String> removedAttributes = new ArrayList<String>();
        HashMap propertyMap = new HashMap();
        Hashtable map = new Hashtable();
        if (shapeChanged) {
            this.changeShape(graph, this, activity);
        }
        GraphConstants.setFont(map, (Font)CoreUtilities.getTextFont(activity));
        GraphConstants.setForeground(map, (Color)CoreUtilities.getTextColor(activity));
        int allignment = CoreUtilities.getTextPosition(activity).getValue();
        switch (allignment) {
            case 1: {
                GraphConstants.setHorizontalTextPosition(map, (int)4);
                break;
            }
            case 0: {
                GraphConstants.setHorizontalTextPosition(map, (int)2);
                break;
            }
            case 3: {
                GraphConstants.setHorizontalTextPosition(map, (int)0);
                GraphConstants.setVerticalTextPosition(map, (int)3);
                break;
            }
            case 2: {
                GraphConstants.setHorizontalTextPosition(map, (int)0);
                GraphConstants.setVerticalTextPosition(map, (int)1);
                break;
            }
            default: {
                GraphConstants.setHorizontalTextPosition(map, (int)4);
            }
        }
        GraphConstants.setBackground(map, (Color)CoreUtilities.getBackground(activity));
        if (CoreUtilities.hasBorder(activity)) {
            GraphConstants.setBorderColor(map, (Color)CoreUtilities.getBorderColor(activity));
            GraphConstants.setLineWidth(map, (float)CoreUtilities.getBorderWidth(activity));
        } else {
            removedAttributes.add("border");
            removedAttributes.add("bordercolor");
        }
        GraphConstants.setOpaque(map, (boolean)CoreUtilities.isOpaque(activity));
        if (CoreUtilities.isUseIcon(activity)) {
            GraphConstants.setIcon(map, (Icon)new ImageIcon(activity.getIcon()));
        } else {
            removedAttributes.add("icon");
        }
        GraphConstants.setRemoveAttributes(map, (Object[])removedAttributes.toArray());
        propertyMap.put(this, map);
        graph.getGraphLayoutCache().edit(propertyMap, null, null, null);
        graph.repaint();
    }

    public void changeShape(NccFlowChart graph, NccAbstractFlowCell cell, WFElement stepVO) {
        ShapeStyle shapeStyle = CoreUtilities.getShapeStyle(stepVO);
        this.setShapeStyle(shapeStyle);
        graph.getGraphLayoutCache().removeMapping((Object)this);
        graph.getGraphLayoutCache().getMapping((Object)this, true);
        ArrayList<Object> removedPorts = new ArrayList<Object>();
        int portCount = graph.getModel().getChildCount((Object)this);
        for (int j = 0; j < portCount; ++j) {
            Object child = graph.getModel().getChild((Object)this, j);
            if (!(child instanceof Port)) continue;
            removedPorts.add(child);
        }
        graph.getModel().remove(removedPorts.toArray());
        Hashtable viewMap = new Hashtable();
        graph.getModel().insert(null, viewMap, null, null, null);
    }

    @Override
    public boolean acceptsSource() {
        return false;
    }

    @Override
    public boolean acceptsTarget() {
        return true;
    }

    @Override
    public String getTooltip() {
        return "";
    }

    @Override
    @Deprecated
    public void showPropertyDialog(Window parentWindow, NccFlowChart graph) {
    }

    public Object clone() {
        DefaultGraphCell cloneCell = (DefaultGraphCell)super.clone();
        cloneCell.setUserObject(this.cloneUserObject());
        return cloneCell;
    }

    public abstract Object cloneUserObject();
}

