/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import nc.bs.logging.Logger;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.guid.GuidUtils;
import nc.vo.wfengine.core.WFElement;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.ActivityEx;
import nc.vo.wfengine.core.activity.ActivitySet;
import nc.vo.wfengine.core.activity.BlockActivity;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.activity.Implementation;
import nc.vo.wfengine.core.activity.NoImplementation;
import nc.vo.wfengine.core.activity.OrganizeTransferObj;
import nc.vo.wfengine.core.activity.Route;
import nc.vo.wfengine.core.activity.ShapeStyle;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.activity.TextPosition;
import nc.vo.wfengine.core.activity.Tool;
import nc.vo.wfengine.core.activity.ToolSet;
import nc.vo.wfengine.core.activity.ToolType;
import nc.vo.wfengine.core.participant.BasicParticipantEx;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.participant.ParticipantType;
import nc.vo.wfengine.core.transition.BasicTransitionEx;
import nc.vo.wfengine.core.transition.Join;
import nc.vo.wfengine.core.transition.RoutingType;
import nc.vo.wfengine.core.transition.Split;
import nc.vo.wfengine.core.transition.SplitJoinType;
import nc.vo.wfengine.core.transition.TLineType;
import nc.vo.wfengine.core.transition.Transition;
import nc.vo.wfengine.core.transition.TransitionRestriction;
import nc.vo.wfengine.core.util.CoreUtilities;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.ActivityTypeEnum;
import nc.vo.wfengine.definition.StartOrEndInfo;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nccloud.riawf.flowchar.NccFlowChart;
import nccloud.riawf.flowchar.NccGraphUtils;
import nccloud.riawf.flowchar.NccResManager;
import nccloud.riawf.flowchar.NccUfWConstants;
import nccloud.riawf.flowchar.NccUfWGraphModel;
import nccloud.riawf.flowchar.NccUfWParentMap;
import nccloud.riawf.flowchar.graph.NccActivityCell;
import nccloud.riawf.flowchar.graph.NccBlockCell;
import nccloud.riawf.flowchar.graph.NccDesignerUtilsPub;
import nccloud.riawf.flowchar.graph.NccEndCell;
import nccloud.riawf.flowchar.graph.NccParticipantCell;
import nccloud.riawf.flowchar.graph.NccRouteCell;
import nccloud.riawf.flowchar.graph.NccStartCell;
import nccloud.riawf.flowchar.graph.NccSubflowCell;
import nccloud.riawf.flowchar.graph.NccTransitionCell;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;

public class NccFlowGraphManager {
    private transient NccFlowChart graph;
    private transient boolean _bShowParticipant = true;

    public NccFlowGraphManager(NccFlowChart chart) {
        this.graph = chart;
    }

    public NccFlowChart getGraph() {
        return this.graph;
    }

    public Object findNearestCell(Object selectedCell, int direction) {
        List cellSet = NccUfWGraphModel.getAllCellsInModel((GraphModel)this.graphModel());
        if (cellSet == null || cellSet.size() == 0) {
            return null;
        }
        Object[] cells = cellSet.toArray();
        if (selectedCell == null) {
            return cells[0];
        }
        Point2D centerOfSelectedCell = this.getCenter(selectedCell);
        if (centerOfSelectedCell == null) {
            return cells[0];
        }
        Object nearestCell = null;
        double minDistance = Double.MAX_VALUE;
        block5: for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == selectedCell || cells[i] instanceof Port) continue;
            Point2D centerOfCell = this.getCenter(cells[i]);
            Point2D.Double ref = new Point2D.Double(centerOfCell.getX(), centerOfSelectedCell.getY());
            double dist = centerOfSelectedCell.distance(centerOfCell);
            double absOfTan = centerOfCell.distance(ref) / ref.distance(centerOfSelectedCell);
            switch (direction) {
                case 1: {
                    if (!(centerOfCell.getY() >= centerOfSelectedCell.getY()) || !(dist < minDistance) || !(absOfTan >= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                    continue block5;
                }
                case 2: {
                    if (!(centerOfCell.getX() <= centerOfSelectedCell.getX()) || !(dist < minDistance) || !(absOfTan <= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                    continue block5;
                }
                case 3: {
                    if (!(centerOfCell.getX() >= centerOfSelectedCell.getX()) || !(dist < minDistance) || !(absOfTan <= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                    continue block5;
                }
                default: {
                    if (!(centerOfCell.getY() <= centerOfSelectedCell.getY()) || !(dist < minDistance) || !(absOfTan >= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                }
            }
        }
        return nearestCell;
    }

    public NccUfWGraphModel graphModel() {
        return (NccUfWGraphModel)this.graph.getModel();
    }

    private Point2D getCenter(Object cell) {
        if (cell == null) {
            return null;
        }
        Rectangle2D r = this.getBounds(cell, null);
        if (!(cell instanceof NccParticipantCell)) {
            return new Point2D.Double(r.getX() + r.getWidth() / 2.0, r.getY() + r.getHeight() / 2.0);
        }
        Participant userObject = (Participant)((NccParticipantCell)cell).getUserObject();
        double textPercent = CoreUtilities.getParticipantTextPercent(userObject);
        double nameHeight = r.getWidth() * textPercent;
        return new Point2D.Double(r.getX() + nameHeight / 2.0, r.getY() + r.getHeight() / 2.0);
    }

    public Rectangle2D getBounds(Object cell, Map propertyMap) {
        if (propertyMap != null && propertyMap.containsKey(cell)) {
            Map map = (Map)propertyMap.get(cell);
            return GraphConstants.getBounds((Map)map);
        }
        CellView view = this.getView(cell);
        return view.getBounds();
    }

    public Set getBlockActivities(boolean recursivly) {
        Set allActs = NccUfWGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        HashSet bas = new HashSet();
        if (allActs != null) {
            for (Object act : allActs) {
                NccFlowGraphManager wm;
                if (!(act instanceof NccBlockCell)) continue;
                bas.add(act);
                if (!recursivly || (wm = ((NccBlockCell)act).getWorkflowManager()) == null) continue;
                bas.addAll(wm.getBlockActivities(true));
            }
        }
        return bas;
    }

    @Deprecated
    protected void changeBounds(Object cell, Map propertyMap, Rectangle r) {
        if (propertyMap == null || !propertyMap.containsKey(cell)) {
            Hashtable map = new Hashtable();
            GraphConstants.setBounds(map, (Rectangle2D)r);
            propertyMap.put(cell, map);
        } else {
            Map map = (Map)propertyMap.get(cell);
            GraphConstants.setBounds((Map)map, (Rectangle2D)r);
        }
    }

    protected Rectangle getUnionBounds(Rectangle[] rects) {
        if (rects != null && rects.length > 0) {
            Rectangle unionRect = null;
            for (int i = 0; i < rects.length; ++i) {
                if (unionRect == null) {
                    unionRect = new Rectangle(rects[i]);
                    continue;
                }
                SwingUtilities.computeUnion(rects[i].x, rects[i].y, rects[i].width, rects[i].height, unionRect);
            }
            return unionRect;
        }
        return null;
    }

    public CellView getView(Object cell) {
        return this.graph.getGraphLayoutCache().getMapping(cell, false);
    }

    public void insertStart(Point2D p) {
        if (this.getStart() == null) {
            Point2D realP = this.graph.fromScreen(new Point2D.Double(p.getX(), p.getY()));
            Hashtable viewMap = new Hashtable();
            StartOrEndInfo startInfo = new StartOrEndInfo();
            startInfo.setFont(new Font("Dialog", 0, 12));
            startInfo.setTitle(StartOrEndInfo.DEFAULT_START_TITLE);
            startInfo.setType(StartOrEndInfo.DEFAULT_START_TPYE);
            startInfo.setCellIcon(NccResManager.getResourceString("DefaultNccStartCellIcon"));
            startInfo.setBackground(StartOrEndInfo.DEFAULT_START_BACKGROUND);
            startInfo.setDimension(new Rectangle((int)realP.getX() - 39, (int)realP.getY() - 20, 78, 60));
            NccStartCell sCell = this.createStart(startInfo, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{sCell}, null, null, viewMap, "MessageInsertingStart", true);
        }
    }

    public void insertEnd(Point2D p) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(p.getX(), p.getY()));
        Hashtable viewMap = new Hashtable();
        StartOrEndInfo endInfo = new StartOrEndInfo();
        endInfo.setFont(new Font("Dialog", 0, 12));
        endInfo.setTitle(StartOrEndInfo.DEFAULT_END_TITLE);
        endInfo.setType(StartOrEndInfo.DEFAULT_END_TYPE);
        endInfo.setCellIcon(NccResManager.getResourceString("DefaultNccEndCellIcon"));
        endInfo.setBackground(StartOrEndInfo.DEFAULT_END_BACKGROUND);
        endInfo.setDimension(new Rectangle((int)realP.getX() - 39, (int)realP.getY() - 20, 78, 60));
        NccEndCell e = this.createEnd(endInfo, viewMap);
        this.updateModelAndArrangeParticipants(new Object[]{e}, null, null, viewMap, "MessageInsertingEnd", true);
    }

    protected NccEndCell createEnd(StartOrEndInfo endInfo, Map viewMap) {
        Hashtable map = new Hashtable();
        this.setAppearForStartOrEnd(map, endInfo);
        NccEndCell e = new NccEndCell(endInfo);
        e.setShapeStyle(endInfo.getShapeStyle());
        viewMap.put(e, map);
        return e;
    }

    protected NccStartCell createStart(StartOrEndInfo startInfo, Map viewMap) {
        Hashtable map = new Hashtable();
        this.setAppearForStartOrEnd(map, startInfo);
        NccStartCell e = new NccStartCell(startInfo);
        e.setShapeStyle(startInfo.getShapeStyle());
        viewMap.put(e, map);
        return e;
    }

    private void setAppearForStartOrEnd(Map map, StartOrEndInfo info) {
        GraphConstants.setBounds((Map)map, (Rectangle2D)info.getDimension());
        GraphConstants.setBackground((Map)map, (Color)info.getBackground());
        if (info.getHasBorder()) {
            GraphConstants.setBorderColor((Map)map, (Color)info.getBorderColor());
        } else {
            GraphConstants.setRemoveAttributes((Map)map, (Object[])new Object[]{"border", "bordercolor"});
        }
        GraphConstants.setLineWidth((Map)map, (float)info.getBorderWidth());
        URL iconURL = NccResManager.loadImage(info.getCellIcon());
        if (info.getUseIcon() && iconURL != null) {
            GraphConstants.setIcon((Map)map, (Icon)new ImageIcon(iconURL));
            TextPosition allignment = info.getTextPosition();
            switch (allignment.getValue()) {
                case 1: {
                    GraphConstants.setHorizontalTextPosition((Map)map, (int)4);
                    GraphConstants.setVerticalTextPosition((Map)map, (int)0);
                    break;
                }
                case 0: {
                    GraphConstants.setHorizontalTextPosition((Map)map, (int)2);
                    GraphConstants.setVerticalTextPosition((Map)map, (int)0);
                    break;
                }
                case 3: {
                    GraphConstants.setVerticalTextPosition((Map)map, (int)3);
                    break;
                }
                case 2: {
                    GraphConstants.setVerticalTextPosition((Map)map, (int)1);
                    break;
                }
            }
        }
        GraphConstants.setFont((Map)map, (Font)info.getFont());
        GraphConstants.setForeground((Map)map, (Color)info.getTextColor());
        GraphConstants.setOpaque((Map)map, (boolean)info.getOpaque());
    }

    public NccStartCell getStart() {
        Set allActivities = NccUfWGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (allActivities != null) {
            for (Object act : allActivities) {
                if (!(act instanceof NccStartCell)) continue;
                return (NccStartCell)act;
            }
        }
        return null;
    }

    public Set getEnds() {
        HashSet ends = new HashSet();
        Set allActivities = NccUfWGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (allActivities != null) {
            for (Object act : allActivities) {
                if (!(act instanceof NccEndCell)) continue;
                ends.add(act);
            }
        }
        return ends;
    }

    protected void updateModelAndArrangeParticipants(Object[] insert, Map propertyMap, ParentMap parentMap, Map viewMap, String actionName, boolean updateCollection) {
        if (propertyMap == null && viewMap == null) {
            return;
        }
        if (propertyMap == null) {
            propertyMap = new HashMap(viewMap);
        }
        if (parentMap == null) {
            parentMap = new NccUfWParentMap();
        }
        if (this._bShowParticipant) {
            this.arrangeParticipants(propertyMap, parentMap);
        }
        this.graphModel().insert(insert, propertyMap, null, parentMap, null);
        if (updateCollection) {
            this.refreshCollections(insert, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void refreshCollections(Object[] cellsToAddOrRemove, boolean toAdd) {
        HashSet<Object> xmlaAR = new HashSet<Object>();
        HashSet<Transition> xmltAR = new HashSet<Transition>();
        HashSet<Object> baAR = new HashSet<Object>();
        for (int i = 0; i < (cellsToAddOrRemove == null ? 0 : cellsToAddOrRemove.length); ++i) {
            Object cell = cellsToAddOrRemove[i];
            if (cell instanceof NccTransitionCell) {
                TransitionRestriction tr;
                List trList;
                int noft;
                Activity a;
                void var11_12;
                NccTransitionCell tCell = (NccTransitionCell)cell;
                Transition xmlT = (Transition)tCell.getUserObject();
                NccActivityCell s = null;
                try {
                    s = tCell.getSourceActivity();
                }
                catch (Exception exception) {
                    s = this.getNccActivityCell(xmlT.getFrom());
                }
                Object var11_15 = null;
                try {
                    NccActivityCell nccActivityCell = tCell.getTargetActivity();
                }
                catch (Exception ex) {
                    NccActivityCell nccActivityCell = this.getNccActivityCell(xmlT.getTo());
                }
                if (toAdd) {
                    if (s != null && s.getUserObject() instanceof WFElement && var11_12 != null && var11_12.getUserObject() instanceof WFElement) {
                        xmltAR.add(xmlT);
                    }
                } else {
                    xmltAR.add(xmlT);
                }
                if (s != null && s.getUserObject() instanceof WFElement) {
                    a = (Activity)s.getUserObject();
                    noft = s.getOutgoingTransitions().size();
                    trList = a.getTransitionRestrictions();
                    if (trList.size() == 0) {
                        if (noft > 1) {
                            tr = new TransitionRestriction();
                            Split split = new Split();
                            split.setType(SplitJoinType.XOR);
                            tr.setSplit(split);
                            trList.add(tr);
                        }
                    } else if (noft <= 1) {
                        tr = (TransitionRestriction)trList.get(0);
                        tr.setSplit(null);
                    }
                }
                if (var11_12 == null || !(var11_12.getUserObject() instanceof WFElement)) continue;
                a = (Activity)var11_12.getUserObject();
                noft = var11_12.getIncomingTransitions().size();
                trList = a.getTransitionRestrictions();
                if (trList.size() == 0) {
                    if (noft <= 1) continue;
                    tr = new TransitionRestriction();
                    Join join = new Join();
                    join.setType(SplitJoinType.XOR);
                    tr.setJoin(join);
                    trList.add(tr);
                    continue;
                }
                if (noft > 1) continue;
                tr = (TransitionRestriction)trList.get(0);
                tr.setJoin(null);
                continue;
            }
            if (cell instanceof NccBlockCell) {
                xmlaAR.add(((NccBlockCell)cell).getUserObject());
                baAR.add(cell);
                continue;
            }
            if (!(cell instanceof NccActivityCell) || cell instanceof NccStartCell || cell instanceof NccEndCell) continue;
            xmlaAR.add(((NccActivityCell)cell).getUserObject());
        }
        WorkflowProcess wp = this.graph.getWorkflowProcess();
        if (wp != null) {
            List actsts = wp.getActivitySets();
            List acts = wp.getActivities();
            List trans = wp.getTransitions();
            if (toAdd) {
                acts.addAll(xmlaAR);
                trans.addAll(xmltAR);
            } else {
                acts.removeAll(xmlaAR);
                trans.removeAll(xmltAR);
            }
            for (NccBlockCell nccBlockCell : baAR) {
                ActivitySet as = null;
                String blockId = ((Activity)nccBlockCell.getUserObject()).getBlockActivity().getBlockId();
                if (toAdd) {
                    as = new ActivitySet(blockId);
                    actsts.add(as);
                    continue;
                }
                for (int i = 0; i < actsts.size(); ++i) {
                    as = (ActivitySet)actsts.get(i);
                    if (!as.getId().equals(blockId)) continue;
                    actsts.remove(as);
                }
            }
        }
    }

    protected void arrangeParticipants(Map propertyMap, ParentMap parentMap) {
        Object[] cellsToManage = propertyMap.keySet().toArray();
        for (int i = 0; i < cellsToManage.length; ++i) {
            Object cell = cellsToManage[i];
            if (!(cell instanceof NccActivityCell) || cell instanceof NccRouteCell || cell instanceof NccStartCell || cell instanceof NccEndCell || cell instanceof NccSubflowCell || cell instanceof NccBlockCell) continue;
            Set set = this.updateActivityParent((NccActivityCell)cell, propertyMap, parentMap);
        }
    }

    protected Set updateActivityParent(NccActivityCell ac, Map propertyMap, ParentMap parentMap) {
        HashSet<NccParticipantCell> oldAndNewPar = new HashSet<NccParticipantCell>();
        NccParticipantCell oldPar = (NccParticipantCell)((Object)ac.getParent());
        NccParticipantCell newPar = null;
        if (oldPar != null) {
            oldAndNewPar.add(oldPar);
        }
        if ((newPar = this.findParentParticipantForActivity(ac, propertyMap, parentMap)) != null) {
            oldAndNewPar.add(newPar);
            if (!newPar.equals(oldPar)) {
                parentMap.addEntry((Object)ac, (Object)newPar);
                ActivityEx actVo = (ActivityEx)ac.getUserObject();
                Participant parVo = (Participant)newPar.getUserObject();
                actVo.setPerformer(parVo.getId());
                actVo.setPerformerName(parVo.getName());
            }
        } else if (oldPar != null) {
            parentMap.addEntry((Object)ac, null);
            ActivityEx actVo = (ActivityEx)ac.getUserObject();
            actVo.setPerformer(null);
            actVo.setPerformerName(null);
        }
        return oldAndNewPar;
    }

    protected NccParticipantCell findParentParticipantForActivity(NccActivityCell ac, Map propertyMap, ParentMap parentMap) {
        NccParticipantCell newPar = null;
        Rectangle2D acRect = this.getBounds(ac, propertyMap);
        Rectangle2D parRect = null;
        Set participants = NccUfWGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (participants == null) {
            return null;
        }
        Iterator it = participants.iterator();
        NccParticipantCell iterPar = null;
        while (it.hasNext()) {
            iterPar = (NccParticipantCell)it.next();
            parRect = this.getBounds(iterPar, propertyMap);
            if (!acRect.intersects(parRect)) continue;
            newPar = iterPar;
            break;
        }
        return newPar;
    }

    public void createWorkflowGraph(WorkflowProcess wp, boolean bShowParticipants) {
        boolean isMine = false;
        if (NccGraphUtils.isMadeByUFW(wp.getPackage())) {
            isMine = true;
        }
        if (bShowParticipants) {
            this.createGraphParticipants(wp.getParticipants(), isMine);
        }
        this.createGraphActivities(wp, isMine);
        this.createGraphTransitions(wp.getTransitions());
        this.createGraphStarts(wp, isMine);
        this.createGraphEnds(wp, isMine);
    }

    private void createGraphEnds(WorkflowProcess wp, boolean isMine) {
        block3: {
            Hashtable viewMap;
            NccEndCell target;
            NccActivityCell source;
            block2: {
                source = null;
                target = null;
                viewMap = null;
                boolean isTransitionRouted = false;
                if (!isMine) break block2;
                List endInfoList = this.fetchEndInfo(wp);
                Iterator iter = endInfoList.iterator();
                StartOrEndInfo endInfo = null;
                while (iter.hasNext()) {
                    endInfo = (StartOrEndInfo)iter.next();
                    viewMap = new Hashtable();
                    source = this.getNccActivityCell(endInfo.getActivityId());
                    target = this.createEnd(endInfo, viewMap);
                    this.updateModelAndArrangeParticipants(new Object[]{target}, null, null, viewMap, "", false);
                    if (source == null || target == null) continue;
                    this.connectStartOrEndToActivity(source, target, endInfo);
                }
                break block3;
            }
            Set acs = NccUfWGraphModel.getAllActivitiesInModel(this.graph.getModel());
            if (acs == null) break block3;
            int translY = 120;
            for (NccActivityCell act : acs) {
                Set trns = act.getOutgoingTransitions();
                if (trns.size() != 0) continue;
                source = act;
                viewMap = new Hashtable();
                StartOrEndInfo endInfo = new StartOrEndInfo();
                endInfo.setTitle(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000084"));
                endInfo.setDimension(new Rectangle(20, translY, 36, 56));
                target = this.createEnd(endInfo, viewMap);
                translY += 70;
                this.updateModelAndArrangeParticipants(new Object[]{target}, null, null, viewMap, "", false);
                if (source == null || target == null) continue;
                this.connectStartOrEndToActivity(source, target, endInfo);
            }
        }
    }

    private void createGraphStarts(WorkflowProcess wp, boolean isMine) {
        NccStartCell source = null;
        NccActivityCell target = null;
        Hashtable viewMap = null;
        StartOrEndInfo startInfo = null;
        if (isMine) {
            startInfo = this.fetchStartInfo(wp);
            if (startInfo == null) {
                return;
            }
            startInfo.setType(StartOrEndInfo.DEFAULT_START_TPYE);
            viewMap = new Hashtable();
            target = this.getNccActivityCell(startInfo.getActivityId());
            source = this.createStart(startInfo, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{source}, null, null, viewMap, "", false);
        } else {
            Set acs = NccUfWGraphModel.getAllActivitiesInModel(this.graph.getModel());
            if (acs != null) {
                for (NccActivityCell act : acs) {
                    Set trns = act.getIncomingTransitions();
                    if (trns.size() != 0) continue;
                    target = act;
                    viewMap = new Hashtable();
                    startInfo = new StartOrEndInfo();
                    startInfo.setTitle(StartOrEndInfo.DEFAULT_START_TITLE);
                    startInfo.setType(StartOrEndInfo.DEFAULT_START_TPYE);
                    startInfo.setCellIcon(NccResManager.getResourceString("DefaultNccStartCellIcon"));
                    startInfo.setBackground(StartOrEndInfo.DEFAULT_START_BACKGROUND);
                    startInfo.setDimension(new Rectangle(20, 50, 36, 56));
                    source = this.createStart(startInfo, viewMap);
                    this.updateModelAndArrangeParticipants(new Object[]{source}, null, null, viewMap, "", false);
                    break;
                }
            }
        }
        if (source != null && target != null) {
            this.connectStartOrEndToActivity(source, target, startInfo);
        }
    }

    private void connectStartOrEndToActivity(NccActivityCell source, NccActivityCell target, StartOrEndInfo info) {
        if (info == null) {
            return;
        }
        BasicTransitionEx transVo = new BasicTransitionEx(GuidUtils.generate(), info.getTransTitle(), "", "");
        this.genExtAttrs4TransitionByStartOrEndInfo(transVo, info);
        this.insertTransitionByXPDL(source, target, transVo);
    }

    private void genExtAttrs4TransitionByStartOrEndInfo(Transition transVo, StartOrEndInfo info) {
        Map attrs = transVo.getExtendedAttributes();
        attrs.put("RoutingType", info.getRoutingType());
        attrs.put("LineColor", CoreUtilities.parseColor(info.getLineColor()));
        attrs.put("LineWidth", String.valueOf(info.getLineWidth()));
        attrs.put("LineType", String.valueOf(info.getLineType()));
        attrs.put("StartArrow", info.getStartArrow());
        attrs.put("EndArrow", info.getEndArrow());
        attrs.put("Dashed", info.getDashed() ? "true" : "false");
        attrs.put("DashPattern", info.getDashPattern());
        attrs.put("LabelPosition", info.getLabelPosition());
        attrs.put("LabelOffset", info.getLabelOffset());
    }

    private void createGraphTransitions(List list) {
        for (Object transObj : list) {
            if (!(transObj instanceof Transition)) continue;
            Transition transVo = (Transition)transObj;
            Activity fromAct = transVo.getFromActivity();
            Activity toAct = transVo.getToActivity();
            NccActivityCell source = fromAct == null ? null : this.getNccActivityCell(fromAct.getId());
            NccActivityCell target = toAct == null ? null : this.getNccActivityCell(toAct.getId());
            this.insertTransitionByXPDL(source, target, transVo);
        }
    }

    private void insertTransitionByXPDL(NccActivityCell srcActCell, NccActivityCell targetActCell, Transition transVo) {
        if (srcActCell == null || targetActCell == null) {
            return;
        }
        Hashtable viewMap = new Hashtable();
        NccTransitionCell tCell = this.createTransition(viewMap, transVo, true, false);
        Point2D startP = this.getCenter(srcActCell);
        Point2D endP = this.getCenter(targetActCell);
        Point2D p = this.graph.fromScreen(startP);
        Point2D p2 = this.graph.fromScreen(endP);
        Map map = (Map)viewMap.get(tCell);
        List lPoints = GraphConstants.getPoints((Map)map);
        if (lPoints == null) {
            ArrayList<Point2D> list = new ArrayList<Point2D>();
            list.add(p);
            list.add(p2);
            GraphConstants.setPoints((Map)map, list);
        } else {
            lPoints.add(0, p);
            lPoints.add(p2);
            GraphConstants.setPoints((Map)map, (List)lPoints);
        }
        ConnectionSet cs = new ConnectionSet();
        cs.connect((Object)tCell, (Object)srcActCell.getPort(), (Object)targetActCell.getPort());
        HashMap propertyMap = new HashMap(viewMap);
        Object[] insert = new Object[]{tCell};
        this.graphModel().insert(insert, propertyMap, cs, null, null);
    }

    private NccTransitionCell createTransition(Map viewMap, Transition transVo, boolean isLoadFromXPDL, boolean isRouting) {
        Transition userObject = transVo;
        if (!isLoadFromXPDL) {
            if (transVo == null) {
                transVo = new BasicTransitionEx(GuidUtils.generate(), "", "", "");
            }
            userObject = transVo;
            CoreUtilities.genDefaultExtAttr4Transition(userObject, isRouting);
        }
        NccTransitionCell tCell = new NccTransitionCell(userObject);
        Hashtable map = new Hashtable();
        this.setAppearForTransition(map, userObject);
        viewMap.put(tCell, map);
        return tCell;
    }

    public void insertTransition(Point2D start, Point2D end, PortView sourcePortView, PortView targetPortView, boolean isRouting) {
        Hashtable viewMap = new Hashtable();
        NccTransitionCell transCell = this.createTransition(viewMap, null, false, isRouting);
        Map map = (Map)viewMap.get(transCell);
        Point2D p = this.graph.fromScreen(new Point2D.Double(start.getX(), start.getY()));
        Point2D p2 = this.graph.fromScreen(new Point2D.Double(end.getX(), end.getY()));
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        list.add(p);
        list.add(p2);
        GraphConstants.setPoints((Map)map, list);
        Object[] insert = new Object[]{transCell};
        ConnectionSet cs = new ConnectionSet();
        if (sourcePortView != null && targetPortView != null) {
            DefaultPort sPort = (DefaultPort)sourcePortView.getCell();
            DefaultPort tPort = (DefaultPort)targetPortView.getCell();
            cs.connect((Object)transCell, (Object)sPort, (Object)tPort);
            Object sUserObject = ((NccActivityCell)((Object)sPort.getParent())).getUserObject();
            Object tUserObject = ((NccActivityCell)((Object)tPort.getParent())).getUserObject();
            Transition transVo = (Transition)transCell.getUserObject();
            if (!(sUserObject instanceof StartOrEndInfo) && !(tUserObject instanceof StartOrEndInfo)) {
                transVo.setFromActivity((Activity)sUserObject);
                transVo.setToActivity((Activity)tUserObject);
            }
        }
        this.graph.getModel().insert(insert, viewMap, cs, null, null);
        this.refreshCollections(insert, true);
    }

    private void setAppearForTransition(Map map, Transition userObject) {
        Map points;
        Point2D offsetLabel;
        Point2D pLabel = CoreUtilities.getLabelPosition(userObject);
        if (pLabel != null) {
            GraphConstants.setLabelPosition((Map)map, (Point2D)pLabel);
        }
        if ((offsetLabel = CoreUtilities.getLabelOffset(userObject)) != null) {
            GraphConstants.setOffset((Map)map, (Point2D)offsetLabel);
        }
        GraphConstants.setLineColor((Map)map, (Color)CoreUtilities.getLineColor(userObject));
        GraphConstants.setLineWidth((Map)map, (float)CoreUtilities.getLineWidth(userObject));
        RoutingType routingType = CoreUtilities.getRoutingType(userObject);
        if (routingType == RoutingType.SIMPLE) {
            GraphConstants.setRouting((Map)map, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
        }
        TLineType lineType = CoreUtilities.getLineType(userObject);
        int iLineType = lineType.getValue();
        switch (iLineType) {
            case 0: {
                GraphConstants.setLineStyle((Map)map, (int)11);
                break;
            }
            case 1: {
                GraphConstants.setLineStyle((Map)map, (int)13);
                break;
            }
            case 2: {
                GraphConstants.setLineStyle((Map)map, (int)12);
                break;
            }
            default: {
                GraphConstants.setLineStyle((Map)map, (int)11);
            }
        }
        boolean bDashed = CoreUtilities.isTransDashed(userObject);
        float[] dash = CoreUtilities.getDashPattern(userObject);
        if (bDashed) {
            GraphConstants.setDashPattern((Map)map, (float[])dash);
        }
        if ((points = NccGraphUtils.getBreakPoints(userObject)) != null && points.size() > 0) {
            ArrayList list = new ArrayList();
            Integer key = null;
            for (int i = 0; i < points.size(); ++i) {
                key = i;
                Point p = (Point)points.get(key);
                list.add(points.get(key));
            }
            GraphConstants.setPoints((Map)map, list);
        }
        String[] startArrow = CoreUtilities.getStartArrow(userObject);
        String[] endArrow = CoreUtilities.getEndArrow(userObject);
        if (startArrow != null) {
            GraphConstants.setLineBegin((Map)map, (int)NccTransitionCell.getArrowStyleToIndex(Integer.parseInt(startArrow[0])));
            GraphConstants.setBeginSize((Map)map, (int)Integer.parseInt(startArrow[1]));
            GraphConstants.setBeginFill((Map)map, (boolean)startArrow[2].equals("true"));
        }
        if (endArrow != null) {
            GraphConstants.setLineEnd((Map)map, (int)NccTransitionCell.getArrowStyleToIndex(Integer.parseInt(endArrow[0])));
            GraphConstants.setEndSize((Map)map, (int)Integer.parseInt(endArrow[1]));
            GraphConstants.setEndFill((Map)map, (boolean)endArrow[2].equals("true"));
        }
    }

    public NccActivityCell getNccActivityCell(String ID) {
        Set allActs = NccUfWGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (allActs != null) {
            for (NccActivityCell act : allActs) {
                Activity userobj;
                String curID;
                if (act instanceof NccStartCell || act instanceof NccEndCell || (curID = (userobj = (Activity)act.getUserObject()).getId()) == null || !curID.equals(ID)) continue;
                return act;
            }
        }
        return null;
    }

    public Set getActivitiesNotStartEnd() {
        Set allActs = NccUfWGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (allActs != null) {
            ArrayList<NccActivityCell> alStartEnd = new ArrayList<NccActivityCell>();
            Iterator it = allActs.iterator();
            NccActivityCell act = null;
            while (it.hasNext()) {
                act = (NccActivityCell)it.next();
                if (!(act instanceof NccStartCell) && !(act instanceof NccEndCell)) continue;
                alStartEnd.add(act);
            }
            allActs.removeAll(alStartEnd);
        }
        return allActs;
    }

    public boolean isMissingMakeBillActivity() {
        int workflowType = this.getGraph().getWorkflowProcess().getWorkflowType();
        if (workflowType == WorkflowTypeEnum.SubApproveflow.getIntValue() || workflowType == WorkflowTypeEnum.Workflow.getIntValue() || workflowType == WorkflowTypeEnum.SubWorkflow.getIntValue()) {
            return false;
        }
        Set allActs = this.getActivitiesNotStartEnd();
        if (allActs == null) {
            return true;
        }
        Iterator it = allActs.iterator();
        NccActivityCell act = null;
        GenericActivityEx userObj = null;
        while (it.hasNext()) {
            act = (NccActivityCell)it.next();
            Object obj = act.getUserObject();
            if (!(obj instanceof GenericActivityEx) || !(userObj = (GenericActivityEx)obj).getAppId().equals(ActivityTypeEnum.Makebill.getTag())) continue;
            return false;
        }
        return true;
    }

    private void createGraphParticipants(List participants, boolean isMine) {
        Iterator iter = participants.iterator();
        int count = participants.size();
        int i = 0;
        Rectangle partRect = null;
        if (isMine) {
            while (iter.hasNext()) {
                Participant partVo = (Participant)iter.next();
                partRect = CoreUtilities.getDimension(partVo);
                this.insertParticipantAndArrangeParticipants(partRect, partVo, true);
            }
        } else {
            partRect = new Rectangle(NccUfWConstants.defParticipantWidth, NccUfWConstants.defParticipantHeight);
            while (iter.hasNext()) {
                Point start = NccGraphUtils.getAutoCoordinateByIndex(i);
                partRect.x = start.x;
                partRect.y = start.y;
                Participant partVo = (Participant)iter.next();
                this.insertParticipantAndArrangeParticipants(partRect, partVo, true);
                ++i;
            }
        }
    }

    public void insertParticipantAndArrangeParticipants(Rectangle2D rect, Participant partVo, boolean isLoadFromXPDL) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(rect.getX(), rect.getY()));
        double ulx = realP.getX();
        double uly = realP.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(ulx, uly, rect.getWidth(), rect.getHeight());
        Hashtable viewMap = new Hashtable();
        NccParticipantCell partCell = this.createParticipant(bounds, viewMap, partVo, isLoadFromXPDL);
        HashMap propertyMap = new HashMap(viewMap);
        NccUfWParentMap parentMap = new NccUfWParentMap();
        Object[] insert = new Object[]{partCell};
        this.graphModel().insert(insert, propertyMap, null, parentMap, null);
        this.graph.getGraphLayoutCache().toBack(insert);
    }

    protected NccParticipantCell createParticipant(Rectangle2D bounds, Map viewMap, Participant partVo, boolean isLoadFromXPDL) {
        Participant userObject = partVo;
        if (!isLoadFromXPDL) {
            if (partVo == null) {
                partVo = new BasicParticipantEx(GuidUtils.generate(), NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000086"), ParticipantType.HUMAN);
            }
            userObject = partVo;
            WorkflowProcess wp = this.graph.getWorkflowProcess();
            wp.getParticipants().add(userObject);
            this.genDefaultExtAttr4Participant(bounds, userObject);
        }
        ((BasicParticipantEx)userObject).setType(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000087"));
        NccParticipantCell partCell = new NccParticipantCell(userObject);
        Hashtable map = new Hashtable();
        GraphConstants.setBounds(map, (Rectangle2D)bounds);
        this.setAppearForNccParticipantCell(map, userObject);
        viewMap.put(partCell, map);
        return partCell;
    }

    private void setAppearForNccParticipantCell(Map map, Participant userObject) {
        GraphConstants.setBackground((Map)map, (Color)CoreUtilities.getBackground(userObject));
        GraphConstants.setBorderColor((Map)map, (Color)CoreUtilities.getBorderColor(userObject));
        GraphConstants.setLineWidth((Map)map, (float)CoreUtilities.getBorderWidth(userObject));
        GraphConstants.setFont((Map)map, (Font)CoreUtilities.getTextFont(userObject));
        GraphConstants.setForeground((Map)map, (Color)CoreUtilities.getTextColor(userObject));
        GraphConstants.setOpaque((Map)map, (boolean)CoreUtilities.isOpaque(userObject));
        GraphConstants.setHorizontalTextPosition((Map)map, (int)4);
        GraphConstants.setVerticalTextPosition((Map)map, (int)0);
        String iconClsPath = CoreUtilities.getParticipantIcon(userObject);
        if (CoreUtilities.isUseIcon(userObject) && iconClsPath != null) {
            GraphConstants.setIcon((Map)map, (Icon)new ImageIcon(NccResManager.loadImage(iconClsPath)));
        }
    }

    private void genDefaultExtAttr4Participant(Rectangle2D bounds, Participant userObject) {
        Map attrs = userObject.getExtendedAttributes();
        attrs.put("Dimension", CoreUtilities.getRect(bounds.getBounds()));
        attrs.put("Font", "Dialog;0;12");
        attrs.put("TextColor", "Color.black");
        attrs.put("Background", "R=248,G=255,B=185");
        attrs.put("BorderColor", "Color.black");
        attrs.put("BorderWidth", "2");
        attrs.put("Opaque", "true");
        attrs.put("UseIcon", "true");
        attrs.put("Exchange", "true");
        attrs.put("TextPercent", NccUfWConstants.DEFALUT_TEXT_PERCENT);
        String iconClsPath = NccResManager.getResourceString("DefaultNccParticipantCellIcon");
        if (iconClsPath != null) {
            attrs.put("Icon", iconClsPath);
        }
    }

    private void createGraphActivities(WorkflowProcess wp, boolean isMine) {
        List activities = wp.getActivities();
        Iterator it = activities.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object mayBeActivity = it.next();
            if (!(mayBeActivity instanceof Activity) || this.insertMaybeActivity(index, (Activity)mayBeActivity, wp, isMine)) continue;
            ++index;
        }
    }

    private boolean insertMaybeActivity(int index, Activity actVo, WorkflowProcess wp, boolean isMine) {
        boolean isInsertToParticipant = false;
        Rectangle activityRect = null;
        List parts = wp.getParticipants();
        if (isMine) {
            activityRect = CoreUtilities.getDimension(actVo);
        } else {
            activityRect = new Rectangle(76, 76);
            Point start = NccGraphUtils.getAutoCoordinateByIndex(parts.size() + index);
            activityRect.x = start.x;
            activityRect.y = start.y;
        }
        Implementation impl = actVo.getImplementation();
        if (impl != null) {
            if (impl instanceof SubFlow) {
                this.insertSubflowAndArrangeParticipants(activityRect, actVo, true);
            } else {
                String parIdOfActivity = actVo.getPerformer();
                if (parIdOfActivity != null && !parIdOfActivity.equals("")) {
                    Participant element;
                    Iterator iter = parts.iterator();
                    int i = 0;
                    while (iter.hasNext() && !(element = (Participant)iter.next()).getId().equals(parIdOfActivity)) {
                        ++i;
                    }
                    if (i == parts.size()) {
                        Point p = NccGraphUtils.getAutoCoordinateByIndex(i);
                        activityRect.x = p.x + 10;
                        activityRect.y = p.y + 40;
                        isInsertToParticipant = true;
                    }
                }
                this.insertGenericAndArrangeParticipants(activityRect, actVo, true);
            }
        } else if (actVo.getRoute() != null) {
            this.insertRouteAndArrangeParticipants(activityRect, actVo, true);
        } else if (actVo.getBlockActivity() != null) {
            this.insertBlockAndArrangeParticipants(activityRect, actVo, true);
        } else {
            Logger.error((Object)"FATAL ERROR in insertActivities()!");
        }
        return isInsertToParticipant;
    }

    public void insertGenericAndArrangeParticipants(Rectangle2D rect, Activity actVo, boolean isLoadFromXPDL) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(rect.getX(), rect.getY()));
        double ulx = realP.getX();
        double uly = realP.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(ulx, uly, rect.getWidth(), rect.getHeight());
        boolean bOutsideParticipant = false;
        NccActivityCell actCell = null;
        if (!bOutsideParticipant) {
            Hashtable viewMap = new Hashtable();
            actCell = this.createGenericActivity(bounds, viewMap, actVo, isLoadFromXPDL);
            this.updateModelAndArrangeParticipants(new Object[]{actCell}, null, null, viewMap, "MessageInsertingGenericActivity", !isLoadFromXPDL);
        }
    }

    public void insertGenericActivityAndParticipent(Rectangle2D rect, Activity actVo, boolean isLoadFromXPDL) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(rect.getX(), rect.getY()));
        double ulx = realP.getX();
        double uly = realP.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(ulx, uly, rect.getWidth(), rect.getHeight());
        boolean bOutsideParticipant = false;
        NccActivityCell actCell = null;
        if (!bOutsideParticipant) {
            Hashtable viewMap = new Hashtable();
            actCell = this.createGenericActivity(bounds, viewMap, actVo, isLoadFromXPDL);
            this.createParticipent(actCell.getUserObject());
            this.updateModelAndArrangeParticipants(new Object[]{actCell}, null, null, viewMap, "MessageInsertingGenericActivity", !isLoadFromXPDL);
        }
    }

    private void createParticipent(Object act) {
        if (act instanceof GenericActivityEx) {
            WorkflowProcess ps = this.graph.getWorkflowProcess();
            GenericActivityEx ex = (GenericActivityEx)act;
            OrganizeTransferObj transferObj = (OrganizeTransferObj)CoreUtilities.getValueOfExtendedAttr(ex, "OrganizeTransferObj");
            BasicParticipantEx partVo = new BasicParticipantEx(GuidUtils.generate(), null, ParticipantType.HUMAN);
            if (!CoreUtilities.isParticipantAlreadyExist(partVo, ps)) {
                ps.getParticipants().add(partVo);
            }
            ex.setPerformer(partVo.getId());
        }
    }

    protected NccActivityCell createGenericActivity(Rectangle2D bounds, Map viewMap, Activity actVo, boolean isLoadFromXPDL) {
        Activity userObject = actVo;
        ShapeStyle shapeStyle = ShapeStyle.RECTANGLE;
        boolean isDefaultActivity = false;
        if (isLoadFromXPDL) {
            shapeStyle = CoreUtilities.getShapeStyle(userObject);
        } else {
            WorkflowProcess wp = this.graph.getWorkflowProcess();
            if (actVo == null) {
                isDefaultActivity = true;
                actVo = new GenericActivityEx(GuidUtils.generate(), NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000164"), wp);
                actVo.setImplementation(new NoImplementation());
                actVo.setIcon(NccResManager.getResourceString("DefaultGenericCellIcon"));
            }
            userObject = actVo;
        }
        if (userObject instanceof GenericActivityEx) {
            String appId;
            GenericActivityEx gae = (GenericActivityEx)userObject;
            if (isDefaultActivity) {
                this.makeDefaultGenericActivity(gae, bounds);
            }
            if ((appId = gae.getAppId()).trim().length() != 0) {
                gae.setAppName(ActivityTypeEnum.fromTag(appId).toString());
                gae.setType(ActivityTypeEnum.fromTag(appId).toString());
            }
            gae.setOrganizeTransferObj(this.getOrganizeTransferObj(this.graph.getWorkflowProcess(), gae));
        } else {
            ((ActivityEx)userObject).setType(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000089"));
        }
        NccActivityCell actCell = new NccActivityCell(userObject);
        actCell.setShapeStyle(shapeStyle);
        Hashtable map = new Hashtable();
        GraphConstants.setBounds(map, (Rectangle2D)bounds);
        this.setAppearForNccActivityCell(map, userObject);
        viewMap.put(actCell, map);
        return actCell;
    }

    private OrganizeTransferObj getOrganizeTransferObj(WorkflowProcess wp, GenericActivityEx gae) {
        OrganizeTransferObj obj = new OrganizeTransferObj();
        List parts = wp.getParticipants();
        String performerGuid = gae.getPerformer();
        Participant participant = NccDesignerUtilsPub.getParticipant(performerGuid, parts);
        obj.setOrgUnitTypeName(gae.getPerformerType());
        obj.setOrgUnitName(gae.getPerformerName());
        if (participant != null) {
            String orgunitpk = (String)CoreUtilities.getValueOfExtendedAttr(participant, "OrganizeUnitPK");
            String orgunittype = (String)CoreUtilities.getValueOfExtendedAttr(participant, "OrganizeUnitType");
            String orgunitBelong = (String)CoreUtilities.getValueOfExtendedAttr(participant, "OrganizeUnitBelongOrg");
            obj.setBelongOrg(orgunitBelong);
            obj.setOrgUnitPK(orgunitpk);
            obj.setOrgUnitType(orgunittype);
            return obj;
        }
        return null;
    }

    private void makeDefaultGenericActivity(GenericActivityEx gae, Rectangle2D dropPoint) {
        WorkflowProcess wp = gae.getWorkflowProcess();
        Participant billMaker = NccDesignerUtilsPub.getBillMakerParticipant(wp);
        boolean isMainFlow = wp.getWorkflowType() == WorkflowTypeEnum.Approveflow.getIntValue() || wp.getWorkflowType() == WorkflowTypeEnum.Workflow.getIntValue();
        OrganizeTransferObj transferObj = gae.getOrganizeTransferObj();
        if (billMaker != null || !isMainFlow) {
            if (transferObj != null && transferObj.isOnlyUsedForStart()) {
                return;
            }
            ToolSet toolset = new ToolSet();
            Tool tool = new Tool(this.getManualActivityType(wp.getWorkflowType()).getTag());
            tool.setToolType(ToolType.APPLICATION);
            toolset.getTools().add(tool);
            gae.setImplementation(toolset);
            gae.setAppId(this.getManualActivityType(wp.getWorkflowType()).getTag());
            gae.setAppName(this.getManualActivityType(wp.getWorkflowType()).toString());
            gae.setType(this.getManualActivityType(wp.getWorkflowType()).toString());
            gae.setIcon(this.getDefaultActivityIcon(false));
            CoreUtilities.fillDefaultExtAttr4CheckBillActivity(gae);
        } else if (isMainFlow) {
            ToolSet toolset = new ToolSet();
            Tool tool = new Tool(this.getStartActivityType().getTag());
            tool.setToolType(ToolType.APPLICATION);
            toolset.getTools().add(tool);
            gae.setImplementation(toolset);
            gae.setAppId(this.getStartActivityType().getTag());
            gae.setAppName(this.getStartActivityType().toString());
            gae.setType(this.getStartActivityType().toString());
            gae.setIcon(this.getDefaultActivityIcon(true));
            CoreUtilities.fillDefaultExtAttr4MakeBillActivity(gae);
        }
    }

    protected ActivityTypeEnum getManualActivityType(int wfType) {
        if (wfType == WorkflowTypeEnum.Approveflow.getIntValue() || wfType == WorkflowTypeEnum.SubApproveflow.getIntValue()) {
            return ActivityTypeEnum.Checkbill;
        }
        if (wfType == WorkflowTypeEnum.Workflow.getIntValue() || wfType == WorkflowTypeEnum.SubWorkflow.getIntValue()) {
            return ActivityTypeEnum.Manual;
        }
        return null;
    }

    protected ActivityTypeEnum getStartActivityType() {
        return ActivityTypeEnum.Makebill;
    }

    private String getDefaultActivityIcon(boolean isMakeBill) {
        if (isMakeBill) {
            return "nc/ui/wfengine/designer/resources/billmaker.png";
        }
        return "nc/ui/wfengine/designer/resources/manualActivity.png";
    }

    private void setAppearForNccActivityCell(Map map, Activity userObject) {
        GraphConstants.setBackground((Map)map, (Color)CoreUtilities.getBackground(userObject));
        if (CoreUtilities.hasBorder(userObject)) {
            GraphConstants.setBorderColor((Map)map, (Color)CoreUtilities.getBorderColor(userObject));
        } else {
            GraphConstants.setRemoveAttributes((Map)map, (Object[])new Object[]{"border", "bordercolor"});
        }
        GraphConstants.setLineWidth((Map)map, (float)CoreUtilities.getBorderWidth(userObject));
        String iconClsPath = userObject.getIcon();
        URL iconURL = NccResManager.loadImage(iconClsPath);
        if (CoreUtilities.isUseIcon(userObject) && iconURL != null) {
            GraphConstants.setIcon((Map)map, (Icon)new ImageIcon(iconURL));
            int allignment = CoreUtilities.getTextPosition(userObject).getValue();
            switch (allignment) {
                case 1: {
                    GraphConstants.setHorizontalTextPosition((Map)map, (int)4);
                    GraphConstants.setVerticalTextPosition((Map)map, (int)0);
                    break;
                }
                case 0: {
                    GraphConstants.setHorizontalTextPosition((Map)map, (int)2);
                    GraphConstants.setVerticalTextPosition((Map)map, (int)0);
                    break;
                }
                case 3: {
                    GraphConstants.setVerticalTextPosition((Map)map, (int)3);
                    break;
                }
                case 2: {
                    GraphConstants.setVerticalTextPosition((Map)map, (int)1);
                    break;
                }
            }
        }
        GraphConstants.setFont((Map)map, (Font)CoreUtilities.getTextFont(userObject));
        GraphConstants.setForeground((Map)map, (Color)CoreUtilities.getTextColor(userObject));
        GraphConstants.setOpaque((Map)map, (boolean)CoreUtilities.isOpaque(userObject));
    }

    private void genDefaultExtAttr4Subflow(Rectangle2D bounds, Activity act) {
        Map attrs = act.getExtendedAttributes();
        attrs.put("Font", "Dialog;0;12");
        attrs.put("TextColor", "Color.black");
        attrs.put("TextPosition", String.valueOf(3));
        attrs.put("Background", "Color.lightGray");
        attrs.put("HasBorder", "false");
        attrs.put("BorderColor", "Color.black");
        attrs.put("BorderWidth", "2");
        attrs.put("Opaque", "false");
        attrs.put("UseIcon", "true");
        attrs.put("Exchange", "true");
    }

    public void insertSubflowAndArrangeParticipants(Rectangle2D rect, Activity actVo, boolean isLoadFromXPDL) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(rect.getX(), rect.getY()));
        double ulx = realP.getX();
        double uly = realP.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(ulx, uly, rect.getWidth(), rect.getHeight());
        boolean bOutsideParticipant = false;
        NccSubflowCell NccSubflowCell2 = null;
        if (!bOutsideParticipant) {
            Hashtable viewMap = new Hashtable();
            NccSubflowCell2 = this.createSubflow(bounds, viewMap, actVo, isLoadFromXPDL);
            this.updateModelAndArrangeParticipants(new Object[]{NccSubflowCell2}, null, null, viewMap, "MessageInsertingSubflowActivity", !isLoadFromXPDL);
        }
    }

    protected NccSubflowCell createSubflow(Rectangle2D bounds, Map viewMap, Activity actVo, boolean isLoadFromXPDL) {
        Activity userObject = actVo;
        ShapeStyle shapeStyle = ShapeStyle.RECTANGLE;
        if (isLoadFromXPDL) {
            shapeStyle = CoreUtilities.getShapeStyle(userObject);
        } else {
            WorkflowProcess wp = this.graph.getWorkflowProcess();
            if (actVo == null) {
                actVo = new ActivityEx(GuidUtils.generate(), NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000090"), wp);
                SubFlow sf = new SubFlow(GuidUtils.generate());
                actVo.setImplementation(sf);
                actVo.setIcon(NccResManager.getResourceString("DefaultNccSubflowCellIcon"));
            }
            userObject = actVo;
            this.genDefaultExtAttr4Subflow(bounds, userObject);
        }
        int wfType = actVo.getWorkflowProcess().getWorkflowType();
        if (wfType == WorkflowTypeEnum.Workflow.getIntValue() || wfType == WorkflowTypeEnum.SubWorkflow.getIntValue()) {
            ((ActivityEx)userObject).setType(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000160"));
        } else {
            ((ActivityEx)userObject).setType(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000091"));
        }
        ((ActivityEx)userObject).setType(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "subflowActivityToolLabel"));
        NccSubflowCell sbf = new NccSubflowCell(userObject);
        sbf.setShapeStyle(shapeStyle);
        Hashtable map = new Hashtable();
        GraphConstants.setBounds(map, (Rectangle2D)bounds);
        this.setAppearForNccActivityCell(map, userObject);
        viewMap.put(sbf, map);
        return sbf;
    }

    public void insertBlockAndArrangeParticipants(Rectangle2D rect, Activity actVo, boolean isLoadFromXPDL) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(rect.getX(), rect.getY()));
        double ulx = realP.getX();
        double uly = realP.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(ulx, uly, rect.getWidth(), rect.getHeight());
        boolean bOutsideParticipant = false;
        NccBlockCell NccBlockCell2 = null;
        if (!bOutsideParticipant) {
            Hashtable viewMap = new Hashtable();
            NccBlockCell2 = this.createBlockActivity(bounds, viewMap, actVo, isLoadFromXPDL);
            this.updateModelAndArrangeParticipants(new Object[]{NccBlockCell2}, null, null, viewMap, "MessageInsertingBlockActivity", !isLoadFromXPDL);
        }
    }

    protected NccBlockCell createBlockActivity(Rectangle2D bounds, Map viewMap, Activity actVo, boolean isLoadFromXPDL) {
        Activity userObject = actVo;
        ShapeStyle shapeStyle = ShapeStyle.RECTANGLE;
        if (isLoadFromXPDL) {
            shapeStyle = CoreUtilities.getShapeStyle(userObject);
        } else {
            WorkflowProcess wp = this.graph.getWorkflowProcess();
            if (actVo == null) {
                actVo = new ActivityEx(GuidUtils.generate(), NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000092"), wp);
                BlockActivity ba = new BlockActivity();
                ba.setBlockId(GuidUtils.generate());
                actVo.setBlockActivity(ba);
                actVo.setIcon(NccResManager.getResourceString("DefaultNccBlockCellIcon"));
            }
            userObject = actVo;
        }
        ((ActivityEx)userObject).setType(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000093"));
        NccBlockCell baCell = new NccBlockCell(userObject);
        baCell.setShapeStyle(shapeStyle);
        Hashtable map = new Hashtable();
        GraphConstants.setBounds(map, (Rectangle2D)bounds);
        this.setAppearForNccActivityCell(map, userObject);
        viewMap.put(baCell, map);
        return baCell;
    }

    public void insertRouteAndArrangeParticipants(Rectangle2D rect, Activity actVo, boolean isLoadFromXPDL) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(rect.getX(), rect.getY()));
        double ulx = realP.getX();
        double uly = realP.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(ulx, uly, rect.getWidth(), rect.getHeight());
        boolean bOutsideParticipant = false;
        NccRouteCell rCell = null;
        if (!bOutsideParticipant) {
            Hashtable viewMap = new Hashtable();
            rCell = this.createRoute(bounds, viewMap, actVo, isLoadFromXPDL);
            this.updateModelAndArrangeParticipants(new Object[]{rCell}, null, null, viewMap, "MessageInsertingRouteActivity", !isLoadFromXPDL);
        }
    }

    public void insertAutoactivitytoolParticipants(Rectangle2D rect, Activity actVo, boolean isLoadFromXPDL) {
        Point2D realP = this.graph.fromScreen(new Point2D.Double(rect.getX(), rect.getY()));
        double ulx = realP.getX();
        double uly = realP.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(ulx, uly, rect.getWidth(), rect.getHeight());
        boolean bOutsideParticipant = false;
        NccActivityCell rCell = null;
        if (!bOutsideParticipant) {
            Hashtable viewMap = new Hashtable();
            rCell = this.createAutoactivitytool(bounds, viewMap, actVo, isLoadFromXPDL);
            this.updateModelAndArrangeParticipants(new Object[]{rCell}, null, null, viewMap, "MessageInsertingAutoeActivity", !isLoadFromXPDL);
        }
    }

    protected NccActivityCell createAutoactivitytool(Rectangle2D bounds, Map viewMap, Activity actVo, boolean isLoadFromXPDL) {
        Activity userObject = actVo;
        ShapeStyle shapeStyle = ShapeStyle.RECTANGLE;
        String lang = NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000177");
        if (isLoadFromXPDL) {
            shapeStyle = CoreUtilities.getShapeStyle(userObject);
        } else {
            WorkflowProcess wp = this.graph.getWorkflowProcess();
            if (actVo == null) {
                actVo = new GenericActivityEx(GuidUtils.generate(), lang, wp);
                actVo.setIcon(NccResManager.getResourceString("autoActivityImage"));
                ToolSet toolset = new ToolSet();
                Tool tool = new Tool(ActivityTypeEnum.Auto.getTag());
                tool.setToolType(ToolType.PROCEDURE);
                tool.setDescription(lang);
                toolset.getTools().add(tool);
                actVo.setImplementation(toolset);
                actVo.setName(ActivityTypeEnum.Auto.toString());
            }
            userObject = actVo;
            CoreUtilities.fillDefaultExtAttr4Route(userObject);
            shapeStyle = ShapeStyle.RECTANGLE;
        }
        ((ActivityEx)userObject).setType(lang);
        NccActivityCell actCell = new NccActivityCell(userObject);
        actCell.setShapeStyle(shapeStyle);
        Hashtable map = new Hashtable();
        GraphConstants.setBounds(map, (Rectangle2D)bounds);
        this.setAppearForNccActivityCell(map, userObject);
        viewMap.put(actCell, map);
        return actCell;
    }

    protected NccRouteCell createRoute(Rectangle2D bounds, Map viewMap, Activity actVo, boolean isLoadFromXPDL) {
        Activity userObject = actVo;
        ShapeStyle shapeStyle = ShapeStyle.CIRCLE;
        if (isLoadFromXPDL) {
            shapeStyle = CoreUtilities.getShapeStyle(userObject);
        } else {
            WorkflowProcess wp = this.graph.getWorkflowProcess();
            if (actVo == null) {
                actVo = new ActivityEx(GuidUtils.generate(), "R", wp);
                Route r = new Route();
                actVo.setRoute(r);
                actVo.setIcon(NccResManager.getResourceString("DefaultNccRouteCellIcon"));
            }
            userObject = actVo;
            CoreUtilities.fillDefaultExtAttr4Route(userObject);
            shapeStyle = ShapeStyle.RECTANGLE;
        }
        ((ActivityEx)userObject).setType(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000094"));
        NccRouteCell rCell = new NccRouteCell(userObject);
        rCell.setShapeStyle(shapeStyle);
        Hashtable map = new Hashtable();
        GraphConstants.setBounds(map, (Rectangle2D)bounds);
        this.setAppearForNccActivityCell(map, userObject);
        viewMap.put(rCell, map);
        return rCell;
    }

    public void insertCellsAndArrangeParticipants(Object[] insert, Map viewMap) {
        this.updateModelAndArrangeParticipants(insert, null, null, viewMap, "MessageDuplicatingObject", true);
    }

    public void removeCellsAndArrangeParticipants(Object[] cellsToDelete) {
        HashSet<TreeNode> participantsToArrange = new HashSet<TreeNode>();
        HashMap propertyMap = new HashMap();
        NccUfWParentMap parentMap = new NccUfWParentMap();
        HashSet<Object> ports = new HashSet<Object>();
        if (cellsToDelete != null && cellsToDelete.length > 0) {
            for (int i = 0; i < cellsToDelete.length; ++i) {
                if (cellsToDelete[i] instanceof NccParticipantCell) {
                    NccParticipantCell nccParticipantCell = (NccParticipantCell)cellsToDelete[i];
                    continue;
                }
                if (!(cellsToDelete[i] instanceof Port)) continue;
                ports.add(cellsToDelete[i]);
            }
            HashSet<Object> ctd = new HashSet<Object>(Arrays.asList(cellsToDelete));
            ctd.removeAll(ports);
            if (ctd.size() == 0) {
                return;
            }
            cellsToDelete = ctd.toArray();
            List cellsToDel = DefaultGraphModel.getDescendants((GraphModel)this.graphModel(), (Object[])cellsToDelete);
            Set edges = DefaultGraphModel.getEdges((GraphModel)this.graphModel(), (Object[])cellsToDel.toArray());
            cellsToDel.addAll(edges);
            HashSet allEdgesToDelete = new HashSet();
            HashSet allCellsToDelete = new HashSet();
            for (Object cell : cellsToDel) {
                if (cell instanceof Edge) {
                    allEdgesToDelete.add(cell);
                    continue;
                }
                if (cell instanceof Port) continue;
                allCellsToDelete.add(cell);
            }
            cellsToDelete = allCellsToDelete.toArray();
            for (int i = 0; i < cellsToDelete.length; ++i) {
                TreeNode parent = ((DefaultMutableTreeNode)cellsToDelete[i]).getParent();
                if (parent != null && parent instanceof NccParticipantCell && cellsToDelete[i] instanceof NccActivityCell) {
                    participantsToArrange.add(parent);
                }
                parentMap.addEntry(cellsToDelete[i], null);
            }
            this.graphModel().removeAndEdit(cellsToDel.toArray(), propertyMap);
            this.refreshCollections(cellsToDel.toArray(), false);
        }
    }

    public void moveCellsAndArrangeParticipants(Map propertyMap) {
        this.updateModelAndArrangeParticipants(null, propertyMap, null, null, "MessageMovingObjects", false);
    }

    public StartOrEndInfo fetchStartInfo(WorkflowProcess wp) {
        Map attrs = wp.getExtendedAttributes();
        String value = "";
        if (attrs.containsKey("UFW_StartOfWorkflow")) {
            value = (String)attrs.get("UFW_StartOfWorkflow");
        }
        StartOrEndInfo startInfo = this.constructStartOrEndInfo(value);
        return startInfo;
    }

    public List fetchEndInfo(WorkflowProcess wp) {
        ArrayList<StartOrEndInfo> endInfoList = new ArrayList<StartOrEndInfo>();
        Map attrs = wp.getExtendedAttributes();
        String extAttrValue = "";
        Set extAttrKeys = attrs.keySet();
        Iterator iter = extAttrKeys.iterator();
        String key = "";
        StartOrEndInfo endInfo = null;
        while (iter.hasNext()) {
            key = (String)iter.next();
            if (key.indexOf("UFW_EndOfWorkflow") < 0 || (endInfo = this.constructStartOrEndInfo(extAttrValue = (String)attrs.get(key))) == null) continue;
            endInfo.setType(StartOrEndInfo.DEFAULT_END_TYPE);
            endInfoList.add(endInfo);
        }
        return endInfoList;
    }

    private StartOrEndInfo constructStartOrEndInfo(String strInfo) {
        String[] infos = CoreUtilities.tokenize(strInfo, "@");
        StartOrEndInfo startInfo = new StartOrEndInfo();
        if (infos == null || infos.length == 0) {
            return null;
        }
        startInfo.setActivityId(infos[0]);
        startInfo.setTitle(infos[1].equals("-1") ? "" : infos[1]);
        startInfo.setDimension(CoreUtilities.parseRectString(infos[2]));
        startInfo.setShapeStyle(ShapeStyle.VALUES[Integer.parseInt(infos[3])]);
        startInfo.setFont(CoreUtilities.parseFontString(infos[4]));
        startInfo.setTextColor(CoreUtilities.getColor(infos[5]));
        startInfo.setTextPosition(TextPosition.VALUES[Integer.parseInt(infos[6])]);
        startInfo.setBackground(CoreUtilities.getColor(infos[7]));
        startInfo.setHasBorder(infos[8].equals("true"));
        startInfo.setBorderColor(CoreUtilities.getColor(infos[9]));
        startInfo.setBorderWidth(Float.parseFloat(infos[10]));
        startInfo.setOpaque(infos[11].equals("true"));
        startInfo.setUseIcon(infos[12].equals("true"));
        startInfo.setTransTitle(infos[13].equals("-1") ? "" : infos[13]);
        startInfo.setStartArrow(infos[14]);
        startInfo.setEndArrow(infos[15]);
        startInfo.setLineWidth(Float.parseFloat(infos[16]));
        startInfo.setLineColor(CoreUtilities.getColor(infos[17]));
        startInfo.setLineType(Integer.parseInt(infos[18]));
        startInfo.setRoutingType(infos[19]);
        startInfo.setDashed(infos[20].equals("true"));
        startInfo.setDashPattern(infos[21]);
        startInfo.setLabelPosition(infos[22]);
        startInfo.setCellIcon(infos[23]);
        if (infos.length > 24) {
            startInfo.setLabelOffset(infos[24]);
        }
        return startInfo;
    }
}

