/*
 * Decompiled with CFR 0.152.
 */
package nccloud.riawf.flowchar;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.ActivityEx;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nccloud.riawf.flowchar.NccFlowGraphManager;
import nccloud.riawf.flowchar.NccIWorkflowCell;
import nccloud.riawf.flowchar.NccUfWGraphModel;
import nccloud.riawf.flowchar.graph.NccActivityCell;
import nccloud.riawf.flowchar.graph.NccEndCell;
import nccloud.riawf.flowchar.graph.NccParticipantCell;
import nccloud.riawf.flowchar.graph.NccStartCell;
import nccloud.riawf.flowchar.graph.NccTransitionCell;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class NccFlowChart
extends JGraph
implements MouseListener {
    private Vector clickListeners = new Vector();
    protected WorkflowProcess _workflowProcess = null;
    protected NccFlowGraphManager _NccFlowGraphManager = new NccFlowGraphManager(this);

    public NccFlowChart(GraphModel model) {
        super(model);
    }

    public NccFlowChart(GraphLayoutCache cache) {
        super(cache);
    }

    public NccFlowChart(GraphModel model, BasicMarqueeHandler arg1) {
        super(model, arg1);
    }

    public NccFlowChart(GraphModel model, GraphLayoutCache cache, BasicMarqueeHandler mh) {
        super(model, cache, mh);
    }

    public NccFlowChart(GraphModel model, GraphLayoutCache cache) {
        super(model, cache);
    }

    public boolean isVertex(Object object) {
        if (!(object instanceof Port) && !(object instanceof Edge)) {
            return !this.isGroup(object) && object != null;
        }
        return false;
    }

    public boolean isGroup(Object cell) {
        CellView view = this.getGraphLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public CellView getNextViewAt(CellView current, double x, double y) {
        CellView[] sel = this.getOrderedAllSelectableCells();
        CellView cell = this.getNextViewAt(sel, current, x, y);
        return cell;
    }

    public CellView getNextViewAt(CellView[] cells, CellView c, double x, double y) {
        if (cells != null) {
            Rectangle2D.Double r = new Rectangle2D.Double(x - (double)this.tolerance, y - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            CellView first = null;
            boolean active = c == null;
            for (int i = 0; i < cells.length; ++i) {
                boolean intersects = false;
                intersects = cells[i].intersects((JGraph)this, (Rectangle2D)r);
                if (!intersects) continue;
                if (active) {
                    return cells[i];
                }
                if (first == null) {
                    first = cells[i];
                }
                active = active || cells[i] == c;
            }
            return first;
        }
        return null;
    }

    private CellView[] getOrderedAllSelectableCells() {
        CellView[] views = this.graphLayoutCache.getRoots();
        Stack<CellView> s = new Stack<CellView>();
        for (int i = 0; i < views.length; ++i) {
            s.add(views[i]);
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!s.isEmpty()) {
            CellView view = (CellView)s.pop();
            Object cell = view.getCell();
            if (!(cell instanceof Port)) {
                result.add(view);
            }
            CellView[] children = view.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                s.add(children[i]);
            }
        }
        ArrayList<CellView> activitiesAndEdges = new ArrayList<CellView>();
        ArrayList<CellView> participants = new ArrayList<CellView>();
        for (CellView cv : result) {
            if (cv.getCell() instanceof NccParticipantCell) {
                participants.add(cv);
                continue;
            }
            activitiesAndEdges.add(cv);
        }
        int i = -1;
        int j = participants.size() + activitiesAndEdges.size();
        CellView[] tmp = new CellView[j];
        Iterator it = activitiesAndEdges.iterator();
        while (it.hasNext()) {
            tmp[++i] = (CellView)it.next();
        }
        it = participants.iterator();
        while (it.hasNext()) {
            tmp[--j] = (CellView)it.next();
        }
        return tmp;
    }

    public WorkflowProcess getWorkflowProcess() {
        return this._workflowProcess;
    }

    public void populateByWorkflowProcess(WorkflowProcess process, boolean bShowParticipants) {
        this._workflowProcess = process;
        this.clearSelection();
        this._NccFlowGraphManager.createWorkflowGraph(process, bShowParticipants);
        this.clearSelection();
        this.revalidate();
    }

    public String getTooltip() {
        return "";
    }

    public NccFlowGraphManager getNccFlowGraphManager() {
        return this._NccFlowGraphManager;
    }

    public void setNccFlowGraphManager(NccFlowGraphManager manager) {
        this._NccFlowGraphManager = manager;
    }

    @Deprecated
    public void reload() {
        if (this._workflowProcess == null) {
            return;
        }
        this.setModel((GraphModel)new NccUfWGraphModel());
        this._NccFlowGraphManager.createWorkflowGraph(this._workflowProcess, true);
        this.revalidate();
    }

    public void setActivityRouteHighView(HashSet hsRunningActivityDefIds, String[] startedActivityDefIds, ArrayList<String[]> actRelas, Color gradientColor, Color borderColor) {
        if (startedActivityDefIds == null || startedActivityDefIds.length == 0) {
            return;
        }
        HashMap<NccIWorkflowCell, AttributeMap> propertyMap = new HashMap<NccIWorkflowCell, AttributeMap>();
        NccActivityCell cell = null;
        HashSet<String> hsStartedActivityDefIds = new HashSet<String>();
        for (int i = 0; i < startedActivityDefIds.length; ++i) {
            if (startedActivityDefIds[i] == null) continue;
            hsStartedActivityDefIds.add(startedActivityDefIds[i]);
            cell = this.getNccFlowGraphManager().getNccActivityCell(startedActivityDefIds[i]);
            if (cell == null) continue;
            AttributeMap amap = new AttributeMap();
            if (hsRunningActivityDefIds.contains(startedActivityDefIds[i])) {
                GraphConstants.setGradientColor((Map)amap, (Color)gradientColor);
            }
            GraphConstants.setOpaque((Map)amap, (boolean)true);
            Object[] objectArray = new Object[]{"border"};
            GraphConstants.setRemoveAttributes((Map)amap, (Object[])objectArray);
            if (hsRunningActivityDefIds.contains(startedActivityDefIds[i])) {
                GraphConstants.setBorder((Map)amap, (Border)BorderFactory.createBevelBorder(0, Color.GRAY, Color.GRAY));
            }
            GraphConstants.setBorderColor((Map)amap, (Color)borderColor);
            GraphConstants.setLineWidth((Map)amap, (float)2.0f);
            propertyMap.put(cell, amap);
        }
        HashSet<String> hsSrcTarget = new HashSet<String>();
        for (Object[] objectArray : actRelas) {
            hsSrcTarget.add(objectArray[0] + "+" + objectArray[1]);
        }
        Set allTransitions = NccUfWGraphModel.getAllTransitionsInModel((GraphModel)this.getNccFlowGraphManager().graphModel());
        for (NccTransitionCell NccTransitionCell2 : allTransitions) {
            NccActivityCell sourceCell = NccTransitionCell2.getSourceActivity();
            Activity srcAct = null;
            if (!(sourceCell instanceof NccStartCell) && !hsStartedActivityDefIds.contains((srcAct = (Activity)sourceCell.getUserObject()).getId())) continue;
            NccActivityCell targetCell = NccTransitionCell2.getTargetActivity();
            Activity targetAct = null;
            if (targetCell instanceof NccEndCell ? hsRunningActivityDefIds.size() > 0 : !hsStartedActivityDefIds.contains((targetAct = (Activity)targetCell.getUserObject()).getId())) continue;
            if (srcAct != null && targetAct != null && srcAct instanceof ActivityEx && targetAct instanceof ActivityEx && !hsSrcTarget.contains(srcAct.getId() + "+" + targetAct.getId())) continue;
            AttributeMap amap = new AttributeMap();
            GraphConstants.setLineColor((Map)amap, (Color)borderColor);
            GraphConstants.setLineWidth((Map)amap, (float)2.0f);
            propertyMap.put(NccTransitionCell2, amap);
        }
        this.getGraphLayoutCache().edit(propertyMap, null, null, null);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

