/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.workflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nc.vo.wfengine.core.XpdlPackage;
import nc.vo.wfengine.core.util.CoreUtilities;
import nc.vo.wfengine.core.util.DateUtilities;
import nc.vo.wfengine.core.workflow.AbstractWorkflowProcess;
import nc.vo.wfengine.core.workflow.BackModal;
import nc.vo.wfengine.core.workflow.MailMobileSetting;
import nc.vo.wfengine.core.workflow.MailModal;
import nc.vo.wfengine.core.workflow.MailPrintTemplet;
import nc.vo.wfengine.core.workflow.MobileModal;
import nc.vo.wfengine.core.workflow.ProcessHeader;
import nc.vo.wfengine.definition.WorkflowTypeEnum;

public class BasicWorkflowProcess
extends AbstractWorkflowProcess {
    static final long serialVersionUID = -2882297172070612924L;
    private String version;

    public BasicWorkflowProcess(String id, String name, XpdlPackage pkg, ProcessHeader processHeader) {
        super(id, name, pkg, processHeader);
    }

    public String getCreated() {
        Date createDate = super.getProcessHeader().getCreated();
        return DateUtilities.getInstance().format(createDate);
    }

    public void setHideNoPassing(boolean isHideNOPassing) {
        Map extAttr = this.getExtendedAttributes();
        if (isHideNOPassing) {
            extAttr.put("HideNoPassing", "true");
        } else {
            extAttr.put("HideNoPassing", "false");
        }
    }

    public boolean isHideNoPassing() {
        Object value = CoreUtilities.getValueOfExtendedAttr(this, "HideNoPassing");
        if (value == null) {
            return true;
        }
        return value.equals("true");
    }

    public boolean isHideReject() {
        Object value = CoreUtilities.getValueOfExtendedAttr(this, "HideNoReject");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public void setBillType(String billType) {
        CoreUtilities.setValueOfExtendedAttr(this, "PFBillType", billType);
    }

    public String getBillType() {
        String billtype = (String)CoreUtilities.getValueOfExtendedAttr(this, "PFBillType");
        return billtype;
    }

    public int getEmendFlow() {
        Object value = CoreUtilities.getValueOfExtendedAttr(this, "EmendFlow");
        if (value == null) {
            return -1;
        }
        return Integer.parseInt((String)value);
    }

    public void setEmendFlow(int emendEnum) {
        CoreUtilities.setValueOfExtendedAttr(this, "EmendFlow", String.valueOf(emendEnum));
    }

    public boolean getSubmitTORejecter() {
        return true;
    }

    public void setSubmitTORejecter(boolean isSubmitTORejecter) {
        CoreUtilities.setValueOfExtendedAttr(this, "SubmitTORejecter", isSubmitTORejecter ? "Y" : "N");
    }

    public String fetchSubmitTORejecter() {
        Object value = CoreUtilities.getValueOfExtendedAttr(this, "SubmitTORejecter");
        if (value == null) {
            return "N";
        }
        return value.toString();
    }

    public void putSubmitTORejecter(String isSubmitTORejecter) {
        CoreUtilities.setValueOfExtendedAttr(this, "SubmitTORejecter", isSubmitTORejecter);
    }

    @Override
    public void setDescription(String desc) {
        super.getProcessHeader().setDescription(desc);
    }

    @Override
    public String getDescription() {
        return super.getProcessHeader().getDescription();
    }

    public void setTimeLimit(int limitDays) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("TimeLimit", String.valueOf(limitDays));
    }

    public int getTimeLimit() {
        Object value = this.getExtendedAttributes().get("TimeLimit");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt((String)value);
    }

    public void setTimeRemind(int remindDays) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("TimeRemind", String.valueOf(remindDays));
    }

    public int getTimeRemind() {
        Object value = this.getExtendedAttributes().get("TimeRemind");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt((String)value);
    }

    public void setSupervisor(ArrayList<String> supervisorAry) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("Supervisor", supervisorAry);
    }

    public ArrayList<String> getSupervisor() {
        Object value = this.getExtendedAttributes().get("Supervisor");
        if (value == null) {
            return null;
        }
        return (ArrayList)value;
    }

    public int getPriority() {
        return CoreUtilities.getPriority(this);
    }

    public void setPriority(int priority) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("Priority", String.valueOf(priority));
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.0";
        }
        return this.version;
    }

    public void setWorkflowType(int wfType) {
        CoreUtilities.setValueOfExtendedAttr(this, "WorkflowType", String.valueOf(wfType));
    }

    @Override
    public int getWorkflowType() {
        Object type = CoreUtilities.getValueOfExtendedAttr(this, "WorkflowType");
        return type == null ? WorkflowTypeEnum.Approveflow.getIntValue() : Integer.parseInt(type.toString());
    }

    public List getRelevantData() {
        return this.getDataFields();
    }

    public void setRelevantData(List dataFields) {
    }

    public BackModal getBackModal() {
        Object obj = CoreUtilities.getValueOfExtendedAttr(this, "BackModal");
        return obj == null ? BackModal.STEP : BackModal.fromString(obj.toString());
    }

    public void setBackModal(BackModal backModal) {
        CoreUtilities.setValueOfExtendedAttr(this, "BackModal", backModal.getTag());
    }

    public MailModal getMailModal() {
        return MailModal.fromString(this.getProcessHeader().getMailMobile().getMailModal());
    }

    public void setWorkitemMsgConfig(String config) {
        this.getExtendedAttributes().put("WorkitemMsgConfig", config);
    }

    public String getWorkitemMsgConfig() {
        return (String)this.getExtendedAttributes().get("WorkitemMsgConfig");
    }

    public void setMailModal(MailModal mailModal) {
        this.getProcessHeader().getMailMobile().setMailModal(mailModal.getTag());
    }

    public MobileModal getMobileModal() {
        return MobileModal.fromString(this.getProcessHeader().getMailMobile().getMobileModal());
    }

    public void setMobileModal(MobileModal mobileModal) {
        this.getProcessHeader().getMailMobile().setMobileModal(mobileModal.getTag());
    }

    public MailPrintTemplet getMailPrintTemplet() {
        MailMobileSetting mms = this.getProcessHeader().getMailMobile();
        MailPrintTemplet mpt = new MailPrintTemplet(mms.getPrintTempletid(), mms.getPrintTempletname());
        return mpt;
    }

    public void setMailPrintTemplet(MailPrintTemplet mpt) {
        this.getProcessHeader().getMailMobile().setPrintTempletid(mpt.getTempletid());
        this.getProcessHeader().getMailMobile().setPrintTempletname(mpt.getTempletname());
    }

    public String toString2() {
        return "Package[workflowId='" + this.getId() + "', packageId='" + this.getPackage().getId() + "', name='" + this.getName() + "']";
    }

    public ArrayList<String> getWorkflowStateChangeInfo() {
        Object value = CoreUtilities.getValueOfExtendedAttr(this, "WorkflowStateChangeInfo");
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        ArrayList<String> arrs = new ArrayList<String>();
        if (value != null) {
            arrs.add(String.valueOf(value));
        }
        return arrs;
    }

    public void setWorkflowStateChangeInfo(ArrayList<String> statechange) {
        CoreUtilities.setValueOfExtendedAttr(this, "WorkflowStateChangeInfo", statechange);
    }

    public void setShowBillOrg(String billOrg) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("ShowBillOrg", billOrg);
    }

    public String getShowBillOrg() {
        return (String)this.getExtendedAttributes().get("ShowBillOrg");
    }

    public void setOrgUnitTree(ArrayList list) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("OrgUnitTree", list);
    }

    public ArrayList getOrgUnitTree() {
        return (ArrayList)this.getExtendedAttributes().get("OrgUnitTree");
    }

    public String toString() {
        return this.getName();
    }
}

