/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.transition;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import nc.vo.wfengine.core.IBeanInfoProvider;
import nc.vo.wfengine.core.condition.BasicCondition;
import nc.vo.wfengine.core.condition.Condition;
import nc.vo.wfengine.core.condition.ConditionType;
import nc.vo.wfengine.core.transition.ArrowStyle;
import nc.vo.wfengine.core.transition.BasicTransition;
import nc.vo.wfengine.core.transition.RoutingType;
import nc.vo.wfengine.core.transition.TLineType;
import nc.vo.wfengine.core.util.CoreUtilities;

public class BasicTransitionEx
extends BasicTransition
implements IBeanInfoProvider {
    public BasicTransitionEx(String id, String name, String from, String to) {
        super(id, name, from, to);
    }

    public void setLineType(TLineType lineType) {
        Map extAttr = this.getExtendedAttributes();
        int iLineType = lineType.getValue();
        extAttr.put("LineType", String.valueOf(iLineType));
    }

    public TLineType getLineType() {
        return CoreUtilities.getLineType(this);
    }

    public void setLineWidth(float lineWidth) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("LineWidth", String.valueOf(lineWidth));
    }

    public float getLineWidth() {
        return CoreUtilities.getLineWidth(this);
    }

    public void setLineColor(Color lineColor) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("LineColor", CoreUtilities.parseColor(lineColor));
    }

    public Color getLineColor() {
        return CoreUtilities.getLineColor(this);
    }

    public void setRoutingType(RoutingType routingType) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("RoutingType", routingType.getTag());
    }

    public RoutingType getRoutingType() {
        return CoreUtilities.getRoutingType(this);
    }

    public void setStartArrowStyle(ArrowStyle arrowStyle) {
        int iStyle = arrowStyle.getValue();
        String[] startArrow = CoreUtilities.getStartArrow(this);
        Map extAttr = this.getExtendedAttributes();
        String newStartArrow = String.valueOf(iStyle) + ";" + startArrow[1] + ";" + startArrow[2];
        extAttr.put("StartArrow", newStartArrow);
    }

    public ArrowStyle getStartArrowStyle() {
        String[] startArrow = CoreUtilities.getStartArrow(this);
        if (startArrow == null || startArrow.length != 3) {
            return ArrowStyle.NONE;
        }
        int iStyle = Integer.parseInt(startArrow[0]);
        return ArrowStyle.VALUES[iStyle];
    }

    public void setStartArrowSize(int arrowSize) {
        String[] startArrow = CoreUtilities.getStartArrow(this);
        Map extAttr = this.getExtendedAttributes();
        String newStartArrow = startArrow[0] + ";" + String.valueOf(arrowSize) + ";" + startArrow[2];
        extAttr.put("StartArrow", newStartArrow);
    }

    public int getStartArrowSize() {
        String[] startArrow = CoreUtilities.getStartArrow(this);
        if (startArrow == null || startArrow.length != 3) {
            return 10;
        }
        return Integer.parseInt(startArrow[1]);
    }

    public void setStartArrowFill(boolean filled) {
        String[] startArrow = CoreUtilities.getStartArrow(this);
        Map extAttr = this.getExtendedAttributes();
        String fill = "false";
        if (filled) {
            fill = "true";
        }
        String newStartArrow = startArrow[0] + ";" + startArrow[1] + ";" + fill;
        extAttr.put("StartArrow", newStartArrow);
    }

    public boolean getStartArrowFill() {
        String[] startArrow = CoreUtilities.getStartArrow(this);
        if (startArrow == null || startArrow.length != 3) {
            return false;
        }
        return startArrow[2].equals("true");
    }

    public void setEndArrowStyle(ArrowStyle arrowStyle) {
        int iStyle = arrowStyle.getValue();
        String[] endArrow = CoreUtilities.getEndArrow(this);
        Map extAttr = this.getExtendedAttributes();
        String newEndArrow = String.valueOf(iStyle) + ";" + endArrow[1] + ";" + endArrow[2];
        extAttr.put("EndArrow", newEndArrow);
    }

    public ArrowStyle getEndArrowStyle() {
        String[] endArrow = CoreUtilities.getEndArrow(this);
        if (endArrow == null || endArrow.length != 3) {
            return ArrowStyle.NONE;
        }
        int iStyle = Integer.parseInt(endArrow[0]);
        return ArrowStyle.VALUES[iStyle];
    }

    public void setEndArrowSize(int arrowSize) {
        String[] endArrow = CoreUtilities.getEndArrow(this);
        Map extAttr = this.getExtendedAttributes();
        String newEndArrow = endArrow[0] + ";" + String.valueOf(arrowSize) + ";" + endArrow[2];
        extAttr.put("EndArrow", newEndArrow);
    }

    public int getEndArrowSize() {
        String[] endArrow = CoreUtilities.getEndArrow(this);
        if (endArrow == null || endArrow.length != 3) {
            return 10;
        }
        return Integer.parseInt(endArrow[1]);
    }

    public void setEndArrowFill(boolean filled) {
        String[] endArrow = CoreUtilities.getEndArrow(this);
        Map extAttr = this.getExtendedAttributes();
        String fill = "false";
        if (filled) {
            fill = "true";
        }
        String newEndArrow = endArrow[0] + ";" + endArrow[1] + ";" + fill;
        extAttr.put("EndArrow", newEndArrow);
    }

    public boolean getEndArrowFill() {
        String[] endArrow = CoreUtilities.getEndArrow(this);
        if (endArrow == null || endArrow.length != 3) {
            return false;
        }
        return endArrow[2].equals("true");
    }

    public void setDashed(boolean dashed) {
        Map extAttr = this.getExtendedAttributes();
        String dash = "false";
        if (dashed) {
            dash = "true";
        }
        extAttr.put("Dashed", dash);
    }

    public boolean getDashed() {
        return CoreUtilities.isTransDashed(this);
    }

    public void setManualChoice(boolean isManualChoice) {
        Map extAttr = this.getExtendedAttributes();
        if (isManualChoice) {
            extAttr.put("ManualChoice", "true");
        } else {
            extAttr.put("ManualChoice", "false");
        }
    }

    public boolean getManualChoice() {
        Object value = CoreUtilities.getValueOfExtendedAttr(this, "ManualChoice");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public void setEmptySpan(float emptySpan) {
        Map extAttr = this.getExtendedAttributes();
        float[] dash_pattern = CoreUtilities.getDashPattern(this);
        String newDashPattern = String.valueOf(dash_pattern[0]) + ";" + String.valueOf(emptySpan);
        extAttr.put("DashPattern", newDashPattern);
    }

    public float getEmptySpan() {
        float[] dash = CoreUtilities.getDashPattern(this);
        if (dash == null || dash.length != 2) {
            return 5.0f;
        }
        return dash[1];
    }

    public void setSolidSpan(float solidSpan) {
        Map extAttr = this.getExtendedAttributes();
        float[] dash_pattern = CoreUtilities.getDashPattern(this);
        String newDashPattern = String.valueOf(solidSpan) + ";" + String.valueOf(dash_pattern[1]);
        extAttr.put("DashPattern", newDashPattern);
    }

    public float getSolidSpan() {
        float[] dash = CoreUtilities.getDashPattern(this);
        if (dash == null || dash.length != 2) {
            return 5.0f;
        }
        return dash[0];
    }

    public ConditionType getConditionType() {
        Condition condition = this.getCondition();
        if (condition == null) {
            condition = new BasicCondition();
            this.setCondition(condition);
        }
        return condition.getType();
    }

    public void setConditionType(ConditionType type) {
        Condition condition = this.getCondition();
        if (condition == null) {
            condition = new BasicCondition();
            this.setCondition(condition);
        }
        condition.setType(type);
    }

    public List getConditionXpression() {
        Condition condition = this.getCondition();
        if (condition == null) {
            condition = new BasicCondition();
            this.setCondition(condition);
        }
        List xPressions = condition.getXpressions();
        return xPressions;
    }

    public void setConditionXpression(List xPressions) {
    }

    public int getPriority() {
        return CoreUtilities.getPriority(this);
    }

    public void setPriority(int priority) {
        Map extAttr = this.getExtendedAttributes();
        extAttr.put("Priority", String.valueOf(priority));
    }

    @Override
    public String provideBeanInfoClass() {
        return "nc.ui.wfengine.designer.misc.BasicTransitionExBeanInfo";
    }
}

