/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.serializer;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import nc.vo.pub.lang.MultiLangText;
import nc.vo.wfengine.core.WFElement;
import nc.vo.wfengine.core.util.DateUtilities;
import nc.vo.wfengine.core.util.Duration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class XPDLSerializerUtil {
    private final DateFormat STANDARD_DF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");

    private XPDLSerializerUtil() {
    }

    public static void setNameWithMultiLang(Element element, WFElement wfElement) {
        XPDLSerializerUtil.setMultiLangAttr(element, "Name", wfElement.getMultiLangName());
    }

    public static void setMultiLangAttr(Element element, String fieldName, MultiLangText multiLangText) {
        element.setAttribute(fieldName, multiLangText.getText());
        element.setAttribute(fieldName + "2", multiLangText.getText2());
        element.setAttribute(fieldName + "3", multiLangText.getText3());
        element.setAttribute(fieldName + "4", multiLangText.getText4());
        element.setAttribute(fieldName + "5", multiLangText.getText5());
        element.setAttribute(fieldName + "6", multiLangText.getText6());
    }

    public static Element addChildElement(Element element, String child_ele_name, String text) {
        Document doc = element.getOwnerDocument();
        Element sub_element = doc.createElement(child_ele_name);
        if (text != null) {
            sub_element.appendChild(doc.createTextNode(text));
        }
        element.appendChild(sub_element);
        return sub_element;
    }

    public static Text addChildElement(Element element, String text) {
        Document doc = element.getOwnerDocument();
        Text t = doc.createTextNode(text);
        element.appendChild(t);
        return t;
    }

    static Element addElement(Element parent, String name) {
        return XPDLSerializerUtil.addChildElement(parent, name, null);
    }

    static Element addElement(Element parent, String name, Date value) {
        return XPDLSerializerUtil.addElement(parent, name, value, null);
    }

    static Element addElement(Element parent, String name, Date value, Date defaultValue) {
        Element child = null;
        if (value == null) {
            value = defaultValue;
        }
        if (value != null) {
            XPDLSerializerUtil.addChildElement(parent, name, DateUtilities.getInstance().format(value));
        }
        return child;
    }

    static Element addElement(Element parent, String name, String value) {
        return XPDLSerializerUtil.addElement(parent, name, value, null);
    }

    static Element addElement(Element parent, String name, String value, String defaultValue) {
        Element child = null;
        if (value == null) {
            value = defaultValue;
        }
        if (value != null) {
            XPDLSerializerUtil.addChildElement(parent, name, value.toString());
        }
        return child;
    }

    static Element addElement(Element parent, String name, URL value) {
        return XPDLSerializerUtil.addElement(parent, name, value, null);
    }

    static Element addElement(Element parent, String name, URL value, URL defaultValue) {
        Element child = null;
        if (value == null) {
            value = defaultValue;
        }
        if (value != null) {
            XPDLSerializerUtil.addChildElement(parent, name, value.toString());
        }
        return child;
    }

    static Element addElement(Element parent, String name, Duration value) {
        return XPDLSerializerUtil.addElement(parent, name, value, null);
    }

    static Element addElement(Element parent, String name, Duration value, Duration defaultValue) {
        Element child = null;
        if (value == null) {
            value = defaultValue;
        }
        if (value != null) {
            XPDLSerializerUtil.addChildElement(parent, name, value.toString());
        }
        return child;
    }
}

