/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.serializer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nc.rule.datastruct.AndRule;
import nc.rule.datastruct.IRule;
import nc.rule.datastruct.OrRule;
import nc.rule.datastruct.QueryRule;
import nc.vo.jcom.xml.XMLUtil;
import nc.vo.querytemplate.QueryTemplateUtils;
import nc.vo.wfengine.core.ConformanceClass;
import nc.vo.wfengine.core.GraphConformance;
import nc.vo.wfengine.core.PackageHeader;
import nc.vo.wfengine.core.PublicationStatus;
import nc.vo.wfengine.core.RedefinableHeader;
import nc.vo.wfengine.core.Script;
import nc.vo.wfengine.core.XpdlPackage;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.ActivitySet;
import nc.vo.wfengine.core.activity.AutomationMode;
import nc.vo.wfengine.core.activity.BlockActivity;
import nc.vo.wfengine.core.activity.CompletionStrategy;
import nc.vo.wfengine.core.activity.ExecutionType;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.activity.Implementation;
import nc.vo.wfengine.core.activity.NoImplementation;
import nc.vo.wfengine.core.activity.Route;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.activity.Tool;
import nc.vo.wfengine.core.activity.ToolSet;
import nc.vo.wfengine.core.application.Application;
import nc.vo.wfengine.core.condition.Condition;
import nc.vo.wfengine.core.condition.ConditionType;
import nc.vo.wfengine.core.data.ActualParameter;
import nc.vo.wfengine.core.data.ArrayType;
import nc.vo.wfengine.core.data.BasicType;
import nc.vo.wfengine.core.data.DataField;
import nc.vo.wfengine.core.data.DataType;
import nc.vo.wfengine.core.data.DeclaredType;
import nc.vo.wfengine.core.data.EnumerationType;
import nc.vo.wfengine.core.data.EnumerationValue;
import nc.vo.wfengine.core.data.ExternalReference;
import nc.vo.wfengine.core.data.FormalParameter;
import nc.vo.wfengine.core.data.ListType;
import nc.vo.wfengine.core.data.RecordType;
import nc.vo.wfengine.core.data.Type;
import nc.vo.wfengine.core.data.TypeDeclaration;
import nc.vo.wfengine.core.data.UnionType;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.serializer.ElementRequiredException;
import nc.vo.wfengine.core.serializer.XPDLSerializer;
import nc.vo.wfengine.core.serializer.XPDLSerializerException;
import nc.vo.wfengine.core.serializer.XPDLSerializerUtil;
import nc.vo.wfengine.core.transition.Join;
import nc.vo.wfengine.core.transition.Split;
import nc.vo.wfengine.core.transition.SplitJoinType;
import nc.vo.wfengine.core.transition.Transition;
import nc.vo.wfengine.core.transition.TransitionRestriction;
import nc.vo.wfengine.core.util.Deadline;
import nc.vo.wfengine.core.util.DurationUnit;
import nc.vo.wfengine.core.util.SimulationInformation;
import nc.vo.wfengine.core.util.TimeEstimation;
import nc.vo.wfengine.core.workflow.MailMobileSetting;
import nc.vo.wfengine.core.workflow.ProcessHeader;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nccloud.baseapp.xml.tool.XMLInstanceGenerate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UfXPDLSerializer
implements XPDLSerializer {
    static UfXPDLSerializer instance = new UfXPDLSerializer();
    public static final String DEFAULT_XPDL_VERSION = "1.0";
    public static final String DEFAULT_VENDOR = "Ufsoft";
    private final int SERIALIZE_TYPE_ALL = 0;
    private final int SERIALIZE_TYPE_NO_PROCESS = 1;
    private final int SERIALIZE_TYPE_PROCESS_ONLY = 2;

    private UfXPDLSerializer() {
    }

    public static UfXPDLSerializer getInstance() {
        return instance;
    }

    @Override
    public void serialize(XpdlPackage pkg, OutputStream out) throws Exception {
        Document doc = XMLUtil.getDocumentBuilder().newDocument();
        Element packageElement = doc.createElement("Package");
        doc.appendChild(packageElement);
        packageElement.setAttribute("xmlns", "http://www.wfmc.org/2002/XPDL1.0");
        packageElement.setAttribute("xmlns:xpdl", "http://www.wfmc.org/2002/XPDL1.0");
        packageElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        packageElement.setAttribute("xsi:schemaLocation", "http://www.w3.org/2000/10/XMLSchema");
        packageElement.setAttribute("Id", pkg.getId());
        packageElement.setAttribute("Name", pkg.getName());
        XPDLSerializerUtil.setNameWithMultiLang(packageElement, pkg);
        this.writePackageHeader(pkg.getPackageHeader(), packageElement);
        this.writeRedefinableHeader(pkg.getRedefinableHeader(), packageElement);
        this.writeConformanceClass(pkg.getConformanceClass(), packageElement);
        this.writeScript(pkg.getScript(), packageElement);
        this.writeTypeDeclarations(pkg.getTypeDeclarations(), packageElement);
        this.writeParticipants(pkg.getParticipants(), packageElement);
        this.writeApplications(pkg.getApplications(), packageElement);
        this.writeDataFields(pkg.getDataFields(), packageElement);
        this.writeWorkflowProcesses(pkg.getWorkflowProcesses(), packageElement);
        this.writeExtendedAttributes(pkg.getExtendedAttributes(), packageElement);
    }

    public void serialize(XpdlPackage pkg, String xpdlFilePath) throws Exception {
        FileOutputStream fos = new FileOutputStream(xpdlFilePath);
        this.serialize(pkg, fos);
    }

    protected void writePackageHeader(PackageHeader header, Element parent) throws XPDLSerializerException {
        if (header == null) {
            throw new ElementRequiredException("Package header required");
        }
        Element headerElement = XPDLSerializerUtil.addElement(parent, "PackageHeader");
        XPDLSerializerUtil.addElement(headerElement, "XPDLVersion", header.getXPDLVersion(), DEFAULT_XPDL_VERSION);
        XPDLSerializerUtil.addElement(headerElement, "Vendor", header.getVendor(), DEFAULT_VENDOR);
        XPDLSerializerUtil.addElement(headerElement, "Created", header.getCreated(), new Date());
        XPDLSerializerUtil.addElement(headerElement, "Description", header.getDescription());
        XPDLSerializerUtil.addElement(headerElement, "Documentation", header.getDocumentation());
        XPDLSerializerUtil.addElement(headerElement, "PriorityUnit", header.getPriorityUnit());
        XPDLSerializerUtil.addElement(headerElement, "CostUnit", header.getCostUnit());
    }

    protected void writeRedefinableHeader(RedefinableHeader header, Element parent) {
        if (header == null) {
            return;
        }
        Element headerElement = XPDLSerializerUtil.addElement(parent, "RedefinableHeader");
        XPDLSerializerUtil.addElement(headerElement, "Author", header.getAuthor());
        XPDLSerializerUtil.addElement(headerElement, "Version", header.getVersion());
        XPDLSerializerUtil.addElement(headerElement, "Codepage", header.getCodepage());
        XPDLSerializerUtil.addElement(headerElement, "Countrykey", header.getCountrykey());
        this.writeResponsibles(header.getResponsibles(), headerElement);
        PublicationStatus publicationStatus = header.getPublicationStatus();
        if (publicationStatus != null) {
            headerElement.setAttribute("PublicationStatus", publicationStatus.toString());
        }
    }

    protected void writeConformanceClass(ConformanceClass cc, Element parent) {
        if (cc == null) {
            return;
        }
        Element ccElement = XPDLSerializerUtil.addElement(parent, "ConformanceClass");
        GraphConformance gc = cc.getGraphConformance();
        if (gc != null) {
            ccElement.setAttribute("GraphConformance", gc.toString());
        }
    }

    protected void writeScript(Script script, Element parent) {
        if (script == null) {
            return;
        }
        Element scriptElement = XPDLSerializerUtil.addElement(parent, "Script");
        scriptElement.setAttribute("Type", script.getType());
        scriptElement.setAttribute("Version", script.getVersion());
        scriptElement.setAttribute("Grammar", script.getGrammar());
    }

    protected void writeTypeDeclarations(List typeDeclarations, Element parent) throws XPDLSerializerException {
        if (typeDeclarations == null || typeDeclarations.size() == 0) {
            return;
        }
        Element typeDeclarationsElement = XPDLSerializerUtil.addElement(parent, "TypeDeclarations");
        for (TypeDeclaration typeDeclaration : typeDeclarations) {
            Element typeDeclarationElement = XPDLSerializerUtil.addElement(typeDeclarationsElement, "TypeDeclaration");
            typeDeclarationElement.setAttribute("Id", typeDeclaration.getId());
            typeDeclarationElement.setAttribute("Name", typeDeclaration.getName());
            XPDLSerializerUtil.addElement(typeDeclarationElement, "Description", typeDeclaration.getDescription());
            this.writeType(typeDeclaration.getType(), typeDeclarationElement);
            this.writeExtendedAttributes(typeDeclaration.getExtendedAttributes(), typeDeclarationElement);
        }
    }

    protected void writeParticipants(List participants, Element parent) {
        if (participants == null || participants.size() == 0) {
            return;
        }
        Element participantsElement = XPDLSerializerUtil.addElement(parent, "Participants");
        for (Participant participant : participants) {
            Element participantElement = XPDLSerializerUtil.addElement(participantsElement, "Participant");
            participantElement.setAttribute("Id", participant.getId());
            if (participant.getName() != null) {
                participantElement.setAttribute("Name", participant.getName());
            }
            Element participantTypeElement = XPDLSerializerUtil.addElement(participantElement, "ParticipantType");
            participantTypeElement.setAttribute("Type", participant.getParticipantType().toString());
            XPDLSerializerUtil.addElement(participantElement, "Description", participant.getDescription());
            this.writeExtendedAttributes(participant.getExtendedAttributes(), participantElement);
        }
    }

    protected void writeApplications(List applications, Element parent) throws XPDLSerializerException {
        if (applications == null || applications.size() == 0) {
            return;
        }
        Element applicationsElement = XPDLSerializerUtil.addElement(parent, "Applications");
        for (Application application : applications) {
            Element applicationElement = XPDLSerializerUtil.addElement(applicationsElement, "Application");
            applicationElement.setAttribute("Id", application.getId());
            if (application.getName() != null) {
                applicationElement.setAttribute("Name", application.getName());
            }
            if (application.getDescription() != null) {
                XPDLSerializerUtil.addElement(applicationElement, "Description", application.getDescription());
            }
            this.writeFormalParameters(application.getFormalParameters(), applicationElement);
            this.writeExternalReference(application.getExternalReference(), applicationElement);
            this.writeExtendedAttributes(application.getExtendedAttributes(), applicationElement);
        }
    }

    protected void writeDataFields(List dataFields, Element parent) throws XPDLSerializerException {
        if (dataFields == null || dataFields.size() == 0) {
            return;
        }
        Element dataFieldsElement = XPDLSerializerUtil.addElement(parent, "DataFields");
        for (DataField dataField : dataFields) {
            Element dataFieldElement = XPDLSerializerUtil.addElement(dataFieldsElement, "DataField");
            dataFieldElement.setAttribute("Id", dataField.getId());
            if (dataField.getName() != null) {
                dataFieldElement.setAttribute("Name", dataField.getName());
            }
            if (dataField.isArray()) {
                dataFieldElement.setAttribute("IsArray", String.valueOf(dataField.isArray()));
            }
            this.writeDataType(dataField.getDataType(), dataFieldElement);
            XPDLSerializerUtil.addElement(dataFieldElement, "InitialValue", dataField.getInitialValue());
            if (dataField.isArray()) {
                XPDLSerializerUtil.addElement(dataFieldElement, "Length", Integer.toString(dataField.getLength()));
            }
            XPDLSerializerUtil.addElement(dataFieldElement, "Description", dataField.getDescription());
            this.writeExtendedAttributes(dataField.getExtendedAttributes(), dataFieldElement);
        }
    }

    protected void writeDataType(DataType dataType, Element parent) throws XPDLSerializerException {
        if (dataType == null) {
            return;
        }
        Element dataTypeElement = XPDLSerializerUtil.addElement(parent, "DataType");
        this.writeType(dataType.getType(), dataTypeElement);
    }

    protected void writeResponsibles(List responsibles, Element parent) {
        if (responsibles == null || responsibles.size() == 0) {
            return;
        }
        Element responsiblesElement = XPDLSerializerUtil.addElement(parent, "Responsibles");
        for (String responsibleId : responsibles) {
            XPDLSerializerUtil.addElement(responsiblesElement, "Responsible", responsibleId);
        }
    }

    protected void writeType(Type type, Element parent) throws XPDLSerializerException {
        if (type instanceof BasicType) {
            Element typeElement = XPDLSerializerUtil.addElement(parent, "BasicType");
            typeElement.setAttribute("Type", type.toString());
        } else if (type instanceof RecordType) {
            Element typeElement = XPDLSerializerUtil.addElement(parent, "RecordType");
            Element memberElement = XPDLSerializerUtil.addElement(typeElement, "Member");
            Iterator iter = ((RecordType)type).getMembers().iterator();
            while (iter.hasNext()) {
                this.writeType((Type)iter.next(), memberElement);
            }
        } else if (type instanceof UnionType) {
            Element typeElement = XPDLSerializerUtil.addElement(parent, "UnionType");
            Iterator iter = ((UnionType)type).getMembers().iterator();
            while (iter.hasNext()) {
                this.writeType((Type)iter.next(), typeElement);
            }
        } else if (type instanceof ListType) {
            Element typeElement = XPDLSerializerUtil.addElement(parent, "ListType");
            this.writeType(((ListType)type).getType(), typeElement);
        } else if (type instanceof EnumerationType) {
            Element typeElement = XPDLSerializerUtil.addElement(parent, "EnumerationType");
            for (EnumerationValue value : ((EnumerationType)type).getValues()) {
                XPDLSerializerUtil.addElement(typeElement, "EnumerationValue", value.getName());
            }
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Element typeElement = XPDLSerializerUtil.addElement(parent, "ArrayType");
            this.writeType(arrayType.getType(), typeElement);
            typeElement.setAttribute("LowerIndex", Integer.toString(arrayType.getLowerIndex()));
            typeElement.setAttribute("UpperIndex", Integer.toString(arrayType.getUpperIndex()));
        } else if (type instanceof DeclaredType) {
            Element typeElement = XPDLSerializerUtil.addElement(parent, "DeclaredType");
            typeElement.setAttribute("Id", ((DeclaredType)type).getId());
        } else if (type instanceof ExternalReference) {
            this.writeExternalReference((ExternalReference)type, parent);
        } else {
            throw new XPDLSerializerException("Unsupported data type: " + type.getClass().getName());
        }
    }

    protected void writeWorkflowProcesses(List workflowProcesses, Element parent) throws XPDLSerializerException {
        if (workflowProcesses == null || workflowProcesses.size() == 0) {
            return;
        }
        Element wpsElement = XPDLSerializerUtil.addElement(parent, "WorkflowProcesses");
        Iterator iter = workflowProcesses.iterator();
        while (iter.hasNext()) {
            this.writeWorkflowProcess((WorkflowProcess)iter.next(), wpsElement);
        }
    }

    protected void writeWorkflowProcess(WorkflowProcess wp, Element parent) throws XPDLSerializerException {
        Element wpElement = XPDLSerializerUtil.addElement(parent, "WorkflowProcess");
        wpElement.setAttribute("Id", wp.getId());
        XPDLSerializerUtil.setNameWithMultiLang(wpElement, wp);
        wpElement.setAttribute("AccessLevel", wp.getAccessLevel().toString());
        ProcessHeader processHeader = wp.getProcessHeader();
        if (processHeader == null) {
            throw new ElementRequiredException("Process header required");
        }
        this.writeProcessHeader(processHeader, wpElement);
        this.writeRedefinableHeader(wp.getRedefinableHeader(), wpElement);
        this.writeFormalParameters(wp.getFormalParameters(), wpElement);
        this.writeDataFields(wp.getDataFields(), wpElement);
        this.writeParticipants(wp.getParticipants(), wpElement);
        this.writeApplications(wp.getApplications(), wpElement);
        this.writeActivitySets(wp.getActivitySets(), wpElement);
        this.writeActivities(wp.getActivities(), wpElement);
        this.writeTransitions(wp.getTransitions(), wpElement);
        this.writeExtendedAttributes(wp.getExtendedAttributes(), wpElement);
    }

    protected void writeActivitySets(List activitySets, Element parent) throws XPDLSerializerException {
        if (activitySets == null || activitySets.size() == 0) {
            return;
        }
        Element activitySetsElement = XPDLSerializerUtil.addElement(parent, "ActivitySets");
        Iterator iter = activitySets.iterator();
        while (iter.hasNext()) {
            this.writeActivitySet((ActivitySet)iter.next(), activitySetsElement);
        }
    }

    protected void writeActivitySet(ActivitySet activitySet, Element parent) throws XPDLSerializerException {
        Element activitySetElement = XPDLSerializerUtil.addElement(parent, "ActivitySet");
        activitySetElement.setAttribute("Id", activitySet.getId());
        this.writeActivities(activitySet.getActivities(), activitySetElement);
        this.writeTransitions(activitySet.getTransitions(), activitySetElement);
    }

    protected void writeActivities(List activities, Element parent) throws XPDLSerializerException {
        if (activities == null || activities.size() == 0) {
            return;
        }
        Element activitiesElement = XPDLSerializerUtil.addElement(parent, "Activities");
        Iterator iter = activities.iterator();
        while (iter.hasNext()) {
            this.writeActivity((Activity)iter.next(), activitiesElement);
        }
    }

    protected void writeActivity(Activity activity, Element parent) throws XPDLSerializerException {
        BlockActivity blockActivity;
        Route route;
        Element activityElement = XPDLSerializerUtil.addElement(parent, "Activity");
        activityElement.setAttribute("Id", activity.getId());
        XPDLSerializerUtil.setNameWithMultiLang(activityElement, activity);
        XPDLSerializerUtil.addElement(activityElement, "Description", activity.getDescription());
        XPDLSerializerUtil.addElement(activityElement, "Limit", activity.getLimit());
        Implementation implementation = activity.getImplementation();
        if (implementation != null) {
            Element implementationElement = XPDLSerializerUtil.addElement(activityElement, "Implementation");
            if (implementation instanceof ToolSet) {
                for (Tool tool : ((ToolSet)implementation).getTools()) {
                    Element toolElement = XPDLSerializerUtil.addElement(implementationElement, "Tool");
                    toolElement.setAttribute("Id", tool.getId());
                    toolElement.setAttribute("Type", tool.getToolType().getTag());
                    XPDLSerializerUtil.addElement(toolElement, "Description", tool.getDescription());
                    this.writeActualParameters(tool.getActualParameters(), toolElement);
                }
            } else if (implementation instanceof SubFlow) {
                SubFlow subFlow = (SubFlow)implementation;
                Element subFlowElement = XPDLSerializerUtil.addElement(implementationElement, "SubFlow");
                subFlowElement.setAttribute("Id", subFlow.getId());
                subFlowElement.setAttribute("Execution", subFlow.getExecution().toString());
                this.writeActualParameters(subFlow.getActualParameters(), subFlowElement);
            } else if (implementation instanceof NoImplementation) {
                XPDLSerializerUtil.addElement(implementationElement, "No");
            } else {
                throw new XPDLSerializerException("Unknown implementation type: " + implementation.getClass());
            }
        }
        if ((route = activity.getRoute()) != null) {
            if (implementation != null) {
                throw new XPDLSerializerException("Activity cannot contain both a route and an implementation");
            }
            XPDLSerializerUtil.addElement(activityElement, "Route");
        }
        if ((blockActivity = activity.getBlockActivity()) != null) {
            if (implementation != null || route != null) {
                throw new XPDLSerializerException("Activity cannot contain a route or an implementation as well as a BlockActivity");
            }
            Element baElement = XPDLSerializerUtil.addElement(activityElement, "BlockActivity");
            baElement.setAttribute("BlockId", blockActivity.getBlockId());
        }
        XPDLSerializerUtil.addElement(activityElement, "Performer", activity.getPerformer());
        AutomationMode startMode = activity.getStartMode();
        Element startModeElement = XPDLSerializerUtil.addElement(activityElement, "StartMode");
        if (startMode == AutomationMode.MANUAL) {
            XPDLSerializerUtil.addElement(startModeElement, "Manual");
        } else {
            XPDLSerializerUtil.addElement(startModeElement, "Automatic");
        }
        AutomationMode finishMode = activity.getFinishMode();
        Element finishModeElement = XPDLSerializerUtil.addElement(activityElement, "FinishMode");
        if (finishMode == AutomationMode.MANUAL) {
            XPDLSerializerUtil.addElement(finishModeElement, "Manual");
        } else {
            XPDLSerializerUtil.addElement(finishModeElement, "Automatic");
        }
        XPDLSerializerUtil.addElement(activityElement, "Priority", activity.getPriority());
        this.writeDeadlines(activity.getDeadlines(), activityElement);
        this.writeSimulationInformation(activity.getSimulationInformation(), activityElement);
        XPDLSerializerUtil.addElement(activityElement, "Icon", activity.getIcon());
        XPDLSerializerUtil.addElement(activityElement, "Documentation", activity.getDocumentation());
        this.writeTransitionRestrictions(activity.getTransitionRestrictions(), activityElement);
        if (activity instanceof GenericActivityEx) {
            this.writeDataFields(((GenericActivityEx)activity).getApplicationArgs(), activityElement);
        }
        this.writeExtendedAttributes(activity.getExtendedAttributes(), activityElement);
        CompletionStrategy strat = activity.getCompletionStrategy();
        if (strat != null) {
            this.writeCompletionStrategy(strat, activityElement);
        }
    }

    protected void writeCompletionStrategy(CompletionStrategy strat, Element parent) {
        if (strat == null) {
            return;
        }
        Element extendedAttributesElement = XPDLSerializerUtil.addElement(parent, "ExtendedAttributes");
        if (extendedAttributesElement == null) {
            extendedAttributesElement = XPDLSerializerUtil.addElement(parent, "ExtendedAttributes");
        }
        parent = XPDLSerializerUtil.addElement(extendedAttributesElement, "ExtendedAttribute");
        parent.setAttribute("Name", "ufw:CompletionStrategy");
        parent.setAttribute("Value", strat.toString());
    }

    protected void writeTransitions(List transitions, Element parent) throws XPDLSerializerException {
        if (transitions == null || transitions.size() == 0) {
            return;
        }
        Element transitionsElement = XPDLSerializerUtil.addElement(parent, "Transitions");
        Iterator iter = transitions.iterator();
        while (iter.hasNext()) {
            this.writeTransition((Transition)iter.next(), transitionsElement);
        }
    }

    protected void writeTransition(Transition transition, Element parent) throws XPDLSerializerException {
        Element transitionElement = XPDLSerializerUtil.addElement(parent, "Transition");
        transitionElement.setAttribute("Id", transition.getId());
        transitionElement.setAttribute("From", transition.getFrom());
        transitionElement.setAttribute("To", transition.getTo());
        if (transition.getName() != null) {
            transitionElement.setAttribute("Name", transition.getName());
            XPDLSerializerUtil.setNameWithMultiLang(transitionElement, transition);
        }
        this.writeCondition(transition.getCondition(), transitionElement);
        if (transition.getDescription() != null) {
            XPDLSerializerUtil.addElement(transitionElement, "Description", transition.getDescription());
        }
        this.writeExtendedAttributes(transition.getExtendedAttributes(), transitionElement);
        this.writeExecutionType(transition.getExecution(), transitionElement);
    }

    protected void writeExecutionType(ExecutionType execType, Element parent) throws XPDLSerializerException {
        if (execType == null) {
            return;
        }
        Element extendedAttributesElement = XPDLSerializerUtil.addElement(parent, "ExtendedAttributes");
        if (extendedAttributesElement == null) {
            extendedAttributesElement = XPDLSerializerUtil.addElement(parent, "ExtendedAttributes");
        }
        parent = XPDLSerializerUtil.addElement(extendedAttributesElement, "ExtendedAttribute");
        parent.setAttribute("Name", "Execution");
        parent.setAttribute("Value", execType.toString());
    }

    protected void writeTransitionRestrictions(List transitionRestrictions, Element parent) {
        if (transitionRestrictions == null || transitionRestrictions.size() == 0) {
            return;
        }
        Element transitionRestrictionsElement = XPDLSerializerUtil.addElement(parent, "TransitionRestrictions");
        Iterator iter = transitionRestrictions.iterator();
        while (iter.hasNext()) {
            this.writeTransitionRestriction((TransitionRestriction)iter.next(), transitionRestrictionsElement);
        }
    }

    protected void writeTransitionRestriction(TransitionRestriction transitionRestriction, Element parent) {
        Element transitionRestrictionElement = XPDLSerializerUtil.addElement(parent, "TransitionRestriction");
        this.writeJoin(transitionRestriction.getJoin(), transitionRestrictionElement);
        this.writeSplit(transitionRestriction.getSplit(), transitionRestrictionElement);
    }

    protected void writeJoin(Join join, Element parent) {
        if (join == null) {
            return;
        }
        Element joinElement = XPDLSerializerUtil.addElement(parent, "Join");
        SplitJoinType joinType = join.getType();
        if (joinType != null) {
            joinElement.setAttribute("Type", joinType.getTag());
        }
    }

    protected void writeSplit(Split split, Element parent) {
        if (split == null) {
            return;
        }
        Element splitElement = XPDLSerializerUtil.addElement(parent, "Split");
        SplitJoinType splitType = split.getType();
        if (splitType != null) {
            splitElement.setAttribute("Type", splitType.getTag());
        }
        this.writeTransitionReferences(split.getTransitionReferences(), splitElement);
    }

    protected void writeTransitionReferences(List transitionReferences, Element parent) {
        if (transitionReferences == null || transitionReferences.size() == 0) {
            return;
        }
        Element transitionReferencesElement = XPDLSerializerUtil.addElement(parent, "TransitionRefs");
        for (String transitionId : transitionReferences) {
            Element transitionRefElement = XPDLSerializerUtil.addElement(transitionReferencesElement, "TransitionRef");
            transitionRefElement.setAttribute("Id", transitionId);
        }
    }

    protected void writeProcessHeader(ProcessHeader header, Element parent) {
        Element headerElement = XPDLSerializerUtil.addElement(parent, "ProcessHeader");
        DurationUnit durationUnit = header.getDurationUnit();
        if (durationUnit != null) {
            headerElement.setAttribute("DurationUnit", durationUnit.getTag());
        }
        XPDLSerializerUtil.addElement(headerElement, "Created", header.getCreated());
        XPDLSerializerUtil.addElement(headerElement, "Description", header.getDescription());
        XPDLSerializerUtil.addElement(headerElement, "Priority", header.getPriority());
        XPDLSerializerUtil.addElement(headerElement, "Limit", header.getLimit());
        XPDLSerializerUtil.addElement(headerElement, "ValidFrom", header.getValidFrom());
        XPDLSerializerUtil.addElement(headerElement, "ValidTo", header.getValidTo());
        this.writeTimeEstimation(header.getTimeEstimation(), headerElement);
        this.writeMailMobile(header.getMailMobile(), headerElement);
    }

    private void writeMailMobile(MailMobileSetting mailMobile, Element headerElement) {
        XPDLSerializerUtil.addElement(headerElement, "MailModal", mailMobile.getMailModal());
        XPDLSerializerUtil.addElement(headerElement, "PrintTempletId", mailMobile.getPrintTempletid());
        XPDLSerializerUtil.addElement(headerElement, "PrintTempletName", mailMobile.getPrintTempletname());
        XPDLSerializerUtil.addElement(headerElement, "MobileModal", mailMobile.getMobileModal());
    }

    protected void writeDeadlines(List deadlines, Element parent) {
        if (deadlines == null) {
            return;
        }
        Iterator i = deadlines.iterator();
        while (i.hasNext()) {
            this.writeDeadline((Deadline)i.next(), parent);
        }
    }

    protected void writeDeadline(Deadline deadline, Element parent) {
        if (deadline == null) {
            return;
        }
        Element deadlineElement = XPDLSerializerUtil.addElement(parent, "Deadline");
        deadlineElement.setAttribute("Execution", deadline.getExecutionType().toString());
        XPDLSerializerUtil.addElement(deadlineElement, "DeadlineCondition", deadline.getDeadlineCondition());
        XPDLSerializerUtil.addElement(deadlineElement, "ExceptionName", deadline.getExceptionName());
    }

    protected void writeTimeEstimation(TimeEstimation timeEstimation, Element parent) {
        if (timeEstimation == null) {
            return;
        }
        Element timeEstimationElement = XPDLSerializerUtil.addElement(parent, "TimeEstimation");
        XPDLSerializerUtil.addElement(timeEstimationElement, "WorkingTime", timeEstimation.getWorkingTime());
        XPDLSerializerUtil.addElement(timeEstimationElement, "WaitingTime", timeEstimation.getWaitingTime());
        XPDLSerializerUtil.addElement(timeEstimationElement, "Duration", timeEstimation.getDuration());
    }

    protected void writeSimulationInformation(SimulationInformation simulationInformation, Element parent) {
        if (simulationInformation == null) {
            return;
        }
        Element simulationInformationElement = XPDLSerializerUtil.addElement(parent, "SimulationInformation");
        XPDLSerializerUtil.addElement(simulationInformationElement, "Cost", simulationInformation.getCost());
        this.writeTimeEstimation(simulationInformation.getTimeEstimation(), simulationInformationElement);
    }

    protected void writeCondition(Condition condition, Element parent) {
        Object rule;
        Iterator xpressions;
        if (condition == null) {
            return;
        }
        Element conditionElement = XPDLSerializerUtil.addElement(parent, "Condition");
        ConditionType type = condition.getType();
        if (type != null) {
            conditionElement.setAttribute("Type", type.getTag());
        }
        if (condition.getValue() != null) {
            XPDLSerializerUtil.addChildElement(conditionElement, condition.getValue());
        }
        if ((xpressions = condition.getXpressions().iterator()).hasNext() && (rule = xpressions.next()) instanceof IRule) {
            this.constractRuleElement((IRule)rule, conditionElement);
        }
    }

    public Element constractRuleElement(IRule rule, Element parent) {
        if (rule == null) {
            return null;
        }
        if (rule instanceof QueryRule) {
            Element queryRuleElement = XPDLSerializerUtil.addElement(parent, "QueryRule");
            UfXPDLSerializer.createRuleElement(rule, queryRuleElement);
        } else if (rule instanceof AndRule) {
            Element andRuleElement = XPDLSerializerUtil.addElement(parent, "AND");
            UfXPDLSerializer.createRuleElement(rule, andRuleElement);
        } else if (rule instanceof OrRule) {
            Element orRuleElement = XPDLSerializerUtil.addElement(parent, "OR");
            UfXPDLSerializer.createRuleElement(rule, orRuleElement);
        }
        return null;
    }

    public static void createRuleElement(IRule queryrule, Element parent) {
        String querstr = QueryTemplateUtils.writeToXML((Object)queryrule);
        XPDLSerializerUtil.addChildElement(parent, querstr);
    }

    protected void writeExtendedAttributes(Map extendedAttributes, Element parent) {
        if (extendedAttributes == null || extendedAttributes.size() == 0) {
            return;
        }
        Element extendedAttributesElement = XPDLSerializerUtil.addElement(parent, "ExtendedAttributes");
        for (Object key : extendedAttributes.keySet()) {
            Object value = extendedAttributes.get(key);
            if (value instanceof ArrayList) {
                ArrayList al = (ArrayList)value;
                for (int i = 0; i < al.size(); ++i) {
                    Object obj = al.get(i);
                    Element extendedAttributeElement = XPDLSerializerUtil.addElement(extendedAttributesElement, "ExtendedAttribute");
                    extendedAttributeElement.setAttribute("Name", key.toString());
                    if (obj == null) continue;
                    extendedAttributeElement.setAttribute("Value", obj.toString());
                }
                continue;
            }
            Element extendedAttributeElement = XPDLSerializerUtil.addElement(extendedAttributesElement, "ExtendedAttribute");
            extendedAttributeElement.setAttribute("Name", key.toString());
            if (value == null) continue;
            if (value instanceof IRule) {
                String querstr = QueryTemplateUtils.writeToXML(value);
                extendedAttributeElement.setAttribute("Value", querstr);
                continue;
            }
            extendedAttributeElement.setAttribute("Value", value.toString());
        }
    }

    protected void writeFormalParameters(List formalParameters, Element parent) throws XPDLSerializerException {
        if (formalParameters == null || formalParameters.size() == 0) {
            return;
        }
        Element formalParametersElement = XPDLSerializerUtil.addElement(parent, "FormalParameters");
        for (FormalParameter formalParameter : formalParameters) {
            Element formalParameterElement = XPDLSerializerUtil.addElement(formalParametersElement, "FormalParameter");
            formalParameterElement.setAttribute("Id", formalParameter.getId());
            if (formalParameter.getIndex() != 0) {
                formalParameterElement.setAttribute("Index", Integer.toString(formalParameter.getIndex()));
            }
            formalParameterElement.setAttribute("Mode", formalParameter.getMode().toString());
            XPDLSerializerUtil.addElement(formalParameterElement, "Description", formalParameter.getDescription());
            this.writeType(formalParameter.getDataType().getType(), XPDLSerializerUtil.addElement(formalParameterElement, "DataType"));
        }
    }

    protected void writeActualParameters(List actualParameters, Element parent) throws XPDLSerializerException {
        if (actualParameters == null || actualParameters.size() == 0) {
            return;
        }
        Element actualParametersElement = XPDLSerializerUtil.addElement(parent, "ActualParameters");
        for (ActualParameter actualParameter : actualParameters) {
            XPDLSerializerUtil.addElement(actualParametersElement, "ActualParameter", actualParameter.getText());
        }
    }

    protected void writeExternalReference(ExternalReference externalReference, Element parent) throws XPDLSerializerException {
        String namespace;
        if (externalReference == null) {
            return;
        }
        Element element = XPDLSerializerUtil.addElement(parent, "ExternalReference");
        element.setAttribute("location", externalReference.getLocation());
        String xref = externalReference.getXref();
        if (xref != null) {
            element.setAttribute("xref", xref);
        }
        if ((namespace = externalReference.getNamespace()) != null) {
            element.setAttribute("namespace", namespace);
        }
    }

    private void serializeByType(XpdlPackage pkg, OutputStream out, int type) throws Exception {
        Document doc = XMLUtil.getDocumentBuilder().newDocument();
        Element packageElement = doc.createElement("Package");
        doc.appendChild(packageElement);
        packageElement.setAttribute("xmlns", "http://www.wfmc.org/2002/XPDL1.0");
        packageElement.setAttribute("xmlns:xpdl", "http://www.wfmc.org/2002/XPDL1.0");
        packageElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        packageElement.setAttribute("xsi:schemaLocation", "http://www.w3.org/2000/10/XMLSchema");
        packageElement.setAttribute("Id", pkg.getId());
        packageElement.setAttribute("Name", pkg.getName());
        if (type == 0 || type == 1) {
            this.writePackageHeader(pkg.getPackageHeader(), packageElement);
            this.writeRedefinableHeader(pkg.getRedefinableHeader(), packageElement);
            this.writeConformanceClass(pkg.getConformanceClass(), packageElement);
            this.writeScript(pkg.getScript(), packageElement);
            this.writeTypeDeclarations(pkg.getTypeDeclarations(), packageElement);
            this.writeParticipants(pkg.getParticipants(), packageElement);
            this.writeApplications(pkg.getApplications(), packageElement);
            this.writeDataFields(pkg.getDataFields(), packageElement);
            this.writeExtendedAttributes(pkg.getExtendedAttributes(), packageElement);
        }
        if (type == 0 || type == 2) {
            this.writeWorkflowProcesses(pkg.getWorkflowProcesses(), packageElement);
        }
        this.writeToXPDL(doc, out);
    }

    public void serializeNoProcess(XpdlPackage pkg, OutputStream out) throws Exception {
        this.serializeByType(pkg, out, 1);
    }

    public void serializeProcessOnly(XpdlPackage pkg, OutputStream out) throws Exception {
        this.serializeByType(pkg, out, 2);
    }

    public void serializeProcess(WorkflowProcess process, OutputStream out) throws Exception {
        Document doc = XMLUtil.getDocumentBuilder().newDocument();
        Element processElement = doc.createElement("WorkflowProcess");
        this.writeWorkflowProcess0(process, processElement);
        doc.appendChild(processElement);
        this.writeToXPDL(doc, out);
    }

    private void writeToXPDL(Document doc, OutputStream out) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(out);
        TransformerFactory tFactory = XMLInstanceGenerate.getTransformerFactory();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", "utf-8");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(bos);
        transformer.transform(source, result);
        out.flush();
        out.close();
    }

    public String serialize(WorkflowProcess wp) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.serializeProcess(wp, baos);
        return baos.toString("utf-8");
    }

    public String serializeNoProcess(XpdlPackage pkg) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.serializeByType(pkg, baos, 1);
        return baos.toString("utf-8");
    }

    protected void writeWorkflowProcess0(WorkflowProcess wp, Element wpElement) throws XPDLSerializerException {
        wpElement.setAttribute("Id", wp.getId());
        XPDLSerializerUtil.setNameWithMultiLang(wpElement, wp);
        wpElement.setAttribute("AccessLevel", wp.getAccessLevel().toString());
        ProcessHeader processHeader = wp.getProcessHeader();
        if (processHeader == null) {
            throw new ElementRequiredException("Process header required");
        }
        this.writeProcessHeader(processHeader, wpElement);
        this.writeRedefinableHeader(wp.getRedefinableHeader(), wpElement);
        this.writeFormalParameters(wp.getFormalParameters(), wpElement);
        this.writeParticipants(wp.getParticipants(), wpElement);
        this.writeApplications(wp.getApplications(), wpElement);
        this.writeActivitySets(wp.getActivitySets(), wpElement);
        this.writeActivities(wp.getActivities(), wpElement);
        this.writeTransitions(wp.getTransitions(), wpElement);
        this.writeExtendedAttributes(wp.getExtendedAttributes(), wpElement);
    }
}

