/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nc.vo.jcom.xml.XMLUtil;
import nc.vo.pub.lang.MultiLangText;
import nc.vo.wfengine.core.WFElement;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.util.DateUtilities;
import nc.vo.wfengine.core.util.Duration;
import nc.vo.wfengine.core.util.DurationUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPDLParserUtil {
    private XPDLParserUtil() {
    }

    public static void setNameWithMultiLang(WFElement wfElement, Element element) {
        wfElement.setMultiLangName(XPDLParserUtil.getMultiLangField(element, "Name"));
    }

    public static MultiLangText getMultiLangField(Element element, String fieldName) {
        MultiLangText multiLangText = new MultiLangText();
        multiLangText.setText(element.getAttribute(fieldName));
        multiLangText.setText2(element.getAttribute(fieldName + "2"));
        multiLangText.setText3(element.getAttribute(fieldName + "3"));
        multiLangText.setText4(element.getAttribute(fieldName + "4"));
        multiLangText.setText5(element.getAttribute(fieldName + "5"));
        multiLangText.setText6(element.getAttribute(fieldName + "6"));
        return multiLangText;
    }

    public static Node child(Node element, String name) {
        Node node = XMLUtil.getChildNodeOf((Node)element, (String)name);
        return node;
    }

    public static List children(Node element, String name) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node temp = element.getFirstChild(); temp != null; temp = temp.getNextSibling()) {
            if (temp.getNodeType() != 1 || !name.equals(temp.getNodeName())) continue;
            list.add(temp);
        }
        return list;
    }

    public static String elementAsString(Node node, String name) {
        String s = XMLUtil.getChildNodeValueOf((Node)node, (String)name);
        return s == null || s.length() == 0 ? null : s;
    }

    public static Date elementAsDate(Node element, String name) throws XPDLParserException {
        String text = XPDLParserUtil.elementAsString(element, name);
        if (text == null) {
            return null;
        }
        try {
            return DateUtilities.getInstance().parse(text);
        }
        catch (ParseException e) {
            throw new XPDLParserException("Error parsing date: " + text, e);
        }
    }

    public static int elementAsInteger(Element element, String name) {
        String text = XPDLParserUtil.elementAsString(element, name);
        if (text == null) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    public static boolean elementAsBoolean(Element element, String name) {
        String text = XPDLParserUtil.elementAsString(element, name);
        if (text == null) {
            return false;
        }
        return new Boolean(text);
    }

    public static URL elementAsURL(Node element, String name) throws XPDLParserException {
        String text = XPDLParserUtil.elementAsString(element, name);
        if (text == null) {
            return null;
        }
        try {
            return new URL(text);
        }
        catch (MalformedURLException e) {
            throw new XPDLParserException("Invalid URL: " + text, e);
        }
    }

    public static Duration elementAsDuration(Node element, String name) throws XPDLParserException {
        String text = XPDLParserUtil.elementAsString(element, name);
        if (text == null) {
            return null;
        }
        try {
            return Duration.parse(text);
        }
        catch (NumberFormatException e) {
            throw new XPDLParserException("Error parsing duration", e);
        }
    }

    public static DurationUnit elementAsDurationUnit(Node element, String name) throws XPDLParserException {
        String text = XPDLParserUtil.elementAsString(element, name);
        if (text == null) {
            return null;
        }
        try {
            return DurationUnit.fromString(text);
        }
        catch (NumberFormatException e) {
            throw new XPDLParserException("Error parsing duration unit", e);
        }
    }

    public static Element getRootElement(Document document) {
        return XMLUtil.getFirstChildElement((Node)document);
    }

    public static List getChildNodesNotText(Node tdNode) {
        ArrayList<Node> retList = new ArrayList<Node>();
        NodeList nl = tdNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() == 3) continue;
            retList.add(node);
        }
        return retList;
    }
}

