/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.data;

import java.io.Serializable;
import java.util.HashMap;
import nc.vo.wfengine.core.data.Type;

public final class BasicType
implements Type,
Serializable {
    static final long serialVersionUID = -7894443551993705284L;
    public static final int STRING_INT = 0;
    public static final int FLOAT_INT = 1;
    public static final int INTEGER_INT = 2;
    public static final int REFERENCE_INT = 3;
    public static final int DATETIME_INT = 4;
    public static final int BOOLEAN_INT = 5;
    public static final int PERFORMER_INT = 6;
    public static final BasicType STRING = new BasicType(0);
    public static final BasicType FLOAT = new BasicType(1);
    public static final BasicType INTEGER = new BasicType(2);
    public static final BasicType REFERENCE = new BasicType(3);
    public static final BasicType DATETIME = new BasicType(4);
    public static final BasicType BOOLEAN = new BasicType(5);
    public static final BasicType PERFORMER = new BasicType(6);
    public static final String[] TAGS = new String[]{"STRING", "FLOAT", "INTEGER", "REFERENCE", "DATETIME", "BOOLEAN", "PERFORMER"};
    private static final BasicType[] VALUES = new BasicType[]{STRING, FLOAT, INTEGER, REFERENCE, DATETIME, BOOLEAN, PERFORMER};
    private static HashMap tagMap = new HashMap();
    private final int _value;

    public static BasicType fromInt(int type) {
        return VALUES[type];
    }

    public static BasicType fromString(String tag) {
        BasicType basicType = (BasicType)tagMap.get(tag);
        if (basicType == null && tag != null) {
            throw new IllegalArgumentException(tag);
        }
        return basicType;
    }

    private BasicType(int value) {
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    public String toString() {
        return TAGS[this._value];
    }

    public Object readResolve() {
        return VALUES[this._value];
    }

    static {
        for (int i = 0; i < TAGS.length; ++i) {
            tagMap.put(TAGS[i], VALUES[i]);
        }
    }
}

