/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.activity;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.vo.wfengine.core.AbstractWFElement;
import nc.vo.wfengine.core.activity.AutomationMode;
import nc.vo.wfengine.core.activity.BlockActivity;
import nc.vo.wfengine.core.activity.CompletionStrategy;
import nc.vo.wfengine.core.activity.Implementation;
import nc.vo.wfengine.core.activity.NoImplementation;
import nc.vo.wfengine.core.activity.Route;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.activity.Tool;
import nc.vo.wfengine.core.activity.ToolSet;
import nc.vo.wfengine.core.transition.SplitJoinType;
import nc.vo.wfengine.core.util.Duration;
import nc.vo.wfengine.core.util.SimulationInformation;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.ActivityTypeEnum;
import nc.vo.wfengine.definition.WorkflowTypeEnum;

public class Activity
extends AbstractWFElement {
    static final long serialVersionUID = -7464664489372049213L;
    public static final AutomationMode DEFAULT_START_MODE = AutomationMode.AUTOMATIC;
    public static final AutomationMode DEFAULT_FINISH_MODE = AutomationMode.AUTOMATIC;
    private WorkflowProcess workflowProcess;
    private Duration limit;
    private Implementation implementation;
    private Route route;
    private BlockActivity blockActivity;
    private String performer;
    private AutomationMode startMode = DEFAULT_START_MODE;
    private AutomationMode finishMode = DEFAULT_FINISH_MODE;
    private CompletionStrategy completionStrategy;
    private String priority;
    private List deadlines = new ArrayList();
    private SimulationInformation simulationInformation;
    private URL documentation;
    private String icon;
    private List transitionRestrictions = new ArrayList();
    private Map afferentTransitions = new HashMap();
    private Map efferentTransitions = new HashMap();

    public Activity(String id, String name, WorkflowProcess workflowProcess) {
        super(id, name);
        this.workflowProcess = workflowProcess;
    }

    public WorkflowProcess getWorkflowProcess() {
        return this.workflowProcess;
    }

    public Duration getLimit() {
        return this.limit;
    }

    public void setLimit(Duration limit) {
        this.limit = limit;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Implementation implementation) {
        this.implementation = implementation;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public BlockActivity getBlockActivity() {
        return this.blockActivity;
    }

    public void setBlockActivity(BlockActivity blockActivity) {
        this.blockActivity = blockActivity;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public AutomationMode getStartMode() {
        return this.startMode;
    }

    public void setStartMode(AutomationMode startMode) {
        if (startMode == null) {
            startMode = DEFAULT_START_MODE;
        }
        this.startMode = startMode;
    }

    public AutomationMode getFinishMode() {
        return this.finishMode;
    }

    public void setFinishMode(AutomationMode finishMode) {
        if (finishMode == null) {
            finishMode = DEFAULT_FINISH_MODE;
        }
        this.finishMode = finishMode;
    }

    public CompletionStrategy getCompletionStrategy() {
        return this.completionStrategy;
    }

    public void setCompletionStrategy(CompletionStrategy strategy) {
        this.completionStrategy = strategy;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public List getDeadlines() {
        return this.deadlines;
    }

    public SimulationInformation getSimulationInformation() {
        return this.simulationInformation;
    }

    public void setSimulationInformation(SimulationInformation simulationInformation) {
        this.simulationInformation = simulationInformation;
    }

    public URL getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(URL documentation) {
        this.documentation = documentation;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List getTransitionRestrictions() {
        return this.transitionRestrictions;
    }

    public SplitJoinType getPostcondition() {
        return null;
    }

    public SplitJoinType getPrecondition() {
        return null;
    }

    public String getPreconditionValue() {
        return "100%";
    }

    public String getPostconditionValue() {
        return null;
    }

    public Map getAfferentTransitions() {
        return this.afferentTransitions;
    }

    public Map getEfferentTransitions() {
        return this.efferentTransitions;
    }

    public String toString2() {
        return "Activity[id='" + this.getId() + ", name='" + this.getName() + "']";
    }

    public String toString() {
        return this.getName();
    }

    public boolean isExitActivity() {
        List endList = this.getWorkflowProcess().findEndActivities();
        for (Activity element : endList) {
            if (this != element) continue;
            return true;
        }
        return false;
    }

    public boolean isStartActivity() {
        Activity startAct = this.getWorkflowProcess().findStartActivity();
        return this == startAct;
    }

    public int getActivityType() {
        Implementation impl = this.getImplementation();
        if (impl instanceof ToolSet) {
            ToolSet ts = (ToolSet)impl;
            Tool t = (Tool)ts.getTools().get(0);
            return ActivityTypeEnum.fromTag(t.getId()).getIntValue();
        }
        if (!(impl instanceof NoImplementation) && impl instanceof SubFlow) {
            return ActivityTypeEnum.Subflow.getIntValue();
        }
        if (this.getRoute() != null) {
            return ActivityTypeEnum.Route.getIntValue();
        }
        return ActivityTypeEnum.Other.getIntValue();
    }

    public void setProcessDefPK(String processDefPK) {
    }

    public String getProcessDefPK() {
        return null;
    }

    @Override
    public Object clone() {
        Activity act = (Activity)super.clone();
        return act;
    }

    public boolean isInSubflow() {
        int iWorkflowType = this.getWorkflowProcess().getWorkflowType();
        return iWorkflowType == WorkflowTypeEnum.SubApproveflow.getIntValue() || iWorkflowType == WorkflowTypeEnum.SubWorkflow.getIntValue() || iWorkflowType == WorkflowTypeEnum.SubWorkApproveflow.getIntValue();
    }
}

