/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.MultiLangUtil;
import nc.vo.pub.guid.GuidUtils;
import nc.vo.pub.lang.MultiLangText;
import nc.vo.wfengine.core.WFElement;

public abstract class AbstractWFElement
implements WFElement,
Serializable,
Cloneable {
    static final long serialVersionUID = 5028805438136004652L;
    private String _id;
    private MultiLangText multiLangName;
    private String _description;
    private Map _extendedAttributes;

    protected AbstractWFElement(String id, String name) {
        this.setId(id);
        this.setName(name);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null in method AbstractWFElement.setId()");
        }
        this._id = id;
    }

    @Override
    public String getName() {
        String name;
        String string = name = this.getMultiLangName() == null ? "" : this.getMultiLangName().getText(MultiLangUtil.getCurrentLangSeq() - 1);
        if (StringUtil.isEmptyWithTrim((String)name)) {
            name = this.getMultiLangName().getText(MultiLangContext.getInstance().getEnableLangVOs()[0].getLangseq() - 1);
        }
        return name == null ? "" : name;
    }

    @Override
    public void setName(String name) {
        if (this.getMultiLangName() == null) {
            this.setMultiLangName(new MultiLangText());
        }
        this.getMultiLangName().setText(MultiLangUtil.getCurrentLangSeq() - 1, name);
        if (this.getMultiLangName().getCurrLangIndex() != 0) {
            boolean needSetDefaultLag = true;
            if (this.getMultiLangName().getText() != null) {
                String text = this.getMultiLangName().getText();
                int end = text.length();
                for (int i = 0; i < end; ++i) {
                    if (text.charAt(i) < '\u0100') continue;
                    needSetDefaultLag = false;
                    break;
                }
            }
            if (needSetDefaultLag) {
                this.getMultiLangName().setText(0, name);
            }
        }
    }

    @Override
    public MultiLangText getMultiLangName() {
        return this.multiLangName;
    }

    @Override
    public void setMultiLangName(MultiLangText multiLangName) {
        this.multiLangName = multiLangName;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public Map getExtendedAttributes() {
        if (this._extendedAttributes == null) {
            this._extendedAttributes = new HashMap();
        }
        return this._extendedAttributes;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this._id.equals(((AbstractWFElement)obj)._id);
    }

    protected Object clone() {
        WFElement element = null;
        try {
            element = (WFElement)super.clone();
            element.setId(GuidUtils.generate());
            element.setName(this.getName());
            element.setDescription(this.getDescription());
            element.getExtendedAttributes().putAll(this.getExtendedAttributes());
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
        return element;
    }
}

