/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wf.condition;

import java.util.List;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.itf.uap.IUAPQueryBS;
import nc.rule.datastruct.AndRule;
import nc.rule.datastruct.IRule;
import nc.rule.datastruct.QueryRule;
import nc.ui.pub.beans.constenum.DefaultConstEnum;
import nc.ui.pub.beans.constenum.IConstEnum;
import nc.ui.querytemplate.filter.IFilter;
import nc.ui.querytemplate.operator.EqOperator;
import nc.ui.querytemplate.operator.IOperator;
import nc.ui.querytemplate.operator.OperatorFactory;
import nc.ui.querytemplate.value.DefaultFieldValue;
import nc.ui.querytemplate.value.DefaultFieldValueElement;
import nc.ui.querytemplate.value.IFieldValue;
import nc.ui.querytemplate.value.IFieldValueElement;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.pub.FunctionVO;
import nc.vo.wf.condition.ApproveResultFilterMeta;
import nc.vo.wf.condition.CustomFuncFieldValueElement;
import nc.vo.wf.condition.FunctionFieldValueElement;
import nc.vo.wf.condition.FunctionFilterMeta;
import nc.vo.wf.condition.MetadataFieldValueElement;
import nc.vo.wf.condition.WFFilter;
import nc.vo.wfengine.core.condition.Xpression;
import nc.vo.wfengine.core.util.CoreUtilities;
import nc.vo.wfengine.definition.NCFunctionXpression;
import nc.vo.wfengine.definition.NCMetadataXpression;
import nc.vo.wfengine.definition.WFCustomFuncXpression;

public class FilterExpressionConvertor {
    public static void expression2Filter(NCFunctionXpression xpr, WFFilter filter) {
        DefaultFieldValue fv = new DefaultFieldValue();
        FunctionFieldValueElement fe = new FunctionFieldValueElement(xpr);
        fv.add((IFieldValueElement)fe);
        filter.setFieldValue((IFieldValue)fv);
        filter.setOperator(OperatorFactory.getInstance().getOperator(xpr.getYsf()));
    }

    public static void expression2Filter(NCMetadataXpression xpr, WFFilter filter) {
        DefaultFieldValue fv = new DefaultFieldValue();
        MetadataFieldValueElement fe = new MetadataFieldValueElement(xpr);
        fv.add((IFieldValueElement)fe);
        filter.setFieldValue((IFieldValue)fv);
        filter.setOperator(OperatorFactory.getInstance().getOperator(xpr.getYsf()));
        filter.setHintMessage(xpr.getHintMessage());
    }

    public static void expression2Filter(WFCustomFuncXpression xpr, WFFilter filter) {
        DefaultFieldValue dfve = new DefaultFieldValue();
        CustomFuncFieldValueElement fe = new CustomFuncFieldValueElement(xpr);
        dfve.add((IFieldValueElement)fe);
        filter.setFieldValue((IFieldValue)dfve);
        if (!StringUtil.isEmpty((String)xpr.getYsf())) {
            filter.setOperator(OperatorFactory.getInstance().getOperator(xpr.getYsf()));
        }
    }

    public static IRule expression2Rule(List<Xpression> xpressions) {
        AndRule rootRule = new AndRule();
        String checkXpression = CoreUtilities.getCheckXpression(xpressions);
        rootRule.addRule(FilterExpressionConvertor.createRuleByCheckResult(checkXpression));
        NCFunctionXpression[] funcXpressions = CoreUtilities.getFuncXpressions(xpressions);
        FilterExpressionConvertor.fillFuncXpressions(funcXpressions);
        if (funcXpressions != null) {
            for (NCFunctionXpression xpression : funcXpressions) {
                rootRule.addRule(FilterExpressionConvertor.createRuleByFunctionXpression(xpression));
            }
        }
        return rootRule;
    }

    public static IRule createRuleByCheckResult(String checkXpression) {
        QueryRule rule = new QueryRule();
        WFFilter filter = new WFFilter();
        ApproveResultFilterMeta arfm = new ApproveResultFilterMeta();
        filter.setFilterMeta(arfm);
        filter.setOperator((IOperator)EqOperator.getInstance());
        DefaultFieldValue fv = new DefaultFieldValue();
        DefaultConstEnum value = null;
        if ("ACT_Check_Result.equals(\"Y\")".equals(checkXpression)) {
            value = ApproveResultFilterMeta.ENUM_PASS;
        } else if ("ACT_Check_Result.equals(\"N\")".equals(checkXpression)) {
            value = ApproveResultFilterMeta.ENUM_NOPASS;
        } else if (checkXpression == null) {
            value = ApproveResultFilterMeta.ENUM_NULL;
        }
        fv.add((IFieldValueElement)new DefaultFieldValueElement((IConstEnum)value));
        filter.setFieldValue((IFieldValue)fv);
        rule.setFormatObject((IFilter)filter);
        return rule;
    }

    private static IRule createRuleByFunctionXpression(NCFunctionXpression xpression) {
        QueryRule rule = new QueryRule();
        WFFilter filter = new WFFilter();
        FunctionFilterMeta ffm = new FunctionFilterMeta();
        ffm.setFunctionnote(xpression.getFunctionName());
        ffm.setFieldName(xpression.getFunctionName());
        ffm.setReturntype(xpression.getReturnType());
        ffm.setClassname(null);
        ffm.setMethod(null);
        ffm.setParameter(null);
        ffm.setPk_function(xpression.getFunctionId());
        filter.setFilterMeta(ffm);
        filter.setOperator(OperatorFactory.getInstance().getOperator(xpression.getYsf()));
        DefaultFieldValue fv = new DefaultFieldValue();
        fv.add((IFieldValueElement)new FunctionFieldValueElement(xpression));
        filter.setFieldValue((IFieldValue)fv);
        rule.setFormatObject((IFilter)filter);
        return rule;
    }

    private static void fillFuncXpressions(NCFunctionXpression[] funcXpressions) {
        for (int i = 0; i < (funcXpressions == null ? 0 : funcXpressions.length); ++i) {
            NCFunctionXpression xpression = funcXpressions[i];
            String funcId = xpression.getFunctionId();
            FunctionVO left_func_vo = null;
            try {
                IUAPQueryBS name = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class.getName());
                left_func_vo = (FunctionVO)name.retrieveByPK(FunctionVO.class, funcId);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (left_func_vo == null) {
                xpression.setFunctionName(NCLangRes4VoTransl.getNCLangRes().getStrByID("101203", "UPP101203-000017"));
                xpression.setReturnType(null);
            } else {
                xpression.setFunctionName(left_func_vo.getFunctionnote());
                xpression.setReturnType(left_func_vo.getReturntype());
            }
            String value = xpression.getValue();
            FunctionVO right_func_vo = null;
            try {
                IUAPQueryBS name = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class.getName());
                right_func_vo = (FunctionVO)name.retrieveByPK(FunctionVO.class, value);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (right_func_vo == null) {
                xpression.setValueNote(value);
                continue;
            }
            xpression.setValueNote(right_func_vo.getFunctionnote());
        }
    }
}

