/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.uap.pf;

import java.util.HashMap;
import java.util.LinkedHashMap;
import nc.bs.pf.pub.PfDataCache;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.uap.pf.DynamicOrgRegInfo;
import nc.vo.uap.pf.DynamicOrganizeUnit;
import nc.vo.uap.pf.PFBusinessException;
import nc.vo.uap.pf.PFRuntimeException;

public class DynamicOrganizeUnitRegistry {
    private static DynamicOrganizeUnitRegistry inst = new DynamicOrganizeUnitRegistry();

    private DynamicOrganizeUnitRegistry() {
    }

    public static DynamicOrganizeUnitRegistry getInstance() {
        return inst;
    }

    public static void register(String clsNameOfOrganize, String clsNameOfBuilder, String clsNameOfResolver, LinkedHashMap hmTypeToInfo) throws BusinessException {
        DynamicOrgRegInfo doi;
        boolean isNeedCorpNode;
        String nameOfType;
        String strType;
        Object obj = null;
        try {
            Class<?> cls = Class.forName(clsNameOfOrganize);
            obj = cls.newInstance();
        }
        catch (Exception e) {
            throw new PFBusinessException(e);
        }
        if (obj instanceof DynamicOrganizeUnit) {
            strType = ((DynamicOrganizeUnit)obj).getType();
            nameOfType = ((DynamicOrganizeUnit)obj).getNameOfType();
            isNeedCorpNode = ((DynamicOrganizeUnit)obj).isNeedCorpNode();
            doi = new DynamicOrgRegInfo();
            doi.setBuilderclass(clsNameOfBuilder);
            doi.setOrgclass(clsNameOfOrganize);
            doi.setResolverclass(clsNameOfResolver);
            if (hmTypeToInfo.containsKey(strType)) {
                throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "DynamicOrganizeUnitRegistry-000000"));
            }
        } else {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "DynamicOrganizeUnitRegistry-000001"));
        }
        hmTypeToInfo.put(strType, new Object[]{doi, nameOfType, isNeedCorpNode});
    }

    public HashMap getHashTypeToInfo() {
        LinkedHashMap<String, DynamicOrgRegInfo> hmTypeToInfo = new LinkedHashMap<String, DynamicOrgRegInfo>();
        LinkedHashMap lhmRegs = PfDataCache.getDynamicOrgReg();
        for (String strType : lhmRegs.keySet()) {
            DynamicOrgRegInfo doi = (DynamicOrgRegInfo)((Object)((Object[])lhmRegs.get(strType))[0]);
            hmTypeToInfo.put(strType, doi);
        }
        return hmTypeToInfo;
    }

    public HashMap getHashTypeToName() {
        LinkedHashMap<String, String> hmTypeToName = new LinkedHashMap<String, String>();
        LinkedHashMap lhmRegs = PfDataCache.getDynamicOrgReg();
        for (String strType : lhmRegs.keySet()) {
            String nameOfType = (String)((Object[])lhmRegs.get(strType))[1];
            hmTypeToName.put(strType, nameOfType);
        }
        return hmTypeToName;
    }

    public DynamicOrgRegInfo getDynamicOrgInfoByType(String strOrgType) {
        if (this.getHashTypeToInfo().containsKey(strOrgType)) {
            return (DynamicOrgRegInfo)((Object)this.getHashTypeToInfo().get(strOrgType));
        }
        return null;
    }

    public String getTypenameByType(String strOrgType) {
        if (this.getHashTypeToName().containsKey(strOrgType)) {
            return (String)this.getHashTypeToName().get(strOrgType);
        }
        return null;
    }
}

