/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.util.ArrayList;
import java.util.HashMap;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pub.pf.PfUtilTools;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.billtype2.ExtendedClassEnum;
import nc.vo.pub.workflowusergroup.WfUserGroup4AllEmployee;
import nc.vo.pub.workflowusergroup.WfUserGroup4DirectEmployee;
import nc.vo.pub.workflowusergroup.WfUserGroup4Employer;
import nc.vo.pub.workflowusergroup.WfUserGroup4HigherUp;
import nc.vo.pub.workflowusergroup.WfUserGroup4Person;
import nc.vo.pub.workflowusergroup.WfUserGroup4PostSuper;
import nc.vo.pub.workflowusergroup.WfUserGroup4Principal;
import nc.vo.pub.workflowusergroup.WfUserGroup4Superintend;
import nc.vo.pub.workflowusergroup.WfUserGroup4Superior;
import nc.vo.uap.pf.IWfUserGroupResolver;
import nc.vo.wfengine.pub.WfRuleType;

public class WfUserGroupResolverFactory {
    private static WfUserGroupResolverFactory inst = new WfUserGroupResolverFactory();
    private HashMap<String, IWfUserGroupResolver> hmCodeToResolver = new HashMap();

    private WfUserGroupResolverFactory() {
    }

    public static WfUserGroupResolverFactory getInstance() {
        return inst;
    }

    public IWfUserGroupResolver getResolver(String billtype, String ruleCode) {
        IWfUserGroupResolver wfUsergroupResolver = this.hmCodeToResolver.get(ruleCode);
        if (wfUsergroupResolver == null) {
            if (this.isPredefineRule(ruleCode)) {
                wfUsergroupResolver = this.createDefaultResolver(ruleCode);
                this.hmCodeToResolver.put(ruleCode, wfUsergroupResolver);
            } else {
                ArrayList<Billtype2VO> bt2VOs = PfDataCache.getBillType2Info(billtype, ExtendedClassEnum.USERGROUP_RULE.getIntValue());
                for (Billtype2VO bt2VO : bt2VOs) {
                    try {
                        Object obj = PfUtilTools.findBizImplOfBilltype(billtype, bt2VO.getClassname());
                        this.hmCodeToResolver.put(bt2VO.getCode(), (IWfUserGroupResolver)obj);
                    }
                    catch (Exception e) {
                        Logger.error((Object)("\u83b7\u53d6\u7528\u6237\u81ea\u5b9a\u4e49\u89c4\u5219\u6d41\u7a0b\u7528\u6237\u7ec4\u5931\u8d25billType=" + billtype + ",className=" + bt2VO.getClassname()), (Throwable)e);
                    }
                }
            }
        }
        return this.hmCodeToResolver.get(ruleCode);
    }

    private boolean isPredefineRule(String ruleCode) {
        int iCode = Integer.valueOf(ruleCode);
        return WfRuleType.SuperiorType.getIntValue() == iCode || WfRuleType.EmployerType.getIntValue() == iCode || WfRuleType.AllEmployeeType.getIntValue() == iCode || WfRuleType.DirectEmployeeType.getIntValue() == iCode || WfRuleType.HigherUpType.getIntValue() == iCode || WfRuleType.PrincipalType.getIntValue() == iCode || WfRuleType.SuperintendType.getIntValue() == iCode || WfRuleType.PostSuperType.getIntValue() == iCode || WfRuleType.PersonType.getIntValue() == iCode;
    }

    private IWfUserGroupResolver createDefaultResolver(String ruleCode) {
        IWfUserGroupResolver pf = null;
        int iCode = Integer.valueOf(ruleCode);
        if (WfRuleType.EmployerType.getIntValue() == iCode) {
            pf = new WfUserGroup4Employer();
        } else if (WfRuleType.AllEmployeeType.getIntValue() == iCode) {
            pf = new WfUserGroup4AllEmployee();
        } else if (WfRuleType.DirectEmployeeType.getIntValue() == iCode) {
            pf = new WfUserGroup4DirectEmployee();
        } else if (WfRuleType.PrincipalType.getIntValue() == iCode) {
            pf = new WfUserGroup4Principal();
        } else if (WfRuleType.SuperintendType.getIntValue() == iCode) {
            pf = new WfUserGroup4Superintend();
        } else if (WfRuleType.HigherUpType.getIntValue() == iCode) {
            pf = new WfUserGroup4HigherUp();
        } else if (WfRuleType.SuperiorType.getIntValue() == iCode) {
            pf = new WfUserGroup4Superior();
        } else if (WfRuleType.PostSuperType.getIntValue() == iCode) {
            pf = new WfUserGroup4PostSuper();
        } else if (WfRuleType.PersonType.getIntValue() == iCode) {
            pf = new WfUserGroup4Person();
        }
        return pf;
    }
}

