/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.ParticipantFilterContext;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.pubitf.bd.accessor.IGeneralAccessor;
import nc.vo.bd.accessor.IBDData;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.DeptVO;
import nc.vo.org.OrgVO;
import nc.vo.org.util.OrgTypeManager;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.workflowusergroup.WFUserGroupUtil;
import nc.vo.pub.workflowusergroup.WfUserGroupResolvingException;
import nc.vo.uap.pf.IWfUserGroupResolver;

public class WfUserGroup4Superior
implements IWfUserGroupResolver {
    private String NAME = NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Superior-000000");

    @Override
    public HashSet<String> queryUsers(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        long beginMills = System.currentTimeMillis();
        try {
            String[] orgPks = this.getParameterValue(billtype, context, parameter, pk_org, prevParticipant);
            HashSet<String> managers = new HashSet<String>();
            ArrayList<String> busiUnitPks = new ArrayList<String>();
            ArrayList<String> deptPks = new ArrayList<String>();
            for (String pk : orgPks) {
                if (OrgTypeManager.getInstance().isTypeOfByPk(pk, "BUSINESSUNIT00000000")) {
                    busiUnitPks.add(pk);
                    continue;
                }
                if (!OrgTypeManager.getInstance().isTypeOfByPk(pk, "DEPTORGTYPE000000000")) continue;
                deptPks.add(pk);
            }
            if (busiUnitPks.size() == 0 && deptPks.size() == 0) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4AllEmployee-000001", null, new String[]{this.NAME}));
            }
            if (busiUnitPks.size() > 0) {
                managers.addAll(this.findManagersOfParentOrgWithException(busiUnitPks.toArray(new String[0])));
            }
            if (deptPks.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                DeptVO[] depts = WFUserGroupUtil.getDeptQryService().queryDeptVOsByPks(deptPks.toArray(new String[0]));
                StringBuffer whereBuf = new StringBuffer();
                whereBuf.append("pk_dept in (select pk_fatherorg from org_dept where ");
                whereBuf.append(WFUserGroupUtil.buildSqlForIn("pk_dept", deptPks.toArray(new String[0])));
                whereBuf.append(")");
                List parentDepts = (List)WFUserGroupUtil.getUAPQueryBS().retrieveByClause(DeptVO.class, whereBuf.toString());
                HashMap<String, DeptVO> tempMap = new HashMap<String, DeptVO>();
                for (DeptVO dept : parentDepts) {
                    tempMap.put(dept.getPk_dept(), dept);
                }
                ArrayList<String> rootOrgs = new ArrayList<String>();
                for (DeptVO vo : depts) {
                    if (tempMap.containsKey(vo.getPk_fatherorg())) {
                        arrayList.add(((DeptVO)tempMap.get(vo.getPk_fatherorg())).getPk_dept());
                        continue;
                    }
                    rootOrgs.add(vo.getPk_org());
                }
                if (null != rootOrgs && rootOrgs.size() > 0) {
                    managers.addAll(this.findManagersOfOrgWithException(rootOrgs.toArray(new String[0])));
                }
                if (null != arrayList && arrayList.size() > 0) {
                    managers.addAll(WFUserGroupUtil.findManagersOfOrg(arrayList.toArray(new String[0])));
                }
            }
            HashSet<String> hashSet = WFUserGroupUtil.filterDisabledUsersWithException(managers);
            return hashSet;
        }
        catch (BusinessException e) {
            throw new BusinessExceptionAdapter(e);
        }
        finally {
            Logger.debug((Object)WFUserGroupUtil.getPerformanceLogString(this.NAME, beginMills));
        }
    }

    private Set<String> findManagersOfOrgWithException(String[] pk_orgs) throws BusinessException {
        OrgVO[] orgs = WFUserGroupUtil.getOrgUnitQryService().getOrgs(pk_orgs);
        if (orgs == null) {
            IBDData[] orgDatas;
            ArrayList<String> orgsdatas = new ArrayList<String>();
            IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"985be8a4-3a36-4778-8afe-2d8ed3902659");
            for (IBDData ibddate : orgDatas = acessor.getDocbyPks(pk_orgs)) {
                orgsdatas.add(ibddate.getName().toString());
            }
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Employer-000008", null, new String[]{StringUtil.toString((Object[])orgsdatas.toArray(new String[0]), (String)"],[")}));
        }
        ArrayList<String> pks = new ArrayList<String>();
        for (OrgVO org : orgs) {
            pks.add(org.getPrimaryKey());
        }
        Set<String> managers = WFUserGroupUtil.findManagersOfOrg(pks.toArray(new String[0]));
        if (ArrayUtil.isNull(managers)) {
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Superior-000002", null, new String[]{MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)orgs[0], (String)"name", null)}));
        }
        return managers;
    }

    private Set<String> findManagersOfParentOrgWithException(String[] pk_orgs) throws BusinessException {
        StringBuffer whereBuf = new StringBuffer();
        whereBuf.append("pk_org in (select pk_fatherorg from org_orgs where ");
        whereBuf.append(WFUserGroupUtil.buildSqlForIn("pk_org", pk_orgs));
        whereBuf.append(")");
        List parentOrgVOs = (List)WFUserGroupUtil.getUAPQueryBS().retrieveByClause(OrgVO.class, whereBuf.toString());
        if (parentOrgVOs == null || parentOrgVOs.size() == 0) {
            IBDData[] orgDatas;
            ArrayList<String> orgsdatas = new ArrayList<String>();
            IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"985be8a4-3a36-4778-8afe-2d8ed3902659");
            for (IBDData ibddate : orgDatas = acessor.getDocbyPks(pk_orgs)) {
                orgsdatas.add(ibddate.getName().toString());
            }
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4HigherUp-000002", null, new String[]{StringUtil.toString((Object[])orgsdatas.toArray(new String[0]), (String)"],[")}));
        }
        String[] parentOrgPKs = (String[])ArrayUtil.getFieldValues(String.class, (SuperVO[])((SuperVO[])parentOrgVOs.toArray(new OrgVO[0])), (String)"pk_org");
        Set<String> managers = WFUserGroupUtil.findManagersOfOrg(parentOrgPKs);
        if (ArrayUtil.isNull(managers)) {
            ArrayList<String> orgnames = new ArrayList<String>();
            for (OrgVO orgVO : parentOrgVOs) {
                orgnames.add(MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)orgVO, (String)"name", null));
            }
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Superior-000002", null, new String[]{StringUtil.toString((Object[])orgnames.toArray(new String[0]), (String)"],[")}));
        }
        return managers;
    }

    private String[] getParameterValue(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        return WFUserGroupUtil.getParameterValueWithException(this.NAME, context.getBillEntity(), billtype, parameter, pk_org);
    }
}

