/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.ParticipantFilterContext;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.itf.bd.psn.psndoc.IPsndocQueryService;
import nc.itf.org.IPostQueryService;
import nc.itf.uap.rbac.IUserManageQuery;
import nc.md.data.access.NCObject;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.pubitf.bd.accessor.IGeneralAccessor;
import nc.vo.bd.psn.PsndocVO;
import nc.vo.bd.psn.PsnjobVO;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.PostVO;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.workflowusergroup.WFUserGroupUtil;
import nc.vo.pub.workflowusergroup.WfUserGroupResolvingException;
import nc.vo.sm.UserVO;
import nc.vo.uap.pf.IWfUserGroupResolver;
import nc.vo.uap.pf.OrganizeUnitTypes;

public class WfUserGroup4PostSuper
implements IWfUserGroupResolver {
    private String NAME = NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000000");

    @Override
    public HashSet<String> queryUsers(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        long beginMills = System.currentTimeMillis();
        try {
            String pk_post = this.getParameterValue(billtype, context, parameter, pk_org, prevParticipant);
            Set<String> userOfParentPost = this.queryUsersOfParentPostRecursive(pk_post);
            HashSet<String> hashSet = WFUserGroupUtil.filterDisabledUsersWithException(userOfParentPost);
            return hashSet;
        }
        catch (BusinessException e) {
            throw new BusinessExceptionAdapter(e);
        }
        finally {
            Logger.debug((Object)WFUserGroupUtil.getPerformanceLogString(this.NAME, beginMills));
        }
    }

    private Set<String> queryUsersOfParentPostRecursive(String pk_post) throws BusinessException {
        IPostQueryService postQry = (IPostQueryService)NCLocator.getInstance().lookup(IPostQueryService.class);
        PostVO parentPostVO = postQry.queryFatherPostVOByPostID(pk_post);
        if (parentPostVO == null) {
            IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"8a397eb5-f056-4bb3-bb04-4b8008e8a334");
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000001", null, new String[]{acessor.getDocByPk(pk_post).getName().toString()}));
        }
        Set<String> users = this.queryUsersOfPost(parentPostVO.getPk_post());
        if (ArrayUtil.isNotNull(users)) {
            return users;
        }
        Logger.warn((Object)("\u5c97\u4f4dpk=" + parentPostVO.getSuporior() + "\u4e0b\u6ca1\u6709\u627e\u5230\u7528\u6237\uff0c\u9012\u5f52\u67e5\u627e\u4e0a\u7ea7\u5c97\u4f4d"), (Throwable)new Throwable());
        return this.queryUsersOfParentPostRecursive(parentPostVO.getSuporior());
    }

    private Set<String> queryUsersOfPost(String pk_post) throws BusinessException {
        HashSet<String> userSet = new HashSet<String>();
        HashMap psndocUsersMap = WFUserGroupUtil.getPsndocPubService().queryUsersByPost(pk_post);
        if (psndocUsersMap != null) {
            for (Object[] users : psndocUsersMap.values()) {
                if (!ArrayUtil.isNotNull((Object[])users)) continue;
                for (Object user : users) {
                    userSet.add(user.getCuserid());
                }
            }
        }
        return userSet;
    }

    private String getParameterValue(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) throws BusinessException {
        if (StringUtil.isEmptyWithTrim((String)billtype)) {
            Logger.debug((Object)"\u6ca1\u6709\u9009\u62e9\u5355\u636e\u7c7b\u578b\uff0c\u901a\u8fc7\u4e0a\u4e00\u73af\u8282\u53c2\u4e0e\u8005\u627e");
            if (OrganizeUnitTypes.Post.toString().equals(context.getLastParticipantType()) && !StringUtil.isEmptyWithTrim((String)context.getLastParticipantPK())) {
                return context.getLastParticipantPK();
            }
            String userPk = prevParticipant;
            return this.getMainPostOfUserWithException(userPk);
        }
        NCObject ncObj = NCObject.newInstance((Object)context.getBillEntity());
        Object value = ncObj.getAttributeValue(parameter);
        if (value == null) {
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000002", null, new String[]{this.NAME}));
        }
        String refModelName = null;
        if (ncObj.getRelatedBean() != null && ncObj.getRelatedBean() != null && ncObj.getRelatedBean().getAttributeByName(parameter) != null) {
            String pk = String.valueOf(value);
            IUserManageQuery userManager = (IUserManageQuery)NCLocator.getInstance().lookup(IUserManageQuery.class);
            UserVO uservo = userManager.getUser(pk);
            IPsndocQueryService psndocQueryService = (IPsndocQueryService)NCLocator.getInstance().lookup(IPsndocQueryService.class);
            PsndocVO psndoc = psndocQueryService.queryPsndocByPk(pk);
            IPostQueryService postQueryService = (IPostQueryService)NCLocator.getInstance().lookup(IPostQueryService.class);
            PostVO[] postvos = postQueryService.queryPostVOsByPKs(new String[]{pk});
            if (uservo != null) {
                return this.getMainPostOfUserWithException(pk);
            }
            if (psndoc != null) {
                return this.getMainPostOfPersonWithException(pk);
            }
            if (postvos != null && postvos.length > 0) {
                return pk;
            }
        } else if (ncObj.getRelatedBean().getAttributeByName(parameter) == null) {
            String val = null;
            val = this.getMainPostOfUserWithOutException(String.valueOf(value));
            if (val == null) {
                val = this.getMainPostOfPersonWithOutException(String.valueOf(value));
            }
            if (val == null) {
                val = String.valueOf(value);
            }
            return val;
        }
        if (parameter.endsWith("pk_post")) {
            return String.valueOf(value);
        }
        throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000003", null, new String[]{this.NAME}) + " \u53c2\u6570:" + parameter + " \u5f15\u7528\u540d\u79f0\uff1a" + refModelName);
    }

    private String getMainPostOfPersonWithOutException(String pk_psndoc) throws BusinessException {
        PsnjobVO psnJobVO = WFUserGroupUtil.getPsndocQueryService().queryPsnJobVOByPsnDocPK(pk_psndoc);
        if (psnJobVO == null) {
            return null;
        }
        String pk_post = psnJobVO.getPk_post();
        if (StringUtil.isEmptyWithTrim((String)pk_post)) {
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000005", null, new String[]{pk_psndoc}));
        }
        return pk_post;
    }

    private String getMainPostOfUserWithOutException(String cuserid) throws BusinessException {
        String pk_psndoc = WFUserGroupUtil.getUserPubService().queryPsndocByUserid(cuserid);
        if (StringUtil.isEmptyWithTrim((String)pk_psndoc)) {
            return null;
        }
        return this.getMainPostOfPersonWithException(pk_psndoc);
    }

    private String getMainPostOfPersonWithException(String pk_psndoc) throws BusinessException {
        PsnjobVO psnJobVO = WFUserGroupUtil.getPsndocQueryService().queryPsnJobVOByPsnDocPK(pk_psndoc);
        if (psnJobVO == null) {
            IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"40d39c26-a2b6-4f16-a018-45664cac1a1f");
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000004", null, new String[]{acessor.getDocByPk(pk_psndoc).getCode()}));
        }
        String pk_post = psnJobVO.getPk_post();
        if (StringUtil.isEmptyWithTrim((String)pk_post)) {
            IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"40d39c26-a2b6-4f16-a018-45664cac1a1f");
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000005", null, new String[]{acessor.getDocByPk(pk_psndoc).getCode()}));
        }
        return pk_post;
    }

    private String getMainPostOfUserWithException(String cuserid) throws BusinessException {
        String pk_psndoc = WFUserGroupUtil.getUserPubService().queryPsndocByUserid(cuserid);
        if (StringUtil.isEmptyWithTrim((String)pk_psndoc)) {
            IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"f6f9a473-56c0-432f-8bc7-fbf8fde54fee");
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Employer-000002", null, new String[]{acessor.getDocByPk(cuserid).getCode()}));
        }
        return this.getMainPostOfPersonWithException(pk_psndoc);
    }
}

