/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.itf.bd.psn.psndoc.IPsndocQueryService;
import nc.itf.org.IBasicOrgUnitQryService;
import nc.itf.org.IDeptQryService;
import nc.itf.uap.IUAPQueryBS;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.md.data.access.NCObject;
import nc.pubitf.rbac.IUserPubService;
import nc.pubitf.uapbd.IPsndocPubService;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.DeptVO;
import nc.vo.org.OrgManagerVO;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFLiteralDate;
import nc.vo.pub.workflowusergroup.WfUserGroupResolvingException;
import nc.vo.sm.UserVO;
import nc.vo.trade.sqlutil.IInSqlBatchCallBack;
import nc.vo.trade.sqlutil.InSqlBatchCaller;
import nc.vo.uap.pf.LinkAutoApproveException;
import nc.vo.uap.rbac.util.UserDisableFilterUtil;
import nccloud.commons.lang.ArrayUtils;

public class WFUserGroupUtil {
    private static final int SQL_IN_LIST_LIMIT = 200;

    public static String getDeptPrincipal(String pkDept) throws BusinessException {
        DeptVO deptVO = WFUserGroupUtil.getDeptQryService().queryDeptVOByID(pkDept);
        return deptVO != null ? deptVO.getPrincipal() : null;
    }

    public static String[] getParameterValueWithException(String resolverName, Object billEntity, String billtype, String parameter, String defaultValue) {
        try {
            if (StringUtil.isEmptyWithTrim((String)billtype)) {
                return new String[]{defaultValue};
            }
            if (StringUtil.isEmptyWithTrim((String)parameter)) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WFUserGroupUtil-000000", null, new String[]{resolverName}));
            }
            NCObject ncObj = NCObject.newInstance((Object)billEntity);
            Object obj = ncObj.getAttributeValue(parameter);
            if (obj == null) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4PostSuper-000002", null, new String[]{resolverName}));
            }
            ArrayList<String> pks = new ArrayList<String>();
            if (obj instanceof Object[]) {
                Object[] values;
                for (Object o : values = (Object[])obj) {
                    String var = String.valueOf(o);
                    if (StringUtil.isEmptyWithTrim((String)var)) continue;
                    pks.add(var);
                }
            } else {
                String var = String.valueOf(obj);
                if (!StringUtil.isEmptyWithTrim((String)var)) {
                    pks.add(var);
                }
            }
            return pks.toArray(new String[0]);
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LinkAutoApproveException(e);
        }
    }

    public static Set<String> findManagersOfOrg(String[] pk_orgs) throws BusinessException {
        IUAPQueryBS queryServ = WFUserGroupUtil.getUAPQueryBS();
        StringBuffer whereBuf = new StringBuffer();
        whereBuf.append(WFUserGroupUtil.buildSqlForIn("pk_org", pk_orgs));
        List orgManagerVOs = (List)queryServ.retrieveByClause(OrgManagerVO.class, whereBuf.toString());
        HashSet<String> userSet = new HashSet<String>();
        if (ArrayUtil.isNotNull((Collection)orgManagerVOs)) {
            for (OrgManagerVO orgManagerVO : orgManagerVOs) {
                String userPk = orgManagerVO.getCuserid();
                userSet.add(userPk);
            }
        }
        return userSet;
    }

    public static HashSet<String> filterDisabledUsersWithException(Set<String> userSet) {
        try {
            Object[] uvos = WFUserGroupUtil.getUserPubService().getUsersByPKs(userSet.toArray(new String[0]));
            if (ArrayUtil.isNull((Object[])uvos)) {
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WFUserGroupUtil-000001"));
            }
            Object[] filtered = UserDisableFilterUtil.filterDisableAndDisableDateUser((UserVO[])uvos);
            if (ArrayUtil.isNull((Object[])filtered)) {
                int count = uvos.length > 10 ? 10 : uvos.length;
                Object[] userNames = new String[count];
                for (int i = 0; i < count; ++i) {
                    userNames[i] = MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)uvos[i], (String)"user_name", null);
                }
                throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WFUserGroupUtil-000002", null, new String[]{StringUtil.toString((Object[])userNames, (String)"],[")}));
            }
            List filteredIdList = ArrayUtil.getFieldValueList(String.class, (SuperVO[])filtered, (String)"cuserid");
            HashSet<String> filteredSet = new HashSet<String>();
            filteredSet.addAll(filteredIdList);
            return filteredSet;
        }
        catch (BusinessException e) {
            throw new BusinessExceptionAdapter(e);
        }
    }

    public static Set<String> findAllEmployeeOfDepts(String ... pk_depts) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])pk_depts)) {
            return new HashSet<String>();
        }
        InSqlBatchCaller caller = new InSqlBatchCaller(pk_depts);
        final String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        try {
            return (Set)caller.execute(new IInSqlBatchCallBack(){
                Set<String> userSet = new HashSet<String>();

                public Object doWithInSql(String inSql) throws BusinessException, SQLException {
                    String sql = "select cuserid from sm_user where pk_group = '" + pk_group + "' and pk_psndoc in (select pk_psndoc from bd_psnjob where pk_dept in " + inSql + "" + WFUserGroupUtil.getTimejobDate() + " ) ";
                    List userIDs = (List)new BaseDAO().executeQuery(sql, (ResultSetProcessor)new ColumnListProcessor());
                    this.userSet.addAll(userIDs);
                    return this.userSet;
                }
            });
        }
        catch (SQLException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getTimejobDate() {
        long busiDateTime = InvocationInfoProxy.getInstance().getBizDateTime();
        UFLiteralDate buinessDate = new UFLiteralDate(busiDateTime);
        return " and bd_psnjob.indutydate <='" + buinessDate + "' and (bd_psnjob.enddutydate >='" + buinessDate + "' or bd_psnjob.enddutydate ='~' or bd_psnjob.enddutydate is null)";
    }

    public static Set<String> findAllEmployeeOfDept(String pk_dept) throws BusinessException {
        return WFUserGroupUtil.findAllEmployeeOfDepts(pk_dept);
    }

    public static Set<String> findUserOfPsndoc(String[] pk_psndocs) throws BusinessException {
        HashSet<String> resultSet = new HashSet<String>();
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        HashMap uvos = WFUserGroupUtil.getUserPubService().batchQueryUserVOsByPsnDocID(pk_psndocs, pk_group);
        if (uvos != null) {
            for (UserVO[] vos : uvos.values()) {
                if (vos == null) continue;
                for (UserVO vo : vos) {
                    if (resultSet.contains(vo.getCuserid())) continue;
                    resultSet.add(vo.getCuserid());
                }
            }
        }
        return resultSet;
    }

    public static String getPerformanceLogString(String resolverName, long beginMills) {
        long duration = System.currentTimeMillis() - beginMills;
        String logStr = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630024") + resolverName + NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630025") + duration + "ms";
        return logStr;
    }

    public static String buildSqlForIn(String fieldname, String[] fieldvalue) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("(" + fieldname + " IN ( ");
        int len = fieldvalue.length;
        for (int i = 0; i < len; ++i) {
            if (fieldvalue[i] != null && fieldvalue[i].trim().length() > 0) {
                sbSQL.append("'").append(fieldvalue[i].toString()).append("'");
                if (i != fieldvalue.length - 1 && (i <= 0 || (i + 1) % 200 != 0)) {
                    sbSQL.append(",");
                }
            } else {
                return null;
            }
            if (i <= 0 || (i + 1) % 200 != 0 || i == fieldvalue.length - 1) continue;
            sbSQL.append(" ) OR ").append(fieldname).append(" IN ( ");
        }
        sbSQL.append(" )) ");
        return sbSQL.toString();
    }

    public static IUserPubService getUserPubService() {
        return (IUserPubService)NCLocator.getInstance().lookup(IUserPubService.class);
    }

    public static IDeptQryService getDeptQryService() {
        return (IDeptQryService)NCLocator.getInstance().lookup(IDeptQryService.class);
    }

    public static IBasicOrgUnitQryService getOrgUnitQryService() {
        return (IBasicOrgUnitQryService)NCLocator.getInstance().lookup(IBasicOrgUnitQryService.class);
    }

    public static IPsndocPubService getPsndocPubQueryService() {
        return (IPsndocPubService)NCLocator.getInstance().lookup(IPsndocPubService.class);
    }

    public static IPsndocQueryService getPsndocQueryService() {
        return (IPsndocQueryService)NCLocator.getInstance().lookup(IPsndocQueryService.class);
    }

    public static IPsndocPubService getPsndocPubService() {
        return (IPsndocPubService)NCLocator.getInstance().lookup(IPsndocPubService.class);
    }

    public static IUAPQueryBS getUAPQueryBS() {
        return (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
    }
}

