/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.pf.plugin;

import java.util.LinkedHashMap;
import nc.bs.logging.Logger;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.pf.plugin.SysVariableValueGetter;

public class PfSysVariable {
    public static final String DEFAULT_BILLMAKER = "BILLMAKER";
    public static final String DEFAULT_ALLAPPROVER = "ALLAPPROVER";
    public static final String DEFAULT_PREVIOUSAPPROVER = "PREVIOUSAPPROVER";
    public static final String DEFAULT_PREVIOUSPARTICIPATOR = "PREVIOUSPARTICIPATOR";
    private static PfSysVariable inst = new PfSysVariable();
    private LinkedHashMap<String, VarEntry> lhmCodeToVar = new LinkedHashMap();

    private PfSysVariable() {
        this.initDefaultVar();
    }

    public static PfSysVariable instance() {
        return inst;
    }

    public void register(String name, String code, String valueGetterClz) {
        VarEntry ve = new VarEntry(name, code, valueGetterClz);
        if (this.lhmCodeToVar.keySet().contains(code)) {
            throw new IllegalArgumentException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PfSysVariable-000000", null, new String[]{code}));
        }
        this.lhmCodeToVar.put(code, ve);
    }

    public LinkedHashMap getAllVariables() {
        return this.lhmCodeToVar;
    }

    private VarEntry getVarEntry(String code) {
        if (!this.lhmCodeToVar.keySet().contains(code)) {
            throw new IllegalArgumentException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PfSysVariable-000001", null, new String[]{code}));
        }
        return this.lhmCodeToVar.get(code);
    }

    public void clear() {
        this.lhmCodeToVar.clear();
    }

    private void initDefaultVar() {
        this.register(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PfSysVariable-000002"), DEFAULT_BILLMAKER, SysVariableValueGetter.class.getName());
        this.register(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PfSysVariable-000003"), DEFAULT_ALLAPPROVER, SysVariableValueGetter.class.getName());
        this.register(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PfSysVariable-000004"), DEFAULT_PREVIOUSAPPROVER, SysVariableValueGetter.class.getName());
        this.register(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PfSysVariable-000005"), DEFAULT_PREVIOUSPARTICIPATOR, SysVariableValueGetter.class.getName());
    }

    public SysVariableValueGetter instanceValueGetter(String code, Object context) {
        VarEntry ve = this.getVarEntry(code);
        Object objImpl = null;
        try {
            objImpl = Class.forName(ve.getValueGetterClz()).getConstructor(Object.class).newInstance(context);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (objImpl instanceof SysVariableValueGetter) {
            return objImpl;
        }
        return null;
    }

    public class VarEntry {
        private String name;
        private String code;
        private String valueGetterClz;

        VarEntry(String name, String code, String valueGetterClz) {
            this.name = name;
            this.code = code;
            this.valueGetterClz = valueGetterClz;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public String getValueGetterClz() {
            return this.valueGetterClz;
        }
    }
}

