/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.pf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.ICacheDataQueryCallback;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.ml.DataMultiLangAccessor;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.MapListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.uap.bd.util.BDInSqlUtil;
import nc.ui.pf.multilang.PfMultiLangUtil;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.pub.BusitypeVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.pfflow.BillactionVO;
import nc.vo.pub.workflowusergroup.WFUserGroupVO;
import nc.vo.sm.UserVO;

public class Pfi18nTools {
    public static final String DAPSYSTEMP_PATH = "funcode";
    public static final String BILLTYPEP_PATH = "billtype";
    public static final String BILLACTION_PATH = "pub_billaction";
    public static final String BILLACTIONGROUP_PATH = "pub_billactiongroup";
    public static final String BILLITEM_PATH = "fidap";
    public static final String WORKFLOW_PATH = "pfworkflow";

    public static String i18nWfUserGroupName(WFUserGroupVO wfUserGroupVO) {
        String name = (String)wfUserGroupVO.getAttributeValue("name" + MultiLangUtil.getCurrentLangSeqSuffix());
        if (StringUtil.isEmptyWithTrim((String)name)) {
            name = wfUserGroupVO.getName();
        }
        return name;
    }

    public static String i18nBusiTypeName(BusitypeVO busiTypeVO) {
        String name = (String)busiTypeVO.getAttributeValue("businame" + MultiLangUtil.getCurrentLangSeqSuffix());
        if (StringUtil.isEmptyWithTrim((String)name)) {
            name = busiTypeVO.getBusiname();
        }
        return name;
    }

    public static String i18nParticipantFilter(String filterCode, String billType) {
        String resId = "Dfilter." + billType + "." + filterCode;
        String strName = NCLangRes4VoTransl.getNCLangRes().getStrByID(WORKFLOW_PATH, resId);
        return strName;
    }

    public static String i18nSystemtypeName(String resId, String defaultName) {
        if (StringUtil.isEmptyWithTrim((String)resId)) {
            return defaultName;
        }
        String strName = NCLangRes4VoTransl.getNCLangRes().getStrByID(DAPSYSTEMP_PATH, resId);
        if (resId.equals(strName)) {
            strName = defaultName == null ? strName : defaultName;
        }
        return strName;
    }

    public static String i18nBilltypeName(String pkBilltype) {
        BilltypeVO billTypeVO = PfDataCache.getBillType(pkBilltype);
        return Pfi18nTools.i18nBilltypeNameByVO(pkBilltype, billTypeVO);
    }

    public static String i18nBilltypeName(String pkBilltype, String defaultName) {
        if (pkBilltype == null) {
            return null;
        }
        String strName = Pfi18nTools.i18nBilltypeName(pkBilltype);
        if (StringUtil.isEmptyWithTrim((String)strName)) {
            strName = defaultName;
        }
        return strName;
    }

    public static String i18nBilltypeNameByVO(String pkBilltype, BilltypeVO billTypeVO) {
        String billTypeName;
        if (pkBilltype == null) {
            return null;
        }
        String strName = null;
        String string = billTypeName = billTypeVO == null ? null : billTypeVO.getBilltypenameOfCurrLang();
        strName = !StringUtil.isEmptyWithTrim((String)billTypeName) ? billTypeName : (billTypeVO == null || StringUtil.isEmptyWithTrim((String)billTypeVO.getBilltypename()) ? strName : billTypeVO.getBilltypename());
        return strName;
    }

    public static String nccloudi18nBilltypeNameByVO(String pkBilltype, BilltypeVO billTypeVO) {
        String billTypeName;
        if (pkBilltype == null) {
            return null;
        }
        String strName = null;
        String string = billTypeName = billTypeVO == null ? null : billTypeVO.getNCCloudBilltypenameOfCurrLang();
        strName = !StringUtil.isEmptyWithTrim((String)billTypeName) ? billTypeName : (billTypeVO == null || StringUtil.isEmptyWithTrim((String)billTypeVO.getBilltypename()) ? strName : billTypeVO.getBilltypename());
        return strName;
    }

    public static String i18nBillItemName(String itemName, String defaultName) {
        if (itemName == null) {
            return defaultName;
        }
        String strName = NCLangRes4VoTransl.getNCLangRes().getStrByID(BILLITEM_PATH, itemName);
        if (itemName.equals(strName)) {
            strName = defaultName == null ? strName : defaultName;
        }
        return strName;
    }

    public static String i18nBillItemDescription(String pk_billtype, String attrname, String defaultName) {
        String strName;
        if (attrname == null) {
            return null;
        }
        String resId = "D" + pk_billtype + "." + attrname + ".desc";
        if (resId.equals(strName = NCLangRes4VoTransl.getNCLangRes().getStrByID(BILLITEM_PATH, resId))) {
            strName = defaultName == null ? strName : defaultName;
        }
        return strName;
    }

    public static String i18nBillItemName2(String pk_billtype, String attrname, String defaultName) {
        String strName;
        if (attrname == null) {
            return null;
        }
        String resId = "D" + pk_billtype + "." + attrname;
        if (resId.equals(strName = NCLangRes4VoTransl.getNCLangRes().getStrByID(BILLITEM_PATH, resId))) {
            strName = defaultName == null ? strName : defaultName;
        }
        return strName;
    }

    public static String i18nActionName(String pkBilltype, String pk_actiontype, String defaultName) {
        String strName;
        String resId = "D" + pkBilltype + pk_actiontype;
        if (resId.equals(strName = NCLangRes4VoTransl.getNCLangRes().getStrByID(BILLACTION_PATH, resId))) {
            strName = defaultName == null ? strName : defaultName;
        }
        return strName;
    }

    public static String i18nActionGroupName(String pkBilltype, String actionstyle, String defaultName) {
        String strName;
        String resId = "D" + pkBilltype + actionstyle;
        if (resId.equals(strName = NCLangRes4VoTransl.getNCLangRes().getStrByID(BILLACTIONGROUP_PATH, resId))) {
            strName = defaultName == null ? strName : defaultName;
        }
        return strName;
    }

    public static String findActionName(String actionCode, ArrayList alActions) {
        String strActionDefaultName = null;
        for (BillactionVO baVO : alActions) {
            if (!actionCode.equals(baVO.getActiontype())) continue;
            strActionDefaultName = baVO.getActionnote();
            break;
        }
        return strActionDefaultName;
    }

    public static String getLangcodeOfUser(final String cuserid) {
        if (RuntimeEnv.getInstance().isRunningInServer()) {
            CondStringKey key = new CondStringKey(Pfi18nTools.class.getName() + "getLangcodeOfUser(String)", cuserid);
            ICacheDataQueryCallback<String> callback = new ICacheDataQueryCallback<String>(){

                public String queryData() throws BusinessException {
                    return Pfi18nTools.getLangcodeOfUserFromDb(cuserid);
                }
            };
            try {
                return (String)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
            }
            catch (BusinessException e) {
                return null;
            }
        }
        return Pfi18nTools.getLangcodeOfUserFromDb(cuserid);
    }

    public static String getLangcodeOfUserFromDb(String cuserid) {
        String sql = "select langcode from pub_multilang l join sm_user u on u.contentlang=l.pk_multilang where u.cuserid=?";
        SQLParameter param = new SQLParameter();
        param.addParam(cuserid);
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        try {
            String langcode = (String)qry.executeQuery(sql, param, (ResultSetProcessor)new ColumnProcessor("langcode"));
            if (langcode == null) {
                throw new NullPointerException();
            }
            return langcode;
        }
        catch (Exception e) {
            String langcode = DataMultiLangAccessor.getInstance().getDefaultLang().getLangcode();
            return langcode;
        }
    }

    public static HashMap<String, String> getLangcodesOfUserFromDb(String[] cuserids) {
        HashMap<String, String> result = new HashMap<String, String>();
        String sql = "select u.cuserid,langcode from pub_multilang l join sm_user u on u.contentlang=l.pk_multilang where u.cuserid in ";
        String condition = sql + BDInSqlUtil.getInSql((String[])cuserids, (boolean)false);
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        try {
            List langcodes = (List)qry.executeQuery(condition, (ResultSetProcessor)new MapListProcessor());
            if (langcodes == null || langcodes.size() == 0) {
                throw new NullPointerException();
            }
            for (int i = 0; i < langcodes.size(); ++i) {
                Map map = (Map)langcodes.get(i);
                if (map == null) continue;
                String cuserid = (String)map.get("cuserid");
                String langcode = (String)map.get("langcode");
                if (cuserid == null || langcode == null) continue;
                result.put(cuserid, langcode);
            }
            return result;
        }
        catch (Exception e) {
            for (int i = 0; i < cuserids.length; ++i) {
                result.put(cuserids[i], DataMultiLangAccessor.getInstance().getDefaultLang().getLangcode());
            }
            return result;
        }
    }

    public static Map<String, List<String>> classifyUsersByLangcode(String[] cuserids) {
        HashMap<String, List<String>> langUserMap = new HashMap<String, List<String>>();
        String defaultLang = InvocationInfoProxy.getInstance().getLangCode();
        if (cuserids == null || cuserids.length == 0) {
            return langUserMap;
        }
        StringBuffer sb = new StringBuffer();
        for (String id : cuserids) {
            sb.append(",'");
            sb.append(id);
            sb.append("'");
        }
        String sql = "select l.langcode, u.cuserid from pub_multilang l join sm_user u on u.contentlang=l.pk_multilang where u.cuserid in (" + sb.substring(1) + ")";
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        HashSet<String> userWithLangConf = new HashSet<String>();
        try {
            List list = (List)qry.executeQuery(sql, (ResultSetProcessor)new ArrayListProcessor());
            if (list != null && list.size() > 0) {
                for (Object[] row : list) {
                    String langcode = (String)row[0];
                    String cuserid = (String)row[1];
                    if (!langUserMap.containsKey(langcode)) {
                        ArrayList userList = new ArrayList();
                        langUserMap.put(langcode, userList);
                    }
                    ((List)langUserMap.get(langcode)).add(cuserid);
                    userWithLangConf.add(cuserid);
                }
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (String cuserid : cuserids) {
            if (userWithLangConf.contains(cuserid)) continue;
            if (!langUserMap.containsKey(defaultLang)) {
                ArrayList userList = new ArrayList();
                langUserMap.put(defaultLang, userList);
            }
            ((List)langUserMap.get(defaultLang)).add(cuserid);
        }
        return langUserMap;
    }

    public static String getUserName(final String cuserid) {
        String langcode = InvocationInfoProxy.getInstance().getLangCode();
        CondStringKey key = new CondStringKey("pfi18ntools_getusername", langcode, cuserid);
        ICacheDataQueryCallback<String> callback = new ICacheDataQueryCallback<String>(){

            public String queryData() throws BusinessException {
                return Pfi18nTools.getUserNameMl(cuserid);
            }
        };
        try {
            return (String)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getUserNameMl(String cuserid) throws DAOException {
        String suffix = MultiLangUtil.getCurrentLangSeqSuffix();
        String[] fields = null;
        fields = StringUtil.isEmptyWithTrim((String)suffix) ? new String[]{"user_name"} : new String[]{"user_name", "user_name" + suffix};
        String cond = "cuserid=?";
        SQLParameter param = new SQLParameter();
        param.addParam(cuserid);
        BaseDAO dao = new BaseDAO();
        Collection col = dao.retrieveByClause(UserVO.class, cond, fields, param);
        if (col != null && col.size() > 0) {
            UserVO uvo = (UserVO)col.iterator().next();
            return PfMultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)uvo, "user_name");
        }
        return null;
    }
}

