/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.mobile;

import java.io.Serializable;
import java.util.Map;
import nc.bs.framework.common.InvocationInfo;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.vo.pf.msg.MessageMetaVO;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.msg.IMsgL10NCallback;

public class MobileMsg
implements Serializable {
    private String msg = null;
    private IMsgL10NCallback msgCallback = null;
    private String[] targetPhones = null;
    private Map<String, String> phoneUserMap = null;
    private Map<String, MessageMetaVO> userMetaMap = null;
    private InvocationInfo info = null;
    private String txMark;
    private String sourcePhone = null;
    private boolean isTiming = false;
    private UFDateTime time = null;
    private boolean isDirectSend = false;
    private String[] serialNumbers = null;

    public String[] getSerialNumbers() {
        return this.serialNumbers;
    }

    public void setSerialNumbers(String[] serialNumbers) {
        this.serialNumbers = serialNumbers;
    }

    public MobileMsg() {
        this.saveInvocationInfo();
    }

    public String getMsg() {
        return this.msg;
    }

    public String getSourcePhone() {
        return this.sourcePhone;
    }

    public String[] getTargetPhones() {
        return this.targetPhones;
    }

    public UFDateTime getTime() {
        return this.time;
    }

    public boolean isDirectSend() {
        return this.isDirectSend;
    }

    public static boolean isLegalPhone(String phone) {
        if (phone == null || phone.length() != 11) {
            return false;
        }
        if (!phone.startsWith("13")) {
            return false;
        }
        try {
            Long.decode(phone);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isTiming() {
        return this.isTiming;
    }

    public void setIsDirectSend(boolean newIsDirectSend) {
        this.isDirectSend = newIsDirectSend;
    }

    public void setIsTiming(boolean newIsTiming) {
        this.isTiming = newIsTiming;
    }

    public void setMsg(String newMsg) {
        this.msg = newMsg;
    }

    public void setSourcePhone(String newSourcePhone) {
        this.sourcePhone = newSourcePhone;
    }

    public void setTargetPhones(String[] newTargetPhones) {
        this.targetPhones = newTargetPhones;
    }

    public void setTime(UFDateTime newTime) {
        this.time = newTime;
    }

    public IMsgL10NCallback getMsgCallback() {
        return this.msgCallback;
    }

    public void setMsgCallback(IMsgL10NCallback msgCallback) {
        this.msgCallback = msgCallback;
    }

    public Map<String, String> getPhoneUserMap() {
        return this.phoneUserMap;
    }

    public void setPhoneUserMap(Map<String, String> phoneUserMap) {
        this.phoneUserMap = phoneUserMap;
    }

    public Map<String, MessageMetaVO> getUserMetaMap() {
        return this.userMetaMap;
    }

    public void setUserMetaMap(Map<String, MessageMetaVO> userMetaMap) {
        this.userMetaMap = userMetaMap;
    }

    public void saveInvocationInfo() {
        this.info = new InvocationInfo();
        this.info.setBizDateTime(InvocationInfoProxy.getInstance().getBizDateTime());
        this.info.setGroupId(InvocationInfoProxy.getInstance().getGroupId());
        this.info.setGroupNumber(InvocationInfoProxy.getInstance().getGroupNumber());
        this.info.setLangCode(InvocationInfoProxy.getInstance().getLangCode());
        this.info.setUserDataSource(InvocationInfoProxy.getInstance().getUserDataSource());
        this.info.setUserId(InvocationInfoProxy.getInstance().getUserId());
    }

    public void loadInvocationInfo() {
        if (this.info != null) {
            InvocationInfoProxy.getInstance().setBizDateTime(this.info.getBizDateTime());
            InvocationInfoProxy.getInstance().setGroupId(this.info.getGroupId());
            InvocationInfoProxy.getInstance().setGroupNumber(this.info.getGroupNumber());
            InvocationInfoProxy.getInstance().setLangCode(this.info.getLangCode());
            InvocationInfoProxy.getInstance().setUserDataSource(this.info.getUserDataSource());
            InvocationInfoProxy.getInstance().setUserId(this.info.getUserId());
        }
    }

    public String getTxMark() {
        return this.txMark;
    }

    public void setTxMark(String txMark) {
        this.txMark = txMark;
    }
}

