/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.busilog;

import nc.bs.busilog.vo.BusinessLogContext;
import nc.bs.pf.pub.PfDataCache;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.busilog.PFBusiLogUtil;
import nc.vo.pub.busilog.operation.PFOperaEnum;
import nc.vo.pub.busilog.operation.WorkFlowOperaEnum;
import nc.vo.wfengine.definition.WorkflowDefinitionVO;
import nc.vo.wfengine.definition.WorkflowTypeEnum;

public class WorkFlowBusiLogUtil {
    public static void writeExport(WorkflowDefinitionVO wfDefVO, String fileName, PFOperaEnum operation) throws BusinessException {
        BusinessLogContext context = WorkFlowBusiLogUtil.buildLogContext(wfDefVO, operation);
        String logMsg = WorkFlowBusiLogUtil.buildExportMsg(wfDefVO, fileName, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    public static void writeSyncLog(WorkFlowOperaEnum operation) throws BusinessException {
        BusinessLogContext context = WorkFlowBusiLogUtil.buildLogContext(null, operation);
        String logMsg = WorkFlowBusiLogUtil.buildSyncMsg(operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    public static void writeBaseLog(WorkflowDefinitionVO wfDefVO, PFOperaEnum operation) throws BusinessException {
        BusinessLogContext context = WorkFlowBusiLogUtil.buildLogContext(wfDefVO, operation);
        String logMsg = WorkFlowBusiLogUtil.buildBaseOperaMsg(wfDefVO, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static BusinessLogContext buildLogContext(WorkflowDefinitionVO wfDefVO, PFOperaEnum operation) {
        BusinessLogContext context = PFBusiLogUtil.createPFBusinessLogContext();
        if (wfDefVO != null) {
            context.setPk_busiobj(wfDefVO.getPrimaryKey());
            context.setBusiobjcode(wfDefVO.getNode_name());
            context.setBusiobjname(wfDefVO.getNode_name());
            context.setBusiobjvo((Object)wfDefVO);
        } else {
            context.setPk_busiobj("global00000000000000");
        }
        context.setTypepk_busiobj("14863070-0793-4934-944b-d67bdc745196");
        context.setPk_operation(WorkFlowBusiLogUtil.getPkOperationByEnum(operation));
        return context;
    }

    private static String buildExportMsg(WorkflowDefinitionVO wfDefVO, String fileName, PFOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        String billTypeCode = wfDefVO.getBilltype();
        BilltypeVO billTypeVO = PfDataCache.getBillType(billTypeCode);
        if (billTypeVO == null) {
            billTypeVO = PfDataCache.getBillTypeInfo(wfDefVO.getPk_group(), billTypeCode);
        }
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000003")).append(":[").append(billTypeVO.getBilltypenameOfCurrLang()).append("]");
        sbMsg.append(operation.toString()).append(" ");
        WorkflowTypeEnum workFlowTypeEnum = WorkflowTypeEnum.fromIntValue(wfDefVO.getWorkflow_type());
        sbMsg.append(workFlowTypeEnum.toString());
        sbMsg.append("[").append(wfDefVO.getNode_name()).append("],");
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000008")).append("[").append(wfDefVO.getVersion()).append("]");
        if (WorkFlowOperaEnum.ExportTemplate.equals(operation)) {
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000012"));
        }
        sbMsg.append(",").append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000011")).append("[").append(fileName).append("]");
        return sbMsg.toString();
    }

    private static String buildSyncMsg(PFOperaEnum operation) {
        return "\u540c\u6b65 \u5de5\u4f5c\u6d41";
    }

    private static String buildBaseOperaMsg(WorkflowDefinitionVO wfDefVO, PFOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(operation.toString()).append(" ");
        WorkflowTypeEnum workFlowTypeEnum = WorkflowTypeEnum.fromIntValue(wfDefVO.getWorkflow_type());
        sbMsg.append(workFlowTypeEnum.toString());
        sbMsg.append("[").append(wfDefVO.getNode_name()).append("],");
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000008")).append("[").append(wfDefVO.getVersion()).append("]");
        return sbMsg.toString();
    }

    private static String getPkOperationByEnum(PFOperaEnum operation) {
        if (PFOperaEnum.Add.equals(operation)) {
            return "19f8526a-18ec-43be-a3bc-8345e5024273";
        }
        if (PFOperaEnum.Edit.equals(operation)) {
            return "1ccb9ee9-125b-4338-a93e-3cc82a757947";
        }
        if (PFOperaEnum.Delete.equals(operation)) {
            return "d7bc65e2-e0de-4ed4-95d9-47f35fa2524d";
        }
        if (PFOperaEnum.Enable.equals(operation)) {
            return "ce2dd7e4-55cc-4a3e-9b03-8b67712e36d1";
        }
        if (PFOperaEnum.Disable.equals(operation)) {
            return "75157142-3bd0-4ee5-bba2-c452c985efc0";
        }
        if (PFOperaEnum.Import.equals(operation)) {
            return "17f9add3-1643-44ae-8d62-ccbfe6303a47";
        }
        if (PFOperaEnum.Export.equals(operation)) {
            return "bae65ac0-5c47-4d9e-bb5a-af7ae2d7520c";
        }
        if (WorkFlowOperaEnum.ExportTemplate.equals(operation)) {
            return "9b735aa0-9db9-448d-ba94-c062d69233ef";
        }
        if (WorkFlowOperaEnum.Sync.equals(operation)) {
            return "0c6c6902-a75e-46a5-aefc-908c2ef7d1e3";
        }
        return null;
    }
}

