/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.busilog;

import java.util.List;
import nc.bs.busilog.vo.BusinessLogContext;
import nc.bs.framework.common.NCLocator;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.pubitf.bd.accessor.IGeneralAccessor;
import nc.pubitf.rbac.IUserPubService;
import nc.vo.bd.accessor.IBDData;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pf.pub.util.UserUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.busilog.PFBusiLogUtil;
import nc.vo.pub.workflowpsn.WorkflowagentVO;
import nc.vo.pub.workflowpsn.WorkflowpersonVO;
import nc.vo.sm.UserVO;

public class WorkFlowAgentBusiLogUtil {
    public static void writeEditLog(List<WorkflowagentVO> listData, String cuserID) throws BusinessException {
        UserVO userVO = WorkFlowAgentBusiLogUtil.queryUserVO(cuserID);
        BusinessLogContext context = WorkFlowAgentBusiLogUtil.buildLogContext(userVO, "c9504260-a082-40ce-8cc3-4eff1acc5da1");
        String logMsg = WorkFlowAgentBusiLogUtil.buildEditAgentUserMsg(listData, userVO);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static UserVO queryUserVO(String cuserID) throws BusinessException {
        Object[] userVOs = ((IUserPubService)NCLocator.getInstance().lookup(IUserPubService.class)).getUsersByPKs(new String[]{cuserID});
        return ArrayUtil.isNull((Object[])userVOs) ? null : userVOs[0];
    }

    public static void writeSetAgentLog(WorkflowpersonVO[] agentInfo, String cuserID) throws BusinessException {
        UserVO userVO = WorkFlowAgentBusiLogUtil.queryUserVO(cuserID);
        BusinessLogContext context = WorkFlowAgentBusiLogUtil.buildLogContext(userVO, "67f06341-9480-4abc-ad42-0dfa84a26aef");
        String logMsg = WorkFlowAgentBusiLogUtil.buildSetAgentMsg(agentInfo);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    public static void writeCancelAgentLog(WorkflowpersonVO[] agentInfo, String cuserID) throws BusinessException {
        UserVO userVO = WorkFlowAgentBusiLogUtil.queryUserVO(cuserID);
        BusinessLogContext context = WorkFlowAgentBusiLogUtil.buildLogContext(userVO, "3af0ca3f-b156-4d22-83ab-35ede7ec55cd");
        String logMsg = WorkFlowAgentBusiLogUtil.builCancelAgentMsg(agentInfo);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static BusinessLogContext buildLogContext(UserVO userVO, String operationID) {
        BusinessLogContext context = PFBusiLogUtil.createPFBusinessLogContext();
        context.setPk_busiobj(userVO.getPrimaryKey());
        context.setBusiobjcode(userVO.getUser_code());
        context.setBusiobjname(UserUtil.getUserName(userVO));
        context.setTypepk_busiobj("186d46f7-2fdd-4d5f-8923-eab74d377886");
        context.setPk_operation(operationID);
        return context;
    }

    private static String buildEditAgentUserMsg(List<WorkflowagentVO> listData, UserVO userVO) {
        StringBuffer sbMsg = new StringBuffer();
        int agentCount = ArrayUtil.isNull(listData) ? 0 : listData.size();
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000009") + ",").append("[" + UserUtil.getUserName(userVO) + "]").append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "BusiTypeBusiLogUtil-000010")).append(agentCount);
        if (!ArrayUtil.isNull(listData)) {
            sbMsg.append(":");
            for (int i = 0; i < listData.size(); ++i) {
                sbMsg.append("[").append(listData.get(i).getUserName()).append("]");
            }
        }
        return sbMsg.toString();
    }

    private static String buildSetAgentMsg(WorkflowpersonVO[] agentInfo) {
        StringBuffer sbMsg = new StringBuffer();
        for (WorkflowpersonVO workflowpersonVO : agentInfo) {
            IGeneralAccessor accessor = GeneralAccessorFactory.getAccessor((String)"f6f9a473-56c0-432f-8bc7-fbf8fde54fee");
            IBDData userData = accessor.getDocByPk(workflowpersonVO.getPk_cuserid());
            String usercode = userData == null ? null : userData.getName().toString();
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow65", "pfworkflow-agent01", null, new String[]{usercode, workflowpersonVO.getStarttime().toLocalString(), workflowpersonVO.getEndtime() == null ? null : workflowpersonVO.getEndtime().toLocalString(), workflowpersonVO.getIstrantask().toString()}));
            sbMsg.append("\n");
        }
        return sbMsg.toString();
    }

    private static String builCancelAgentMsg(WorkflowpersonVO[] agentInfo) {
        StringBuffer sbMsg = new StringBuffer();
        for (WorkflowpersonVO workflowpersonVO : agentInfo) {
            IGeneralAccessor accessor = GeneralAccessorFactory.getAccessor((String)"f6f9a473-56c0-432f-8bc7-fbf8fde54fee");
            IBDData userData = accessor.getDocByPk(workflowpersonVO.getPk_cuserid());
            String usercode = userData == null ? null : userData.getName().toString();
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow65", "pfworkflow-agent02", null, new String[]{usercode}));
            sbMsg.append("\n");
        }
        return sbMsg.toString();
    }
}

