/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.sql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import nc.bs.logging.Logger;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.trade.sqlutil.IInSqlBatchCallBack;
import nc.vo.trade.sqlutil.InSqlBatchCaller;

public class InSqlUtil {
    public static final String CONCATINATOR_OR = "or";
    public static final String CONCATINATOR_AND = "and";
    public static final String OPERATOR_IN = "in";
    public static final String OPERATOR_NOTIN = "not in";
    public static final String LEFT_BRACKET = "(";
    public static final String RIGHT_BRACKET = ")";

    public static String buildInSql(final String fieldName, final String concatinator, final String operator, String[] values) {
        if (ArrayUtil.isNull((Object[])values)) {
            return "(1=1)";
        }
        final StringBuffer sb = new StringBuffer();
        sb.append(LEFT_BRACKET);
        try {
            InSqlBatchCaller caller = new InSqlBatchCaller(values);
            caller.execute(new IInSqlBatchCallBack(){

                public Object doWithInSql(String inSql) throws BusinessException, SQLException {
                    if (sb.length() > InSqlUtil.LEFT_BRACKET.length()) {
                        sb.append(" ").append(concatinator).append(" ");
                    }
                    sb.append(fieldName).append(" ").append(operator).append(" ").append(inSql);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logger.error((Object)e);
        }
        sb.append(RIGHT_BRACKET);
        return sb.toString();
    }

    public static String[] combine(String[] ... elements) {
        ArrayList<String> list = new ArrayList<String>();
        for (String[] ele : elements) {
            list.addAll(Arrays.asList(ele));
        }
        return list.toArray(new String[0]);
    }
}

