/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.pub.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.logging.Logger;
import nc.bs.mw.sqltrans.TempTable;
import nc.jdbc.framework.ConnectionFactory;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.SuperVO;
import nc.vo.uap.pf.PFBusinessException;
import nccloud.commons.lang.StringUtils;

public class SQLUtil {
    private static final int SQL_IN_LIST_LIMIT = 200;

    public static void appendPKFieldSQL(StringBuffer sb, SuperVO superVO, String fieldName) {
        String value = (String)superVO.getAttributeValue(fieldName);
        if (value == null) {
            sb.append(" isnull(").append(fieldName).append(", '~') = '~' ");
        } else {
            sb.append(fieldName).append(" = '").append("'");
        }
    }

    public static String getGlobalInSQL() {
        return " in ('global00000000000000', '" + "global00000000000000".toUpperCase() + "') ";
    }

    public static Map<String, String> getMapColumnByString(String columnStr) {
        HashMap<String, String> mapColumn = null;
        if (!StringUtil.isEmptyWithTrim((String)columnStr)) {
            mapColumn = new HashMap<String, String>();
            Object[] columns = columnStr.split(",");
            if (!ArrayUtil.isNull((Object[])columns)) {
                for (Object column : columns) {
                    if (StringUtil.isEmptyWithTrim((String)column)) continue;
                    String[] columnAndType = ((String)column).trim().split(" ");
                    mapColumn.put(columnAndType[0].trim(), columnAndType[1].trim());
                }
            }
        }
        return mapColumn;
    }

    public static String initTempTableFromOld(String oldTableName, String tempTableName, String whereSql, Map<String, String> mapColumn) throws DAOException, PFBusinessException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTableName).append("(");
        for (Map.Entry<String, String> entryColumn : mapColumn.entrySet()) {
            insertSql.append(entryColumn.getKey()).append(", ");
        }
        insertSql.delete(insertSql.length() - 2, insertSql.length());
        insertSql.append(") select ");
        for (Map.Entry<String, String> entryColumn : mapColumn.entrySet()) {
            insertSql.append(oldTableName).append(".").append(entryColumn.getKey()).append(", ");
        }
        insertSql.delete(insertSql.length() - 2, insertSql.length());
        insertSql.append(" from ").append(oldTableName).append(" ");
        if (!StringUtil.isEmptyWithTrim((String)whereSql)) {
            insertSql.append(" where ").append(whereSql);
        }
        BaseDAO baseDAO = new BaseDAO();
        Logger.debug((Object)("+=+=+=+= tempTableName::insertSql" + tempTableName + " ::" + insertSql.toString()));
        int count = baseDAO.executeUpdate(insertSql.toString());
        Logger.debug((Object)("+=+=+=+= insertCount::" + count));
        return tempTableName;
    }

    public static String createTempTable(String tableName, String columns, String indexs) throws PFBusinessException {
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            TempTable tt = new TempTable();
            tableName = tt.createTempTable(con, tableName, columns, new String[]{indexs});
        }
        catch (SQLException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0083") + e.getMessage(), e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return tableName;
    }

    public static void clearTempTable(String tableName) throws PFBusinessException {
        BaseDAO baseDAO = new BaseDAO();
        try {
            baseDAO.executeUpdate("delete from " + tableName);
        }
        catch (DAOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0084") + e.getMessage(), e);
        }
    }

    public static void removeTempTable(String tableName) throws PFBusinessException {
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            TempTable tt = new TempTable();
            tt.dropTempTable(con, tableName);
        }
        catch (SQLException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0085") + e.getMessage(), e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String buildSqlForIn(String fieldname, String[] fieldvalue) {
        if (fieldvalue == null || fieldvalue.length == 0) {
            return " (1=2) ";
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("(" + fieldname + " IN ( ");
        int len = fieldvalue.length;
        for (int i = 0; i < len; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)fieldvalue[i])) continue;
            sbSQL.append("'").append(fieldvalue[i]).append("'");
            if (i == fieldvalue.length - 1) continue;
            if (i > 0 && (i + 1) % 200 == 0) {
                sbSQL.append(" ) OR ").append(fieldname).append(" IN ( ");
                continue;
            }
            if (i >= len - 1 || !StringUtils.isNotBlank((CharSequence)fieldvalue[i + 1])) continue;
            sbSQL.append(",");
        }
        sbSQL.append(" )) ");
        return sbSQL.toString();
    }
}

