/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nc.bill.data.access.BillAccess;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pub.pf.IMobileBillConstructHancerListener;
import nc.bs.pub.pf.IMobileBillConstructListener;
import nc.bs.pub.pf.PfUtilTools;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFMetaModel;
import nc.itf.uap.pf.IPFMobileAppService;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.pf.mobileapp.ITaskType;
import nc.vo.pf.mobileapp.MobileAppUtil;
import nc.vo.pf.mobileapp.TaskMetaData;
import nc.vo.pf.mobileapp.exception.LoopTerminateNotification;
import nc.vo.pf.mobileapp.log.PerformanceLoggerUtil;
import nc.vo.pf.mobileapp.query.ITaskQuery;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.platform.appsystemplate.AreaVO;
import nc.vo.platform.appsystemplate.FormPropertyVO;
import nc.vo.platform.appsystemplate.PageTempletVO;
import nc.vo.platform.workbench.AppPageVO;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.BusinessRuntimeException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.bill.BillStructVO;
import nc.vo.pub.bill.BillTabVO;
import nc.vo.pub.bill.BillTempletBodyVO;
import nc.vo.pub.bill.BillTempletHeadVO;
import nc.vo.pub.bill.BillTempletVO;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.billtype2.ExtendedClassEnum;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nccloud.commons.lang.StringUtils;
import nccloud.putitf.riart.billtype.IDefaultQueryRelatedAppInfoService;
import nccloud.riart.crossservice.pf.IPfCrossServiceHandle;

public abstract class TaskQuery
implements ITaskQuery {
    private ITaskType taskType = null;
    private String pk_group = null;
    private String cuserid = null;
    private String date = null;
    private String condition = null;
    private String moduleid = null;
    private IUAPQueryBS qry = null;
    private IPFMetaModel pfmetaqry = null;
    private List<String> pk_org = null;
    private List<String> billtypeOrTranstype = null;
    private String starttime = null;

    protected IUAPQueryBS getQueryService() {
        if (this.qry == null) {
            this.qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        }
        return this.qry;
    }

    protected IPFMetaModel getPFMetaModelService() {
        if (this.pfmetaqry == null) {
            this.pfmetaqry = (IPFMetaModel)NCLocator.getInstance().lookup(IPFMetaModel.class);
        }
        return this.pfmetaqry;
    }

    public ITaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(ITaskType taskType) {
        this.taskType = taskType;
    }

    public String getPk_group() {
        return this.pk_group;
    }

    public void setPk_group(String pk_group) {
        this.pk_group = pk_group;
    }

    public String getCuserid() {
        return this.cuserid;
    }

    public void setCuserid(String cuserid) {
        this.cuserid = cuserid;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getDateAsEnd() {
        return new UFDate(this.date).asEnd().toString();
    }

    public String getDateAsBegin() {
        if (this.starttime != null && this.starttime.length() > 0) {
            return new UFDate(this.starttime).asBegin().toString();
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTaskType().getCategory());
        sb.append(this.getTaskType().getCode());
        sb.append(this.getPk_group());
        sb.append(this.getCuserid());
        sb.append(this.getDate());
        return sb.toString();
    }

    @Override
    public Map<String, Object> queryTaskBill(String pk) throws BusinessException {
        String mainTag = "TaskQuery.queryTaskBill";
        PerformanceLoggerUtil.begin(mainTag);
        try {
            PerformanceLoggerUtil.begin("queryTmd");
            TaskMetaData tmd = this.queryTaskMetaData(pk);
            PerformanceLoggerUtil.end("queryTmd");
            BillTempletVO tvo = null;
            IDefaultQueryRelatedAppInfoService service = (IDefaultQueryRelatedAppInfoService)NCLocator.getInstance().lookup(IDefaultQueryRelatedAppInfoService.class);
            Map<String, Object> map = service.getMobileAppInfoMap_NoSameOrigin(tmd.getBillType(), tmd);
            String appcode_new = null;
            String pagecode_new = null;
            LinkedHashMap colorresult = new LinkedHashMap();
            if (((Boolean)map.get("islightbill")).booleanValue()) {
                String appcode;
                if (map.get("appPageVO") == null || map.get("appcode") == null) {
                    HashMap<String, Object> resultNull = new HashMap<String, Object>();
                    resultNull.put("appPageVO", "none");
                    resultNull.put("appcode", "none");
                    HashMap<String, Object> hashMap = resultNull;
                    return hashMap;
                }
                AppPageVO page = (AppPageVO)map.get("appPageVO");
                String userappcode = appcode = (String)map.get("appcode");
                Object curWorkflowApp = map.get("curWorkflowApp");
                if (curWorkflowApp != null) {
                    userappcode = (String)curWorkflowApp;
                }
                appcode_new = userappcode;
                pagecode_new = page.getPagecode();
                PageTempletVO template = MobileAppUtil.queryNCCTemplate(tmd, page, userappcode);
                if (template == null) {
                    appcode_new = appcode;
                    template = MobileAppUtil.queryNCCTemplate(tmd, page, appcode);
                }
                if (template == null) {
                    throw new BusinessException("\u7f3a\u5c11\u79fb\u52a8\u5ba1\u6279\u5355\u636e\u6a21\u7248");
                }
                List colorarea = template.getAreaList();
                for (int i = 0; i < colorarea.size(); ++i) {
                    AreaVO vo = (AreaVO)colorarea.get(i);
                    String tablecode = vo.getCode();
                    List colorproperty = vo.getFormPropertyList();
                    HashMap<String, String> property_color = new HashMap<String, String>();
                    for (int j = 0; j < colorproperty.size(); ++j) {
                        String code = ((FormPropertyVO)colorproperty.get(j)).getCode();
                        String color = ((FormPropertyVO)colorproperty.get(j)).getColor();
                        if (color == null || color.length() <= 0) continue;
                        property_color.put(code, color);
                    }
                    colorresult.put(tablecode, property_color);
                }
                tvo = this.convertToNCC(template);
            } else {
                String templateid = MobileAppUtil.queryTemplateId(tmd);
                tvo = MobileAppUtil.queryTemplate(templateid);
            }
            PerformanceLoggerUtil.begin("query bill entity");
            AggregatedValueObject bvo = MobileAppUtil.queryBillEntity(tmd.getBillType(), tmd.getBillId());
            PerformanceLoggerUtil.end("query bill entity");
            this.processEntity(bvo);
            String billtype = tmd.getBillType();
            Map<String, Object> listermap = this.getConstructListenerMap(billtype);
            String realBillType = null;
            String className = null;
            if (listermap != null && !listermap.isEmpty()) {
                Object lis = listermap.get("listener");
                if (listermap.get("realBillType") != null) {
                    realBillType = (String)listermap.get("realBillType");
                }
                if (listermap.get("className") != null) {
                    className = (String)listermap.get("className");
                }
                if (lis != null) {
                    try {
                        ((IMobileBillConstructListener)lis).beforeConstruct(tvo, bvo);
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BusinessException(e.getMessage());
                    }
                }
                Map<String, Object> beformap = null;
                try {
                    IPfCrossServiceHandle handle = (IPfCrossServiceHandle)NCLocator.getInstance().lookup(IPfCrossServiceHandle.class.getName());
                    beformap = handle.getBeforeMobileBillConstruct(billtype, className, tvo, bvo);
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BusinessException(e.getMessage());
                }
                if (beformap != null && !beformap.isEmpty()) {
                    if (beformap.get("BillTempletVO") != null) {
                        tvo = (BillTempletVO)beformap.get("BillTempletVO");
                    }
                    if (beformap.get("AggregatedValueObject") != null) {
                        bvo = (AggregatedValueObject)beformap.get("AggregatedValueObject");
                    }
                }
            }
            PerformanceLoggerUtil.begin("construct by bill templet");
            BillAccess ba = new BillAccess(tvo, (Object)bvo);
            Map billVOMap = ba.billVO2Map();
            PerformanceLoggerUtil.end("construct by bill templet");
            PerformanceLoggerUtil.begin("after construct, process row count");
            int origin = MobileAppUtil.getRowCount();
            int current = ArrayUtil.getLength((Object[])bvo.getChildrenVO());
            Map<String, Object> result = this.processResultSetRowCount(billVOMap, origin, current);
            result.put("colormap", colorresult);
            PerformanceLoggerUtil.end("after construct, process row count");
            if (listermap != null && !listermap.isEmpty()) {
                Object lis = listermap.get("listener");
                if (listermap.get("realBillType") != null) {
                    realBillType = (String)listermap.get("realBillType");
                }
                if (listermap.get("className") != null) {
                    className = (String)listermap.get("className");
                }
                if (lis != null) {
                    block36: {
                        try {
                            if (!(lis instanceof IMobileBillConstructHancerListener)) break block36;
                            ((IMobileBillConstructHancerListener)lis).afterConstructWithBillVO(billVOMap, appcode_new, pagecode_new, bvo);
                            result.putAll(billVOMap);
                            Map<String, Object> j = result;
                            return j;
                        }
                        catch (Exception e) {
                            Logger.error((Object)e.getMessage(), (Throwable)e);
                            throw new BusinessException(e.getMessage());
                        }
                    }
                    ((IMobileBillConstructListener)lis).afterConstruct(billVOMap);
                }
                Map<String, Object> aftermap = null;
                try {
                    IPfCrossServiceHandle handle = (IPfCrossServiceHandle)NCLocator.getInstance().lookup(IPfCrossServiceHandle.class.getName());
                    aftermap = handle.getAfterMobileBillConstruct(realBillType, className, billVOMap);
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (aftermap != null && !aftermap.isEmpty() && aftermap.get("billVOMap") != null) {
                    billVOMap = (Map)aftermap.get("billVOMap");
                }
            }
            Map<String, Object> map2 = result;
            return map2;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        finally {
            PerformanceLoggerUtil.end(mainTag);
        }
    }

    private Map<String, Object> processResultSetRowCount(Map<String, List<Map<String, Object>>> billVOMap, int origin, int current) {
        LinkedHashMap<String, Object> resultMap = MobileAppUtil.createLinkedHashMap();
        if (billVOMap != null) {
            for (Map.Entry<String, List<Map<String, Object>>> entry : billVOMap.entrySet()) {
                String key = entry.getKey();
                List<Map<String, Object>> value = entry.getValue();
                resultMap.put(key, value);
                try {
                    Map<Object, Object> bodyMap;
                    if (!key.equals("body")) continue;
                    if (value != null) {
                        bodyMap = value.get(0);
                        bodyMap.put("rowcnt", String.valueOf(origin));
                        continue;
                    }
                    bodyMap = new HashMap();
                    bodyMap.put("rowcnt", "0");
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (origin > current) {
            try {
                this.processElement(resultMap);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return resultMap;
    }

    private void processElement(Object obj) throws LoopTerminateNotification {
        block4: {
            block3: {
                if (!(obj instanceof List)) break block3;
                for (Object sub : (List)obj) {
                    if (sub == null) continue;
                    this.processElement(sub);
                }
                break block4;
            }
            if (!(obj instanceof Map)) break block4;
            Map map = (Map)obj;
            if (map.containsKey("ibodyrowcount")) {
                Integer rowcnt = MobileAppUtil.getRowCount();
                map.put("ibodyrowcount", String.valueOf(rowcnt));
                throw new LoopTerminateNotification();
            }
            for (String key : map.keySet()) {
                Object value = map.get(key);
                this.processElement(value);
            }
        }
    }

    private void processEntity(AggregatedValueObject aggVo) {
        this.processRowCount(aggVo);
        CircularlyAccessibleValueObject parent = aggVo.getParentVO();
        Object[] children = aggVo.getChildrenVO();
        this.processDouble(parent);
        if (!ArrayUtil.isNull((Object[])children)) {
            for (Object c : children) {
                this.processDouble((CircularlyAccessibleValueObject)c);
            }
        }
    }

    private void processRowCount(AggregatedValueObject aggVo) {
        try {
            CircularlyAccessibleValueObject[] children = aggVo.getChildrenVO();
            Integer rowCount = children == null ? 0 : children.length;
            Logger.debug((Object)("____row count: " + rowCount));
            MobileAppUtil.setRowCount(rowCount);
            if (rowCount > MobileAppUtil.TRIM_TO_COUNT) {
                List<CircularlyAccessibleValueObject> subList = Arrays.asList(children).subList(0, MobileAppUtil.TRIM_TO_COUNT);
                CircularlyAccessibleValueObject[] casted = (CircularlyAccessibleValueObject[])ArrayUtil.convertToArray(subList);
                aggVo.setChildrenVO(casted);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void processDouble(CircularlyAccessibleValueObject vo) {
        String[] attrs;
        for (String att : attrs = vo.getAttributeNames()) {
            Object value = vo.getAttributeValue(att);
            if (!(value instanceof UFDouble)) continue;
            UFDouble d = (UFDouble)value;
            d = MobileAppUtil.adjust2Scale(d);
            vo.setAttributeValue(att, (Object)d);
        }
    }

    private IMobileBillConstructListener getConstructListener(String billtype) {
        ArrayList<Billtype2VO> list = PfDataCache.getBillType2Info(billtype, ExtendedClassEnum.MOBILEBILL_CONSTRUCT_LISTENER.getIntValue());
        if (list != null && list.size() > 0) {
            Billtype2VO b2vo = (Billtype2VO)((Object)list.get(0));
            String className = b2vo.getClassname();
            String realBillType = b2vo.getPk_billtype();
            try {
                return (IMobileBillConstructListener)PfUtilTools.instantizeObject(realBillType, className);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private Map<String, Object> getConstructListenerMap(String billtype) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Billtype2VO> list = PfDataCache.getBillType2Info(billtype, ExtendedClassEnum.MOBILEBILL_CONSTRUCT_LISTENER.getIntValue());
        if (list != null && list.size() > 0) {
            Billtype2VO b2vo = (Billtype2VO)((Object)list.get(0));
            String className = b2vo.getClassname();
            String realBillType = b2vo.getPk_billtype();
            map.put("realBillType", realBillType);
            map.put("className", className.trim());
            try {
                IMobileBillConstructListener Listener = (IMobileBillConstructListener)PfUtilTools.instantizeObject(realBillType, className);
                if (Listener != null) {
                    map.put("listener", Listener);
                }
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessRuntimeException(e.getMessage());
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> queryTaskActions(String pk) throws BusinessException {
        return MobileAppUtil.createHashMap();
    }

    @Override
    public Map<String, Object> queryTaskActionDefaultValue(String pk, String actionCode) throws BusinessException {
        return MobileAppUtil.createHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> queryHTMLTaskBill(String pk) throws BusinessException {
        String mainTag = "TaskQuery.queryHTMLTaskBill";
        PerformanceLoggerUtil.begin(mainTag);
        try {
            PerformanceLoggerUtil.begin("queryTmd");
            TaskMetaData tmd = this.queryTaskMetaData(pk);
            PerformanceLoggerUtil.end("queryTmd");
            PerformanceLoggerUtil.begin("query template id");
            String templateid = MobileAppUtil.queryPrintTemplateId(tmd);
            PerformanceLoggerUtil.end("query template id");
            PerformanceLoggerUtil.begin("query List<HtmlContentVO>");
            List<Map<String, Object>> htmlList = MobileAppUtil.getHtmlOfPrintTemplete(tmd.getBillId(), tmd.getBillType(), templateid);
            PerformanceLoggerUtil.end("query List<HtmlContentVO>");
            List<Map<String, Object>> list = htmlList;
            return list;
        }
        finally {
            PerformanceLoggerUtil.end(mainTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> toPNGImagesWithSubFlow(String billId, String billType, int iWorkflowtype, String pk_busiworkflow) throws BusinessException {
        String mainTag = "TaskQuery.toPNGImagesWithSubFlow";
        PerformanceLoggerUtil.begin(mainTag);
        try {
            PerformanceLoggerUtil.begin("toPNGImages");
            Map<String, Object> map = MobileAppUtil.toPNGImagesWithSubFlow(billId, billType, iWorkflowtype, pk_busiworkflow);
            return map;
        }
        finally {
            PerformanceLoggerUtil.end(mainTag);
        }
    }

    private BillTempletVO convertToNCC(PageTempletVO template) {
        BillTempletVO billtemplet = null;
        ArrayList<AreaVO> bodyArea = new ArrayList<AreaVO>();
        AreaVO headArea = new AreaVO();
        List areas = null;
        areas = template.getAreaList() != null && template.getAreaList().size() > 0 ? template.getAreaList() : new ArrayList();
        String mainMetaid = "";
        for (AreaVO area : areas) {
            if (template.getHeadcode().equals(area.getCode())) {
                headArea = area;
                mainMetaid = area.getMetaid();
                continue;
            }
            bodyArea.add(area);
        }
        BillTempletHeadVO headVO = this.getHeadVO(headArea);
        BillTempletBodyVO[] bodyVOs = this.getBodyVO(areas, template.getHeadcode());
        billtemplet = new BillTempletVO(headVO, bodyVOs);
        this.setBillTab(billtemplet, areas, template.getHeadcode(), mainMetaid);
        return billtemplet;
    }

    private BillTempletHeadVO getHeadVO(AreaVO headArea) {
        BillTempletHeadVO headVO = new BillTempletHeadVO();
        headVO.setPkBillTypeCode(headArea.getCode());
        headVO.setBillTempletName(headArea.getName());
        headVO.setBillTempletCaption(headArea.getAreadesc());
        headVO.setTs(headArea.getTs());
        headVO.setMetadataclass(headArea.getMetaspace());
        return headVO;
    }

    private BillTempletBodyVO[] getBodyVO(List<AreaVO> bodyArea, String headCode) {
        ArrayList<BillTempletBodyVO> tolist = new ArrayList<BillTempletBodyVO>();
        BillTempletBodyVO[] vos = new BillTempletBodyVO[bodyArea.size()];
        for (AreaVO area : bodyArea) {
            List list = area.getFormPropertyList();
            for (FormPropertyVO vo : list) {
                BillTempletBodyVO tovo = new BillTempletBodyVO();
                tovo.setItemkey(vo.getCode());
                tovo.setPos(Integer.valueOf(headCode.equals(area.getCode()) ? 0 : 1));
                tovo.setWidth(vo.getWidth());
                tovo.setShoworder(vo.getPosition());
                tovo.setListshoworder(vo.getPosition());
                tovo.setLockflag(Boolean.valueOf("0"));
                tovo.setDefaultshowname(vo.getLabel());
                tovo.setEditflag(Boolean.valueOf("0"));
                tovo.setDatatype(this.convertDatatype(vo));
                tovo.setInputlength(Integer.valueOf(-1));
                tovo.setShowflag(Boolean.valueOf(vo.getVisible().booleanValue()));
                tovo.setTotalflag(Boolean.valueOf("0"));
                if (vo.getShowformula() != null) {
                    tovo.setLoadformula(vo.getShowformula());
                }
                tovo.setEditformula(vo.getEditformula());
                tovo.setNullflag(Boolean.valueOf("0"));
                tovo.setUsershowflag(Boolean.valueOf("1"));
                tovo.setUserflag(Boolean.valueOf("1"));
                tovo.setCardflag(Boolean.valueOf("1"));
                tovo.setListflag(Boolean.valueOf("1"));
                tovo.setTable_code(area.getCode());
                tovo.setTable_name(area.getCode());
                tovo.setForeground(Integer.valueOf(-1));
                tovo.setDefaultvalue(vo.getDefaultvalue());
                tovo.setPk_corp("@@@@");
                tovo.setItemtype(Integer.valueOf(0));
                tovo.setOptions(null);
                tovo.setLeafflag(UFBoolean.FALSE);
                tovo.setUserdefflag(UFBoolean.FALSE);
                tovo.setNewlineflag(UFBoolean.FALSE);
                tovo.setReviseflag(UFBoolean.FALSE);
                tovo.setUserreviseflag(UFBoolean.FALSE);
                tovo.setListshowflag(Boolean.valueOf("N"));
                tovo.setValidateformula(vo.getValidateformula());
                if (vo.getMetapath() != null) {
                    tovo.setMetadatapath(vo.getMetapath());
                } else {
                    tovo.setMetadatapath(null);
                }
                if (area.getMetaspace() != null && vo.getMetapath() != null) {
                    tovo.setMetadataproperty(area.getMetaspace() + "." + vo.getMetapath());
                } else if (vo.getMetadataproperty() != null) {
                    tovo.setMetadataproperty(vo.getMetadataproperty());
                } else {
                    tovo.setMetadataproperty(null);
                }
                tovo.setMetadatarelation(null);
                tovo.setHyperlinkflag(UFBoolean.FALSE);
                tovo.setListHyperlinkflag(UFBoolean.FALSE);
                tolist.add(tovo);
            }
        }
        vos = tolist.toArray(vos);
        return vos;
    }

    private void setBillTab(BillTempletVO billtemplet, List<AreaVO> areas, String headCode, String mainMetaid) {
        if (billtemplet != null) {
            BillStructVO bsvo = billtemplet.getHeadVO().getStructvo();
            if (bsvo == null) {
                bsvo = new BillStructVO();
            }
            try {
                BillTempletBodyVO[] bodys;
                BillTabVO[] bts = new BillTabVO[areas.size()];
                bts = this.getTabVO(areas, headCode, mainMetaid);
                if (bts != null && bts.length > 0) {
                    bsvo.setBillTabVOs(bts);
                    billtemplet.getHeadVO().setStructvoAndClearOptions(bsvo);
                }
                if (billtemplet.getHeadVO().getStructvo() != null) {
                    bts = billtemplet.getHeadVO().getStructvo().getBillTabVOs();
                }
                HashMap<String, BillTabVO> map = new HashMap<String, BillTabVO>();
                if (bts != null && bts.length > 0) {
                    for (int i = 0; i < bts.length; ++i) {
                        if (bts[i].getPos() != null && bts[i].getPos() == 1) {
                            map.put(bts[i].getTabcode(), bts[i]);
                        }
                        if (bts[i].getPk_layout() == null) continue;
                        String string = bts[i].getPk_layout();
                    }
                }
                if ((bodys = billtemplet.getBodyVO()) != null) {
                    for (int i = 0; i < bodys.length; ++i) {
                        if (map.size() == 0 || bodys[i].getPos() == null || bodys[i].getPos() != 1) {
                            bodys[i].setOptions(null);
                            continue;
                        }
                        if (bodys[i].getOptions() == null) continue;
                        HashMap hs = bodys[i].getHashShareTable();
                        if (hs != null) {
                            Iterator it = hs.keySet().iterator();
                            ArrayList<String> listcode = new ArrayList<String>();
                            while (it.hasNext()) {
                                String code = (String)it.next();
                                if (map.containsKey(code)) continue;
                                listcode.add(code);
                            }
                            if (listcode.size() > 0) {
                                for (int j = 0; j < listcode.size(); ++j) {
                                    hs.remove(listcode.get(j));
                                }
                            }
                        }
                        bodys[i].clearOptions();
                        if (hs != null && hs.size() != 0) continue;
                        bodys[i].setOptions(null);
                    }
                }
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage());
            }
        }
    }

    private BillTabVO[] getTabVO(List<AreaVO> bodyArea, String headCode, String mainMetaid) {
        ArrayList<BillTabVO> list = new ArrayList<BillTabVO>();
        BillTabVO[] vos = new BillTabVO[bodyArea.size()];
        for (AreaVO area : bodyArea) {
            String[] prepath;
            BillTabVO vo = new BillTabVO();
            String metaSpace = area.getMetaspace();
            vo.setMetadataclass(area.getClazz());
            String desc = area.getAreadesc();
            String metapath = metaSpace;
            if (metaSpace != null && metaSpace.trim().length() > 0 && metaSpace.contains(".")) {
                metapath = metaSpace.substring(metaSpace.indexOf(".") + 1);
            }
            String bodypath = null;
            boolean hasDefMetaPath = false;
            if (desc != null && desc.trim().length() > 0 && desc.contains("#") && (prepath = desc.split("#")) != null && prepath.length == 2) {
                metapath = prepath[1];
                hasDefMetaPath = true;
            }
            if (!hasDefMetaPath && area != null && !StringUtils.isEmpty((CharSequence)(bodypath = this.getBodypath(mainMetaid, area.getMetaid())))) {
                metapath = bodypath;
            }
            vo.setMetadatapath(metapath);
            vo.setPos(Integer.valueOf(headCode.equals(area.getCode()) ? 0 : 1));
            vo.setPosition(Integer.valueOf(headCode.equals(area.getCode()) ? 0 : 1));
            vo.setTabcode(area.getCode());
            vo.setTabindex(area.getPosition());
            vo.setTabname(area.getName());
            list.add(vo);
        }
        vos = list.toArray(vos);
        return vos;
    }

    private String getBodypath(String mainMetaid, String bodyMetaid) {
        String sql = "select name from md_property where classid='" + mainMetaid + "'  and datatype='" + bodyMetaid + "'";
        try {
            Object bodypath = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).executeQuery(sql, (ResultSetProcessor)new ColumnProcessor(1));
            if (bodypath == null) {
                return null;
            }
            return (String)bodypath;
        }
        catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private Integer convertDatatype(FormPropertyVO vo) {
        switch (vo.getDatatype()) {
            case 203: {
                return 6;
            }
            case 204: {
                return 5;
            }
            case 52: {
                return 18;
            }
            case 57: {
                return 7;
            }
            case 56: {
                return 16;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 32: {
                return 4;
            }
            case 31: {
                return 2;
            }
            case 58: {
                return 17;
            }
            case 30: {
                return 9;
            }
            case 34: {
                return 8;
            }
            case 33: {
                return 3;
            }
            case 37: {
                return 0;
            }
            case 38: {
                return 0;
            }
        }
        return -1;
    }

    public List<String> getPk_org() {
        return this.pk_org;
    }

    public void setPk_org(List<String> pk_org) {
        this.pk_org = pk_org;
    }

    public List<String> getBilltypeOrTranstype() {
        return this.billtypeOrTranstype;
    }

    public void setBilltypeOrTranstype(List<String> billtypeOrTranstype) {
        this.billtypeOrTranstype = billtypeOrTranstype;
    }

    public String getStarttime() {
        return this.starttime;
    }

    public void setStarttime(String starttime) {
        this.starttime = starttime;
    }

    public String getModuleid() {
        return this.moduleid;
    }

    public void setModuleid(String moduleid) {
        this.moduleid = moduleid;
    }

    protected List<String> getBillTypeByModuleid(String moduleid, String pk_group) throws BusinessException {
        IPFMobileAppService service = (IPFMobileAppService)NCLocator.getInstance().lookup(IPFMobileAppService.class);
        List<String> ret = service.getBillTypeByModuleid(moduleid, pk_group);
        return ret;
    }
}

