/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.NCLocator;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.ICacheDataQueryCallback;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.itf.uap.pf.IPFMobileAppService;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ArrayProcessor;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.mobileapp.MobileAppUtil;
import nc.vo.pf.mobileapp.TaskMetaData;
import nc.vo.pf.mobileapp.exception.TaskNotValidException;
import nc.vo.pf.mobileapp.query.TaskQuery;
import nc.vo.pub.BusinessException;
import nc.vo.pub.pf.Pfi18nTools;

public abstract class AbstractSubmittedQuery
extends TaskQuery {
    protected static final String BILLMAKER = "#billmaker#";
    protected static final String WORKFLOWTYPE = "#workflowtype#";
    protected static final String PROCSTATUS = "#procstatus#";
    protected static final String PK_GROUP = "#pk_group#";
    protected static final String STARTTS = "#startts#";
    protected static final String GROUP_SQL = "select distinct task.pk_wf_instance from pub_wf_task task inner join pub_workflownote note on note.pk_wf_task = task.pk_wf_task  where note.pk_group ='#pk_group#'";
    private static final String SQL = "select pk_wf_instance,startts from pub_wf_instance where billmaker='#billmaker#' and workflow_type in#workflowtype# and procstatus=#procstatus# and pk_wf_instance in (select distinct task.pk_wf_instance from pub_wf_task task inner join pub_workflownote note on note.pk_wf_task = task.pk_wf_task  where note.pk_group ='#pk_group#') and startts < '#startts#'  order by startts desc";

    protected String getBaseSQL() {
        if (!StringUtil.isEmptyWithTrim((String)this.getCondition())) {
            String group_sql = "select distinct task.pk_wf_instance from pub_wf_task task inner join pub_workflownote note on note.pk_wf_task = task.pk_wf_task  left join sm_msg_content msg on note.pk_checkflow = msg.pk_detail  where note.pk_group ='#pk_group#' and msg.subject like '%" + this.getCondition() + "%'";
            String sql = "select pk_wf_instance,startts from pub_wf_instance where billmaker='#billmaker#' and workflow_type in #workflowtype# and procstatus=#procstatus# and pk_wf_instance in (" + group_sql + ") and startts < '" + STARTTS + "'  order by startts desc";
            return sql;
        }
        return SQL;
    }

    protected String getBilltype() {
        return " select pk_billtypecode from bd_billtype inner join pub_systemplate_base on bd_billtype.nodecode = pub_systemplate_base.funnode where tempstyle = '5' and nodekey is null ";
    }

    @Override
    public List<Map<String, Object>> queryByPks(String[] pks) throws BusinessException {
        ArrayList<Map<String, Object>> list = MobileAppUtil.createArrayList();
        for (String pk : pks) {
            TaskMetaData tmd = this.queryTaskMetaData(pk);
            Map<String, Object> map = this.convertToTask(tmd);
            list.add(map);
        }
        return list;
    }

    private Map<String, Object> convertToTask(TaskMetaData tmd) throws BusinessException {
        HashMap<String, Object> map = MobileAppUtil.createHashMap();
        map.put("taskid", tmd.getPk_wf_instance());
        map.put("title", tmd.getTitle());
        map.put("date", tmd.getStartDate());
        map.put("priority", "");
        map.put("isreminder", "N");
        map.put("moduleid", this.getParentCode(tmd.getModulecode()));
        return map;
    }

    @Override
    public TaskMetaData queryTaskMetaData(final String pk) throws BusinessException {
        CondStringKey key = new CondStringKey("mobileapp_submitted_querytaskmetadata", pk);
        ICacheDataQueryCallback<TaskMetaData> callback = new ICacheDataQueryCallback<TaskMetaData>(){

            public TaskMetaData queryData() throws BusinessException {
                String sql = "select billmaker, billno, billtype, billversionpk, startts,workflow_type from pub_wf_instance where pk_wf_instance=?";
                SQLParameter param = new SQLParameter();
                param.addParam(pk);
                Object[] result = (Object[])AbstractSubmittedQuery.this.getQueryService().executeQuery(sql, param, (ResultSetProcessor)new ArrayProcessor());
                if (result == null) {
                    throw new TaskNotValidException();
                }
                TaskMetaData tmd = new TaskMetaData();
                tmd.setCuserid((String)result[0]);
                tmd.setBillNo((String)result[1]);
                tmd.setBillType((String)result[2]);
                tmd.setBillId((String)result[3]);
                tmd.setStartDate((String)result[4]);
                tmd.setPk_wf_instance(pk);
                tmd.setWorkflow_type((Integer)result[5]);
                String devModel = AbstractSubmittedQuery.this.getPFMetaModelService().queryModuleOfBilltype(tmd.getBillType());
                tmd.setModulecode(devModel);
                AbstractSubmittedQuery.this.fillTitle(tmd);
                return tmd;
            }
        };
        return (TaskMetaData)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }

    private void fillTitle(TaskMetaData tmd) throws BusinessException {
        String sql = "select top 2 w.checkman from pub_workflownote w join pub_wf_task k on w.pk_wf_task=k.pk_wf_task  where k.pk_wf_instance=? order by w.senddate asc";
        SQLParameter param = new SQLParameter();
        param.addParam(tmd.getPk_wf_instance());
        List result = (List)this.getQueryService().executeQuery(sql, param, (ResultSetProcessor)new ColumnListProcessor());
        StringBuffer sb = new StringBuffer();
        String billTypeName = Pfi18nTools.i18nBilltypeName(tmd.getBillType());
        sb.append(billTypeName);
        sb.append(", ");
        sb.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("mobileapp", "AbstractSubmittedQuery-000000"));
        sb.append(": ");
        sb.append(tmd.getBillNo());
        if (result != null && result.size() != 0) {
            if (result.size() > 1) {
                sb.append(", ");
                String cuserid = (String)result.get(0);
                String text = NCLangRes4VoTransl.getNCLangRes().getStrByID("mobileapp", "AbstractSubmittedQuery-000002", null, new String[]{Pfi18nTools.getUserName(cuserid)});
                sb.append(text);
            } else {
                sb.append(", ");
                String cuserid = (String)result.get(0);
                String text = NCLangRes4VoTransl.getNCLangRes().getStrByID("mobileapp", "AbstractSubmittedQuery-000003", null, new String[]{Pfi18nTools.getUserName(cuserid)});
                sb.append(text);
            }
        }
        tmd.setTitle(sb.toString());
    }

    private String getModuleid(String billtype) throws BusinessException {
        String modulecode = this.getPFMetaModelService().queryModuleOfBilltype(billtype);
        return this.getParentCode(modulecode);
    }

    private String getParentCode(String modulecode) throws BusinessException {
        IPFMobileAppService service = (IPFMobileAppService)NCLocator.getInstance().lookup(IPFMobileAppService.class);
        String moduleid = service.getParentCode(modulecode);
        return moduleid;
    }
}

