/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.mapp.conf.MappConfAccessor;
import nc.bs.ml.NCLangResOnserver;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pf.pub.WorkflowProcessCache;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.ICacheDataQueryCallback;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.itf.pub.workflowqry.IFlowInstanceQuery;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.billtemplate.IBillTemplateQry;
import nc.itf.uap.pf.IPFConfig;
import nc.itf.uap.pf.IPFTemplate;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.print.IPrintEntry;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.mapping.IMappingMeta;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.ui.pf.multilang.PfMultiLangUtil;
import nc.ui.pub.print.IDataSource;
import nc.vo.bd.psn.PsnjobVO;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.org.DeptVO;
import nc.vo.org.JobVO;
import nc.vo.pf.mobileapp.ITaskType;
import nc.vo.pf.mobileapp.MobileTaskFilterHandler;
import nc.vo.pf.mobileapp.TaskMetaData;
import nc.vo.pf.mobileapp.TaskTypeFactory;
import nc.vo.pf.mobileapp.query.BillVORowCountKey;
import nc.vo.pf.mobileapp.query.TaskQuery;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.platform.appsystemplate.PageTempletVO;
import nc.vo.platform.workbench.AppPageVO;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.BusinessRuntimeException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.bill.BillTempletVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFDouble;
import nc.vo.pub.pf.AssignableInfo;
import nc.vo.pub.pf.PFClientBizRetVO;
import nc.vo.pub.print.PrintTempletmanageHeaderVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.uap.pf.TemplateParaVO;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.pub.WFTask;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;
import nccloud.pubitf.platform.print.IPrintInfo;
import nccloud.pubitf.platform.print.IPrintService2;
import nccloud.pubitf.platform.print.vo.PrintInfo;
import nccloud.pubitf.platform.template.IAppTemplateAssignment;
import nccloud.putitf.riart.billtype.IDefaultQueryRelatedAppInfoService;
import nccloud.vo.pf.flowinstance.NCCFlowInstanceVO;

public class MobileAppUtil {
    public static final Integer TRIM_TO_COUNT = 50;

    public static ArrayList<Map<String, Object>> createArrayList() {
        return new ArrayList<Map<String, Object>>();
    }

    public static HashMap<String, Object> createHashMap() {
        return new HashMap<String, Object>();
    }

    public static LinkedHashMap<String, Object> createLinkedHashMap() {
        return new LinkedHashMap<String, Object>();
    }

    public static Map<Object, Map<String, Object>> convertToMap(List<Map<String, Object>> list, String key) {
        HashMap<Object, Map<String, Object>> resultMap = new HashMap<Object, Map<String, Object>>();
        for (Map<String, Object> map : list) {
            resultMap.put(map.get(key), map);
        }
        return resultMap;
    }

    public static UFDouble adjust2Scale(UFDouble value) {
        value.setTrimZero(true);
        String struf = value.toString();
        if (struf.lastIndexOf(".") > 0 && struf.length() - (struf.lastIndexOf(".") + 1) >= 2) {
            return value;
        }
        value.setTrimZero(false);
        return value.setScale(-2, 4);
    }

    public static ITaskType getTaskType(String category, String code) {
        ITaskType taskType = TaskTypeFactory.getInstance().get(category, code);
        if (taskType == null) {
            throw new IllegalArgumentException("invalid category or code: " + category + ", " + code);
        }
        return taskType;
    }

    public static String getStringFromObjects(Object[] objs, int idx) {
        if (objs == null) {
            return null;
        }
        if (idx >= objs.length) {
            return null;
        }
        return objs[idx] == null ? null : String.valueOf(objs[idx]);
    }

    public static TaskMetaData queryTaskMetaData(final String category, final String code, final String taskid) throws BusinessException {
        CondStringKey key = new CondStringKey("mobileapp_query_taskmetadata", category, code, taskid);
        ICacheDataQueryCallback<TaskMetaData> callback = new ICacheDataQueryCallback<TaskMetaData>(){

            public TaskMetaData queryData() throws BusinessException {
                ITaskType taskType = MobileAppUtil.getTaskType(category, code);
                TaskQuery query = taskType.createNewTaskQuery();
                TaskMetaData tmd = query.queryTaskMetaData(taskid);
                return tmd;
            }
        };
        return (TaskMetaData)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }

    public static WorkflownoteVO checkWorkflow(String pk_checkflow) throws BusinessException {
        TaskMetaData tmd = MobileAppUtil.queryTaskMetaData("ishandled", "unhandled", pk_checkflow);
        return MobileAppUtil.checkWorkflow(tmd);
    }

    public static WorkflownoteVO checkWorkflow(TaskMetaData tmd) throws BusinessException {
        IWorkflowMachine srv = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
        WorkflownoteVO note = srv.checkWorkflowActions(tmd.getBillType(), tmd.getBillId());
        return note;
    }

    public static PFClientBizRetVO executeClientBiz(AggregatedValueObject aggvo, WorkflownoteVO wfvo) throws BusinessException {
        IWorkflowMachine srv = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class);
        return srv.executeClientBizProcess(aggvo, wfvo, false);
    }

    public static String queryTemplateId(TaskMetaData tmd) throws BusinessException {
        String billtype = tmd.getBillType();
        String cuserid = tmd.getCuserid();
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        BilltypeVO btvo = PfDataCache.getBillTypeInfo(billtype);
        String funnode = btvo.getNodecode();
        TemplateParaVO para = new TemplateParaVO();
        para.setFunNode(funnode);
        para.setOperator(cuserid);
        para.setPk_Corp(pk_group);
        para.setTemplateType(5);
        IPFTemplate srv = (IPFTemplate)NCLocator.getInstance().lookup(IPFTemplate.class);
        String templateid = srv.getTemplateId(para);
        return templateid;
    }

    public static BillTempletVO queryTemplate(String pk_template) throws BusinessException {
        IBillTemplateQry qry = (IBillTemplateQry)NCLocator.getInstance().lookup(IBillTemplateQry.class.getName());
        BillTempletVO vo = qry.findTempletData(pk_template);
        return vo;
    }

    public static AggregatedValueObject queryBillEntity(final String billtype, final String billid) throws BusinessException {
        CondStringKey key = new CondStringKey("mobileapp_query_billentity", billtype, billid);
        ICacheDataQueryCallback<AggregatedValueObject> callback = new ICacheDataQueryCallback<AggregatedValueObject>(){

            public AggregatedValueObject queryData() throws BusinessException {
                AggregatedValueObject busiObj = ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).queryBillDataVO(billtype, billid);
                return busiObj;
            }
        };
        AggregatedValueObject aggvo = (AggregatedValueObject)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
        if (aggvo == null) {
            NCCFlowInstanceVO[] resultInstance = ((IFlowInstanceQuery)NCLocator.getInstance().lookup(IFlowInstanceQuery.class)).findFlowInstancesByBillversionpkAndBillTypeAppendOrderByCondition(billid, billtype);
            if (resultInstance == null || resultInstance.length == 0) {
                return null;
            }
            AggregatedValueObject aggvoNew = ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).queryBillDataVO(billtype, resultInstance[0].getBillid());
            PFRequestDataCacheProxy.put((IRequestDataCacheKey)key, (Object)aggvoNew);
            return aggvoNew;
        }
        return aggvo;
    }

    public static boolean canAddApprover(WorkflownoteVO note) {
        Object value = note.getRelaProperties().get("CanAddApprover");
        if (value != null && "true".equalsIgnoreCase(value.toString())) {
            return !note.actiontype.endsWith("_A");
        }
        return false;
    }

    public static boolean canReject(PFClientBizRetVO bizret, WorkflownoteVO note) {
        if (bizret != null && !bizret.isShowReject()) {
            return false;
        }
        return !note.getActiontype().endsWith("_A") && MobileAppUtil.canDisReject(bizret, note);
    }

    public static boolean canAgree(PFClientBizRetVO bizret, WorkflownoteVO note) {
        return bizret == null || bizret.isShowPass();
    }

    public static boolean canDisAgree(PFClientBizRetVO bizret, WorkflownoteVO note) {
        if (bizret != null && !bizret.isShowNoPass()) {
            return false;
        }
        try {
            String pk_wf_def = MobileAppUtil.getPk_wf_def(note);
            BasicWorkflowProcess process = WorkflowProcessCache.getInstance().getWorkflowProcess(pk_wf_def);
            if (process != null) {
                return !process.isHideNoPassing();
            }
            return false;
        }
        catch (BusinessException e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean canDisReject(PFClientBizRetVO bizret, WorkflownoteVO note) {
        if (bizret != null && !bizret.isShowNoPass()) {
            return false;
        }
        try {
            String pk_wf_def = MobileAppUtil.getPk_wf_def(note);
            BasicWorkflowProcess process = WorkflowProcessCache.getInstance().getWorkflowProcess(pk_wf_def);
            if (process != null) {
                return !process.isHideReject();
            }
            return false;
        }
        catch (BusinessException e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getPk_wf_def(WorkflownoteVO note) throws BusinessException {
        if (note.getTaskInfo() != null && note.getTaskInfo().getTask() != null) {
            return note.getTaskInfo().getTask().getWfProcessDefPK();
        }
        String cond = "pk_wf_task=?";
        SQLParameter param = new SQLParameter();
        param.addParam(note.getPk_wf_task());
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        Collection taskCol = qry.retrieveByClause(WFTask.class, (IMappingMeta)WFTask.mappingMeta, cond, new String[]{"pk_wf_task", "processdefid"}, param);
        if (ArrayUtil.isNull((Collection)taskCol)) {
            return null;
        }
        return ((WFTask)taskCol.iterator().next()).getWfProcessDefPK();
    }

    public static boolean canReassign(WorkflownoteVO note) {
        Object value = note.getRelaProperties().get("CanTransfer");
        if (value != null && "true".equalsIgnoreCase(value.toString())) {
            return !note.actiontype.endsWith("_A");
        }
        return false;
    }

    public static boolean canAssignWhenNoPass(WorkflownoteVO note) {
        if (note.getActiontype().endsWith("_A")) {
            return false;
        }
        Vector assignInfos = note.getTaskInfo().getAssignableInfos();
        if (assignInfos != null && assignInfos.size() > 0) {
            String strCriterion = null;
            for (AssignableInfo ai : assignInfos) {
                strCriterion = ai.getCheckResultCriterion();
                if (!AssignableInfo.CRITERION_NOTGIVEN.equals(strCriterion) && !AssignableInfo.CRITERION_NOPASS.equals(strCriterion)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canAssignWhenPassing(WorkflownoteVO note) {
        if (note.getActiontype().endsWith("_A")) {
            return false;
        }
        Vector assignInfos = note.getTaskInfo().getAssignableInfos();
        if (assignInfos != null && assignInfos.size() > 0) {
            String strCriterion = null;
            for (AssignableInfo ai : assignInfos) {
                strCriterion = ai.getCheckResultCriterion();
                if (!AssignableInfo.CRITERION_NOTGIVEN.equals(strCriterion) && !AssignableInfo.CRITERION_PASS.equals(strCriterion)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> List<T> subList(List<T> list, int startIndex, int count) {
        ArrayList<T> resultList = new ArrayList<T>();
        int size = list.size();
        int endIndex = startIndex + count;
        if (startIndex >= size) {
            return resultList;
        }
        if (endIndex > size) {
            endIndex = size;
        }
        List<T> subList = list.subList(startIndex, endIndex);
        resultList.addAll(subList);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStack(Throwable e) {
        CharArrayWriter cw = null;
        try (PrintWriter pw = null;){
            String msg;
            cw = new CharArrayWriter();
            pw = new PrintWriter(cw);
            e.printStackTrace(pw);
            String string = msg = cw.toString();
            return string;
        }
    }

    public static String getMaPushServlet() {
        String servlet = MappConfAccessor.getInstance().getProperty("mapurl");
        String url = "/" + servlet;
        return url;
    }

    public static String getMaHost() {
        return MappConfAccessor.getInstance().getMappHost();
    }

    public static int getMaPort() {
        try {
            return Integer.parseInt(MappConfAccessor.getInstance().getMappPort());
        }
        catch (Throwable e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return 8090;
        }
    }

    public static String getMaPushServiceCode() {
        return MappConfAccessor.getInstance().getProperty("mapmessageserviceid");
    }

    public static String getMaPushServiceCode(String key) {
        if (key != null && !key.trim().isEmpty()) {
            return MappConfAccessor.getInstance().getProperty(key);
        }
        return MobileAppUtil.getMaPushServiceCode();
    }

    public static String getMaPushToken() {
        return MappConfAccessor.getInstance().getProperty("maservertoken");
    }

    public static String getPsnJobInfo(String pk_psndoc) throws BusinessException {
        IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        String cond = "pk_psndoc=?  and enddutydate is null and ismainjob ='Y'";
        SQLParameter param = new SQLParameter();
        param.addParam(pk_psndoc);
        String[] fields = new String[]{"pk_job", "pk_dept"};
        Collection col = qry.retrieveByClause(PsnjobVO.class, cond, fields, param);
        StringBuffer sb = new StringBuffer();
        if (col != null && col.size() > 0) {
            PsnjobVO pjv = (PsnjobVO)col.iterator().next();
            if (!StringUtil.isEmptyWithTrim((String)pjv.getPk_dept())) {
                cond = "pk_dept=?";
                param = new SQLParameter();
                param.addParam(pjv.getPk_dept());
                fields = new String[]{"name", "name" + MultiLangUtil.getCurrentLangSeqSuffix()};
                Collection deptCol = qry.retrieveByClause(DeptVO.class, cond, fields, param);
                if (deptCol != null && deptCol.size() > 0) {
                    DeptVO dvo = (DeptVO)deptCol.iterator().next();
                    String deptName = PfMultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)dvo, "name");
                    sb.append(deptName);
                }
            }
            if (!StringUtil.isEmptyWithTrim((String)pjv.getPk_job())) {
                cond = "pk_job=?";
                param = new SQLParameter();
                param.addParam(pjv.getPk_job());
                fields = new String[]{"jobname", "jobname" + MultiLangUtil.getCurrentLangSeqSuffix()};
                Collection jobCol = qry.retrieveByClause(JobVO.class, cond, fields, param);
                if (jobCol != null && jobCol.size() > 0) {
                    JobVO jvo = (JobVO)jobCol.iterator().next();
                    String jobName = PfMultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)jvo, "jobname");
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(jobName);
                }
            }
        }
        return sb.toString();
    }

    public static void setRowCount(Integer cnt) {
        BillVORowCountKey key = new BillVORowCountKey();
        PFRequestDataCacheProxy.put((IRequestDataCacheKey)key, (Object)cnt);
    }

    public static Integer getRowCount() {
        Object rowCount = PFRequestDataCacheProxy.get((IRequestDataCacheKey)new BillVORowCountKey());
        if (rowCount != null && rowCount instanceof Integer) {
            return (Integer)rowCount;
        }
        return 0;
    }

    public static void handleException(Exception e) throws BusinessException {
        if (e instanceof BusinessException) {
            throw (BusinessException)((Object)e);
        }
        throw new BusinessException(e.getMessage(), (Throwable)e);
    }

    public static List<Map<String, String>> getWorkNumByUserIds(String groupid, List<String> usridsList, String type) throws BusinessException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> countMap = MobileAppUtil.getWorkNumByUseridList(groupid, usridsList, type);
        for (Map.Entry<String, String> entry : countMap.entrySet()) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("usrid", entry.getKey());
            tempMap.put("badge", entry.getValue());
            list.add(tempMap);
        }
        return list;
    }

    public static Map<String, String> getWorkNumByUseridList(String groupid, List<String> usridList, String type) throws BusinessException {
        String sql = "select count(pk_checkflow) from pub_workflownote where actiontype like 'Z%' and pk_group = '" + groupid + "' and approvestatus = " + WfTaskOrInstanceStatus.Started.getIntValue() + " and checkman = ?";
        try {
            sql = MobileTaskFilterHandler.getFinalSqlWithWfWork(sql);
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            MobileAppUtil.handleException((Exception)((Object)e));
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (usridList != null && usridList.size() > 0 && groupid != null) {
            IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
            for (String checkman : usridList) {
                SQLParameter param = new SQLParameter();
                param.addParam(checkman);
                String badge = qry.executeQuery(sql, param, (ResultSetProcessor)new ColumnProcessor()).toString();
                resultMap.put(checkman, badge);
            }
        } else {
            String err = NCLangResOnserver.getInstance().getStrByID("mobileapp", "TaskNotValidException-000001");
            MobileAppUtil.handleException((Exception)((Object)new BusinessException(err)));
        }
        return resultMap;
    }

    public static List<Map<String, Object>> getHtmlOfPrintTemplete(String billID, String billType, String printTempletid) throws BusinessException {
        ArrayList<Map<String, Object>> htmlList = new ArrayList<Map<String, Object>>();
        byte[] billHtml = null;
        if (StringUtil.isEmptyWithTrim((String)printTempletid)) {
            return null;
        }
        IDataSource ds = ((IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class)).getDataSourceForMobile(billType, billID);
        if (ds == null) {
            return null;
        }
        try {
            IPrintEntry printEntry = (IPrintEntry)NCLocator.getInstance().lookup(IPrintEntry.class.getName());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IDataSource[] dataSources = new IDataSource[]{ds};
            printEntry.exportHtml(dataSources, printTempletid, (Writer)new OutputStreamWriter((OutputStream)bos, "UTF-8"));
            billHtml = bos.toByteArray();
            HashMap<String, Object> map = MobileAppUtil.createHashMap();
            map.put("htmlname", billType);
            map.put("htmlfile", billHtml);
            htmlList.add(map);
            Logger.debug((Object)"\u79fb\u52a8\u5355\u636e\u5168\u8c8cHTML\u5bfc\u51fa\u6210\u529f");
        }
        catch (Throwable e) {
            Logger.error((Object)(">>\u540e\u53f0\u6253\u5370\u6a21\u677f\u8f93\u51faHTML\u51fa\u9519=" + e.getMessage()), (Throwable)e);
            MobileAppUtil.handleException((Exception)((Object)new BusinessException(e.getMessage())));
        }
        return htmlList;
    }

    public static String queryPrintTemplateId(TaskMetaData tmd) throws BusinessException {
        String billtype = tmd.getBillType();
        String cuserid = tmd.getCuserid();
        String templateid = null;
        IDefaultQueryRelatedAppInfoService service = (IDefaultQueryRelatedAppInfoService)NCLocator.getInstance().lookup(IDefaultQueryRelatedAppInfoService.class);
        Map<String, Object> map = service.getMobileAppInfoMap_NoSameOrigin(tmd.getBillType(), tmd);
        if (map != null && !map.isEmpty() && ((Boolean)map.get("islightbill")).booleanValue()) {
            String appcode;
            if (map.get("appcode") == null) {
                return null;
            }
            String userappcode = appcode = (String)map.get("appcode");
            Object curWorkflowApp = map.get("curWorkflowApp");
            if (curWorkflowApp != null) {
                userappcode = (String)curWorkflowApp;
            }
            IPrintService2 printservice = (IPrintService2)NCLocator.getInstance().lookup(IPrintService2.class);
            PrintInfo newinfo = new PrintInfo();
            newinfo.setAppcode(userappcode);
            newinfo.setNodeKey("useMobileForBill");
            PrintTempletmanageHeaderVO[] vos = printservice.getAllPrintTemplateVOs((IPrintInfo)newinfo);
            if (vos != null && vos.length > 0) {
                templateid = vos[0].getCtemplateid();
            }
        } else {
            String pk_group = InvocationInfoProxy.getInstance().getGroupId();
            BilltypeVO btvo = PfDataCache.getBillTypeInfo(billtype);
            String funnode = btvo.getNodecode();
            TemplateParaVO para = new TemplateParaVO();
            para.setFunNode(funnode);
            para.setOperator(cuserid);
            para.setPk_Corp(pk_group);
            para.setTemplateType(3);
            para.setNodeKey("useMobileForBill");
            IPFTemplate srv = (IPFTemplate)NCLocator.getInstance().lookup(IPFTemplate.class);
            templateid = srv.getTemplateId(para);
        }
        return templateid;
    }

    public static Map<String, Object> toPNGImagesWithSubFlow(String billId, String billType, int iWorkflowtype, String pk_busiworkflow) throws BusinessException {
        IWorkflowDefine workflowDefine = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
        try {
            return workflowDefine.toPNGImagesWithMobile(billId, billType, iWorkflowtype, pk_busiworkflow);
        }
        catch (BusinessException e) {
            Logger.error((Object)(">>\u79fb\u52a8\u7aef\u67e5\u8be2\u6d41\u7a0b\u56fe\u51fa\u9519=" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static PageTempletVO queryNCCTemplate(TaskMetaData tmd, AppPageVO page, String appcode) throws BusinessException {
        String cuserid = tmd.getCuserid();
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        IAppTemplateAssignment srv = (IAppTemplateAssignment)NCLocator.getInstance().lookup(IAppTemplateAssignment.class);
        PageTempletVO template = null;
        try {
            template = srv.getPriorTemplate(cuserid, pk_group, appcode, page.getPagecode());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        return template;
    }
}

