/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.change;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.BillTypeCacheKey;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.itf.uap.pf.metadata.IFlowBizItf;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.md.common.AssociationKind;
import nc.md.model.IBean;
import nc.md.model.IBusinessEntity;
import nc.md.model.access.javamap.AggVOStyle;
import nc.md.model.access.javamap.IBeanStyle;
import nc.md.persist.designer.vo.ClassVO;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.UserDefineFunction;
import nc.vo.pf.pub.BasedocTempVO;
import nc.vo.pf.pub.BasedocVO;
import nc.vo.pf.pub.FunctionVO;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.change.PublicHeadVO;
import nc.vo.pub.compiler.PfParameterVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.lang.UFDouble;
import nc.vo.pub.pfflow.BillActionTypeEnum;
import nc.vo.pub.pfflow.BillactionVO;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.uap.pf.PFBusinessException;
import nc.vo.uap.pf.PFRuntimeException;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nccloud.commons.lang.StringUtils;
import nccloud.putitf.riart.billtype.IBilltypeService;

public class PfUtilBaseTools {
    public static final String BATCH_LOCK_ERROR = "BATCH_LOCK_ERROR";
    public static final String PARAM_FLOWPK = "flowdefpk";
    public static final String PARAM_NO_LOCK = "nolockandconsist";
    public static final String PARAM_NOFLOW = "nosendmessage";
    public static final String PARAM_SILENTLY = "silently";
    public static final String PARAM_NOTE_CHECKED = "notechecked";
    public static final String PARAM_RELOAD_VO = "reload_vo";
    public static final String IS_BATCH_ACTION = "isBatchAction";
    public static final String PARAM_BATCH = "batch";
    public static final String PARAM_WORKNOTE = "worknote";
    public static final String PARAM_NOTSILENT = "notsilent";
    public static final String PARAM_DRIVEACTION = "driveaction";
    public static final String PARAM_PREAPPROVEDATE = "preapprovedate";
    public static final String PARAM_FORCESTART = "forcestart";
    public static final String PARAM_BESIDEAPPROVE = "besideapprove";
    public static final String PARAM_ALTER_FORCEPASS = "alter_force_pass";
    public static final String PARAM_WORKFLOWTYPE = "workflow";
    public static final String PARAM_WORKFLOW = "workflow";
    public static final String PARAM_APPROVEFLOW = "approveflow";
    public static final String PARAM_FLOW_CONTENT = "content";
    public static final String ConfirmOrCancle = "confirmOrCancleAction";
    public static final String WORKFLOWTYPE = "workflowtype";

    public static UserDefineFunction[] changeFunctionVOs(ArrayList<FunctionVO> alFuncs) {
        Vector<UserDefineFunction> vec = new Vector<UserDefineFunction>();
        try {
            for (FunctionVO fVO : alFuncs) {
                if (!fVO.getFunctionnote().startsWith("<") || fVO.getArguments() != null && fVO.getArguments().indexOf(".") > -1) continue;
                UserDefineFunction temp = new UserDefineFunction();
                temp.setClassName(fVO.getClassname());
                temp.setMethodName(fVO.getMethodname());
                temp.setFunctionNote(fVO.getFunctionnote());
                temp.setReturnType(PfUtilBaseTools.parseTypeClass(fVO.getReturntype()));
                String[] par = PfUtilBaseTools.getParameters(fVO);
                if (par != null) {
                    Class[] classes = new Class[par.length];
                    String[] argNames = new String[par.length];
                    for (int j = 0; j < par.length; ++j) {
                        classes[j] = PfUtilBaseTools.parseTypeClass(par[j].substring(par[j].indexOf(":") + 1));
                        argNames[j] = par[j].substring(0, par[j].indexOf(":"));
                    }
                    temp.setArgNames(argNames);
                    temp.setArgTypes(classes);
                }
                vec.addElement(temp);
            }
        }
        catch (Throwable e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        UserDefineFunction[] functions = new UserDefineFunction[vec.size()];
        vec.copyInto((Object[])functions);
        return functions;
    }

    public static AggregatedValueObject[] createArrayWithBilltype(String destBillOrTranstype, int size) throws BusinessException {
        AggregatedValueObject[] retDestVOs;
        String destBillVoClzName = null;
        IBusinessEntity destBE = PfMetadataTools.queryMetaOfBilltype(destBillOrTranstype);
        IBeanStyle bs = destBE.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000009"));
        }
        destBillVoClzName = ((AggVOStyle)bs).getAggVOClassName();
        try {
            retDestVOs = (AggregatedValueObject[])Array.newInstance(Class.forName(destBillVoClzName), size);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000034", null, new String[]{e.getMessage()}));
        }
        return retDestVOs;
    }

    public static void fetchBillId(PfParameterVO paravo, Object singleBillEntity, Object retObj) {
        paravo.m_billVersionPK = PfUtilBaseTools.getBillID(retObj);
        PublicHeadVO standHeadVo = new PublicHeadVO();
        PfUtilBaseTools.getHeadInfoByMeta(standHeadVo, singleBillEntity, paravo.m_billType);
        paravo.m_billNo = standHeadVo.billNo;
        if (paravo.m_billId == null) {
            paravo.m_billId = standHeadVo.pkBillId;
        }
        if (paravo.m_billVersionPK == null) {
            paravo.m_billVersionPK = standHeadVo.pkBillVersion;
        }
    }

    public static Object[] composeResultAry(Object tmpRet, int length, int i, Object[] ret) {
        if (ret == null && tmpRet != null) {
            ret = tmpRet.getClass().getName().startsWith("[") && ((Object[])tmpRet).length > 0 ? (Object[])Array.newInstance(((Object[])tmpRet)[0].getClass(), length) : (Object[])Array.newInstance(tmpRet.getClass(), length);
        }
        if (ret != null) {
            ret[i] = tmpRet != null && tmpRet.getClass().getName().startsWith("[") && ((Object[])tmpRet).length > 0 ? (tmpRet.getClass().getName().startsWith("[") ? ((Object[])tmpRet)[0] : tmpRet) : (tmpRet != null ? tmpRet : null);
        }
        return ret;
    }

    public static HashMap<String, String> fetchValuesByPKs(String tableName, String pkFieldName, String columnName, HashSet<String> hsPK) {
        String sql = "select " + pkFieldName + "," + columnName + " from " + tableName;
        StringBuffer where = new StringBuffer();
        where.append(" where ");
        where.append(pkFieldName);
        where.append(" in(");
        for (String strPK : hsPK) {
            where.append("'");
            where.append(strPK);
            where.append("',");
        }
        sql = sql + where.substring(0, where.length() - 1) + ") order by " + pkFieldName;
        List lResult = new ArrayList(0);
        HashMap<String, String> hmRet = new HashMap<String, String>();
        try {
            IUAPQueryBS uapqry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class.getName());
            lResult = (List)uapqry.executeQuery(sql, (ResultSetProcessor)new ArrayListProcessor());
            for (Object[] objs : lResult) {
                hmRet.put(objs[0].toString(), objs[1] == null ? null : objs[1].toString());
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return hmRet;
    }

    private static String findParentBilltypeByStyle(BilltypeVO btVO) {
        if (btVO.getBillstyle() == null) {
            return null;
        }
        String parentBilltype = PfDataCache.getBillTypeByStyle(btVO.getBillstyle().toString());
        if (parentBilltype == null || parentBilltype.equals(btVO.getPk_billtypecode())) {
            return null;
        }
        return parentBilltype;
    }

    public static String findPkField(String billType) throws BusinessException {
        IBusinessEntity bean = PfMetadataTools.queryMetaOfBilltype(billType);
        return bean.getTable().getPrimaryKeyName();
    }

    public static BasedocVO[] getAllBasedocVO() {
        ClassVO[] classVOs = null;
        try {
            classVOs = PfUtilBaseTools.queryAllRefInfoVOs();
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (classVOs == null) {
            return null;
        }
        BasedocVO[] vos = new BasedocTempVO[classVOs.length + 1];
        ArrayList<BasedocVO> list = new ArrayList<BasedocVO>();
        for (int i = 0; i < vos.length - 1; ++i) {
            vos[i] = new BasedocTempVO();
            ((BasedocTempVO)vos[i]).setDocName(classVOs[i].getDisplayName());
            ((BasedocTempVO)vos[i]).setDocPK(classVOs[i].getPrimaryKey());
            ((BasedocTempVO)vos[i]).setDocCode(classVOs[i].getName());
            String refModelName = classVOs[i].getRefModelName();
            if (refModelName != null && refModelName.contains(";")) {
                ((BasedocTempVO)vos[i]).setRefNodeName(refModelName.split(";")[0]);
                if (classVOs[i].getId().equals("4caac608-2989-4a9c-bba7-6e6eeed5b156") && classVOs[i].getFullClassName().equals("nc.vo.ssctp.sscbd.SSCNodeVO")) {
                    vos[classVOs.length] = new BasedocTempVO();
                    ((BasedocTempVO)vos[classVOs.length]).setDocName(refModelName.split(";")[1]);
                    ((BasedocTempVO)vos[classVOs.length]).setDocPK(classVOs[i].getPrimaryKey());
                    ((BasedocTempVO)vos[classVOs.length]).setDocCode(classVOs[i].getName());
                    ((BasedocTempVO)vos[classVOs.length]).setRefNodeName(refModelName.split(";")[1]);
                    list.add(vos[classVOs.length]);
                }
            } else {
                ((BasedocTempVO)vos[i]).setRefNodeName(refModelName);
            }
            list.add(vos[i]);
        }
        return vos;
    }

    private static ClassVO[] queryAllRefInfoVOs() throws BusinessException {
        return ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveByClause(ClassVO.class, "help like '%DOC%' and classtype=201 and refmodelname is not null").toArray(new ClassVO[0]);
    }

    private static String getBillID(Object tmpObj) {
        Logger.debug((Object)NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000037"));
        String billId = null;
        if (tmpObj == null) {
            return billId;
        }
        if (tmpObj instanceof ArrayList) {
            ArrayList alRetObj = (ArrayList)tmpObj;
            Object[] retObjAry = alRetObj.toArray();
            if (retObjAry.length > 1 && retObjAry[1] instanceof ArrayList) {
                billId = ((ArrayList)retObjAry[1]).toArray()[0].toString();
                Logger.debug((Object)"\u83b7\u5f97\u5355\u636eId:Array\u7684\u7b2c\u4e00\u7ef4\u7684\u6570\u7ec4\u7684\u7b2c0\u7ef4\u4e3a\u5355\u636eID");
            } else if (retObjAry[0] != null && !retObjAry[0].equals("")) {
                billId = retObjAry[0].toString();
                Logger.debug((Object)"\u83b7\u5f97\u5355\u636eId:Array\u7684\u7b2c0\u7ef4\u4e3a\u5355\u636eID");
            }
        } else if (tmpObj instanceof String) {
            billId = (String)tmpObj;
            Logger.debug((Object)"\u76f4\u63a5\u4ece\u5bf9\u8c61String\u53d6\u7684ID");
        }
        Logger.debug((Object)("****\u4ece\u52a8\u4f5c\u811a\u672c\u6267\u884c\u540e\u7684\u8fd4\u56de\u503c\u4e2d\u83b7\u5f97\u5355\u636eId=" + billId + "\u7ed3\u675f****"));
        return billId;
    }

    public static int getHeadInfoByMeta(PublicHeadVO headvo, Object singleBillEntity, String billType) {
        headvo.billType = billType;
        if (singleBillEntity == null) {
            throw new PFRuntimeException("\u5355\u636e\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u5355\u636e\u88ab\u5220\u9664\u6216\u7248\u672c\u5df2\u53d8\u66f4\uff01");
        }
        IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(singleBillEntity, IFlowBizItf.class);
        if (fbi == null) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000038"));
        }
        headvo.approveId = fbi.getApprover();
        headvo.billNo = fbi.getBillNo();
        headvo.businessType = fbi.getBusitype();
        headvo.pkOrg = fbi.getPkorg();
        headvo.operatorId = fbi.getBillMaker();
        headvo.pkBillId = fbi.getBillId();
        headvo.transType = fbi.getTranstype();
        headvo.pkBillVersion = fbi.getBillVersionPK();
        return fbi.getEmendEnum();
    }

    public static String[] getParameters(FunctionVO fVO) {
        if (fVO == null || fVO.getArguments() == null) {
            return null;
        }
        String str = fVO.getArguments();
        if (str.length() == 0 || str.indexOf(".") > -1) {
            return null;
        }
        Vector<String> vec = new Vector<String>();
        while (str.indexOf(",") >= 0) {
            vec.addElement(str.substring(0, str.indexOf(",")));
            str = str.substring(str.indexOf(",") + 1);
        }
        vec.addElement(str);
        Object[] res = new String[vec.size()];
        vec.copyInto(res);
        return res;
    }

    public static String getRealBilltype(String strTypeCodestr) {
        BillTypeCacheKey strTypeCode = new BillTypeCacheKey().buildBilltype(strTypeCodestr).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId());
        String billtype = strTypeCode.getBilltype().trim();
        strTypeCode.buildBilltype(billtype);
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(strTypeCode);
        if (btVO == null) {
            try {
                IBilltypeService ser = (IBilltypeService)NCLocator.getInstance().lookup(IBilltypeService.class);
                btVO = ser.getBilltype(strTypeCodestr, InvocationInfoProxy.getInstance().getGroupId());
            }
            catch (Exception e) {
                throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PfUtilBaseTools-000000", null, new String[]{billtype}));
            }
            if (btVO == null) {
                throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PfUtilBaseTools-000000", null, new String[]{billtype}));
            }
            if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
                Logger.debug((Object)("\u83b7\u5f97\u5355\u636e\u7c7b\u578b\u6216\u4ea4\u6613\u7c7b\u578b=" + strTypeCode + "\u7684\u771f\u5b9e\u5355\u636e\u7c7b\u578b=" + billtype));
                billtype = btVO.getParentbilltype();
            }
        } else if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            Logger.debug((Object)("\u83b7\u5f97\u5355\u636e\u7c7b\u578b\u6216\u4ea4\u6613\u7c7b\u578b=" + strTypeCode + "\u7684\u771f\u5b9e\u5355\u636e\u7c7b\u578b=" + billtype));
            billtype = btVO.getParentbilltype();
        }
        return billtype;
    }

    public static String getRealBilltypeByGroup(String pk_group, String strTypeCodestr) {
        if (StringUtils.isBlank((CharSequence)pk_group)) {
            pk_group = InvocationInfoProxy.getInstance().getGroupId();
        }
        BillTypeCacheKey strTypeCode = new BillTypeCacheKey().buildBilltype(strTypeCodestr).buildPkGroup(pk_group);
        String billtype = strTypeCode.getBilltype().trim();
        strTypeCode.buildBilltype(billtype);
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(strTypeCode);
        if (btVO == null) {
            try {
                IBilltypeService ser = (IBilltypeService)NCLocator.getInstance().lookup(IBilltypeService.class);
                btVO = ser.getBilltype(strTypeCodestr, pk_group);
            }
            catch (Exception e) {
                throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PfUtilBaseTools-000000", null, new String[]{billtype}));
            }
            if (btVO == null) {
                throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PfUtilBaseTools-000000", null, new String[]{billtype}));
            }
            if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
                Logger.debug((Object)("\u83b7\u5f97\u5355\u636e\u7c7b\u578b\u6216\u4ea4\u6613\u7c7b\u578b=" + strTypeCode + "\u7684\u771f\u5b9e\u5355\u636e\u7c7b\u578b=" + billtype));
                billtype = btVO.getParentbilltype();
            }
        } else if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            Logger.debug((Object)("\u83b7\u5f97\u5355\u636e\u7c7b\u578b\u6216\u4ea4\u6613\u7c7b\u578b=" + strTypeCode + "\u7684\u771f\u5b9e\u5355\u636e\u7c7b\u578b=" + billtype));
            billtype = btVO.getParentbilltype();
        }
        return billtype;
    }

    public static String getRealBilltypeByPK(String strPK) {
        Collection<BilltypeVO> collbilltypes = PfDataCache.getBilltypes().values();
        for (BilltypeVO vo : collbilltypes) {
            if (vo == null || !vo.getPrimaryKey().equals(strPK)) continue;
            if (vo.getIstransaction() != null && vo.getIstransaction().booleanValue()) {
                return vo.getParentbilltype();
            }
            return vo.getPk_billtypecode();
        }
        throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PfUtilBaseTools-000000", null, new String[]{strPK}));
    }

    public static String getBillTypeNameByCode(String billType) {
        BilltypeVO btVO = PfDataCache.getBillType(billType);
        return btVO.getBilltypenameOfCurrLang();
    }

    public static String getBillTypeCodeByPK(String strPK) {
        Collection<BilltypeVO> collbilltypes = PfDataCache.getBilltypes().values();
        for (BilltypeVO vo : collbilltypes) {
            if (vo == null || !vo.getPrimaryKey().equals(strPK)) continue;
            return vo.getPk_billtypecode();
        }
        throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PfUtilBaseTools-000000", null, new String[]{strPK}));
    }

    public static String[] getStrBillVo(String pkBillType) throws BusinessException {
        String[] retStrs = new String[3];
        IBusinessEntity be = PfMetadataTools.queryMetaOfBilltype(pkBillType);
        IBeanStyle bs = be.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000009"));
        }
        retStrs[0] = ((AggVOStyle)bs).getAggVOClassName();
        retStrs[1] = be.getFullClassName();
        List lRelatedBeans = be.getRelatedEntities(AssociationKind.Composite, 2);
        IBean relatedBean = lRelatedBeans.size() > 0 ? (IBean)lRelatedBeans.iterator().next() : null;
        retStrs[2] = relatedBean == null ? null : relatedBean.getFullClassName();
        return retStrs;
    }

    public static PfParameterVO getVariableValue(String billType, String actionName, AggregatedValueObject billvo, AggregatedValueObject[] billvos, Object userObj, Object[] userObjs, WorkflownoteVO worknoteVO, HashMap hmParam, Hashtable hashBilltypeToParavo) throws BusinessException {
        Logger.debug((Object)(">>>getVariableValue(" + actionName + "," + billType + ") START<<<"));
        PfParameterVO paraVo = new PfParameterVO();
        paraVo.m_billType = billType;
        PublicHeadVO standHeadVo = new PublicHeadVO();
        AggregatedValueObject singleVO = null;
        if (billvo != null) {
            singleVO = billvo;
        } else if (billvos != null && billvos.length > 0) {
            singleVO = billvos[0];
        }
        int isEmend = PfUtilBaseTools.getHeadInfoByMeta(standHeadVo, singleVO, billType);
        paraVo.m_businessType = StringUtil.isEmptyWithTrim((String)standHeadVo.businessType) ? "KHHH0000000000000001" : standHeadVo.businessType;
        paraVo.m_billEntity = billvo;
        paraVo.m_billNo = standHeadVo.billNo;
        paraVo.m_billVersionPK = standHeadVo.pkBillVersion;
        paraVo.m_billId = standHeadVo.pkBillId;
        paraVo.m_pkOrg = standHeadVo.pkOrg;
        paraVo.m_makeBillOperator = standHeadVo.operatorId;
        paraVo.m_preValueVo = singleVO;
        paraVo.m_preValueVos = billvos;
        paraVo.m_standHeadVo = standHeadVo;
        paraVo.m_userObj = userObj;
        paraVo.m_userObjs = userObjs;
        paraVo.m_workFlow = worknoteVO;
        paraVo.m_pkGroup = InvocationInfoProxy.getInstance().getGroupId();
        paraVo.emendEnum = isEmend;
        if (hmParam != null && null != hmParam.get("auto") && !hmParam.containsKey("pk_checkflows")) {
            paraVo.m_autoApproveAfterCommit = true;
        }
        if (hmParam == null) {
            hmParam = new HashMap();
        }
        if (hmParam.containsKey("pk_checkflows")) {
            paraVo.eparams = hmParam;
        }
        if (actionName != null && actionName.length() > 20) {
            paraVo.m_actionName = actionName.substring(0, actionName.length() - 20);
            paraVo.m_operator = actionName.substring(actionName.length() - 20);
        } else {
            paraVo.m_actionName = actionName;
            paraVo.m_operator = InvocationInfoProxy.getInstance().getUserId();
        }
        if (!StringUtil.isEmptyWithTrim((String)standHeadVo.transType)) {
            paraVo.m_billType = standHeadVo.transType;
        }
        paraVo.putCustomPropertyBatch(hmParam);
        Logger.debug((Object)(">>>billType=" + paraVo.m_billType + " busiType=" + paraVo.m_businessType));
        Logger.debug((Object)(">>>billMaker=" + paraVo.m_makeBillOperator + " operator=" + paraVo.m_operator));
        Logger.debug((Object)(">>>corpPK=" + paraVo.m_pkOrg + " billId=" + paraVo.m_billVersionPK));
        Logger.debug((Object)(">>>actionName=" + paraVo.m_actionName + " billNo=" + paraVo.m_billNo));
        if (hashBilltypeToParavo != null) {
            String src_billtypePK = StringUtil.isEmptyWithTrim((String)paraVo.m_preValueVo.getParentVO().getPrimaryKey()) ? "" : paraVo.m_preValueVo.getParentVO().getPrimaryKey();
            hashBilltypeToParavo.put(paraVo.m_billType + src_billtypePK, paraVo);
        }
        Logger.debug((Object)(">>>getVariableValue(" + actionName + "," + billType + ") END<<<"));
        return paraVo;
    }

    public static PfParameterVO getVariableValue(String billType, String actionName, AggregatedValueObject billvo, AggregatedValueObject[] billvos, Object userObj, Object[] userObjs, WorkflownoteVO worknoteVO, HashMap hmParam, Hashtable hashBilltypeToParavo, String src_billtyePK) {
        Logger.debug((Object)(">>>getVariableValue(" + actionName + "," + billType + ") START<<<"));
        PfParameterVO paraVo = new PfParameterVO();
        paraVo.m_billType = billType;
        PublicHeadVO standHeadVo = new PublicHeadVO();
        AggregatedValueObject singleVO = null;
        if (billvo != null) {
            singleVO = billvo;
        } else if (billvos != null && billvos.length > 0) {
            singleVO = billvos[0];
        }
        int isEmend = PfUtilBaseTools.getHeadInfoByMeta(standHeadVo, singleVO, billType);
        paraVo.m_businessType = StringUtil.isEmptyWithTrim((String)standHeadVo.businessType) ? "KHHH0000000000000001" : standHeadVo.businessType;
        paraVo.m_billNo = standHeadVo.billNo;
        paraVo.m_billVersionPK = standHeadVo.pkBillVersion;
        paraVo.m_billId = standHeadVo.pkBillId;
        paraVo.m_pkOrg = standHeadVo.pkOrg;
        paraVo.m_makeBillOperator = standHeadVo.operatorId;
        paraVo.m_preValueVo = singleVO;
        paraVo.m_preValueVos = billvos;
        paraVo.m_standHeadVo = standHeadVo;
        paraVo.m_userObj = userObj;
        paraVo.m_userObjs = userObjs;
        paraVo.m_workFlow = worknoteVO;
        paraVo.m_pkGroup = InvocationInfoProxy.getInstance().getGroupId();
        paraVo.emendEnum = isEmend;
        if (hmParam == null) {
            hmParam = new HashMap();
        }
        if (actionName != null && actionName.length() > 20) {
            paraVo.m_actionName = actionName.substring(0, actionName.length() - 20);
            paraVo.m_operator = actionName.substring(actionName.length() - 20);
        } else {
            paraVo.m_actionName = actionName;
            paraVo.m_operator = InvocationInfoProxy.getInstance().getUserId();
        }
        if (!StringUtil.isEmptyWithTrim((String)standHeadVo.transType)) {
            paraVo.m_billType = standHeadVo.transType;
        }
        paraVo.putCustomPropertyBatch(hmParam);
        Logger.debug((Object)(">>>billType=" + paraVo.m_billType + " busiType=" + paraVo.m_businessType));
        Logger.debug((Object)(">>>billMaker=" + paraVo.m_makeBillOperator + " operator=" + paraVo.m_operator));
        Logger.debug((Object)(">>>corpPK=" + paraVo.m_pkOrg + " billId=" + paraVo.m_billVersionPK));
        Logger.debug((Object)(">>>actionName=" + paraVo.m_actionName + " billNo=" + paraVo.m_billNo));
        if (hashBilltypeToParavo != null) {
            hashBilltypeToParavo.put(paraVo.m_billType + src_billtyePK, paraVo);
        }
        Logger.debug((Object)(">>>getVariableValue(" + actionName + "," + billType + ") END<<<"));
        return paraVo;
    }

    public static boolean isApproveAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "APPROVE".length();
            return actionName.length() >= leng && actionName.toUpperCase().substring(0, leng).equals("APPROVE");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.SignalApproveflow.getIntValue();
    }

    private static BillactionVO getBillActionVO(String actionName, String billtype) {
        Map<String, BillactionVO> actionMap = PfDataCache.getBillactionVOMap(billtype);
        return actionMap == null ? null : actionMap.get(actionName);
    }

    public static boolean isDeleteAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            return actionName.endsWith("DELETE") || actionName.endsWith("DISCARD") || actionName.endsWith("BLANKOUT");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.Delete.getIntValue();
    }

    public static boolean isRollbackAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "ROLLBACK".length();
            return actionName.length() >= leng && actionName.toUpperCase().substring(0, leng).equals("ROLLBACK");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.RollbackWorkflow.getIntValue();
    }

    public static boolean isSaveAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName.toUpperCase().equals("SAVETEMP")) {
            return false;
        }
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "SAVE".length();
            return actionName.length() >= leng && (actionName.toUpperCase().substring(0, leng).equals("SAVE") || actionName.toUpperCase().substring(0, leng).equals("EDIT"));
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.StartApproveflow.getIntValue();
    }

    public static boolean isSignalAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "SIGNAL".length();
            return actionName.length() >= leng && actionName.toUpperCase().substring(0, leng).equals("SIGNAL");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.SignalWorkflow.getIntValue();
    }

    public static boolean isStartAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "START".length();
            return actionName.length() >= leng && actionName.toUpperCase().substring(0, leng).equals("START");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.StartWorkflow.getIntValue();
    }

    public static boolean isTranstype(String strTypeCode) {
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(strTypeCode).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId()));
        return btVO != null && btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue();
    }

    public static boolean isTranstype(String strTypeCode, String pk_group) {
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(strTypeCode).buildPkGroup(pk_group));
        return btVO != null && btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue();
    }

    public static boolean isUnapproveAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "UNAPPROVE".length();
            return actionName.length() >= leng && actionName.toUpperCase().substring(0, leng).equals("UNAPPROVE");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.RollbackApproveflow.getIntValue();
    }

    public static boolean isValueChanged(Object oldValue, Object newValue) {
        boolean isChange = false;
        if (oldValue != null && !oldValue.equals(newValue)) {
            isChange = true;
        }
        if (newValue != null && !newValue.equals(oldValue)) {
            isChange = true;
        }
        return isChange;
    }

    public static Class parseTypeClass(String dataType) {
        if (dataType.toUpperCase().equals("STRING")) {
            return String.class;
        }
        if (dataType.toUpperCase().equals("UFDATE")) {
            return UFDate.class;
        }
        if (dataType.toUpperCase().equals("UFDOUBLE")) {
            return UFDouble.class;
        }
        if (dataType.toUpperCase().equals("DOUBLE")) {
            return UFDouble.class;
        }
        if (dataType.toUpperCase().equals("UFBOOLEAN")) {
            return UFBoolean.class;
        }
        if (dataType.toUpperCase().equals("BOOLEAN")) {
            return UFBoolean.class;
        }
        if (dataType.toUpperCase().equals("UFDATETIME")) {
            return UFDateTime.class;
        }
        if (dataType.toUpperCase().equals("INTEGER")) {
            return Integer.class;
        }
        if (dataType.toUpperCase().equals("ARRAYLIST")) {
            return ArrayList.class;
        }
        if (dataType.toUpperCase().equals("OBJECT")) {
            return Object.class;
        }
        if (dataType.toUpperCase().equals("STRING[]")) {
            return String[].class;
        }
        if (dataType.toUpperCase().equals("UFDATE[]")) {
            return UFDate[].class;
        }
        if (dataType.toUpperCase().equals("UFDOUBLE[]")) {
            return UFDouble[].class;
        }
        if (dataType.toUpperCase().equals("UFBOOLEAN[]")) {
            return UFBoolean[].class;
        }
        if (dataType.toUpperCase().equals("UFDATETIME[]")) {
            return UFDateTime[].class;
        }
        if (dataType.toUpperCase().equals("INTEGER[]")) {
            return Integer[].class;
        }
        if (dataType.toUpperCase().equals("OBJECT[]")) {
            return Object[].class;
        }
        return null;
    }

    public static AggregatedValueObject[] pfInitVos(String strBillVoClassName, int voLen) throws BusinessException {
        AggregatedValueObject[] retVos;
        try {
            retVos = (AggregatedValueObject[])Array.newInstance(Class.forName(strBillVoClassName), voLen);
        }
        catch (Exception e) {
            throw new PFBusinessException(e.getMessage(), e);
        }
        return retVos;
    }

    public static String queryAllCheckers(String billId, String billType) {
        String ret = null;
        StringBuffer strAllCheckers = new StringBuffer();
        try {
            WorkflownoteVO[] noteVOs = ((IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class)).queryWorkitems(billId, billType, WorkflowTypeEnum.Approveflow.getIntValue(), 1);
            for (int i = 0; i < (noteVOs == null ? 0 : noteVOs.length); ++i) {
                strAllCheckers.append(noteVOs[i].getCheckname());
                strAllCheckers.append(",");
            }
            if (strAllCheckers.length() > 0) {
                ret = strAllCheckers.substring(0, strAllCheckers.length() - 1);
            }
            Logger.debug((Object)NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000039", null, new String[]{billId, strAllCheckers.toString()}));
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public static HashSet<String> querySimilarTypes(String billType) {
        HashSet<String> hsRet = new HashSet<String>();
        hsRet.add(billType);
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(billType).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId()));
        if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            BilltypeVO parentTypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(btVO.getParentbilltype()).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId()));
            hsRet.add(parentTypeVO.getPk_billtypecode());
            String parentBilltype = PfUtilBaseTools.findParentBilltypeByStyle(parentTypeVO);
            if (parentBilltype != null) {
                hsRet.add(parentBilltype);
            }
        } else {
            String parentBilltype = PfUtilBaseTools.findParentBilltypeByStyle(btVO);
            if (parentBilltype != null) {
                hsRet.add(parentBilltype);
            }
        }
        return hsRet;
    }

    public static boolean isRecallAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "RECALL".length();
            return actionName.length() >= leng && actionName.toUpperCase().substring(0, leng).equals("RECALL");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.CancelSubmitWorkflow.getIntValue();
    }

    public static boolean isUnSaveAction(String actionName, String billtype) {
        BillactionVO actionVo;
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        if ((actionVo = PfUtilBaseTools.getBillActionVO(actionName, billtype)) == null || actionVo.getAction_type() == null) {
            int leng = "UNSAVE".length();
            return actionName.length() >= leng && actionName.toUpperCase().substring(0, leng).equals("UNSAVE");
        }
        return actionVo.getAction_type().intValue() == BillActionTypeEnum.CancelSubmitApproveflow.getIntValue();
    }

    public static boolean isSignalFlowAction(String actionName, String billtype) {
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        return PfUtilBaseTools.isSignalAction(actionName, billtype) || PfUtilBaseTools.isApproveAction(actionName, billtype);
    }

    public static boolean isStartFlowAction(String actionName, String billtype) {
        if (actionName != null && actionName.length() > 20) {
            actionName = actionName.substring(0, actionName.length() - 20);
        }
        return PfUtilBaseTools.isStartAction(actionName, billtype) || PfUtilBaseTools.isSaveAction(actionName, billtype);
    }

    public static String getActionCodeB4NCC(String billtype, int billactioncode) {
        Map<String, BillactionVO> actionMap = PfDataCache.getBillactionVOMap(billtype);
        String actiontype = "";
        if (actionMap != null) {
            for (BillactionVO vo : actionMap.values()) {
                if (vo.getAction_type() == null || vo.getAction_type() != billactioncode) continue;
                actiontype = vo.getActiontype();
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)actiontype)) {
            switch (billactioncode) {
                case 10: {
                    actiontype = "SAVE";
                    break;
                }
                case 11: {
                    actiontype = "APPROVE";
                    break;
                }
                case 12: {
                    actiontype = "UNAPPROVE";
                    break;
                }
                case 13: {
                    actiontype = "UNSAVE";
                    break;
                }
                case 20: {
                    actiontype = "START";
                    break;
                }
                case 21: {
                    actiontype = "SIGNAL";
                    break;
                }
                case 22: {
                    actiontype = "ROLLBACK";
                    break;
                }
                case 23: {
                    actiontype = "RECALL";
                    break;
                }
            }
        }
        return actiontype;
    }
}

