/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.change;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.pf.change.BillMappingConvertor;
import nc.md.model.IBusinessEntity;
import nc.md.model.access.javamap.AggVOStyle;
import nc.md.model.access.javamap.IBeanStyle;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.IExChangeConst;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.SuperVO;
import nc.vo.pub.formulaset.VarryVO;
import nc.vo.trade.exdoc.IExDocAggVO;
import nc.vo.trade.pub.IExAggVO;
import nc.vo.uap.pf.PFBusinessException;

public class PfBillMappingUtil
implements IExChangeConst {
    public static final String[] ENV_CODES = new String[]{"SYSDATE", "SYSOPERATOR", "SYSGROUP", "SYSTIME", "DESTBILLTYPE", "DESTTRANSTYPE", "NCSYSUSER", "BUZIDATE", "BUZITIME"};

    public static String[] getEnvNames() {
        return new String[]{NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000605"), NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000606"), NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000607"), NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000608"), NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000029"), NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000030"), NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000031"), NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000032"), NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000033")};
    }

    public static boolean isSystemEnvField(String srcField) {
        return srcField.equals("SYSDATE") || srcField.equals("SYSOPERATOR") || srcField.equals("SYSGROUP") || srcField.equals("SYSTIME") || srcField.equals("DESTBILLTYPE") || srcField.equals("DESTTRANSTYPE") || srcField.equals("NCSYSUSER") || srcField.equals("BUZITIME") || srcField.equals("BUZIDATE");
    }

    public static AggregatedValueObject[] initDestBillVOs(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject[] sourceBillVOs, BillMappingConvertor bmc) throws BusinessException {
        String destBillVoClzName = null;
        IBusinessEntity destBE = PfMetadataTools.queryMetaOfBilltype(destBillOrTranstype);
        IBeanStyle bs = destBE.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000009"));
        }
        destBillVoClzName = ((AggVOStyle)bs).getAggVOClassName();
        try {
            AggregatedValueObject[] destVOs = (AggregatedValueObject[])Array.newInstance(Class.forName(destBillVoClzName), sourceBillVOs.length);
            for (int i = 0; i < sourceBillVOs.length; ++i) {
                AggregatedValueObject destVO;
                destVOs[i] = destVO = PfBillMappingUtil.initDestBillVO(srcBillOrTranstype, destBillOrTranstype, sourceBillVOs[i], bmc);
            }
            return destVOs;
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000034", null, new String[]{e.getMessage()}));
        }
    }

    public static AggregatedValueObject[] initDestBillVOs(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject[] sourceBillVOs, BillMappingConvertor bmc, int classifyMode) throws BusinessException {
        String destBillVoClzName = null;
        IBusinessEntity destBE = PfMetadataTools.queryMetaOfBilltype(destBillOrTranstype);
        IBeanStyle bs = destBE.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000009"));
        }
        destBillVoClzName = ((AggVOStyle)bs).getAggVOClassName();
        String destHeadVoClzName = destBE.getFullClassName();
        try {
            int i;
            String[] srcChildAttrs = PfMetadataTools.queryChildAttributes(srcBillOrTranstype);
            String[] destChildAttrs = PfMetadataTools.queryChildAttributes(destBillOrTranstype);
            AggregatedValueObject[] destVOs = (AggregatedValueObject[])Array.newInstance(Class.forName(destBillVoClzName), sourceBillVOs.length);
            for (i = 0; i < sourceBillVOs.length; ++i) {
                AggregatedValueObject destVO;
                destVOs[i] = destVO = PfBillMappingUtil.initDestBillVOForWell(srcBillOrTranstype, destBillOrTranstype, sourceBillVOs[i], bmc, classifyMode, destBillVoClzName, destHeadVoClzName, destBE, srcChildAttrs, destChildAttrs);
            }
            if (destVOs != null && destVOs.length > 0 && destVOs[0] instanceof IExDocAggVO) {
                for (i = 0; i < sourceBillVOs.length; ++i) {
                    ((IExDocAggVO)destVOs[i]).setPkDocByBilltype(destBillOrTranstype);
                }
            }
            return destVOs;
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000034", null, new String[]{e.getMessage()}));
        }
    }

    private static AggregatedValueObject initDestBillVO(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject srcBillVO, BillMappingConvertor bmc) throws Exception {
        HashMap<String, Integer> hmSrcTablecode2Length = new HashMap<String, Integer>();
        PfBillMappingUtil.parseChildFromSrcVO(srcBillOrTranstype, srcBillVO, hmSrcTablecode2Length);
        HashMap<String, String> destChild2srcChildInMapping = new HashMap<String, String>();
        PfBillMappingUtil.parseChildFromRules(bmc, destChild2srcChildInMapping, hmSrcTablecode2Length);
        String destBillVoClzName = null;
        IBusinessEntity destBE = PfMetadataTools.queryMetaOfBilltype(destBillOrTranstype);
        IBeanStyle bs = destBE.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000009"));
        }
        destBillVoClzName = ((AggVOStyle)bs).getAggVOClassName();
        String destHeadVoClzName = destBE.getFullClassName();
        AggregatedValueObject destBillVO = (AggregatedValueObject)Class.forName(destBillVoClzName).newInstance();
        CircularlyAccessibleValueObject destHeadVO = (CircularlyAccessibleValueObject)Class.forName(destHeadVoClzName).newInstance();
        destBillVO.setParentVO(destHeadVO);
        PfBillMappingUtil.generateDestChild(destBillOrTranstype, hmSrcTablecode2Length, destChild2srcChildInMapping, destBE, destBillVO);
        PfBillMappingUtil.putHideField(srcBillVO, destBillVO, destChild2srcChildInMapping);
        return destBillVO;
    }

    private static AggregatedValueObject initDestBillVO(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject srcBillVO, BillMappingConvertor bmc, int classifyMode) throws Exception {
        HashMap<String, Integer> hmSrcTablecode2Length = new HashMap<String, Integer>();
        PfBillMappingUtil.parseChildFromSrcVO(srcBillOrTranstype, srcBillVO, hmSrcTablecode2Length);
        HashMap<String, String> destChild2srcChildInMapping = new HashMap<String, String>();
        PfBillMappingUtil.parseChildFromRules(bmc, destChild2srcChildInMapping, hmSrcTablecode2Length);
        String destBillVoClzName = null;
        IBusinessEntity destBE = PfMetadataTools.queryMetaOfBilltype(destBillOrTranstype);
        IBeanStyle bs = destBE.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000009"));
        }
        destBillVoClzName = ((AggVOStyle)bs).getAggVOClassName();
        String destHeadVoClzName = destBE.getFullClassName();
        AggregatedValueObject destBillVO = (AggregatedValueObject)Class.forName(destBillVoClzName).newInstance();
        CircularlyAccessibleValueObject destHeadVO = (CircularlyAccessibleValueObject)Class.forName(destHeadVoClzName).newInstance();
        destBillVO.setParentVO(destHeadVO);
        PfBillMappingUtil.generateDestChild(destBillOrTranstype, hmSrcTablecode2Length, destChild2srcChildInMapping, destBE, destBillVO);
        PfBillMappingUtil.putHideField(srcBillVO, destBillVO, destChild2srcChildInMapping, classifyMode);
        return destBillVO;
    }

    private static AggregatedValueObject initDestBillVOForWell(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject srcBillVO, BillMappingConvertor bmc, int classifyMode, String destBillVoClzName, String destHeadVoClzName, IBusinessEntity destBE, String[] srcChildAttrs, String[] destChildAttrs) throws Exception {
        HashMap<String, Integer> hmSrcTablecode2Length = new HashMap<String, Integer>();
        PfBillMappingUtil.parseChildFromSrcVOForWell(srcBillOrTranstype, srcBillVO, hmSrcTablecode2Length, srcChildAttrs);
        HashMap<String, String> destChild2srcChildInMapping = new HashMap<String, String>();
        PfBillMappingUtil.parseChildFromRules(bmc, destChild2srcChildInMapping, hmSrcTablecode2Length);
        AggregatedValueObject destBillVO = (AggregatedValueObject)Class.forName(destBillVoClzName).newInstance();
        CircularlyAccessibleValueObject destHeadVO = (CircularlyAccessibleValueObject)Class.forName(destHeadVoClzName).newInstance();
        destBillVO.setParentVO(destHeadVO);
        PfBillMappingUtil.generateDestChildForWell(destBillOrTranstype, hmSrcTablecode2Length, destChild2srcChildInMapping, destBE, destBillVO, destChildAttrs);
        PfBillMappingUtil.putHideField(srcBillVO, destBillVO, destChild2srcChildInMapping, classifyMode);
        return destBillVO;
    }

    private static void parseChildFromSrcVO(String srcBillOrTranstype, AggregatedValueObject srcBillVO, HashMap<String, Integer> hmSrcTablecode2Length) throws BusinessException {
        String[] srcChildAttrs = PfMetadataTools.queryChildAttributes(srcBillOrTranstype);
        if (srcBillVO instanceof IExAggVO) {
            IExAggVO exSrcBillVO = (IExAggVO)srcBillVO;
            for (int i = 0; i < srcChildAttrs.length; ++i) {
                CircularlyAccessibleValueObject[] childs = exSrcBillVO.getTableVO(srcChildAttrs[i]);
                hmSrcTablecode2Length.put(srcChildAttrs[i], childs == null ? 0 : childs.length);
            }
        } else if (srcChildAttrs.length > 0) {
            hmSrcTablecode2Length.put(srcChildAttrs[0], srcBillVO.getChildrenVO() == null ? 0 : srcBillVO.getChildrenVO().length);
        }
        hmSrcTablecode2Length.put("head", 1);
    }

    private static void parseChildFromSrcVOForWell(String srcBillOrTranstype, AggregatedValueObject srcBillVO, HashMap<String, Integer> hmSrcTablecode2Length, String[] srcChildAttrs) throws BusinessException {
        if (srcBillVO instanceof IExAggVO) {
            IExAggVO exSrcBillVO = (IExAggVO)srcBillVO;
            for (int i = 0; i < srcChildAttrs.length; ++i) {
                CircularlyAccessibleValueObject[] childs = exSrcBillVO.getTableVO(srcChildAttrs[i]);
                hmSrcTablecode2Length.put(srcChildAttrs[i], childs == null ? 0 : childs.length);
            }
        } else if (srcChildAttrs.length > 0) {
            hmSrcTablecode2Length.put(srcChildAttrs[0], srcBillVO.getChildrenVO() == null ? 0 : srcBillVO.getChildrenVO().length);
        }
        hmSrcTablecode2Length.put("head", 1);
    }

    private static void parseChildFromRules(BillMappingConvertor bmc, HashMap<String, String> destChild2srcChildInMapping, HashMap<String, Integer> hmSrcTablecode2Length) throws PFBusinessException {
        String[][] sMoves = bmc.getMoveRules();
        String[] sFormulas = bmc.getFormulaRules();
        for (int i = 0; i < (sMoves == null ? 0 : sMoves.length); ++i) {
            int dci = sMoves[i][0].indexOf(".");
            if (dci <= 0) continue;
            String dChildAttr = sMoves[i][0].substring(0, dci);
            PfBillMappingUtil.putDestChild2srcChildMap(destChild2srcChildInMapping, hmSrcTablecode2Length, sMoves[i][1], dChildAttr);
        }
        if (sFormulas != null && sFormulas.length > 0) {
            bmc.getFormulaParse().setExpressArray(sFormulas);
            VarryVO[] varrys = bmc.getFormulaParse().getVarryArray();
            for (int i = 0; i < varrys.length; ++i) {
                String dest = varrys[i].getFormulaName();
                int dci = dest.indexOf(".");
                if (dci <= 0) continue;
                String dChildAttr = dest.substring(0, dci);
                for (int j = 0; j < (varrys[i].getVarry() == null ? 0 : varrys[i].getVarry().length); ++j) {
                    String var = varrys[i].getVarry()[j];
                    PfBillMappingUtil.putDestChild2srcChildMap(destChild2srcChildInMapping, hmSrcTablecode2Length, var, dChildAttr);
                }
            }
        }
    }

    private static void putDestChild2srcChildMap(HashMap<String, String> destChild2srcChildInMapping, HashMap<String, Integer> hmSrcTablecode2Length, String var, String dChildAttr) throws PFBusinessException {
        int sci = var.indexOf(".");
        boolean isSrcChild = false;
        String sChildAttr = null;
        if (sci > 0 && hmSrcTablecode2Length.containsKey(sChildAttr = var.substring(0, sci))) {
            isSrcChild = true;
        }
        if (isSrcChild) {
            String old = destChild2srcChildInMapping.get(dChildAttr);
            if (old != null && !old.equals("head") && !sChildAttr.equalsIgnoreCase(old)) {
                throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000035", null, new String[]{dChildAttr, sChildAttr, old}));
            }
            destChild2srcChildInMapping.put(dChildAttr, sChildAttr);
        } else if (!destChild2srcChildInMapping.containsKey(dChildAttr)) {
            destChild2srcChildInMapping.put(dChildAttr, "head");
        }
    }

    private static void putHideField(AggregatedValueObject srcBillVO, AggregatedValueObject destBillVO, HashMap<String, String> destChild2srcChildInMapping) throws BusinessException {
        destBillVO.getParentVO().setAttributeValue("splitkeyvalue", srcBillVO.getParentVO().getAttributeValue("splitkeyvalue"));
        Set<String> destChildSet = destChild2srcChildInMapping.keySet();
        for (String destChildAttr : destChildSet) {
            String srcChildAttr = destChild2srcChildInMapping.get(destChildAttr);
            if ("head".equals(srcChildAttr)) continue;
            CircularlyAccessibleValueObject[] srcItemVos = null;
            if (srcBillVO instanceof IExAggVO) {
                IExAggVO exSrcBillVO = (IExAggVO)srcBillVO;
                srcItemVos = exSrcBillVO.getTableVO(srcChildAttr);
            } else {
                srcItemVos = srcBillVO.getChildrenVO();
            }
            CircularlyAccessibleValueObject[] destItemVos = null;
            if (destBillVO instanceof IExAggVO) {
                IExAggVO exDestBillVO = (IExAggVO)destBillVO;
                destItemVos = exDestBillVO.getTableVO(destChildAttr);
            } else {
                destItemVos = destBillVO.getChildrenVO();
            }
            if (srcItemVos == null || destItemVos == null || srcItemVos.length == 0 || destItemVos.length == 0 || !(srcItemVos[0] instanceof SuperVO) || !(destItemVos[0] instanceof SuperVO)) continue;
            if (srcItemVos.length != destItemVos.length) {
                throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000036"));
            }
            for (int i = 0; i < destItemVos.length; ++i) {
                SuperVO destItemVo = (SuperVO)destItemVos[i];
                SuperVO srcItemVo = (SuperVO)srcItemVos[i];
                destItemVo.setAttributeValue("splitkeyvalue", srcItemVo.getAttributeValue("splitkeyvalue"));
            }
        }
    }

    private static void putHideField(AggregatedValueObject srcBillVO, AggregatedValueObject destBillVO, HashMap<String, String> destChild2srcChildInMapping, int classifyMode) throws BusinessException {
        destBillVO.getParentVO().setAttributeValue("splitkeyvalue", srcBillVO.getParentVO().getAttributeValue("splitkeyvalue"));
        if (classifyMode == 2) {
            destBillVO.getParentVO().setAttributeValue("busi_type", srcBillVO.getParentVO().getAttributeValue("busi_type"));
        }
        Set<String> destChildSet = destChild2srcChildInMapping.keySet();
        for (String destChildAttr : destChildSet) {
            String srcChildAttr = destChild2srcChildInMapping.get(destChildAttr);
            if ("head".equals(srcChildAttr)) continue;
            CircularlyAccessibleValueObject[] srcItemVos = null;
            if (srcBillVO instanceof IExAggVO) {
                IExAggVO exSrcBillVO = (IExAggVO)srcBillVO;
                srcItemVos = exSrcBillVO.getTableVO(srcChildAttr);
            } else {
                srcItemVos = srcBillVO.getChildrenVO();
            }
            CircularlyAccessibleValueObject[] destItemVos = null;
            if (destBillVO instanceof IExAggVO) {
                IExAggVO exDestBillVO = (IExAggVO)destBillVO;
                destItemVos = exDestBillVO.getTableVO(destChildAttr);
            } else {
                destItemVos = destBillVO.getChildrenVO();
            }
            if (srcItemVos == null || destItemVos == null || srcItemVos.length == 0 || destItemVos.length == 0 || !(srcItemVos[0] instanceof SuperVO) || !(destItemVos[0] instanceof SuperVO)) continue;
            if (srcItemVos.length != destItemVos.length) {
                throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000036"));
            }
            for (int i = 0; i < destItemVos.length; ++i) {
                SuperVO destItemVo = (SuperVO)destItemVos[i];
                SuperVO srcItemVo = (SuperVO)srcItemVos[i];
                destItemVo.setAttributeValue("splitkeyvalue", srcItemVo.getAttributeValue("splitkeyvalue"));
            }
        }
    }

    private static void generateDestChild(String destBillOrTranstype, HashMap<String, Integer> hmSrcTablecode2Length, HashMap<String, String> destChild2srcChildInMapping, IBusinessEntity destBE, AggregatedValueObject destBillVO) throws BusinessException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Integer srcChildLen;
        String srcChildAttr;
        String[] destChildAttrs = PfMetadataTools.queryChildAttributes(destBillOrTranstype);
        if (destBillVO instanceof IExAggVO) {
            IExAggVO exDestBillVO = (IExAggVO)destBillVO;
            for (int i = 0; i < destChildAttrs.length; ++i) {
                Integer srcChildLen2;
                String srcChildAttr2 = destChild2srcChildInMapping.get(destChildAttrs[i]);
                if (srcChildAttr2 == null || (srcChildLen2 = hmSrcTablecode2Length.get(srcChildAttr2)) == null || srcChildLen2 <= 0) continue;
                IBusinessEntity destChildBE = PfMetadataTools.getBusinessEntityOfAttr(destBE.getAttributeByName(destChildAttrs[i]));
                String destChildVoClzName = destChildBE.getFullClassName();
                CircularlyAccessibleValueObject[] itemVos = (CircularlyAccessibleValueObject[])Array.newInstance(Class.forName(destChildVoClzName), (int)srcChildLen2);
                for (int m = 0; m < itemVos.length; ++m) {
                    itemVos[m] = (CircularlyAccessibleValueObject)Class.forName(destChildVoClzName).newInstance();
                }
                exDestBillVO.setTableVO(destChildAttrs[i], itemVos);
            }
        } else if (destChildAttrs.length > 0 && (srcChildAttr = destChild2srcChildInMapping.get(destChildAttrs[0])) != null && (srcChildLen = hmSrcTablecode2Length.get(srcChildAttr)) != null && srcChildLen > 0) {
            IBusinessEntity destChildBE = PfMetadataTools.getBusinessEntityOfAttr(destBE.getAttributeByName(destChildAttrs[0]));
            String destChildVoClzName = destChildBE.getFullClassName();
            CircularlyAccessibleValueObject[] itemVos = (CircularlyAccessibleValueObject[])Array.newInstance(Class.forName(destChildVoClzName), (int)srcChildLen);
            for (int m = 0; m < itemVos.length; ++m) {
                itemVos[m] = (CircularlyAccessibleValueObject)Class.forName(destChildVoClzName).newInstance();
            }
            destBillVO.setChildrenVO(itemVos);
        }
    }

    private static void generateDestChildForWell(String destBillOrTranstype, HashMap<String, Integer> hmSrcTablecode2Length, HashMap<String, String> destChild2srcChildInMapping, IBusinessEntity destBE, AggregatedValueObject destBillVO, String[] destChildAttrs) throws BusinessException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Integer srcChildLen;
        String srcChildAttr;
        if (destBillVO instanceof IExAggVO) {
            IExAggVO exDestBillVO = (IExAggVO)destBillVO;
            for (int i = 0; i < destChildAttrs.length; ++i) {
                Integer srcChildLen2;
                String srcChildAttr2 = destChild2srcChildInMapping.get(destChildAttrs[i]);
                if (srcChildAttr2 == null || (srcChildLen2 = hmSrcTablecode2Length.get(srcChildAttr2)) == null || srcChildLen2 <= 0) continue;
                IBusinessEntity destChildBE = PfMetadataTools.getBusinessEntityOfAttr(destBE.getAttributeByName(destChildAttrs[i]));
                String destChildVoClzName = destChildBE.getFullClassName();
                CircularlyAccessibleValueObject[] itemVos = (CircularlyAccessibleValueObject[])Array.newInstance(Class.forName(destChildVoClzName), (int)srcChildLen2);
                for (int m = 0; m < itemVos.length; ++m) {
                    itemVos[m] = (CircularlyAccessibleValueObject)Class.forName(destChildVoClzName).newInstance();
                }
                exDestBillVO.setTableVO(destChildAttrs[i], itemVos);
            }
        } else if (destChildAttrs.length > 0 && (srcChildAttr = destChild2srcChildInMapping.get(destChildAttrs[0])) != null && (srcChildLen = hmSrcTablecode2Length.get(srcChildAttr)) != null && srcChildLen > 0) {
            IBusinessEntity destChildBE = PfMetadataTools.getBusinessEntityOfAttr(destBE.getAttributeByName(destChildAttrs[0]));
            String destChildVoClzName = destChildBE.getFullClassName();
            CircularlyAccessibleValueObject[] itemVos = (CircularlyAccessibleValueObject[])Array.newInstance(Class.forName(destChildVoClzName), (int)srcChildLen);
            for (int m = 0; m < itemVos.length; ++m) {
                itemVos[m] = (CircularlyAccessibleValueObject)Class.forName(destChildVoClzName).newInstance();
            }
            destBillVO.setChildrenVO(itemVos);
        }
    }

    public static String getEnvNameByCode(String env_code) {
        String[] names = PfBillMappingUtil.getEnvNames();
        for (int i = 0; i < ENV_CODES.length; ++i) {
            if (!ENV_CODES[i].equals(env_code)) continue;
            return names[i];
        }
        return null;
    }
}

