/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.core.util.ObjectCreator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.impl.pubapp.pattern.database.IDExQueryBuilder;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFExchangeUpgradeEx;
import nc.jdbc.framework.JdbcSession;
import nc.jdbc.framework.PersistenceManager;
import nc.jdbc.framework.exception.DbException;
import nc.jdbc.framework.generator.SequenceGenerator;
import nc.jdbc.framework.processor.BeanListProcessor;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.jdbc.framework.util.SQLHelper;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.change.ExchangeRuleVO;
import nc.vo.pf.change.ExchangeSplitVO;
import nc.vo.pf.change.ExchangeVO;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pf.pub.util.SQLUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.uap.pf.PFBusinessException;
import uap.apppf.util.SQLTransferMeaningUtil;

public class PFExchangeUtil {
    public static String getStrictMatchByTypeSQL(String srcTableName, String destTableName) {
        return " " + srcTableName + ".src_billtype = " + destTableName + ".src_billtype and " + srcTableName + ".src_transtype = " + destTableName + ".src_transtype and " + srcTableName + ".dest_billtype = " + destTableName + ".dest_billtype and " + srcTableName + ".dest_transtype = " + destTableName + ".dest_transtype ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> queryNotNeedCopiedVOChange(String destPk_group, String productCode) throws DbException {
        String sql = "select distinct a.pk_vochange from pub_vochange a, pub_vochange b  where a.DEST_BILLTYPE=b.DEST_BILLTYPE  and a.DEST_TRANSTYPE=b.DEST_TRANSTYPE  and a.SRC_BILLTYPE=b.SRC_BILLTYPE  and a.SRC_TRANSTYPE=b.SRC_TRANSTYPE  and a.PK_BUSITYPE='~'  and (a.PK_GROUP " + SQLUtil.getGlobalInSQL() + " or a.PK_GROUP ='~') and b.PK_GROUP='" + destPk_group + "' ";
        if (!StringUtil.isEmptyWithTrim((String)productCode)) {
            sql = sql + " and " + PFExchangeUtil.getProductExchangeSQL(productCode, "a");
        }
        PersistenceManager persist = null;
        ArrayList lResult = null;
        try {
            persist = PersistenceManager.getInstance();
            JdbcSession jdbc = persist.getJdbcSession();
            lResult = (ArrayList)jdbc.executeQuery(sql, (ResultSetProcessor)new ColumnListProcessor());
        }
        finally {
            if (persist != null) {
                persist.release();
            }
        }
        return lResult;
    }

    public static void copyGroupExchangeVO(String destPk_group, String productCode, Collection<ExchangeVO> preExchangeVOs, Hashtable<String, String> htCopiedBusitype) throws PFBusinessException {
        ArrayList<String> notNeedCopied = null;
        try {
            notNeedCopied = PFExchangeUtil.queryNotNeedCopiedVOChange(destPk_group, productCode);
        }
        catch (DbException e) {
            Logger.error((Object)((Object)e));
            throw new PFBusinessException(e.getMessage(), e);
        }
        boolean needFilter = false;
        if (notNeedCopied != null && notNeedCopied.size() > 0) {
            needFilter = true;
        }
        HashSet<String> notNeedCopiedTrimed = new HashSet<String>();
        if (needFilter) {
            for (String pk : notNeedCopied) {
                notNeedCopiedTrimed.add(pk == null ? "" : pk.trim());
            }
        }
        ArrayList<SuperVO> alNeedCopied = new ArrayList<SuperVO>();
        ArrayList<String> alOldPKs = new ArrayList<String>();
        Hashtable htCopiedVOChange = new Hashtable();
        for (ExchangeVO exchangeVO : preExchangeVOs) {
            String oldBusitype = exchangeVO.getPk_busitype();
            if (!StringUtil.isEmptyWithTrim((String)oldBusitype) && htCopiedBusitype != null) {
                String newBusitype = htCopiedBusitype.get(oldBusitype);
                if (newBusitype == null) continue;
                exchangeVO.setPk_busitype(newBusitype);
            } else if (needFilter && (exchangeVO.getPk_vochange() == null || notNeedCopiedTrimed.contains(exchangeVO.getPk_vochange().trim()))) continue;
            exchangeVO.setPk_group(destPk_group);
            alOldPKs.add(exchangeVO.getPrimaryKey());
            exchangeVO.setPrimaryKey(null);
            alNeedCopied.add(exchangeVO);
        }
        if (alNeedCopied.size() > 0) {
            BaseDAO dao = new BaseDAO();
            try {
                String[] newPKs = dao.insertVOList(alNeedCopied);
                for (int i = 0; i < (newPKs == null ? 0 : newPKs.length); ++i) {
                    htCopiedVOChange.put(alOldPKs.get(i), newPKs[i]);
                }
                IDExQueryBuilder builder = new IDExQueryBuilder("temp_vochangeb_");
                String inSql = builder.buildSQL("pk_vochange", alOldPKs.toArray(new String[alOldPKs.size()]));
                alNeedCopied.clear();
                Collection coChangeRule = dao.retrieveByClause(ExchangeRuleVO.class, inSql);
                for (ExchangeRuleVO exchangeRuleVO : coChangeRule) {
                    String oldPkChange = exchangeRuleVO.getPk_vochange();
                    String newPkChange = (String)htCopiedVOChange.get(oldPkChange);
                    if (newPkChange == null) continue;
                    exchangeRuleVO.setPk_vochange(newPkChange);
                    exchangeRuleVO.setPrimaryKey(null);
                    alNeedCopied.add(exchangeRuleVO);
                }
                dao.insertVOList(alNeedCopied);
                alNeedCopied.clear();
                Collection coChangeSplit = dao.retrieveByClause(ExchangeSplitVO.class, inSql);
                for (ExchangeSplitVO exchangeSplitVO : coChangeSplit) {
                    String oldPkChange = exchangeSplitVO.getPk_vochange();
                    String newPkChange = (String)htCopiedVOChange.get(oldPkChange);
                    if (newPkChange == null) continue;
                    exchangeSplitVO.setPk_vochange(newPkChange);
                    exchangeSplitVO.setPrimaryKey(null);
                    alNeedCopied.add(exchangeSplitVO);
                }
                dao.insertVOList(alNeedCopied);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PFBusinessException(e.getMessage(), e);
            }
        }
    }

    public static IPFExchangeUpgradeEx getExchangeUpgradeEx(ExchangeVO exchangeVO) throws PFBusinessException {
        IPFExchangeUpgradeEx upgradeEx = null;
        String upgradeClazz = exchangeVO.getUpgradeexclass();
        Logger.error((Object)("upgradeClazz===================" + upgradeClazz));
        Throwable thr = null;
        if (null != upgradeClazz && !"".equals(upgradeClazz.trim()) && !"null".equals(upgradeClazz)) {
            String[] modules;
            for (String module : modules = PFExchangeUtil.getModules(exchangeVO)) {
                Logger.error((Object)("module===================" + module));
                try {
                    upgradeEx = (IPFExchangeUpgradeEx)ObjectCreator.newInstance((String)module, (String)upgradeClazz);
                    if (upgradeEx == null) continue;
                    break;
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    thr = e;
                }
            }
            if (upgradeEx == null) {
                try {
                    Class<?> upgradeExClass = Class.forName(exchangeVO.getUpgradeexclass());
                    Logger.error((Object)("upgradeExClass===================" + upgradeExClass));
                    upgradeEx = (IPFExchangeUpgradeEx)upgradeExClass.newInstance();
                    Logger.error((Object)("upgradeEx===================" + upgradeEx));
                }
                catch (Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    thr = e;
                }
            }
        }
        if (upgradeEx != null) {
            return upgradeEx;
        }
        if (thr != null) {
            String message = "instantiate upgradeExClass=" + upgradeClazz + " encountered (several) problem(s): " + thr.getMessage() + ", please refer to the logfile for detail";
            throw new PFBusinessException(message, thr);
        }
        return null;
    }

    private static String[] getModules(ExchangeVO exchangevo) {
        BilltypeVO dest;
        HashSet<String> moduleSet = new HashSet<String>();
        BilltypeVO src = PfDataCache.getBillType(exchangevo.getSrc_billtype());
        if (src != null) {
            moduleSet.add(src.getSystemcode());
        }
        if ((dest = PfDataCache.getBillType(exchangevo.getDest_billtype())) != null) {
            moduleSet.add(dest.getSystemcode());
        }
        return moduleSet.toArray(new String[0]);
    }

    public static <T extends SuperVO> void processUpgradeVOChangeChild(ExchangeVO matchPreExchangeVO, ExchangeVO oldGroupExchangeVO, String childTableName, Map<String, Collection<T>> mapAddChildren, Map<String, String> mapDeleteChildrenInSQL, SequenceGenerator pkGenerator) throws DAOException {
        Collection<T> addChildrenVOs;
        BaseDAO baseDAO = new BaseDAO();
        String inSql = mapDeleteChildrenInSQL.get(matchPreExchangeVO.getPk_vochange());
        if (!StringUtil.isEmptyWithTrim((String)inSql)) {
            String deleteSQL = " delete from " + childTableName + " where pk_vochange = '" + oldGroupExchangeVO.getPk_vochange() + "' and " + inSql;
            int n = baseDAO.executeUpdate(deleteSQL);
        }
        if ((addChildrenVOs = mapAddChildren.get(matchPreExchangeVO.getPk_vochange())) != null && addChildrenVOs.size() > 0) {
            ArrayList<SuperVO> groupAddChildrenVOs = new ArrayList<SuperVO>();
            for (SuperVO addChildVO : addChildrenVOs) {
                SuperVO groupAddChildVO = (SuperVO)addChildVO.clone();
                groupAddChildVO.setPrimaryKey(pkGenerator.generate(SQLHelper.getCorpPk()));
                groupAddChildVO.setAttributeValue("pk_vochange", (Object)oldGroupExchangeVO.getPk_vochange());
                if (addChildVO instanceof ExchangeSplitVO) {
                    ((ExchangeSplitVO)groupAddChildVO).setSelected(UFBoolean.TRUE);
                }
                groupAddChildVO.setStatus(2);
                groupAddChildrenVOs.add(groupAddChildVO);
            }
            String[] pks = baseDAO.insertVOArrayWithPK(groupAddChildrenVOs.toArray(new SuperVO[groupAddChildrenVOs.size()]));
            Logger.error((Object)("=============pks===================" + pks.toString()));
        }
    }

    public static <T extends SuperVO> void fillUpgradeVOChangeChildSets(ExchangeVO newPreExchangeVO, ExchangeVO oldExchangeVO, Class<T> childClass, String compareChildField, String[] ignoreCompareValues, String oldVOChangeChildTableName, String addWhereSQL, Map<String, Collection<T>> mapAddChildren, String deleteWhereSQL, Map<String, String> mapDeleteChildrenInSQL) throws BusinessException {
        BaseDAO baseDAO = new BaseDAO();
        Set ignoreCompareValueSet = ArrayUtil.convertToSet((Object[])ignoreCompareValues);
        String addChildrenSQL = " pk_vochange = '" + newPreExchangeVO.getPk_vochange() + "'";
        if (!StringUtil.isEmptyWithTrim((String)addWhereSQL)) {
            addChildrenSQL = addChildrenSQL + " and " + addWhereSQL;
        }
        ArrayList<SuperVO> addChildren = PFExchangeUtil.getUAPQueryBS().retrieveByClause(childClass, addChildrenSQL);
        Logger.error((Object)("=============addChildren.size===================" + addChildren.size()));
        if (addChildren != null && addChildren.size() > 0) {
            if (ignoreCompareValueSet != null && ignoreCompareValueSet.size() > 0) {
                ArrayList<SuperVO> addChildrenAfterIgnore = new ArrayList<SuperVO>();
                for (SuperVO addChild : addChildren) {
                    String compareAttr = (String)addChild.getAttributeValue(compareChildField);
                    if (ignoreCompareValueSet.contains(compareAttr)) continue;
                    addChildrenAfterIgnore.add(addChild);
                }
                addChildren = addChildrenAfterIgnore;
            }
            mapAddChildren.put(newPreExchangeVO.getPk_vochange(), addChildren);
        }
        String deleteChildSQL = " select * from " + oldVOChangeChildTableName + " where pk_vochange = '" + oldExchangeVO.getPk_vochange() + "'";
        if (!StringUtil.isEmptyWithTrim((String)deleteWhereSQL)) {
            deleteChildSQL = deleteChildSQL + " and " + deleteWhereSQL;
        }
        List deleteChildren = (List)baseDAO.executeQuery(deleteChildSQL, (ResultSetProcessor)new BeanListProcessor(childClass));
        ArrayList<String> deleteChildAttrs = new ArrayList<String>(deleteChildren.size());
        if (deleteChildren != null && deleteChildren.size() > 0) {
            for (Object objExchangeChildVO : deleteChildren) {
                SuperVO exchangeChildVO = (SuperVO)objExchangeChildVO;
                String deleteCompareAttr = (String)exchangeChildVO.getAttributeValue(compareChildField);
                if (ignoreCompareValueSet != null && ignoreCompareValueSet.contains(deleteCompareAttr)) continue;
                deleteChildAttrs.add(deleteCompareAttr);
            }
        }
        if (addChildren != null && addChildren.size() > 0) {
            for (SuperVO addChild : addChildren) {
                String addCompareAttr = (String)addChild.getAttributeValue(compareChildField);
                deleteChildAttrs.add(addCompareAttr);
            }
        }
        if (deleteChildAttrs.size() > 0) {
            String inSQL = SQLUtil.buildSqlForIn(compareChildField, deleteChildAttrs.toArray(new String[deleteChildren.size()]));
            mapDeleteChildrenInSQL.put(newPreExchangeVO.getPk_vochange(), inSQL);
        }
    }

    public static IUAPQueryBS getUAPQueryBS() {
        return (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
    }

    public static String getProductExchangeSQL(String productCode, String voChangeAlias) {
        return " exists (select 1 from bd_billtype b where " + (StringUtil.isEmptyWithTrim((String)voChangeAlias) ? "pub_vochange" : voChangeAlias) + ".dest_billtype = b.pk_billtypecode  and b.systemcode = '" + SQLTransferMeaningUtil.tmsql((String)productCode) + "')";
    }

    public static String getProductPreExchangeCondSQL(String productCode, boolean withBusiType) {
        return " pk_group " + SQLUtil.getGlobalInSQL() + (withBusiType ? " and pk_busitype = '~' " : "") + " and " + PFExchangeUtil.getProductExchangeSQL(productCode, null);
    }

    public static String getPreExchangeCondSQL(boolean withBusiType) {
        return " pk_group " + SQLUtil.getGlobalInSQL() + (withBusiType ? " and pk_busitype = '~' " : "");
    }

    public static String getBlurMatchExchangeByBillTypeSQL(String srcType, String destType) {
        String srcBilltype = PfUtilBaseTools.getRealBilltype(srcType);
        String destBilltype = PfUtilBaseTools.getRealBilltype(destType);
        return PFExchangeUtil.getBlurMatchExchangeByBillTypeSQL(srcBilltype, PfUtilBaseTools.isTranstype(srcType) ? srcType : null, destBilltype, PfUtilBaseTools.isTranstype(destType) ? destType : null);
    }

    public static String getBlurMatchExchangeByBillTypeSQL(String srcType, String destType, String pk_group) {
        String srcBilltype = PfUtilBaseTools.getRealBilltypeByGroup(pk_group, srcType);
        String destBilltype = PfUtilBaseTools.getRealBilltypeByGroup(pk_group, destType);
        return PFExchangeUtil.getBlurMatchExchangeByBillTypeSQL(srcBilltype, PfUtilBaseTools.isTranstype(srcType) ? srcType : null, destBilltype, PfUtilBaseTools.isTranstype(destType) ? destType : null);
    }

    public static String getBlurMatchExchangeByBillTypeSQL(String srcBillType, String srcTransType, String destBillType, String destTransType) {
        String srcType = !StringUtil.isEmptyWithTrim((String)srcTransType) ? srcTransType : srcBillType;
        String destType = !StringUtil.isEmptyWithTrim((String)destTransType) ? destTransType : destBillType;
        String bill2billSql = "(src_billtype='" + SQLTransferMeaningUtil.tmsql((String)srcBillType) + "' and isnull(src_transtype,'~')='~' and dest_billtype='" + SQLTransferMeaningUtil.tmsql((String)destBillType) + "' and isnull(dest_transtype,'~')='~')";
        String typeSql = "";
        if (!StringUtil.isEmptyWithTrim((String)srcTransType)) {
            if (!StringUtil.isEmptyWithTrim((String)destTransType)) {
                String trans2billSql = "(src_transtype='" + SQLTransferMeaningUtil.tmsql((String)srcType) + "' and dest_billtype='" + SQLTransferMeaningUtil.tmsql((String)destBillType) + "' and isnull(dest_transtype, '~')='~')";
                String bill2transSql = "(src_billtype='" + SQLTransferMeaningUtil.tmsql((String)srcBillType) + "' and dest_transtype='" + SQLTransferMeaningUtil.tmsql((String)destType) + "' and isnull(src_transtype, '~')='~')";
                typeSql = typeSql + " and ((src_transtype='" + SQLTransferMeaningUtil.tmsql((String)srcType) + "' and dest_transtype='" + SQLTransferMeaningUtil.tmsql((String)destType) + "') or " + trans2billSql + "or " + bill2transSql + "or " + bill2billSql + ")";
            } else {
                typeSql = typeSql + " and ((src_transtype='" + SQLTransferMeaningUtil.tmsql((String)srcType) + "' and dest_billtype='" + SQLTransferMeaningUtil.tmsql((String)destType) + "' and isnull(dest_transtype,'~')='~') or " + bill2billSql + ")";
            }
        } else {
            typeSql = !StringUtil.isEmptyWithTrim((String)destTransType) ? typeSql + " and ((src_billtype='" + SQLTransferMeaningUtil.tmsql((String)srcType) + "' and isnull(src_transtype,'~')='~' and dest_transtype='" + SQLTransferMeaningUtil.tmsql((String)destType) + "') or " + bill2billSql + ")" : typeSql + " and " + bill2billSql;
        }
        return typeSql;
    }

    public static ExchangeVO getMostMatchExchangeVO(ExchangeVO srcVO, Collection<ExchangeVO> destExchangeVOs) {
        ArrayList<ExchangeVO> blurMatchExchangeVOs = new ArrayList<ExchangeVO>();
        for (ExchangeVO exchangeVO : destExchangeVOs) {
            Logger.error((Object)("=============exchangeVO vs srcVO \u30101\u3011===================" + exchangeVO.getPk_vochange() + ":::" + srcVO.getPk_vochange()));
            if (!srcVO.getSrc_billtype().equals(exchangeVO.getSrc_billtype()) || !srcVO.getDest_billtype().equals(exchangeVO.getDest_billtype())) continue;
            boolean match = true;
            match = !StringUtil.isEmptyWithTrim((String)srcVO.getSrc_transtype()) ? StringUtil.isEmptyWithTrim((String)exchangeVO.getSrc_transtype()) || srcVO.getSrc_transtype().equals(exchangeVO.getSrc_transtype()) : StringUtil.isEmptyWithTrim((String)exchangeVO.getSrc_transtype());
            match = !StringUtil.isEmptyWithTrim((String)srcVO.getDest_transtype()) ? StringUtil.isEmptyWithTrim((String)exchangeVO.getDest_transtype()) || srcVO.getDest_transtype().equals(exchangeVO.getDest_transtype()) : StringUtil.isEmptyWithTrim((String)exchangeVO.getDest_transtype());
            if (!match) continue;
            blurMatchExchangeVOs.add(exchangeVO);
            Logger.error((Object)("=============exchangeVO vs srcVO \u30102\u3011===================" + exchangeVO.getPk_vochange() + ":::" + srcVO.getPk_vochange()));
        }
        return PFExchangeUtil.getMostExactExchangeVO(blurMatchExchangeVOs, null);
    }

    public static ExchangeVO getMostExactExchangeVO(Collection<ExchangeVO> exchangeVOs, ExchangeVO excludeVO) {
        ExchangeVO resultVO = null;
        for (ExchangeVO exchangeVO : exchangeVOs) {
            if (excludeVO != null && exchangeVO.getPrimaryKey().equals(excludeVO.getPrimaryKey())) continue;
            if (resultVO == null) {
                resultVO = exchangeVO;
            }
            if (!PFExchangeUtil.isLastSuitable(resultVO, exchangeVO)) continue;
            resultVO = exchangeVO;
        }
        return resultVO;
    }

    public static boolean isLastSuitable(ExchangeVO resultVO, ExchangeVO exchangeVO) {
        if (!PFExchangeUtil.isEqual(resultVO.getSrc_transtype(), exchangeVO.getSrc_transtype())) {
            return StringUtil.isEmptyWithTrim((String)resultVO.getSrc_transtype());
        }
        if (!PFExchangeUtil.isEqual(resultVO.getDest_transtype(), exchangeVO.getDest_transtype())) {
            return StringUtil.isEmptyWithTrim((String)resultVO.getDest_transtype());
        }
        if (StringUtil.isEmptyWithTrim((String)resultVO.getPk_busitype())) {
            return StringUtil.isEmptyWithTrim((String)resultVO.getPk_group()) || !StringUtil.isEmptyWithTrim((String)exchangeVO.getPk_group()) && !"global00000000000000".equals(exchangeVO.getPk_group());
        }
        return false;
    }

    private static boolean isEqual(String str1, String str2) {
        if (!StringUtil.isEmptyWithTrim((String)str1)) {
            if (StringUtil.isEmptyWithTrim((String)str2)) {
                return false;
            }
            return str1.trim().equals(str2.trim());
        }
        return StringUtil.isEmptyWithTrim((String)str2);
    }
}

