/*
 * Decompiled with CFR 0.152.
 */
package nc.ui.pub.desktop;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import nc.bs.logging.Logger;
import nc.ui.pub.desktop.PojoTableModelDescriptor;
import nc.vo.pf.pub.util.ArrayUtil;

public class PojoTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 8129686307432703875L;
    private PojoTableModelDescriptor<T> descriptor = null;
    private List<T> content = new ArrayList<T>();
    private Map<String, Method> readMethodMap = new HashMap<String, Method>();
    private Map<String, Method> writeMethodMap = new HashMap<String, Method>();

    public PojoTableModel(PojoTableModelDescriptor<T> descriptor) {
        this.setDescriptor(descriptor);
    }

    public void setDescriptor(PojoTableModelDescriptor<T> descriptor) {
        this.descriptor = descriptor;
        this.init();
    }

    public PojoTableModelDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    private void init() {
        if (this.descriptor == null) {
            throw new IllegalArgumentException("descriptor is null!");
        }
        Method[] methods = this.descriptor.getPojoClazz().getMethods();
        HashSet<String> fieldSet = new HashSet<String>();
        int size = this.descriptor.getColumnCount();
        for (int i = 0; i < size; ++i) {
            fieldSet.add(this.descriptor.getColumnField(i).toLowerCase());
        }
        for (Method m : methods) {
            String key;
            String mn = m.getName();
            if (mn.startsWith("is")) {
                key = mn.replaceFirst("is", "").toLowerCase();
                if (!fieldSet.contains(key)) continue;
                this.readMethodMap.put(key, m);
                continue;
            }
            if (mn.startsWith("get")) {
                key = mn.replaceFirst("get", "").toLowerCase();
                if (!fieldSet.contains(key)) continue;
                this.readMethodMap.put(key, m);
                continue;
            }
            if (!mn.startsWith("set") || !fieldSet.contains(key = mn.replaceFirst("set", "").toLowerCase())) continue;
            this.writeMethodMap.put(key, m);
        }
    }

    public void add(T object) {
        this.content.add(object);
        this.fireTableDataChanged();
    }

    public void add(T[] object) {
        this.add((Collection<T>)Arrays.asList(object));
    }

    public void add(Collection<T> objects) {
        this.content.addAll(objects);
        this.fireTableDataChanged();
    }

    public T get(int row) {
        return this.content.get(row);
    }

    public T[] getAll() {
        if (this.content.size() == 0) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(this.content.get(0).getClass(), this.content.size());
        int count = this.content.size();
        for (int i = 0; i < count; ++i) {
            array[i] = this.content.get(i);
        }
        return array;
    }

    public T remove(int row) {
        T t = this.content.remove(row);
        this.fireTableDataChanged();
        return t;
    }

    public void remove(T ... rows) {
        if (ArrayUtil.isNull((Object[])rows)) {
            return;
        }
        for (T row : rows) {
            this.content.remove(row);
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        this.content.clear();
        this.fireTableDataChanged();
    }

    public int indexOf(T object) {
        return this.content.indexOf(object);
    }

    @Override
    public int getRowCount() {
        return this.content.size();
    }

    @Override
    public int getColumnCount() {
        return this.descriptor.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.descriptor.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.descriptor.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.descriptor.isColumnEditable(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        T object = this.get(rowIndex);
        String key = this.descriptor.getColumnField(columnIndex);
        return this.getValueAt(object, key);
    }

    protected Object getValueAt(T row, String fieldName) {
        Method readMethod = this.readMethodMap.get(fieldName);
        try {
            if (readMethod != null) {
                return readMethod.invoke(row, new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        T object = this.get(rowIndex);
        String key = this.descriptor.getColumnField(columnIndex);
        this.setValueAt(object, key, aValue);
    }

    protected void setValueAt(T rowContent, String fieldName, Object value) {
        Method writeMethod = this.writeMethodMap.get(fieldName);
        try {
            if (writeMethod != null) {
                writeMethod.invoke(rowContent, value);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

