/*
 * Decompiled with CFR 0.152.
 */
package nc.uap.pf.metadata;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.pf.pub.BillTypeCacheKey;
import nc.bs.pf.pub.PfDataCache;
import nc.md.MDBaseQueryFacade;
import nc.md.data.access.NCObject;
import nc.md.model.IAttribute;
import nc.md.model.IBusinessEntity;
import nc.md.model.IComponent;
import nc.md.model.type.ICollectionType;
import nc.md.model.type.IType;
import nc.md.util.MDUtil;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.uap.pf.PFBusinessException;
import nc.vo.uap.pf.PFRuntimeException;

public class PfMetadataTools {
    public static String getDisplayName(String strPath, IBusinessEntity be) {
        int npos = strPath.indexOf(46);
        if (npos < 0) {
            IAttribute attr = be.getAttributeByName(strPath);
            if (attr == null) {
                return null;
            }
            return attr.getDisplayName();
        }
        StringBuffer sb = new StringBuffer();
        String[] paths = strPath.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            StringBuffer s = new StringBuffer();
            for (int j = 0; j <= i; ++j) {
                s.append(".");
                s.append(paths[j]);
            }
            String finalStr = null;
            finalStr = s.length() > 0 ? s.substring(1) : s.toString();
            IAttribute attr = be.getAttributeByPath(finalStr);
            sb.append(".");
            sb.append(attr.getDisplayName());
        }
        if (sb.length() > 0) {
            return sb.substring(1);
        }
        return sb.toString();
    }

    public static boolean isObjectArray(Object obj) {
        if (obj == null) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000022"));
        }
        return obj.getClass().isArray();
    }

    public static int validEntityArray(Object billEntity) {
        if (billEntity == null) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000023"));
        }
        try {
            int iLen = Array.getLength(billEntity);
            if (iLen == 0) {
                throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000024"));
            }
            return iLen;
        }
        catch (IllegalArgumentException e) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000025"));
        }
    }

    public static void checkBilltypeRelatedMeta(String strTypeCode) {
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(strTypeCode).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId()));
        if (btVO == null) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000026", null, new String[]{strTypeCode}));
        }
        boolean hasMeta = false;
        if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            hasMeta = !StringUtil.isEmptyWithTrim((String)(btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(btVO.getParentbilltype()))).getComponent());
        } else {
            boolean bl = hasMeta = !StringUtil.isEmptyWithTrim((String)btVO.getComponent());
        }
        if (!hasMeta) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000027", null, new String[]{strTypeCode}));
        }
    }

    public static void checkBilltypeRelatedMeta(String strTypeCode, String pk_group) {
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(strTypeCode).buildPkGroup(pk_group));
        if (btVO == null) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000026", null, new String[]{strTypeCode}));
        }
        boolean hasMeta = false;
        if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            hasMeta = !StringUtil.isEmptyWithTrim((String)(btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(btVO.getParentbilltype()))).getComponent());
        } else {
            boolean bl = hasMeta = !StringUtil.isEmptyWithTrim((String)btVO.getComponent());
        }
        if (!hasMeta) {
            throw new PFRuntimeException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000027", null, new String[]{strTypeCode}));
        }
    }

    public static IBusinessEntity queryMetaOfBilltype(String strTypeCode) throws BusinessException {
        IComponent comp = PfMetadataTools.queryComponentOfBilltype(strTypeCode);
        if (comp == null) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000028", null, new String[]{strTypeCode}));
        }
        return comp.getPrimaryBusinessEntity();
    }

    public static IBusinessEntity queryMetaOfBilltype(String strTypeCode, String pk_group) throws BusinessException {
        IComponent comp = PfMetadataTools.queryComponentOfBilltype(strTypeCode, pk_group);
        if (comp == null) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000028", null, new String[]{strTypeCode}));
        }
        return comp.getPrimaryBusinessEntity();
    }

    public static IComponent queryComponentOfBilltype(String strTypeCode) throws BusinessException {
        PfMetadataTools.checkBilltypeRelatedMeta(strTypeCode);
        BilltypeVO btVO = PfDataCache.getBillType(new BillTypeCacheKey().buildBilltype(strTypeCode).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId()));
        String strComp = btVO.getComponent();
        if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(btVO.getParentbilltype()));
            strComp = btVO.getComponent();
        }
        if (StringUtil.isEmptyWithTrim((String)strComp)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000028", null, new String[]{strTypeCode}));
        }
        return MDBaseQueryFacade.getInstance().getComponentByName(strComp.trim());
    }

    public static IComponent queryComponentOfBilltype(String strTypeCode, String pk_group) throws BusinessException {
        PfMetadataTools.checkBilltypeRelatedMeta(strTypeCode, pk_group);
        BilltypeVO btVO = PfDataCache.getBillType(new BillTypeCacheKey().buildBilltype(strTypeCode).buildPkGroup(pk_group));
        String strComp = btVO.getComponent();
        if (btVO.getIstransaction() != null && btVO.getIstransaction().booleanValue()) {
            btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(btVO.getParentbilltype()));
            strComp = btVO.getComponent();
        }
        if (StringUtil.isEmptyWithTrim((String)strComp)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000028", null, new String[]{strTypeCode}));
        }
        return MDBaseQueryFacade.getInstance().getComponentByName(strComp.trim());
    }

    public static <T> T getBizItfImpl(Object billVo, Class<T> clz) {
        NCObject ncobj = NCObject.newInstance((Object)billVo);
        boolean itfHasImpl = ((IBusinessEntity)ncobj.getRelatedBean()).isImplementBizInterface(clz.getName());
        if (!itfHasImpl) {
            return null;
        }
        return (T)ncobj.getBizInterface(clz);
    }

    public static String[] queryChildAttributes(String billOrTranstype) throws BusinessException {
        IBusinessEntity be = PfMetadataTools.queryMetaOfBilltype(billOrTranstype);
        ArrayList<String> alRet = new ArrayList<String>();
        List alAttr = be.getAttributes();
        for (IAttribute attr : alAttr) {
            IType t = attr.getDataType();
            if (!MDUtil.isMDBean((IType)t) && !MDUtil.isCollectionType((IType)t)) continue;
            alRet.add(attr.getName());
        }
        return alRet.toArray(new String[0]);
    }

    public static IBusinessEntity getBusinessEntityOfAttr(IAttribute attr) {
        IBusinessEntity abe = null;
        if (MDUtil.isCollectionType((IType)attr.getDataType())) {
            ICollectionType col = (ICollectionType)attr.getDataType();
            if (MDUtil.isMDBean((IType)col.getElementType())) {
                abe = (IBusinessEntity)col.getElementType();
            }
        } else if (MDUtil.isMDBean((IType)attr.getDataType())) {
            abe = (IBusinessEntity)attr.getDataType();
        }
        return abe;
    }
}

