/*
 * Decompiled with CFR 0.152.
 */
package nc.uap.pf.metadata;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nc.bs.dao.BaseDAO;
import nc.bs.logging.Logger;
import nc.itf.uap.pf.metadata.IHeadBodyQueryItf;
import nc.md.common.AssociationKind;
import nc.md.data.access.NCObject;
import nc.md.model.IAssociation;
import nc.md.model.IBean;
import nc.md.model.IBusinessEntity;
import nc.md.model.access.javamap.AggVOStyle;
import nc.md.model.access.javamap.IBeanStyle;
import nc.md.persist.framework.MDPersistenceService;
import nc.uap.pf.metadata.AbstractBizInterfaceImpl;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.uap.pf.PFBusinessException;

public class HeadBodyQueryImpl
extends AbstractBizInterfaceImpl
implements IHeadBodyQueryItf {
    public HeadBodyQueryImpl(NCObject ncObj) {
        super(ncObj);
        this.initByBizItf(IHeadBodyQueryItf.class.getName());
    }

    @Override
    public CircularlyAccessibleValueObject[] queryAllBodyData(String billType, String headPK, String whereString) throws BusinessException {
        IBusinessEntity be = PfMetadataTools.queryMetaOfBilltype(billType);
        IBeanStyle bs = be.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000000"));
        }
        List relatedBeans = be.getRelatedEntities(AssociationKind.Composite, 2);
        if (relatedBeans.size() == 0) {
            return null;
        }
        IBean relatedBean = (IBean)relatedBeans.iterator().next();
        if (relatedBean == null) {
            return null;
        }
        Class<?> c = null;
        try {
            c = Class.forName(relatedBean.getFullClassName());
        }
        catch (ClassNotFoundException e) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000001"), e);
        }
        String strPkField = relatedBean.getTable().getForeignKeyWithEndTable(be.getTable()).getStartColumn().getName();
        String strWhere = null;
        strWhere = strPkField + "='" + headPK + "'";
        if (whereString != null) {
            strWhere = strWhere + " and (" + whereString + ")";
        }
        strWhere = strWhere + " and (isnull(dr,0)=0) ";
        BaseDAO dao = new BaseDAO();
        Collection coBodys = dao.retrieveByClause(c, strWhere);
        CircularlyAccessibleValueObject[] bodyVos = (CircularlyAccessibleValueObject[])Array.newInstance(c, coBodys.size());
        int i = 0;
        for (CircularlyAccessibleValueObject body : coBodys) {
            bodyVos[i++] = body;
        }
        return bodyVos;
    }

    @Override
    public CircularlyAccessibleValueObject[] queryAllHeadData(String billType, String whereString) throws BusinessException {
        IBusinessEntity bean = PfMetadataTools.queryMetaOfBilltype(billType);
        Class<?> c = null;
        try {
            c = Class.forName(bean.getFullClassName());
        }
        catch (ClassNotFoundException e) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000002"), e);
        }
        BaseDAO dao = new BaseDAO();
        Collection coRet = dao.retrieveByClause(c, whereString);
        CircularlyAccessibleValueObject[] heads = coRet.toArray(new CircularlyAccessibleValueObject[0]);
        return heads;
    }

    @Override
    public CircularlyAccessibleValueObject queryHeadData(String billType, String billId) throws BusinessException {
        IBusinessEntity bean = PfMetadataTools.queryMetaOfBilltype(billType);
        Class<?> c = null;
        try {
            c = Class.forName(bean.getFullClassName());
        }
        catch (ClassNotFoundException e) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000002"), e);
        }
        BaseDAO dao = new BaseDAO();
        Object objRet = dao.retrieveByPK(c, billId);
        return (CircularlyAccessibleValueObject)objRet;
    }

    @Override
    public AggregatedValueObject queryAggData(String billType, String billId) throws BusinessException {
        IBusinessEntity be = PfMetadataTools.queryMetaOfBilltype(billType);
        IBeanStyle bs = be.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000000"));
        }
        Logger.debug((Object)"do nothing");
        Class<?> c = null;
        try {
            c = Class.forName(be.getFullClassName());
            NCObject ncobj = MDPersistenceService.lookupPersistenceQueryService().queryBillOfNCObjectByPKWithDR(c, billId, true);
            if (ncobj == null) {
                return null;
            }
            return (AggregatedValueObject)ncobj.getContainmentObject();
        }
        catch (ClassNotFoundException e) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000002"), e);
        }
    }

    @Override
    public HashMap<String, CircularlyAccessibleValueObject[]> queryBodyDataByCode(String billType, String headPK, HashMap<String, String> tableCode2Where) throws BusinessException {
        HashMap<String, CircularlyAccessibleValueObject[]> hmRet = new HashMap<String, CircularlyAccessibleValueObject[]>();
        IBusinessEntity be = PfMetadataTools.queryMetaOfBilltype(billType);
        IBeanStyle bs = be.getBeanStyle();
        if (!(bs instanceof AggVOStyle)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000000"));
        }
        List assos = be.getAssociationsByKind(AssociationKind.Composite, 2);
        HashMap<String, IBean> hmChildBean = new HashMap<String, IBean>();
        for (IAssociation asso : assos) {
            hmChildBean.put(asso.getStartAttribute().getName(), asso.getEndBean());
        }
        for (String tCode : tableCode2Where.keySet()) {
            IBean childBean = (IBean)hmChildBean.get(tCode);
            if (childBean == null) {
                throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000003", null, new String[]{tCode}));
            }
            Class<?> c = null;
            try {
                c = Class.forName(childBean.getFullClassName());
            }
            catch (ClassNotFoundException e) {
                throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "HeadBodyQueryImpl-000001"), e);
            }
            String strPkField = childBean.getTable().getForeignKeyWithEndTable(be.getTable()).getStartColumn().getName();
            String strWhere = strPkField + "='" + headPK + "'";
            String bodyWhere = tableCode2Where.get(tCode);
            if (bodyWhere != null) {
                strWhere = strWhere + " and (" + bodyWhere + ")";
            }
            strWhere = strWhere + " and (isnull(dr,0)=0) ";
            BaseDAO dao = new BaseDAO();
            Collection coBodys = dao.retrieveByClause(c, strWhere);
            CircularlyAccessibleValueObject[] bodyVos = (CircularlyAccessibleValueObject[])Array.newInstance(c, coBodys.size());
            int i = 0;
            for (CircularlyAccessibleValueObject body : coBodys) {
                bodyVos[i++] = body;
            }
            hmRet.put(tCode, bodyVos);
        }
        return hmRet;
    }
}

