/*
 * Decompiled with CFR 0.152.
 */
package nc.mailapprove.bs;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import nc.bs.logging.Logger;
import nc.mailapprove.pub.IMailApproveResultHandler;
import nc.mailapprove.pub.MailApproveResult;

public class MailReceiver {
    private String pop3Host = null;
    private String username = null;
    private String password = null;
    private boolean isAuthen = true;

    public MailReceiver(String pop3Host, String username, String password) {
        this.pop3Host = pop3Host;
        this.username = username;
        this.password = password;
    }

    public MailReceiver(String pop3Host, String username, String password, boolean isAuthen) {
        this.pop3Host = pop3Host;
        this.username = username;
        this.password = password;
        this.isAuthen = isAuthen;
    }

    private Session createSession(String ssl) {
        Properties props = new Properties();
        if (ssl != null) {
            props.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.pop3.socketFactory.fallback", "false");
            props.setProperty("mail.pop3.port", "995");
            props.setProperty("mail.pop3.socketFactory.port", "995");
        }
        if (this.isAuthen) {
            props.put("mail.smtp.auth", "true");
        }
        return Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailReceiver.this.username, MailReceiver.this.password);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MailApproveResult> fetchMailApproveResult(IMailApproveResultHandler handler) throws Exception {
        Store store = null;
        Folder folder = null;
        ArrayList<MailApproveResult> list = new ArrayList<MailApproveResult>();
        try {
            Session session = this.createSession(null);
            store = session.getStore("pop3");
            store.connect(this.pop3Host, this.username, this.password);
            folder = store.getFolder("INBOX");
            folder.open(2);
            Message[] msgs = folder.getMessages();
            int count = msgs == null ? 0 : msgs.length;
            for (int i = 0; i < count; ++i) {
                Message message = msgs[i];
                try {
                    MailApproveResult result = handler.handleMessage(message);
                    if (result == null) continue;
                    message.setFlag(Flags.Flag.DELETED, true);
                    list.add(result);
                    continue;
                }
                catch (Exception e) {
                    Logger.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            List<MailApproveResult> list2 = this.fetchMailApproveResult(handler, "ssl");
            return list2;
        }
        finally {
            if (folder != null) {
                folder.close(true);
            }
            if (store != null) {
                store.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MailApproveResult> fetchMailApproveResult(IMailApproveResultHandler handler, String ssl) throws Exception {
        Store store = null;
        Folder folder = null;
        ArrayList<MailApproveResult> list = new ArrayList<MailApproveResult>();
        try {
            Session session = this.createSession(ssl);
            store = session.getStore("pop3");
            store.connect(this.pop3Host, this.username, this.password);
            folder = store.getFolder("INBOX");
            folder.open(2);
            Message[] msgs = folder.getMessages();
            int count = msgs == null ? 0 : msgs.length;
            for (int i = 0; i < count; ++i) {
                Message message = msgs[i];
                try {
                    MailApproveResult result = handler.handleMessage(message);
                    if (result == null) continue;
                    message.setFlag(Flags.Flag.DELETED, true);
                    list.add(result);
                    continue;
                }
                catch (Exception e) {
                    Logger.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            Logger.error((Object)e);
        }
        finally {
            if (folder != null) {
                folder.close(true);
            }
            if (store != null) {
                store.close();
            }
        }
        return list;
    }
}

