/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.wf.attrment;

import com.yonyou.cloud.common.AbstractCommonConfigKey;
import com.yonyou.cloud.common.IConfigKey;
import com.yonyou.cloud.iuap.iris.IrisNCLocator;
import com.yonyou.cloud.middleware.MiddlewareRuntimeEnvironment;
import com.yonyou.cloud.ncc.NCCEnv;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.core.util.ObjectCreator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.wf.attrment.IBillAttrment;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.BusinessRuntimeException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFBoolean;
import nccloud.commons.lang.StringUtils;
import nccloud.pubitf.riart.pf.INccPFCrossServiceQuery;
import nccloud.pubitf.riart.pf.INccWorkflowComponentExe;

public class BillAttrmentUtil {
    private Map<String, IBillAttrment> plugin_map = null;

    public String getBillAttrRootPath(String billtype, String billID) throws BusinessException {
        if (!NCCEnv.isMerged()) {
            BilltypeVO billtypeVO = PfDataCache.getBillType(billtype);
            billtype = StringUtils.isNotBlank((CharSequence)billtypeVO.getParentbilltype()) ? billtypeVO.getParentbilltype() : billtype;
            BilltypeVO billtypeFaVO = PfDataCache.getBillType(billtype);
            String systemcode = billtypeFaVO.getSystemcode();
            String currentServerName = (String)MiddlewareRuntimeEnvironment.get((IConfigKey)AbstractCommonConfigKey.APP_CODE);
            String serverName = IrisNCLocator.getInstance().getServiceByModule(systemcode);
            if (!StringUtils.isEmpty((CharSequence)serverName) && !currentServerName.equalsIgnoreCase(serverName)) {
                INccWorkflowComponentExe nccWorkflowComponentExe = (INccWorkflowComponentExe)IrisNCLocator.getInstance().lookup(INccWorkflowComponentExe.class, serverName);
                return nccWorkflowComponentExe.getBillAttrRootPath(billtype, billID);
            }
            return this.getLocalBillAttrRootPath(billtype, billID);
        }
        return this.getLocalBillAttrRootPath(billtype, billID);
    }

    private String getLocalBillAttrRootPath(String billtype, String billID) throws BusinessException {
        IBillAttrment plugin = this.getBillAttrPlugin(billtype);
        if (plugin == null) {
            return billID;
        }
        return plugin.getBillAttrRootPath(billtype, billID);
    }

    private IBillAttrment getBillAttrPlugin(String billtype) throws BusinessException {
        try {
            BilltypeVO billtypeVO;
            if (this.plugin_map == null) {
                this.initPlugin();
            }
            if ((billtypeVO = PfDataCache.getBillType(billtype)) == null) {
                return null;
            }
            billtype = StringUtils.isNotBlank((CharSequence)billtypeVO.getParentbilltype()) ? billtypeVO.getParentbilltype() : billtype;
            IBillAttrment plugin = this.plugin_map.get(billtype);
            if (plugin == null) {
                plugin = this.plugin_map.get(billtypeVO.getSystemcode());
            }
            return plugin;
        }
        catch (DAOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    private void initPlugin() throws DAOException {
        BaseDAO dao = new BaseDAO();
        try {
            INccPFCrossServiceQuery service = (INccPFCrossServiceQuery)NCLocator.getInstance().lookup(INccPFCrossServiceQuery.class.getName());
            List list = (List)dao.executeQuery("select billtype,module,pluginclassname from pub_attr_plugin", (ResultSetProcessor)new ArrayListProcessor());
            this.plugin_map = new HashMap<String, IBillAttrment>();
            for (Object[] objs : list) {
                String billtype = (String)objs[0];
                String module = (String)objs[1];
                String pluginclassname = (String)objs[2];
                UFBoolean uf = service.isCrossServiceByDevmodule(module);
                if (uf.booleanValue()) continue;
                IBillAttrment plugin = BillAttrmentUtil.createInstance(pluginclassname, module);
                this.plugin_map.put(billtype, plugin);
            }
        }
        catch (Exception e) {
            throw new DAOException(e.getMessage(), (Throwable)e);
        }
    }

    private static IBillAttrment createInstance(String className, String devModuleCode) {
        IBillAttrment instance = null;
        className = className.trim();
        try {
            if (StringUtil.isEmptyWithTrim((String)devModuleCode)) {
                instance = (IBillAttrment)ObjectCreator.newInstance((String)className);
            } else {
                try {
                    instance = (IBillAttrment)ObjectCreator.newInstance((String)devModuleCode, (String)className);
                }
                catch (Exception e) {
                    Logger.error((Object)("cann't create instance. ClassName: " + className + ", devModuleCode:" + devModuleCode + ". Please check register info in table pub_attr_plugin\n"));
                    Logger.error((Object)"try to create instance without devModuleCode.");
                    instance = (IBillAttrment)ObjectCreator.newInstance((String)className);
                }
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException("cann't create instance in all devModuleCode. ClassName: " + className + ". Please check register info in table pub_attr_plugin");
        }
        return instance;
    }
}

