/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.uap.pf.process;

import java.util.ArrayList;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pub.pf.IProcessPersistListener;
import nc.bs.pub.pf.PfUtilTools;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.billtype2.ExtendedClassEnum;
import nc.vo.wfengine.definition.WorkflowDefinitionVO;

public class ProcessPersistListenerWrapper
implements IProcessPersistListener {
    IProcessPersistListener[] listeners = null;

    public ProcessPersistListenerWrapper(String billType) throws BusinessException {
        this.listeners = this.getListeners(billType);
    }

    @Override
    public void beforeSave(WorkflowDefinitionVO def) throws BusinessException {
        for (IProcessPersistListener listener : this.listeners) {
            listener.beforeSave(def);
        }
    }

    @Override
    public void afterSave(WorkflowDefinitionVO oldDef, WorkflowDefinitionVO newDef) throws BusinessException {
        for (IProcessPersistListener listener : this.listeners) {
            listener.afterSave(oldDef, newDef);
        }
    }

    @Override
    public void afterDelete(WorkflowDefinitionVO def) throws BusinessException {
        for (IProcessPersistListener listener : this.listeners) {
            listener.afterDelete(def);
        }
    }

    private IProcessPersistListener[] getListeners(String billType) throws BusinessException {
        ArrayList<Billtype2VO> b2voList = PfDataCache.getBillType2Info(billType, ExtendedClassEnum.PROCESS_PERSIST_LISTENER.getIntValue());
        if (b2voList == null || b2voList.size() == 0) {
            return new IProcessPersistListener[0];
        }
        IProcessPersistListener[] listeners = new IProcessPersistListener[b2voList.size()];
        int count = b2voList.size();
        for (int i = 0; i < count; ++i) {
            IProcessPersistListener listener;
            Billtype2VO b2vo = (Billtype2VO)((Object)b2voList.get(i));
            String className = b2vo.getClassname();
            String realBillType = b2vo.getPk_billtype();
            listeners[i] = listener = (IProcessPersistListener)PfUtilTools.instantizeObject(realBillType, className);
        }
        return listeners;
    }

    public int getListenerCount() {
        return this.listeners.length;
    }
}

