/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.workflowqry.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.BillTypeCacheKey;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.ICacheDataQueryCallback;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.itf.org.IBasicOrgUnitQryService;
import nc.itf.pub.workflowqry.IWorkflowRefactor;
import nc.itf.uap.IUAPQueryBS;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.ui.pf.multilang.PfMultiLangUtil;
import nc.vo.org.OrgVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.sm.UserVO;
import nc.vo.uap.pf.PFBusinessException;

public class WorkflowRefactorCache {
    private static Map<String, IWorkflowRefactor> refactorCache = new WeakHashMap<String, IWorkflowRefactor>();
    private static IUAPQueryBS qryService = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWorkflowRefactor getRefactorInstance(String className) throws BusinessException {
        if (!refactorCache.containsKey(className)) {
            Map<String, IWorkflowRefactor> map = refactorCache;
            synchronized (map) {
                if (!refactorCache.containsKey(className)) {
                    try {
                        IWorkflowRefactor qry = (IWorkflowRefactor)Class.forName(className).newInstance();
                        refactorCache.put(className, qry);
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new PFBusinessException("Error instantiating refactor object: " + className, e);
                    }
                }
            }
        }
        return refactorCache.get(className);
    }

    public static UserVO getUserById(final String cuserid) throws BusinessException {
        CondStringKey key = new CondStringKey(WorkflowRefactorCache.class.getName() + "getUserById", cuserid);
        ICacheDataQueryCallback<UserVO> callback = new ICacheDataQueryCallback<UserVO>(){

            public UserVO queryData() throws BusinessException {
                return (UserVO)qryService.retrieveByPK(UserVO.class, cuserid);
            }
        };
        return (UserVO)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }

    public static String getUserNameById(String cuserid) throws BusinessException {
        UserVO uvo = WorkflowRefactorCache.getUserById(cuserid);
        return uvo == null ? "" : PfMultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)uvo, "user_name");
    }

    public static String getBilltypeNameByCode(String billtype) {
        String billtypeName = null;
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        BilltypeVO billtypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(billtype).buildPkGroup(pk_group));
        if (billtypeVO != null) {
            billtypeName = billtypeVO.getBilltypenameOfCurrLang();
            if (billtypeVO.getIstransaction() != null && billtypeVO.getIstransaction().booleanValue()) {
                billtypeName = billtypeVO.getBilltypenameOfCurrLang();
            }
        }
        return billtypeName;
    }

    public static String getBilltypeTranNameByCode(String billtype) {
        String billtypeName = null;
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        BilltypeVO billtypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(billtype).buildPkGroup(pk_group));
        if (billtypeVO != null && billtypeVO.getIstransaction() != null && billtypeVO.getIstransaction().booleanValue()) {
            billtypeName = billtypeVO.getBilltypenameOfCurrLang();
        }
        return billtypeName;
    }

    public static Map<String, Object> getParentBilltypeByBilltype(String billtype) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parentbilltype", billtype);
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        BilltypeVO billtypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(billtype).buildPkGroup(pk_group));
        if (billtypeVO != null && billtypeVO.getIstransaction() != null && billtypeVO.getIstransaction().booleanValue()) {
            map.put("parentbilltype", billtypeVO.getParentbilltype());
            map.put("billtype", billtypeVO.getBilltypenameOfCurrLang());
        }
        return map;
    }

    public static OrgVO getOrgByPk(final String pk_org) throws BusinessException {
        CondStringKey key = new CondStringKey(WorkflowRefactorCache.class.getName() + "getOrgByPk", pk_org);
        ICacheDataQueryCallback<OrgVO> callback = new ICacheDataQueryCallback<OrgVO>(){

            public OrgVO queryData() throws BusinessException {
                IBasicOrgUnitQryService orgUnitQryService = (IBasicOrgUnitQryService)NCLocator.getInstance().lookup(IBasicOrgUnitQryService.class);
                OrgVO org = orgUnitQryService.getOrg(pk_org);
                return org;
            }
        };
        return (OrgVO)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }

    public static String getOrgNameByPk(String pk_org) throws BusinessException {
        OrgVO orgvo = WorkflowRefactorCache.getOrgByPk(pk_org);
        return orgvo == null ? "" : PfMultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)orgvo, "name");
    }

    public static String getPk_orgOfInstance(final String pk_wf_instance) throws BusinessException {
        CondStringKey key = new CondStringKey(WorkflowRefactorCache.class.getName() + "getPk_orgOfInstance", pk_wf_instance);
        ICacheDataQueryCallback<String> callback = new ICacheDataQueryCallback<String>(){

            public String queryData() throws BusinessException {
                String sql = "select pk_org from pub_workflownote n join pub_wf_task t on n.pk_wf_task=t.pk_wf_task where t.pk_wf_instance=?";
                SQLParameter param = new SQLParameter();
                param.addParam(pk_wf_instance);
                return (String)qryService.executeQuery(sql, param, (ResultSetProcessor)new ColumnProcessor());
            }
        };
        return (String)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }
}

