/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.workflowqry.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pub.workflowqry.impl.WorkflowRefactorCache;
import nc.itf.pub.workflowqry.IWorkflowRefactor;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IWorkflowAdmin;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.workflowqry.WorkflowQueryResult;
import nc.vo.wfengine.core.util.DurationUnit;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.ProcessInstanceResult;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;
import nc.vo.workflow.admin.FlowOverdueVO;
import nc.vo.workflow.admin.WorkflowManageContext;

public class DefaultInstanceRefactor
implements IWorkflowRefactor {
    @Override
    public List<WorkflowQueryResult> refactorBS(List<Object[]> toBeRefactored) throws BusinessException {
        ArrayList<WorkflowQueryResult> list = new ArrayList<WorkflowQueryResult>();
        IWorkflowAdmin admin = (IWorkflowAdmin)NCLocator.getInstance().lookup(IWorkflowAdmin.class);
        ArrayList<String> pkList = new ArrayList<String>();
        for (Object[] row : toBeRefactored) {
            Object[] result = new Object[12];
            String billmaker = this.getStrFromObj(row[0]);
            String startts = this.getStrFromObj(row[1]);
            String endts = this.getStrFromObj(row[2]);
            String billtype = this.getStrFromObj(row[3]);
            String billno = this.getStrFromObj(row[4]);
            String billid = this.getStrFromObj(row[5]);
            String pk_org = this.getStrFromObj(row[6]);
            Integer procstatus = this.getIntFromObj(row[7]);
            String procresult = this.getStrFromObj(row[8]);
            Integer workflow_type = this.getIntFromObj(row[9]);
            String pk_wf_instance = this.getStrFromObj(row[10]);
            pkList.add(pk_wf_instance);
            if (StringUtil.isEmptyWithTrim((String)pk_org)) {
                pk_org = WorkflowRefactorCache.getPk_orgOfInstance(pk_wf_instance);
            }
            WorkflowManageContext context = new WorkflowManageContext();
            context.setBillId(billid);
            context.setBillNo(billno);
            context.setBillType(billtype);
            context.setApproveStatus(procstatus);
            context.setFlowType(workflow_type);
            context.setFlowinstancePk(pk_wf_instance);
            result[0] = WorkflowRefactorCache.getUserNameById(billmaker);
            result[1] = this.getCheckmanNames(billid);
            UFDateTime beginTime = null;
            UFDateTime endTime = null;
            if (!StringUtil.isEmptyWithTrim((String)startts)) {
                beginTime = new UFDateTime(startts);
                result[2] = beginTime;
            }
            if (!StringUtil.isEmptyWithTrim((String)endts)) {
                endTime = new UFDateTime(endts);
                result[3] = endTime;
            }
            String billTypeName = WorkflowRefactorCache.getBilltypeNameByCode(billtype);
            result[6] = billTypeName;
            result[7] = billno;
            result[8] = WorkflowRefactorCache.getOrgNameByPk(pk_org);
            WfTaskOrInstanceStatus status = WfTaskOrInstanceStatus.fromIntValue(Integer.parseInt(String.valueOf(procstatus)));
            result[9] = status == null ? "" : status.toString();
            ProcessInstanceResult instResult = ProcessInstanceResult.fromStrValue(String.valueOf(procresult));
            result[10] = instResult == null ? "" : instResult.toString();
            WorkflowTypeEnum type = WorkflowTypeEnum.fromIntValue(Integer.parseInt(String.valueOf(workflow_type)));
            result[11] = type == null ? "" : type.toString();
            list.add(new WorkflowQueryResult(pk_wf_instance, result, row, context));
        }
        Map<String, FlowOverdueVO> overdueMap = admin.getFlowInstanceOverdue(pkList.toArray(new String[pkList.size()]));
        for (WorkflowQueryResult qryResult : list) {
            String duration;
            Object[] result = qryResult.toFieldValues();
            String pk = qryResult.getPrimaryKey();
            FlowOverdueVO overdue = overdueMap.get(pk);
            result[5] = overdue != null && overdue.isOverdue() ? overdue.getOverdueDays() + DurationUnit.DAY.toString() : NCLangRes4VoTransl.getNCLangRes().getStrByID("101609", "UPP101609-000039");
            String string = duration = overdue == null ? "" : overdue.getDuration();
            if (duration == null) {
                duration = "";
            }
            result[4] = duration;
        }
        return list;
    }

    private String getStrFromObj(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    private Integer getIntFromObj(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return null;
    }

    private String getCheckmanNames(String billid) {
        String sql = "select checkman from pub_workflownote where approvestatus=0 and pk_billtype <>'XX' and actiontype<>'BIZ' and billversionpk=?";
        SQLParameter param = new SQLParameter();
        param.addParam(billid);
        IUAPQueryBS qryService = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        try {
            List rows = (List)qryService.executeQuery(sql, param, (ResultSetProcessor)new ColumnListProcessor());
            StringBuffer sb = new StringBuffer();
            int rowCount = rows.size();
            HashSet<String> ids = new HashSet<String>();
            for (int curRowIdx = 0; curRowIdx < rowCount; ++curRowIdx) {
                String uname;
                String checkman = (String)rows.get(curRowIdx);
                if (ids.contains(checkman) || StringUtil.isEmptyWithTrim((String)(uname = WorkflowRefactorCache.getUserNameById(checkman)))) continue;
                sb.append(uname);
                if (curRowIdx != rowCount - 1) {
                    sb.append(", ");
                }
                ids.add(checkman);
            }
            return sb.toString();
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

