/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.workflowqry.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pub.workflowqry.impl.DefaultWorknoteRefactor;
import nc.bs.pub.workflowqry.impl.WorkflowRefactorCache;
import nc.itf.org.IGroupQryService;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.itf.uap.pf.IWorkflowAdmin;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.org.GroupVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.workflowqry.WorkflowQueryResult;
import nc.vo.sm.UserVO;
import nc.vo.workflow.admin.FlowOverdueVO;
import nc.vo.workflow.admin.WorkflowManageContext;

public class DashboardWorknoteRefactor
extends DefaultWorknoteRefactor {
    private static final long serialVersionUID = -2274165974734044484L;
    private static IGroupQryService iGroupQryService = null;
    private static IPFWorkflowQry flowQryService = null;

    @Override
    public List<WorkflowQueryResult> refactorBS(List<Object[]> toBeRefactored) throws BusinessException {
        ArrayList<WorkflowQueryResult> list = new ArrayList<WorkflowQueryResult>();
        ArrayList<String> pk_checkflows = new ArrayList<String>();
        HashSet<String> pks = new HashSet<String>();
        for (Object[] objectArray : toBeRefactored) {
            pks.add(this.getStrFromObj(objectArray[16]));
        }
        HashMap<String, ArrayList<UserVO>> mapjkr = this.findsupervisor(pks);
        for (Object[] row : toBeRefactored) {
            Object[] result = new Object[15];
            String senddate = this.getStrFromObj(row[0]);
            String billtype = this.getStrFromObj(row[2]);
            String billno = this.getStrFromObj(row[3]);
            String billid = this.getStrFromObj(row[4]);
            String checknote = this.getStrFromObj(row[5]);
            String pk_org = this.getStrFromObj(row[6]);
            String senderman = this.getStrFromObj(row[7]);
            String checkman = this.getStrFromObj(row[8]);
            Integer approvestatus = this.getIntFromObj(row[10]);
            Integer workflow_type = this.getIntFromObj(row[11]);
            String pk_checkflow = this.getStrFromObj(row[12]);
            String pk_group = this.getStrFromObj(row[14]);
            String processdefid = this.getStrFromObj(row[16]);
            pk_checkflows.add(pk_checkflow);
            WorkflowManageContext context = new WorkflowManageContext();
            context.setBillId(billid);
            context.setBillNo(billno);
            context.setBillType(billtype);
            context.setApproveStatus(approvestatus);
            context.setFlowType(workflow_type);
            context.setSendman(senderman);
            context.setWorkflownotePk(pk_checkflow);
            result[0] = pk_org;
            result[1] = pk_group;
            result[2] = checkman;
            Map<String, Object> map = WorkflowRefactorCache.getParentBilltypeByBilltype(billtype);
            result[3] = map.get("parentbilltype");
            UFDateTime sendTime = null;
            if (!StringUtil.isEmptyWithTrim((String)senddate)) {
                sendTime = new UFDateTime(senddate);
                result[5] = sendTime;
            }
            result[6] = checknote;
            result[7] = billno;
            result[13] = mapjkr.get(processdefid);
            result[14] = map.get("billtype");
            list.add(new WorkflowQueryResult(pk_checkflow, result, row, context));
        }
        IWorkflowAdmin iWorkflowAdmin = (IWorkflowAdmin)NCLocator.getInstance().lookup(IWorkflowAdmin.class);
        Map<String, FlowOverdueVO> overdueMap = iWorkflowAdmin.getWorknoteOverdueBatch(pk_checkflows.toArray(new String[0]));
        for (WorkflowQueryResult qryResult : list) {
            String duration;
            Object[] result = qryResult.toFieldValues();
            String pk = qryResult.getPrimaryKey();
            FlowOverdueVO overdue = overdueMap.get(pk);
            result[8] = overdue.getOverdueDays();
            String string = duration = overdue == null ? "" : overdue.getDuration();
            if (duration == null) {
                duration = "";
            }
            result[4] = overdue.getTimeLimit();
            result[9] = overdue.getTimeRemind();
            result[10] = overdue.isNeedRemind();
            result[11] = overdue.isOverdue();
            result[12] = overdue.getOverdueDays();
        }
        return list;
    }

    private String getStrFromObj(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    private Integer getIntFromObj(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return null;
    }

    private static IGroupQryService getIGroupQryService() {
        if (iGroupQryService == null) {
            iGroupQryService = (IGroupQryService)NCLocator.getInstance().lookup(IGroupQryService.class);
        }
        return iGroupQryService;
    }

    public static String getGroupNameByPk(String pk_group) {
        GroupVO[] vos = null;
        try {
            vos = DashboardWorknoteRefactor.getIGroupQryService().queryGroupVOsByPKS(new String[]{pk_group});
        }
        catch (BusinessException e) {
            Logger.error((Object)((Object)e));
        }
        return vos[0] == null ? "" : vos[0].getName();
    }

    private static IPFWorkflowQry getIPFWorkflowQry() {
        if (flowQryService == null) {
            flowQryService = (IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class);
        }
        return flowQryService;
    }

    private List<UserVO> findUser(String processdefid, String pk_wf_instance) {
        try {
            return DashboardWorknoteRefactor.getIPFWorkflowQry().queryWfProcess(processdefid, pk_wf_instance);
        }
        catch (Exception e) {
            Logger.error((Object)e);
            return null;
        }
    }

    private HashMap<String, ArrayList<UserVO>> findsupervisor(HashSet<String> pks) {
        try {
            return DashboardWorknoteRefactor.getIPFWorkflowQry().queryWfProcessForSupervisors(pks);
        }
        catch (Exception e) {
            Logger.error((Object)e);
            return null;
        }
    }
}

