/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.workflowqry.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pub.workflowqry.impl.DefaultInstanceRefactor;
import nc.bs.pub.workflowqry.impl.WorkflowRefactorCache;
import nc.itf.org.IGroupQryService;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.itf.uap.pf.IWorkflowAdmin;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.org.GroupVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.workflowqry.WorkflowQueryResult;
import nc.vo.sm.UserVO;
import nc.vo.workflow.admin.FlowOverdueVO;
import nc.vo.workflow.admin.WorkflowManageContext;

public class DashboardInstanceRefactor
extends DefaultInstanceRefactor {
    private static final long serialVersionUID = 6095338449331769590L;
    private static IGroupQryService iGroupQryService = null;
    private static IPFWorkflowQry flowQryService = null;

    @Override
    public List<WorkflowQueryResult> refactorBS(List<Object[]> toBeRefactored) throws BusinessException {
        ArrayList<WorkflowQueryResult> list = new ArrayList<WorkflowQueryResult>();
        IWorkflowAdmin admin = (IWorkflowAdmin)NCLocator.getInstance().lookup(IWorkflowAdmin.class);
        ArrayList<String> pkList = new ArrayList<String>();
        for (Object[] row : toBeRefactored) {
            Object[] result = new Object[13];
            String billmaker = this.getStrFromObj(row[0]);
            String startts = this.getStrFromObj(row[1]);
            String endts = this.getStrFromObj(row[2]);
            String billtype = this.getStrFromObj(row[3]);
            String billno = this.getStrFromObj(row[4]);
            String billid = this.getStrFromObj(row[5]);
            String pk_org = this.getStrFromObj(row[6]);
            Integer procstatus = this.getIntFromObj(row[7]);
            String procresult = this.getStrFromObj(row[8]);
            Integer workflow_type = this.getIntFromObj(row[9]);
            String pk_wf_instance = this.getStrFromObj(row[10]);
            String pk_group = this.getStrFromObj(row[11]);
            String processdefid = this.getStrFromObj(row[12]);
            pkList.add(pk_wf_instance);
            if (StringUtil.isEmptyWithTrim((String)pk_org)) {
                pk_org = WorkflowRefactorCache.getPk_orgOfInstance(pk_wf_instance);
            }
            WorkflowManageContext context = new WorkflowManageContext();
            context.setBillId(billid);
            context.setBillNo(billno);
            context.setBillType(billtype);
            context.setApproveStatus(procstatus);
            context.setFlowType(workflow_type);
            context.setFlowinstancePk(pk_wf_instance);
            result[0] = pk_org;
            result[1] = pk_group;
            result[2] = billmaker;
            Map<String, Object> map = WorkflowRefactorCache.getParentBilltypeByBilltype(billtype);
            result[3] = map.get("parentbilltype");
            UFDateTime beginTime = null;
            if (!StringUtil.isEmptyWithTrim((String)startts)) {
                beginTime = new UFDateTime(startts);
                result[4] = beginTime;
            }
            result[5] = billno;
            result[11] = this.findUser(processdefid, pk_wf_instance);
            result[12] = map.get("billtype");
            list.add(new WorkflowQueryResult(pk_wf_instance, result, row, context));
        }
        Map<String, FlowOverdueVO> overdueMap = admin.getFlowInstanceOverdue(pkList.toArray(new String[pkList.size()]));
        for (WorkflowQueryResult qryResult : list) {
            Object[] result = qryResult.toFieldValues();
            String pk = qryResult.getPrimaryKey();
            FlowOverdueVO overdue = overdueMap.get(pk);
            if (overdue == null) continue;
            result[6] = overdue.isOverdue();
            result[7] = overdue.getTimeLimit();
            result[8] = overdue.isNeedRemind();
            result[9] = overdue.getTimeRemind();
            result[10] = overdue.getDuration();
        }
        return list;
    }

    private String getStrFromObj(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    private Integer getIntFromObj(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return null;
    }

    private static IGroupQryService getIGroupQryService() {
        if (iGroupQryService == null) {
            iGroupQryService = (IGroupQryService)NCLocator.getInstance().lookup(IGroupQryService.class);
        }
        return iGroupQryService;
    }

    public static String getGroupNameByPk(String pk_group) {
        GroupVO[] vos = null;
        try {
            vos = DashboardInstanceRefactor.getIGroupQryService().queryGroupVOsByPKS(new String[]{pk_group});
        }
        catch (BusinessException e) {
            Logger.error((Object)((Object)e));
        }
        return vos[0] == null ? "" : vos[0].getName();
    }

    private static IPFWorkflowQry getIPFWorkflowQry() {
        if (flowQryService == null) {
            flowQryService = (IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class);
        }
        return flowQryService;
    }

    private List<UserVO> findUser(String processdefid, String pk_wf_instance) {
        try {
            return DashboardInstanceRefactor.getIPFWorkflowQry().queryWfProcess(processdefid, pk_wf_instance);
        }
        catch (Exception e) {
            Logger.error((Object)e);
            return null;
        }
    }
}

