/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pflock;

import nc.bs.logging.Logger;
import nc.bs.ml.NCLangResOnserver;
import nc.bs.pub.pflock.IConsistenceCheck;
import nc.bs.pub.pflock.ILockData;
import nc.bs.pub.pflock.IPfBusinessLock;
import nc.bs.uap.lock.PKLock;
import nc.vo.pub.BusinessException;
import nc.vo.uap.pf.PFBusinessException;

public class PfBusinessLock
implements IPfBusinessLock {
    private boolean locked = false;
    private String[] lockableAry = null;

    @Override
    public void lock(ILockData idata, IConsistenceCheck iConsistence) throws BusinessException {
        this.lockableAry = idata.getLockPks();
        if (this.lockableAry != null && this.lockableAry.length > 0) {
            this.locked = PKLock.getInstance().addBatchDynamicLock(this.lockableAry);
            if (!this.locked) {
                throw new PFBusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "UPPpfworkflow-000602"));
            }
            if (iConsistence != null) {
                iConsistence.checkConsistence();
            }
        }
    }

    @Override
    public void unLock() {
        try {
            if (this.locked && this.lockableAry != null) {
                PKLock.getInstance().releaseDynamicLock(this.lockableAry);
            }
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Deprecated
    public void lock_Manually(ILockData idata, IConsistenceCheck iConsistence) throws BusinessException {
        this.lockableAry = idata.getLockPks();
        if (this.lockableAry != null && this.lockableAry.length > 0) {
            this.locked = PKLock.getInstance().acquireBatchLock(this.lockableAry, null, null);
            if (!this.locked) {
                throw new PFBusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "UPPpfworkflow-000602"));
            }
            if (iConsistence != null) {
                iConsistence.checkConsistence();
            }
        }
    }

    @Deprecated
    public void unLock_Manually() {
        this.unLock();
    }
}

