/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pf;

import com.yonyou.cloud.iuap.iris.IrisNCLocator;
import com.yonyou.cloud.ncc.NCCSagas;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.server.util.NewObjectService;
import nc.bs.logging.Logger;
import nc.bs.ml.NCLangResOnserver;
import nc.bs.pf.pub.BillTypeCacheKey;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.pub.workflowqry.IFlowInstanceQuery;
import nc.itf.uap.pf.IPFConfig;
import nc.itf.uap.pf.IPFMetaModel;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.itf.uap.pf.IPfExchangeService;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.pf.IplatFormEntry;
import nc.itf.uap.pf.metadata.IFlowBizItf;
import nc.itf.uap.rbac.IRoleManageQuery;
import nc.jdbc.framework.JdbcSession;
import nc.jdbc.framework.PersistenceManager;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.exception.DbException;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.md.model.IBusinessEntity;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.cache.CacheManager;
import nc.vo.cache.ICache;
import nc.vo.cache.config.CacheConfig;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.ValueObject;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.compiler.PfParameterVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDouble;
import nc.vo.pub.pf.AssignableInfo;
import nc.vo.pub.pfflow.PfDataTypes;
import nc.vo.pub.pfflow.PfOperatorTypes;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.uap.pf.PFBusinessException;
import nc.vo.uap.pf.PFRuntimeException;
import nc.vo.uap.rbac.role.RoleVO;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WfTaskType;
import ncccloud.pubitf.riart.transtype.IPFMetaLightModel;
import nccloud.commons.lang.StringUtils;
import nccloud.impl.platform.common.util.CollectionUtils;
import nccloud.itf.uap.pf.NCCWorkFlowService;
import nccloud.pubitf.riart.pf.INccPFCrossServiceQuery;
import nccloud.pubitf.riart.pf.INccPFSagasCallback;
import nccloud.pubitf.riart.pf.INccPFSagasConfirmCall;
import nccloud.pubitf.riart.pf.INccWorkflowComponentExe;
import nccloud.riart.crossservice.pf.IRemoteCrossServicePrepareCheck;
import nccloud.vo.pf.flowinstance.NCCFlowInstanceVO;

public class PfUtilTools {
    private static IPfExchangeService exchangeService;

    public static Object instantizeObject(String pkBilltype, String checkClsName) throws BusinessException {
        String strModule = null;
        if (StringUtils.isNotBlank((CharSequence)checkClsName)) {
            INccPFCrossServiceQuery nccPFCrossServiceQuery = (INccPFCrossServiceQuery)NCLocator.getInstance().lookup(INccPFCrossServiceQuery.class.getName());
            strModule = nccPFCrossServiceQuery.getCrossServiceDevModuleByClassName(checkClsName);
        }
        if (StringUtils.isBlank(strModule)) {
            IPFMetaModel pfmeta = (IPFMetaModel)NCLocator.getInstance().lookup(IPFMetaModel.class.getName());
            strModule = pfmeta.queryModuleOfBilltype(pkBilltype);
        }
        if (StringUtil.isEmptyWithTrim(strModule)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000050", null, new String[]{pkBilltype}));
        }
        if (null != checkClsName && checkClsName.indexOf("#") > -1) {
            strModule = checkClsName.split("#")[1];
        }
        try {
            return NewObjectService.newInstance((String)strModule, (String)checkClsName);
        }
        catch (Exception e) {
            return NewObjectService.newInstance((String)checkClsName);
        }
    }

    public static Object instantizeObjectForNcc(String pkBilltype, String checkClsName, String pk_group) throws BusinessException {
        IPFMetaLightModel pfmeta = (IPFMetaLightModel)NCLocator.getInstance().lookup(IPFMetaLightModel.class.getName());
        String strModule = pfmeta.queryModuleOfBilltype(pkBilltype, pk_group);
        if (StringUtil.isEmptyWithTrim((String)strModule)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000050", null, new String[]{pkBilltype}));
        }
        if (null != checkClsName && checkClsName.indexOf("#") > -1) {
            strModule = checkClsName.split("#")[1];
        }
        try {
            return NewObjectService.newInstance((String)strModule, (String)checkClsName);
        }
        catch (Exception e) {
            return NewObjectService.newInstance((String)checkClsName);
        }
    }

    public static Object getBizRuleImpl(String billTypeStr) throws BusinessException {
        BillTypeCacheKey billType = new BillTypeCacheKey().buildBilltype(billTypeStr).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId());
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(billType);
        if (!StringUtil.isEmptyWithTrim((String)btVO.getCheckclassname())) {
            return PfUtilTools.findBizImplOfBilltype(billType.getBilltype(), btVO.getCheckclassname().trim());
        }
        String strTypeCode = PfUtilBaseTools.getRealBilltype(billTypeStr);
        btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(strTypeCode));
        if (!StringUtil.isEmptyWithTrim((String)btVO.getCheckclassname())) {
            return PfUtilTools.findBizImplOfBilltype(billType.getBilltype(), btVO.getCheckclassname().trim());
        }
        return null;
    }

    public static Object getEmendFlowImpl(String billTypeStr) throws BusinessException {
        BillTypeCacheKey billType = new BillTypeCacheKey().buildBilltype(billTypeStr).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId());
        BilltypeVO btVO = PfDataCache.getBillTypeInfo(billType);
        if (!StringUtil.isEmptyWithTrim((String)btVO.getEmendEnumClass())) {
            return PfUtilTools.findBizImplOfBilltype(billType.getBilltype(), btVO.getEmendEnumClass().trim());
        }
        String strTypeCode = PfUtilBaseTools.getRealBilltype(billTypeStr);
        btVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(strTypeCode));
        if (!StringUtil.isEmptyWithTrim((String)btVO.getEmendEnumClass())) {
            return PfUtilTools.findBizImplOfBilltype(billType.getBilltype(), btVO.getEmendEnumClass().trim());
        }
        return null;
    }

    public static Object findBizImplOfBilltype(String billType, String clzName) throws BusinessException {
        if (StringUtil.isEmptyWithTrim((String)clzName)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000051", null, new String[]{billType}));
        }
        return PfUtilTools.instantizeObject(billType, clzName.trim());
    }

    public static Object findBizImplOfBilltypeForNCC(String billType, String clzName, String pk_group) throws BusinessException {
        if (StringUtil.isEmptyWithTrim((String)clzName)) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000051", null, new String[]{billType}));
        }
        return PfUtilTools.instantizeObjectForNcc(billType, clzName.trim(), pk_group);
    }

    public static Class getClassByName(String className) throws BusinessException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new PFBusinessException(e.getMessage(), e);
        }
    }

    public static String getCurrentDatabase() {
        String userDataSource = InvocationInfoProxy.getInstance().getUserDataSource();
        if (userDataSource == null) {
            userDataSource = "design";
        }
        return userDataSource;
    }

    private static String getExpressValue(String macro, String type, Object leftValue, Object rightValue) {
        if (macro.equalsIgnoreCase("L")) {
            return leftValue.toString();
        }
        if (macro.equalsIgnoreCase("R")) {
            return rightValue.toString();
        }
        if (macro.equalsIgnoreCase("L-R")) {
            if (type.equalsIgnoreCase("INTEGER")) {
                return Integer.valueOf((Integer)leftValue - (Integer)rightValue).toString();
            }
            if (type.equalsIgnoreCase("Double")) {
                double value = ((UFDouble)leftValue).doubleValue() - Double.parseDouble((String)rightValue);
                return String.valueOf(value);
            }
        } else if (macro.equalsIgnoreCase("R-L")) {
            if (type.equalsIgnoreCase("INTEGER")) {
                return Integer.valueOf((Integer)rightValue - (Integer)leftValue).toString();
            }
            if (type.equalsIgnoreCase("Double")) {
                double value = ((UFDouble)rightValue).doubleValue() - Double.parseDouble((String)leftValue);
                return String.valueOf(value);
            }
        } else if (macro.equalsIgnoreCase("L+R") || macro.equalsIgnoreCase("R+L")) {
            if (type.equalsIgnoreCase("INTEGER")) {
                return Integer.valueOf((Integer)leftValue + (Integer)rightValue).toString();
            }
            if (type.equalsIgnoreCase("Double")) {
                double value = ((UFDouble)leftValue).doubleValue() + Double.parseDouble((String)rightValue);
                return String.valueOf(value);
            }
        }
        return macro;
    }

    public static boolean isTrueOrNot(Object InObject, String objType, String opType, String value) throws BusinessException {
        Logger.debug((Object)("****\u6bd4\u8f83\u7c7b\u578b:" + objType + "\u6bd4\u8f83\u7c7b\u578b\u8fd0\u7b97\u7b26:" + opType + "****"));
        if (PfDataTypes.VOID.getTag().equals(objType)) {
            return true;
        }
        if (PfDataTypes.UFBOOLEAN.getTag().equals(objType)) {
            return PfUtilTools.compareBoolean((UFBoolean)InObject, opType, value);
        }
        if (PfDataTypes.STRING.getTag().equals(objType)) {
            return PfUtilTools.compareString((String)InObject, opType, value);
        }
        if (PfDataTypes.INTEGER.getTag().equals(objType)) {
            return PfUtilTools.compareInteger((Integer)InObject, opType, value);
        }
        if (PfDataTypes.UFDOUBLE.getTag().equals(objType)) {
            return PfUtilTools.compareDouble((UFDouble)InObject, opType, value);
        }
        return false;
    }

    private static boolean compareDouble(UFDouble InObject, String opType, String value) {
        if (InObject == null) {
            InObject = new UFDouble(0);
        }
        if (value == null) {
            value = "0";
        }
        if (PfOperatorTypes.EQ.toString().equals(opType) || "=".equals(opType)) {
            return InObject.doubleValue() == Double.parseDouble(value);
        }
        if (PfOperatorTypes.GE.toString().equals(opType)) {
            return InObject.doubleValue() >= Double.parseDouble(value);
        }
        if (PfOperatorTypes.LE.toString().equals(opType)) {
            return InObject.doubleValue() <= Double.parseDouble(value);
        }
        if (PfOperatorTypes.NE.toString().equals(opType)) {
            return InObject.doubleValue() != Double.parseDouble(value);
        }
        if (PfOperatorTypes.LT.toString().equals(opType)) {
            return InObject.doubleValue() < Double.parseDouble(value);
        }
        if (PfOperatorTypes.GT.toString().equals(opType)) {
            return InObject.doubleValue() > Double.parseDouble(value);
        }
        return false;
    }

    private static boolean compareInteger(Integer InObject, String opType, String value) {
        if (InObject == null) {
            InObject = 0;
        }
        if (value == null) {
            value = "0";
        }
        Integer typeInteger = InObject;
        if (PfOperatorTypes.EQ.toString().equals(opType) || "=".equals(opType)) {
            return typeInteger == Integer.parseInt(value);
        }
        if (PfOperatorTypes.GE.toString().equals(opType)) {
            return typeInteger >= Integer.parseInt(value);
        }
        if (PfOperatorTypes.LE.toString().equals(opType)) {
            return typeInteger <= Integer.parseInt(value);
        }
        if (PfOperatorTypes.NE.toString().equals(opType)) {
            return typeInteger != Integer.parseInt(value);
        }
        if (PfOperatorTypes.LT.toString().equals(opType)) {
            return typeInteger < Integer.parseInt(value);
        }
        if (PfOperatorTypes.GT.toString().equals(opType)) {
            return typeInteger > Integer.parseInt(value);
        }
        return false;
    }

    private static boolean compareString(String strLeftValue, String opType, String strRightValue) {
        if (strLeftValue == null) {
            return false;
        }
        if (PfOperatorTypes.EQ.toString().equals(opType) || "=".equals(opType)) {
            return strLeftValue.equals(strRightValue);
        }
        if (PfOperatorTypes.LIKE.toString().equals(opType)) {
            return strLeftValue.indexOf(strRightValue) > -1;
        }
        if (PfOperatorTypes.NOTLIKE.toString().equals(opType)) {
            return strLeftValue.indexOf(strRightValue) == -1;
        }
        if (PfOperatorTypes.IN.toString().equals(opType)) {
            String[] tokens = StringUtil.split((String)strRightValue, (String)",");
            HashSet<String> hs = new HashSet<String>();
            for (int i = 0; i < (tokens == null ? 0 : tokens.length); ++i) {
                hs.add(tokens[i]);
            }
            return hs.contains(strLeftValue);
        }
        if (PfOperatorTypes.IN.toString().equals(opType)) {
            String[] tokens = StringUtil.split((String)strRightValue, (String)",");
            HashSet<String> hs = new HashSet<String>();
            for (int i = 0; i < (tokens == null ? 0 : tokens.length); ++i) {
                hs.add(tokens[i]);
            }
            return !hs.contains(strLeftValue);
        }
        if (PfOperatorTypes.GE.toString().equals(opType)) {
            return strLeftValue.compareTo(strRightValue) >= 0;
        }
        if (PfOperatorTypes.LE.toString().equals(opType)) {
            return strLeftValue.compareTo(strRightValue) <= 0;
        }
        if (PfOperatorTypes.NE.toString().equals(opType)) {
            return !strLeftValue.equals(strRightValue);
        }
        if (PfOperatorTypes.LT.toString().equals(opType)) {
            return strLeftValue.compareTo(strRightValue) < 0;
        }
        if (PfOperatorTypes.GT.toString().equals(opType)) {
            return strLeftValue.compareTo(strRightValue) > 0;
        }
        return false;
    }

    private static boolean compareBoolean(UFBoolean InObject, String opType, String value) {
        if (PfOperatorTypes.EQ.toString().equals(opType) || "=".equals(opType)) {
            return InObject.equals((Object)UFBoolean.valueOf((String)value));
        }
        return InObject.booleanValue();
    }

    public static boolean isLeftSameRight(String className, String method, String parameter, String funNote, String returnType, String ysf, String value, String className2, String method2, String parameter2, String funNote2) {
        if (funNote != null && funNote.trim().length() != 0 && funNote2 != null && funNote2.trim().length() != 0 && !funNote.equals(funNote2)) {
            return false;
        }
        if (className != null && className.trim().length() != 0 && className2 != null && className2.trim().length() != 0 ? !className.equals(className2) : className != null && className.trim().length() != 0 && (className2 == null || className2.trim().length() == 0)) {
            return false;
        }
        if (method != null && method.trim().length() != 0 && method2 != null && method2.trim().length() != 0 ? !method.equals(method2) : method != null && method.trim().length() != 0 && (method2 == null || method2.trim().length() == 0)) {
            return false;
        }
        return !(parameter != null && parameter.trim().length() != 0 && parameter2 != null && parameter2.trim().length() != 0 ? !parameter.equals(parameter2) : parameter != null && parameter.trim().length() != 0 && (parameter2 == null || parameter2.trim().length() == 0));
    }

    public static Object parseFunction(String functionNote, String className, String method, String parameter, PfParameterVO paraVo) throws BusinessException {
        INccPFCrossServiceQuery exeCom = (INccPFCrossServiceQuery)NCLocator.getInstance().lookup(INccPFCrossServiceQuery.class);
        UFBoolean ufb = exeCom.isCrossService(paraVo.m_billType);
        if (ufb.booleanValue()) {
            String destservice = exeCom.locationService(paraVo.m_billType);
            IRemoteCrossServicePrepareCheck preCheck = (IRemoteCrossServicePrepareCheck)IrisNCLocator.getInstance().lookup(IRemoteCrossServicePrepareCheck.class, destservice);
            return preCheck.parseFunction(functionNote, className, method, parameter, paraVo);
        }
        Object checkObject = null;
        Logger.debug((Object)("parseFunction\u89e3\u6790\u51fd\u6570\u7c7b\u540d:" + className + "\u65b9\u6cd5\u540d:" + method + "\u53c2\u6570:" + parameter + "\u5f00\u59cb"));
        if (className == null) {
            String errString = NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000052");
            throw new PFBusinessException(errString);
        }
        if (method == null) {
            String errString = NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000053");
            throw new PFBusinessException(errString);
        }
        checkObject = PfUtilTools.runClass(className, method, parameter, paraVo, null);
        if (functionNote != null) {
            Logger.debug((Object)("\u51fd\u6570#" + functionNote + "#\u8fd0\u884c\u8fd4\u56de\u503c\u4e3a\uff1a" + String.valueOf(checkObject)));
        } else {
            Logger.debug((Object)("\u51fd\u6570\u8fd0\u884c\u8fd4\u56de\u503c\u4e3a\uff1a" + String.valueOf(checkObject)));
        }
        Logger.debug((Object)("parseFunction\u89e3\u6790\u51fd\u6570\u7c7b\u540d:" + className + "\u65b9\u6cd5\u540d:" + method + "\u53c2\u6570:" + parameter + "****\u7ed3\u675f"));
        return checkObject;
    }

    private static void parseParmeter(String dealStr, Object[] paraObjects, Class[] paraClasses, int arrIndex, PfParameterVO paraVo) throws BusinessException {
        String fieldName = null;
        String datatype = null;
        int retIndex = dealStr.indexOf(":");
        if (retIndex < 0) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000054"));
        }
        try {
            fieldName = dealStr.substring(0, retIndex);
            paraObjects[arrIndex] = fieldName.startsWith("OBJ") ? (fieldName.endsWith("ARY") ? paraVo.m_userObjs : paraVo.m_userObj) : paraVo.m_standHeadVo.getAttributeValue(fieldName);
            datatype = dealStr.substring(retIndex + 1);
            paraClasses[arrIndex] = PfUtilBaseTools.parseTypeClass(datatype);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000055"), ex);
        }
    }

    public static boolean parseSyntax(String className, String method, String parameter, String funNote, String returnType, String ysf, String value, String className2, String method2, String parameter2, String funNote2, PfParameterVO paraVo) throws BusinessException {
        return PfUtilTools.parseSyntax(className, method, parameter, funNote, returnType, ysf, value, className2, method2, parameter2, funNote2, paraVo, null, null);
    }

    public static boolean parseSyntax(String className, String method, String parameter, String funNote, String returnType, String ysf, String value, String className2, String method2, String parameter2, String funNote2, PfParameterVO paraVo, StringBuffer errorMessageBuffer) throws BusinessException {
        return PfUtilTools.parseSyntax(className, method, parameter, funNote, returnType, ysf, value, className2, method2, parameter2, funNote2, paraVo, errorMessageBuffer, null);
    }

    public static boolean parseSyntax(String className, String method, String parameter, String funNote, String returnType, String ysf, String value, String className2, String method2, String parameter2, String funNote2, PfParameterVO paraVo, StringBuffer errorMessageBuffer, StringBuffer originalHintBuffer) throws BusinessException {
        String strTmp = "";
        Object leftObject = null;
        Object rightObject = null;
        strTmp = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow65", "PfUtilTools-0000");
        Logger.debug((Object)strTmp);
        if (className == null) {
            Logger.debug((Object)NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow65", "PfUtilTools-0001"));
            return false;
        }
        boolean retBool = true;
        leftObject = PfUtilTools.parseFunction(funNote, className, method, parameter, paraVo);
        if (className2 == null || className2.trim().length() == 0) {
            Logger.debug((Object)("\u7528\u6237\u8f93\u5165\u7684\u53f3\u503c\u4e3a\uff1a" + value));
        } else {
            if (PfUtilTools.isLeftSameRight(className, method, parameter, funNote, returnType, ysf, value, className2, method2, parameter2, funNote2)) {
                return true;
            }
            rightObject = PfUtilTools.parseFunction(funNote2, className2, method2, parameter2, paraVo);
            value = String.valueOf(rightObject);
            Logger.debug((Object)("\u53f3\u51fd\u6570\u7684\u8fd0\u884c\u503c\u4e3a:" + value));
        }
        retBool = PfUtilTools.isTrueOrNot(leftObject, returnType.toUpperCase(), ysf, value);
        if (retBool) {
            Logger.debug((Object)"\u51fd\u6570\u8fd0\u884c\u7ed3\u679c\u5224\u65ad\u6210\u529f!");
        } else {
            Logger.debug((Object)"\u51fd\u6570\u8fd0\u884c\u7ed3\u679c\u5224\u65ad\u4e0d\u6210\u529f!");
            if (errorMessageBuffer != null) {
                errorMessageBuffer.append(funNote);
                errorMessageBuffer.append("\n");
                errorMessageBuffer.append(leftObject);
                errorMessageBuffer.append("\n");
                errorMessageBuffer.append(ysf);
                errorMessageBuffer.append("\n");
                errorMessageBuffer.append(funNote2);
                errorMessageBuffer.append("\n");
                errorMessageBuffer.append(rightObject);
            }
            String MACRO_TAG = "%%";
            String originalHint = "";
            if (originalHintBuffer != null) {
                originalHint = originalHintBuffer.toString();
                String hintAfterParse = PfUtilTools.translateMacro(originalHint, MACRO_TAG, returnType, leftObject, value);
                originalHintBuffer.append(hintAfterParse);
            }
        }
        Logger.debug((Object)"parseSyntax\u89e3\u6790\u8bed\u6cd5\u7ed3\u675f");
        return retBool;
    }

    public static AggregatedValueObject runChangeData(String srcTranstype, String destTranstype, AggregatedValueObject sourceBillVO) throws BusinessException {
        return PfUtilTools.getExchangeService().runChangeData(srcTranstype, destTranstype, sourceBillVO, null);
    }

    public static AggregatedValueObject runChangeData(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject sourceBillVO, PfParameterVO paraVo) throws BusinessException {
        return PfUtilTools.getExchangeService().runChangeData(srcBillOrTranstype, destBillOrTranstype, sourceBillVO, paraVo);
    }

    private static synchronized IPfExchangeService getExchangeService() {
        if (exchangeService == null) {
            exchangeService = (IPfExchangeService)NCLocator.getInstance().lookup(IPfExchangeService.class);
        }
        return exchangeService;
    }

    public static AggregatedValueObject[] runChangeDataAry(String sourceBillType, String destBillType, AggregatedValueObject[] sourceBillVOs) throws BusinessException {
        return PfUtilTools.getExchangeService().runChangeDataAry(sourceBillType, destBillType, sourceBillVOs, null);
    }

    public static AggregatedValueObject[] runChangeDataAry(String srcBillOrTranstype, String destBillOrTranstype, AggregatedValueObject[] sourceBillVOs, PfParameterVO paraVo) throws BusinessException {
        return PfUtilTools.getExchangeService().runChangeDataAry(srcBillOrTranstype, destBillOrTranstype, sourceBillVOs, paraVo);
    }

    public static Object newImplOfClz(String sourceBillType, String destBillType, String fullyQualifiedClassName) throws BusinessException {
        Object changeObj = null;
        IPFMetaModel pfmeta = (IPFMetaModel)NCLocator.getInstance().lookup(IPFMetaModel.class.getName());
        String moduleOfDest = pfmeta.queryModuleOfBilltype(destBillType);
        String moduleOfSrc = pfmeta.queryModuleOfBilltype(sourceBillType);
        if (moduleOfDest == null || moduleOfDest.trim().length() == 0) {
            if (moduleOfSrc == null || moduleOfSrc.trim().length() == 0) {
                throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000056"));
            }
            changeObj = NewObjectService.newInstance((String)moduleOfSrc, (String)fullyQualifiedClassName);
            Logger.debug((Object)("OK-\u76ee\u7684\u5355\u636e\u6ca1\u6709\u6240\u5c5e\u6a21\u5757\uff0c\u4f46\u5728\u6765\u6e90\u5355\u636e\u6240\u5c5e\u6a21\u5757" + moduleOfSrc + "\u4e2d\u627e\u5230\u4ea4\u6362\u7c7b=" + changeObj));
        } else {
            try {
                changeObj = NewObjectService.newInstance((String)moduleOfDest, (String)fullyQualifiedClassName);
                Logger.debug((Object)("OK-\u5728\u76ee\u7684\u5355\u636e\u6240\u5c5e\u6a21\u5757" + moduleOfDest + "\u4e2d\u627e\u5230\u4ea4\u6362\u7c7b=" + changeObj));
            }
            catch (Exception e) {
                if (moduleOfSrc == null || moduleOfSrc.trim().length() == 0) {
                    throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000057"));
                }
                changeObj = NewObjectService.newInstance((String)moduleOfSrc, (String)fullyQualifiedClassName);
                Logger.debug((Object)("OK-\u5728\u76ee\u7684\u5355\u636e\u6240\u5c5e\u6a21\u5757\u4e2d\u627e\u4e0d\u5230\u4ea4\u6362\u7c7b\uff0c\u4f46\u5728\u6765\u6e90\u5355\u636e\u6240\u5c5e\u6a21\u5757" + moduleOfSrc + "\u4e2d\u627e\u5230\u4ea4\u6362\u7c7b=" + changeObj));
            }
        }
        Class<?> c = changeObj.getClass();
        Logger.debug((Object)(">>>OBJ=" + changeObj + ";CL=" + c.getProtectionDomain().getClassLoader()));
        Logger.debug((Object)(">>>LOC=" + c.getProtectionDomain().getCodeSource().getLocation()));
        return changeObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runClass(String className, String method, String parameter, PfParameterVO paraVo, Hashtable keyHas) throws BusinessException {
        Logger.debug((Object)"**********\u6267\u884c\u7c7bPfUtilTools.runClass()\u5f00\u59cb************");
        Logger.debug((Object)("\u6267\u884c\u7c7b:" + className + ";\u65b9\u6cd5:" + method + ";\u53c2\u6570:" + parameter));
        long begin = System.currentTimeMillis();
        StringTokenizer tmpStrToken = new StringTokenizer(parameter, ",");
        String[] paraStrs = new String[tmpStrToken.countTokens()];
        int index = 0;
        while (tmpStrToken.hasMoreTokens()) {
            paraStrs[index++] = tmpStrToken.nextElement().toString();
        }
        Object[] paraObjects = new Object[paraStrs.length];
        Class[] paraClasses = new Class[paraStrs.length];
        for (int i = 0; i < paraStrs.length; ++i) {
            boolean isVo = paraStrs[i].indexOf(".") > -1;
            int colonPos = paraStrs[i].indexOf(":");
            if (paraStrs[i].startsWith("&")) {
                Object valueObj;
                String paramKey = paraStrs[i].substring(1, colonPos);
                String strDataType = paraStrs[i].substring(colonPos + 1);
                Object v0 = valueObj = keyHas == null ? null : keyHas.get(paramKey);
                if (isVo) {
                    if (strDataType.endsWith("[]")) {
                        strDataType = strDataType.substring(0, strDataType.length() - 2);
                        int intAryLen = 0;
                        if (valueObj instanceof AggregatedValueObject[]) {
                            intAryLen = ((AggregatedValueObject[])valueObj).length;
                        } else if (valueObj instanceof ValueObject[]) {
                            intAryLen = ((ValueObject[])valueObj).length;
                        }
                        paraClasses[i] = PfUtilTools.getClassNameClass(strDataType, intAryLen);
                    } else {
                        paraClasses[i] = PfUtilTools.getClassByName(strDataType);
                    }
                } else {
                    paraClasses[i] = PfUtilBaseTools.parseTypeClass(strDataType);
                }
                paraObjects[i] = valueObj;
                continue;
            }
            if (isVo) {
                if (colonPos < 0) {
                    throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000058"));
                }
                String tmpbillType = paraStrs[i].substring(colonPos + 1);
                String voClassName = paraStrs[i].substring(0, colonPos);
                if (tmpbillType.equals("00")) {
                    throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000059"));
                }
                if (tmpbillType.equals("01")) {
                    if (voClassName.endsWith("[]")) {
                        paraObjects[i] = paraVo.m_preValueVos;
                        paraClasses[i] = AggregatedValueObject[].class;
                        continue;
                    }
                    paraObjects[i] = paraVo.m_preValueVo;
                    paraClasses[i] = AggregatedValueObject.class;
                    continue;
                }
                if (PfUtilTools.isSimilarBilltype(paraVo.m_billType, tmpbillType, paraVo.m_pkGroup)) {
                    if (voClassName.endsWith("[]")) {
                        paraObjects[i] = paraVo.m_preValueVos;
                        paraClasses[i] = PfUtilTools.getClassNameClass(voClassName.substring(0, voClassName.length() - 2), paraVo.m_preValueVos.length);
                        continue;
                    }
                    paraObjects[i] = paraVo.m_preValueVo;
                    paraClasses[i] = PfUtilTools.getClassByName(voClassName);
                    continue;
                }
                if (voClassName.endsWith("[]")) {
                    paraObjects[i] = PfUtilTools.getExchangeService().runChangeDataAry(paraVo.m_billType, tmpbillType, paraVo.m_preValueVos, paraVo);
                    paraClasses[i] = PfUtilTools.getClassNameClass(voClassName.substring(0, voClassName.length() - 2), paraVo.m_preValueVos.length);
                    continue;
                }
                paraObjects[i] = PfUtilTools.runChangeData(paraVo.m_billType, tmpbillType, paraVo.m_preValueVo, paraVo);
                paraClasses[i] = PfUtilTools.getClassByName(voClassName);
                continue;
            }
            PfUtilTools.parseParmeter(paraStrs[i], paraObjects, paraClasses, i, paraVo);
        }
        Object tmpObj = null;
        try {
            tmpObj = PfUtilTools.instantizeObject(paraVo.m_billType, className);
        }
        catch (Exception e) {
            Logger.warn((Object)("\u5728\u6a21\u5757\u4e2d\u627e\u4e0d\u5230\u7c7b\uff0c\u5219\u5047\u8bbe\u4e3aPUBLIC\u7c7b\uff1a" + className), (Throwable)e);
            try {
                Class<?> cls = Class.forName(className);
                tmpObj = cls.newInstance();
            }
            catch (ClassNotFoundException ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (InstantiationException ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (tmpObj == null) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000060", null, new String[]{className}));
        }
        Object retObj = null;
        try {
            Class<?> c = tmpObj.getClass();
            Method cm = c.getMethod(method, paraClasses);
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                if (cm.getReturnType().toString().equals("void")) {
                    cm.invoke(tmpObj, paraObjects);
                } else {
                    retObj = cm.invoke(tmpObj, paraObjects);
                }
            }
        }
        catch (SecurityException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            Throwable expt = e.getTargetException();
            Logger.error((Object)e.getMessage(), (Throwable)e);
            if (expt instanceof BusinessException) {
                throw (BusinessException)expt;
            }
            if (expt instanceof RemoteException && expt.getCause() instanceof BusinessException) {
                throw (BusinessException)expt.getCause();
            }
            throw new PFBusinessException(expt.getMessage(), expt);
        }
        long end = System.currentTimeMillis();
        Logger.debug((Object)("\u6267\u884c\u7c7b:" + className + ";\u65b9\u6cd5:" + method + ";\u53c2\u6570:" + parameter));
        Logger.debug((Object)("************\u6267\u884c\u7c7bPfUtilTools.runClass()\u7ed3\u675f,\u8017\u65f6=" + (end - begin) + "ms************"));
        return retObj;
    }

    private static boolean isSimilarBilltype(String aTypeCode, String bTypeCode, String pk_group) {
        boolean isSimilar = false;
        BilltypeVO aTypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(aTypeCode).buildPkGroup(pk_group));
        BilltypeVO bTypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(bTypeCode).buildPkGroup(pk_group));
        if (aTypeVO.getIstransaction() != null && aTypeVO.getIstransaction().booleanValue()) {
            BilltypeVO aParentTypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(aTypeVO.getParentbilltype()));
            Integer aParentStyle = aParentTypeVO.getBillstyle();
            if (bTypeVO.getIstransaction() != null && bTypeVO.getIstransaction().booleanValue()) {
                BilltypeVO bParentTypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(bTypeVO.getParentbilltype()));
                Integer bParentStyle = bParentTypeVO.getBillstyle();
                isSimilar = aTypeCode.equals(bTypeCode) || aParentTypeVO.getPk_billtypecode().equals(bParentTypeVO.getPk_billtypecode()) || aParentStyle != null && bParentStyle != null && aParentStyle.equals(bParentStyle);
            } else {
                Integer bStyle = bTypeVO.getBillstyle();
                isSimilar = aParentTypeVO.getPk_billtypecode().equals(bTypeCode) || aParentStyle != null && bStyle != null && aParentStyle.equals(bStyle);
            }
        } else {
            Integer aStyle = aTypeVO.getBillstyle();
            if (bTypeVO.getIstransaction() != null && bTypeVO.getIstransaction().booleanValue()) {
                BilltypeVO bParentTypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(bTypeVO.getParentbilltype()));
                Integer bParentStyle = bParentTypeVO.getBillstyle();
                isSimilar = bParentTypeVO.getPk_billtypecode().equals(aTypeCode) || bParentStyle != null && aStyle != null && bParentStyle.equals(aStyle);
            } else {
                Integer bStyle = bTypeVO.getBillstyle();
                isSimilar = aTypeCode.equals(bTypeCode) || aStyle != null && bStyle != null && aStyle.equals(bStyle);
            }
        }
        return isSimilar;
    }

    protected static String translateMacro(String content, String macro_tag, String type, Object leftValue, Object rightValue) {
        int pos_b = 0;
        int pos_e = 0;
        int offset = 0;
        boolean bFound = false;
        boolean isMatch = false;
        StringBuffer buffer = new StringBuffer();
        do {
            bFound = (pos_e = content.indexOf(macro_tag, pos_b)) != -1;
            int n = offset = bFound ? macro_tag.length() : 0;
            if (bFound) {
                if (isMatch) {
                    String macro = content.substring(pos_b, pos_e);
                    buffer.append(PfUtilTools.getExpressValue(macro, type, leftValue, rightValue));
                } else {
                    buffer.append(content.substring(pos_b, pos_e));
                }
                isMatch = !isMatch;
                continue;
            }
            buffer.append(content.substring(pos_b));
        } while ((pos_b = pos_e + offset) != -1);
        return buffer.toString();
    }

    private PfUtilTools() {
    }

    public static boolean isContinue(String pkCorp, String currUserPK, int configflag, String configedOperator) throws BusinessException {
        switch (configflag) {
            case 2: {
                return configedOperator.equals(currUserPK);
            }
            case 3: {
                IRoleManageQuery roleBS = (IRoleManageQuery)NCLocator.getInstance().lookup(IRoleManageQuery.class.getName());
                RoleVO[] roles = roleBS.queryRoleByUserID(currUserPK, pkCorp);
                if (roles == null || roles.length == 0) {
                    return false;
                }
                for (int i = 0; i < roles.length; ++i) {
                    if (!configedOperator.equals(roles[i].getPrimaryKey())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public static void regDataSourceForServlet(String dsName) throws BusinessException {
        InvocationInfoProxy.getInstance().setUserDataSource(dsName);
    }

    public static String approveSilently(String billType, String billId, String checkResult, String checkNote, String checkman, String[] dispatched_ids, String actioncode) throws Exception {
        Logger.debug((Object)"******\u8fdb\u5165PfUtilTools.approveSilently\u65b9\u6cd5*************************");
        Logger.debug((Object)("* billType=" + billType));
        Logger.debug((Object)("* billId=" + billId));
        Logger.debug((Object)("* checkResult=" + checkResult));
        Logger.debug((Object)("* checkNote=" + checkNote));
        Logger.debug((Object)("* checkman=" + checkman));
        IPFConfig bsConfig = (IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class.getName());
        AggregatedValueObject billVo = bsConfig.queryBillDataVO(billType, billId);
        if (billVo == null) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000063"));
        }
        IWorkflowMachine bsWorkflow = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class.getName());
        HashMap hmPfExParams = new HashMap();
        WorkflownoteVO worknoteVO = bsWorkflow.checkWorkFlow("APPROVE" + checkman, billType, billVo, hmPfExParams);
        if (worknoteVO != null) {
            worknoteVO.setChecknote(checkNote);
            if ("Y".equalsIgnoreCase(checkResult)) {
                worknoteVO.setApproveresult("Y");
            } else if ("N".equalsIgnoreCase(checkResult)) {
                worknoteVO.setApproveresult("N");
            } else if ("R".equalsIgnoreCase(checkResult)) {
                worknoteVO.getTaskInfo().getTask().setTaskType(WfTaskType.Backward.getIntValue());
                worknoteVO.getTaskInfo().getTask().setBackToFirstActivity(true);
            } else {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000064");
            }
            if (dispatched_ids != null && dispatched_ids.length > 0) {
                HashMap hm = new HashMap();
                for (int i = 0; i < dispatched_ids.length; ++i) {
                    int index = dispatched_ids[i].indexOf("#");
                    if (index < 0 || index > dispatched_ids[i].length() - 2) continue;
                    String userid = dispatched_ids[i].substring(0, index);
                    String actDefid = dispatched_ids[i].substring(index + 1);
                    if (hm.get(actDefid) == null) {
                        hm.put(actDefid, new HashSet());
                    }
                    ((HashSet)hm.get(actDefid)).add(userid);
                }
                Vector vecDispatch = worknoteVO.getTaskInfo().getAssignableInfos();
                for (int i = 0; i < vecDispatch.size(); ++i) {
                    HashSet hs;
                    AssignableInfo ai = (AssignableInfo)vecDispatch.get(i);
                    if (ai.getAssignedOperatorPKs() != null) {
                        ai.getAssignedOperatorPKs().clear();
                    }
                    if (ai.getOuAssignedUsers() != null) {
                        ai.getOuAssignedUsers().clear();
                    }
                    if ((hs = (HashSet)hm.get(ai.getActivityDefId())) == null) continue;
                    for (String userId : hs) {
                        if (ai.getAssignedOperatorPKs().contains(userId)) continue;
                        ai.getAssignedOperatorPKs().add(userId);
                    }
                }
            }
        } else {
            Logger.debug((Object)"checkWorkflow\u8fd4\u56de\u7684\u7ed3\u679c\u4e3anull");
        }
        IplatFormEntry pff = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class.getName());
        pff.processAction(actioncode + checkman, billType, worknoteVO, billVo, null, hmPfExParams);
        return null;
    }

    public static String joinHtml(String billHtml, String approveHtml) {
        billHtml = "<head><body>" + billHtml + "<hr>" + approveHtml + "</body></html>";
        return billHtml;
    }

    public static String queryTSByVO(SuperVO vo) throws BusinessException {
        BaseDAO baseDAO = new BaseDAO();
        String sql = "select ts from " + vo.getTableName() + " where " + vo.getPKFieldName() + " = ?";
        SQLParameter param = new SQLParameter();
        param.addParam(vo.getPrimaryKey());
        Object objTs = baseDAO.executeQuery(sql, param, (ResultSetProcessor)new ColumnProcessor());
        return objTs == null ? null : objTs.toString();
    }

    public static Class getClassNameClass(String className, int intLen) throws BusinessException {
        AggregatedValueObject[] retVos = PfUtilBaseTools.pfInitVos(className, intLen);
        return retVos.getClass();
    }

    public static String[] getOrgInfoByPK(String pkOrg) {
        if (StringUtil.isEmptyWithTrim((String)pkOrg)) {
            return null;
        }
        String sql = "select code, name from org_orgs where pk_org=?";
        SQLParameter param = new SQLParameter();
        param.addParam(pkOrg);
        BaseDAO baseDAO = new BaseDAO();
        try {
            List res = (List)baseDAO.executeQuery(sql, param, (ResultSetProcessor)new ArrayListProcessor());
            if (res != null && res.size() != 0) {
                Object[] arrs = (Object[])res.get(0);
                return new String[]{(String)arrs[0], (String)arrs[1]};
            }
        }
        catch (DAOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getMultiCurText(String name1, String name2, String name3, String name4, String name5, String name6) {
        int curCode = MultiLangContext.getInstance().getCurrentLangSeq();
        String curName = PfUtilTools.getNameBySeq(name1, name2, name3, name4, name5, name6, curCode);
        if (StringUtil.isEmptyWithTrim((String)curName)) {
            int mainCode = MultiLangContext.getInstance().getEnableLangVOs()[0].getLangseq();
            curName = PfUtilTools.getNameBySeq(name1, name2, name3, name4, name5, name6, mainCode);
        }
        return curName;
    }

    private static String getNameBySeq(String name1, String name2, String name3, String name4, String name5, String name6, int code) {
        switch (code) {
            case 1: {
                return name1;
            }
            case 2: {
                return name2;
            }
            case 3: {
                return name3;
            }
            case 4: {
                return name4;
            }
            case 5: {
                return name5;
            }
            case 6: {
                return name6;
            }
        }
        return name1;
    }

    public static String approveSilentlyWithWorkNotePk(String billType, String billId, String checkResult, String checkNote, String checkman, String[] dispatched_ids, String worknote_pk) throws Exception {
        Logger.debug((Object)"******\u8fdb\u5165PfUtilTools.approveSilently\u65b9\u6cd5*************************");
        Logger.debug((Object)("* billType=" + billType));
        Logger.debug((Object)("* billId=" + billId));
        Logger.debug((Object)("* checkResult=" + checkResult));
        Logger.debug((Object)("* checkNote=" + checkNote));
        Logger.debug((Object)("* checkman=" + checkman));
        IPFConfig bsConfig = (IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class.getName());
        AggregatedValueObject billVo = bsConfig.queryBillDataVO(billType, billId);
        if (billVo == null) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000063"));
        }
        IWorkflowMachine bsWorkflow = (IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class.getName());
        HashMap hmPfExParams = new HashMap();
        WorkflownoteVO worknoteVO = bsWorkflow.checkWorkflowActions(billType, billId, worknote_pk);
        if (worknoteVO != null) {
            worknoteVO.setChecknote(checkNote);
            if ("Y".equalsIgnoreCase(checkResult)) {
                worknoteVO.setApproveresult("Y");
            } else if ("N".equalsIgnoreCase(checkResult)) {
                worknoteVO.setApproveresult("N");
            } else if ("R".equalsIgnoreCase(checkResult)) {
                worknoteVO.getTaskInfo().getTask().setTaskType(WfTaskType.Backward.getIntValue());
                worknoteVO.getTaskInfo().getTask().setBackToFirstActivity(true);
            } else {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000064");
            }
            if (dispatched_ids != null && dispatched_ids.length > 0) {
                HashMap hm = new HashMap();
                for (int i = 0; i < dispatched_ids.length; ++i) {
                    int index = dispatched_ids[i].indexOf("#");
                    if (index < 0 || index > dispatched_ids[i].length() - 2) continue;
                    String userid = dispatched_ids[i].substring(0, index);
                    String actDefid = dispatched_ids[i].substring(index + 1);
                    if (hm.get(actDefid) == null) {
                        hm.put(actDefid, new HashSet());
                    }
                    ((HashSet)hm.get(actDefid)).add(userid);
                }
                Vector vecDispatch = worknoteVO.getTaskInfo().getAssignableInfos();
                for (int i = 0; i < vecDispatch.size(); ++i) {
                    HashSet hs;
                    AssignableInfo ai = (AssignableInfo)vecDispatch.get(i);
                    if (ai.getAssignedOperatorPKs() != null) {
                        ai.getAssignedOperatorPKs().clear();
                    }
                    if (ai.getOuAssignedUsers() != null) {
                        ai.getOuAssignedUsers().clear();
                    }
                    if ((hs = (HashSet)hm.get(ai.getActivityDefId())) == null) continue;
                    for (String userId : hs) {
                        if (ai.getAssignedOperatorPKs().contains(userId)) continue;
                        ai.getAssignedOperatorPKs().add(userId);
                    }
                }
            }
        } else {
            Logger.debug((Object)"checkWorkflow\u8fd4\u56de\u7684\u7ed3\u679c\u4e3anull");
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "busitypehint-000066"));
        }
        IplatFormEntry pff = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class.getName());
        pff.processAction("APPROVE" + checkman, billType, worknoteVO, billVo, null, hmPfExParams);
        return null;
    }

    public static boolean hasflowDef(String transOrBiiType, AggregatedValueObject billVo, WorkflowTypeEnum flowEnum) throws BusinessException {
        IFlowBizItf fbi = PfMetadataTools.getBizItfImpl(billVo, IFlowBizItf.class);
        if (fbi == null) {
            throw new PFRuntimeException(NCLangResOnserver.getInstance().getStrByID("pfworkflow1", "PfUtilClient-000000"));
        }
        IWorkflowDefine wfDefine = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class);
        Logger.debug((Object)("\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49: billType=" + transOrBiiType + ";pkOrg=" + fbi.getPkorg() + ";userId=" + fbi.getBillMaker() + ";\u5f00\u59cb"));
        boolean isStepIntoFlow = false;
        if (flowEnum == null) {
            try {
                isStepIntoFlow = wfDefine.queryIsStepIntoFlow(billVo.getParentVO().getPrimaryKey(), transOrBiiType, null);
            }
            catch (DbException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return isStepIntoFlow;
        }
        try {
            isStepIntoFlow = wfDefine.queryIsStepIntoFlow(billVo.getParentVO().getPrimaryKey(), transOrBiiType, null);
        }
        catch (DbException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (isStepIntoFlow) {
            NCCFlowInstanceVO[] resultInstance = ((IFlowInstanceQuery)NCLocator.getInstance().lookup(IFlowInstanceQuery.class)).findFlowInstancesByBillIdAndBillTypeAppendOrderByCondition(billVo.getParentVO().getPrimaryKey(), transOrBiiType);
            BasicWorkflowProcess wf = null;
            try {
                wf = PfDataCache.getWorkflowProcess(resultInstance[0].getProcessdefid());
            }
            catch (XPDLParserException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BusinessException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            WorkflownoteVO[] notevos = ((IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class)).queryWorkitems(billVo.getParentVO().getPrimaryKey(), transOrBiiType, 0, 0);
            if (resultInstance.length == 1 && (notevos.length == 0 || notevos == null)) {
                return false;
            }
            if (wf != null && wf.getActivities().size() == 1) {
                return false;
            }
        }
        boolean hasFlow = false;
        if (flowEnum.getIntValue() == WorkflowTypeEnum.Approveflow.getIntValue() || flowEnum.getIntValue() == WorkflowTypeEnum.SubApproveflow.getIntValue() ? (hasFlow = wfDefine.hasValidProcessDef(InvocationInfoProxy.getInstance().getGroupId(), transOrBiiType, fbi.getPkorg(), fbi.getBillMaker(), fbi.getEmendEnum(), WorkflowTypeEnum.Approveflow.getIntValue())) : (hasFlow = wfDefine.hasValidProcessDef(InvocationInfoProxy.getInstance().getGroupId(), transOrBiiType, fbi.getPkorg(), fbi.getBillMaker(), fbi.getEmendEnum(), WorkflowTypeEnum.Workflow.getIntValue()))) {
            return hasFlow;
        }
        return hasFlow;
    }

    public static WorkflowTypeEnum runningFlowStatus(String transOrBiiType, String billid) throws BusinessException {
        NCCFlowInstanceVO[] resultInstance = ((IFlowInstanceQuery)NCLocator.getInstance().lookup(IFlowInstanceQuery.class)).findFlowInstancesByBillIdAndBillType(billid, transOrBiiType);
        if (resultInstance != null && resultInstance.length > 0) {
            BasicWorkflowProcess wf = null;
            try {
                wf = PfDataCache.getWorkflowProcess(resultInstance[0].getProcessdefid());
            }
            catch (XPDLParserException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BusinessException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            WorkflownoteVO[] notevos = ((IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class)).queryWorkitems(billid, transOrBiiType, 0, 0);
            if (resultInstance.length == 1 && (notevos.length == 0 || notevos == null)) {
                return null;
            }
            if (wf != null && wf.getActivities().size() == 1) {
                return null;
            }
            if (Integer.valueOf(resultInstance[0].getWorkflow_type()).intValue() == WorkflowTypeEnum.Approveflow.getIntValue()) {
                return WorkflowTypeEnum.Approveflow;
            }
            if (Integer.valueOf(resultInstance[0].getWorkflow_type()).intValue() == WorkflowTypeEnum.Workflow.getIntValue()) {
                return WorkflowTypeEnum.Workflow;
            }
            return null;
        }
        return null;
    }

    public static WorkflowTypeEnum[] runningFlowStatus(String transOrBiiType, String[] billids) throws BusinessException {
        NCCFlowInstanceVO[] resultInstance = ((IFlowInstanceQuery)NCLocator.getInstance().lookup(IFlowInstanceQuery.class)).findFlowInstancesByBillIdAndBillType(transOrBiiType, billids);
        if (resultInstance == null) {
            return null;
        }
        HashMap<String, NCCFlowInstanceVO> instanceArray = new HashMap<String, NCCFlowInstanceVO>();
        for (NCCFlowInstanceVO instancevo : resultInstance) {
            instanceArray.put(instancevo.getBillid(), instancevo);
        }
        WorkflowTypeEnum[] wtArray = new WorkflowTypeEnum[billids.length];
        for (int i = 0; i < billids.length; ++i) {
            boolean isOnlyOneAct = false;
            BasicWorkflowProcess wf = null;
            try {
                if (instanceArray.get(billids[i]) == null) {
                    wtArray[i] = null;
                    continue;
                }
                wf = PfDataCache.getWorkflowProcess(((NCCFlowInstanceVO)((Object)instanceArray.get(billids[i]))).getProcessdefid());
            }
            catch (XPDLParserException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BusinessException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            WorkflownoteVO[] notevos = ((IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class)).queryWorkitems(billids[i], transOrBiiType, 0, 0);
            if (notevos.length == 0 || notevos == null) {
                isOnlyOneAct = true;
            }
            if (wf != null && wf.getActivities().size() == 1) {
                isOnlyOneAct = true;
            }
            wtArray[i] = isOnlyOneAct ? null : (Integer.valueOf(((NCCFlowInstanceVO)((Object)instanceArray.get(billids[i]))).getWorkflow_type()).intValue() == WorkflowTypeEnum.Approveflow.getIntValue() ? WorkflowTypeEnum.Approveflow : (Integer.valueOf(((NCCFlowInstanceVO)((Object)instanceArray.get(billids[i]))).getWorkflow_type()).intValue() == WorkflowTypeEnum.Workflow.getIntValue() ? WorkflowTypeEnum.Workflow : null));
        }
        return wtArray;
    }

    public static void sendSSCMQAndMessage(String actionName, String billOrTranstype, WorkflownoteVO workflowVo, AggregatedValueObject billvo, Object userObj, HashMap hmPfExParams) throws BusinessException {
        CacheConfig config = new CacheConfig("workflowCache", false, 0L, 100, 2, 3);
        ICache tempcache = CacheManager.getInstance().getCache(config);
        try {
            PfUtilTools.exeConfirm(tempcache);
            if (tempcache.get((Object)(Thread.currentThread().getId() + "isSinglUnApprove")) != null) {
                return;
            }
            if (hmPfExParams != null && hmPfExParams.get("intelligentApv_Next") != null) {
                PfUtilTools.removeAsyncCache(tempcache);
                PfUtilTools.removeLocalCache(tempcache);
                hmPfExParams.remove("intelligentApv_Next");
                PfUtilTools.sscAutoApprove(actionName, billOrTranstype, workflowVo, billvo, userObj, hmPfExParams);
            }
            if (hmPfExParams != null && hmPfExParams.get("intelligentApv_NextRollback") != null) {
                PfUtilTools.removeAsyncCache(tempcache);
                PfUtilTools.removeLocalCache(tempcache);
                hmPfExParams.remove("intelligentApv_NextRollback");
                PfUtilTools.sscAutoUnApprove(actionName, billOrTranstype, null, billvo, userObj, hmPfExParams);
            } else {
                PfUtilTools.exeSplitSendAsyncMsg(tempcache, hmPfExParams);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            PfUtilTools.removeAsyncCache(tempcache);
            PfUtilTools.removeLocalCache(tempcache);
        }
    }

    private static void sscAutoApprove(String actionName, String billOrTranstype, WorkflownoteVO workflowVo, AggregatedValueObject billvo, Object userObj, HashMap hmPfExParams) throws BusinessException {
        IplatFormEntry entry = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class);
        WorkflownoteVO noteVO = ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).getCurrentWorkFlowNoteVO(actionName, billOrTranstype, billvo, null);
        noteVO.setApproveresult("Y");
        NCCWorkFlowService nccWorkFlowService = (NCCWorkFlowService)NCLocator.getInstance().lookup(NCCWorkFlowService.class);
        billvo = nccWorkFlowService.mobileAppUtilForQueryBillEntity(billOrTranstype, noteVO.getBillid());
        entry.processActionNoSagasStartEnd(actionName, billOrTranstype, noteVO, billvo, userObj, hmPfExParams);
    }

    private static void sscAutoUnApprove(String actionName, String billOrTranstype, WorkflownoteVO workflowVo, AggregatedValueObject billvo, Object userObj, HashMap hmPfExParams) throws BusinessException {
        IplatFormEntry entry = (IplatFormEntry)NCLocator.getInstance().lookup(IplatFormEntry.class);
        try {
            billvo = ((IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class)).queryBillDataVO(billOrTranstype, billvo.getParentVO().getPrimaryKey());
            entry.processActionNoSagasStartEnd(actionName, billOrTranstype, null, billvo, userObj, hmPfExParams);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    private static String getTs(String billType, String billid) throws DbException, BusinessException {
        String[] tableNameAndPKField = PfUtilTools.getTableNameAndPKField(billType);
        String tableName = tableNameAndPKField[0];
        String pkField = tableNameAndPKField[1];
        String sqlTs = "select ts from " + tableName + " where " + pkField + "='" + billid + "'";
        String tsInDB = PfUtilTools.queryTs(sqlTs);
        return tsInDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryTs(String strTsSql) throws DbException {
        PersistenceManager persist = null;
        try {
            persist = PersistenceManager.getInstance();
            JdbcSession jdbc = persist.getJdbcSession();
            Object objTs = jdbc.executeQuery(strTsSql, (ResultSetProcessor)new ColumnProcessor());
            String string = objTs == null ? null : objTs.toString();
            return string;
        }
        finally {
            if (persist != null) {
                persist.release();
            }
        }
    }

    private static String[] getTableNameAndPKField(String billType) throws BusinessException {
        String[] resultArray = new String[2];
        IBusinessEntity bean = PfMetadataTools.queryMetaOfBilltype(billType);
        resultArray[0] = bean.getTable().getName();
        resultArray[1] = bean.getTable().getPrimaryKeyName();
        return resultArray;
    }

    public static void exeConfirm(ICache tempcache) {
        String objuuid = InvocationInfoProxy.getInstance().getProperty("currentthread_uuid");
        if (objuuid == null) {
            return;
        }
        String currentthread_uuid = objuuid;
        Object objMessageList = tempcache.get((Object)(currentthread_uuid + "messageList"));
        if (objMessageList == null) {
            return;
        }
        List messageList = new ArrayList();
        messageList = (List)objMessageList;
        if (CollectionUtils.isEmpty(messageList)) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("messageList", messageList);
        paramMap.put("sendMessageBillMaker", InvocationInfoProxy.getInstance().getProperty("sendMessageBillMaker"));
        tempcache.remove((Object)(currentthread_uuid + "messageList"));
        NCCSagas.confirm(INccPFSagasConfirmCall.class, paramMap);
    }

    public static void removeAsyncCache(ICache tempcache) {
        String objuuid = InvocationInfoProxy.getInstance().getProperty("currentthread_uuid_sscList");
        if (objuuid == null) {
            return;
        }
        String currentthread_uuid = objuuid;
        tempcache.remove((Object)(currentthread_uuid + "sscList"));
        tempcache.remove((Object)(currentthread_uuid + "serviceName"));
    }

    public static void removeLocalCache(ICache tempcache) {
        tempcache.remove((Object)(Thread.currentThread().getId() + "isSinglUnApprove"));
        String objuuid = InvocationInfoProxy.getInstance().getProperty("currentthread_uuid");
        if (objuuid == null) {
            return;
        }
        String currentthread_uuid = objuuid;
        tempcache.remove((Object)(currentthread_uuid + "messageList"));
    }

    public static void exeSplitSendAsyncMsg(ICache tempcache, HashMap hmPfExParams) throws BusinessException {
        String objuuid = InvocationInfoProxy.getInstance().getProperty("currentthread_uuid_sscList");
        if (objuuid == null) {
            return;
        }
        String currentthread_uuid = objuuid;
        Object objList = tempcache.get((Object)(currentthread_uuid + "sscList"));
        Object objServiceName = tempcache.get((Object)(currentthread_uuid + "serviceName"));
        if (objList == null || objServiceName == null) {
            return;
        }
        List list = (List)objList;
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        PfUtilTools.removeAsyncCache(tempcache);
        HashMap serviceNameMap = new HashMap();
        for (Map map : list) {
            List reList = null;
            String serviceNameRe = (String)map.get("serviceName");
            reList = serviceNameMap.containsKey(serviceNameRe) ? (List)serviceNameMap.get(serviceNameRe) : new ArrayList();
            reList.add(map);
            serviceNameMap.put(serviceNameRe, reList);
        }
        for (Map.Entry entry : serviceNameMap.entrySet()) {
            if (hmPfExParams != null && ((String)entry.getKey()).equals(hmPfExParams.get("activity_workflow"))) {
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put("objList", (Serializable)entry.getValue());
                NCCSagas.downstreamCallBack(INccPFSagasCallback.class, map);
                continue;
            }
            PfUtilTools.exeSendSSCAndImg((String)entry.getKey(), (List)entry.getValue());
        }
    }

    private static void exeSendSSCAndImg(String serviceName, List<Map<String, Object>> list) throws BusinessException {
        INccWorkflowComponentExe exeCom = (INccWorkflowComponentExe)IrisNCLocator.getInstance().lookup(INccWorkflowComponentExe.class, serviceName);
        UFBoolean flag = exeCom.checkWorkflowComponentAll(list);
        if (flag.booleanValue()) {
            exeCom.exeWorkflowComponentAll(list);
        }
    }
}

