/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import nc.bs.framework.cluster.itf.AbstractClusterListener;
import nc.bs.framework.cluster.itf.BytesClusterMessage;
import nc.bs.framework.cluster.itf.ClusterMessage;
import nc.bs.framework.cluster.itf.ClusterMessageHeader;
import nc.bs.framework.codesync.scanner.ScanService;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.framework.core.ModuleDeployerAccess;
import nc.bs.logging.Logger;

public class PFClusterListener
extends AbstractClusterListener {
    public void onMessage(ClusterMessage message) {
        Logger.debug((Object)"\u6d41\u7a0b\u5e73\u53f0\u96c6\u7fa4\u6d88\u606f\u5904\u7406\u5f00\u59cb");
        Logger.debug((Object)"*****************************************************");
        BytesClusterMessage bytesMessage = (BytesClusterMessage)message;
        ClusterMessageHeader header = bytesMessage.getHeader("fileName");
        String fileName = header.getValue();
        Logger.debug((Object)("fileName=" + fileName));
        header = bytesMessage.getHeader("relativePath");
        String relativePath = header.getValue();
        Logger.debug((Object)("relativePath=" + relativePath));
        header = bytesMessage.getHeader("module");
        String module = header == null ? null : header.getValue();
        Logger.debug((Object)("module=" + module));
        header = message.getHeader("ts");
        String fileNameFullPath = RuntimeEnv.getInstance().getNCHome() + relativePath + fileName;
        File file = new File(fileNameFullPath);
        if (file.exists()) {
            if (String.valueOf(file.lastModified()).equals(header.getValue())) {
                this.updateModule(module);
            } else {
                this.createOrModifyFileAndUpdateModule(bytesMessage, module, file, false);
            }
        } else {
            this.createOrModifyFileAndUpdateModule(bytesMessage, module, file, true);
        }
        if (fileName.endsWith(".class") && fileName.startsWith("nc/ui/")) {
            Logger.debug((Object)"\u8fd8\u9700\u901a\u77e5\u5ba2\u6237\u7aef\u7c7b\u626b\u63cf\u5668");
            ScanService scan = new ScanService(System.getProperty("nc.server.location"));
            scan.rescan();
        }
        Logger.debug((Object)"*****************************************************");
        Logger.debug((Object)("\u6d41\u7a0b\u5e73\u53f0\u96c6\u7fa4\u6d88\u606f\u5904\u7406\u7ed3\u675f=" + fileNameFullPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrModifyFileAndUpdateModule(BytesClusterMessage bytesMessage, String module, File file, boolean createDir) {
        FilterOutputStream fos = null;
        try {
            if (createDir) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            fos = new BufferedOutputStream(new FileOutputStream(file));
            fos.write(bytesMessage.getBytes());
            ((BufferedOutputStream)fos).flush();
            this.updateModule(module);
        }
        catch (IOException e3) {
            Logger.error((Object)("\u96c6\u7fa4\u6d88\u606f\u521b\u5efa\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38:" + e3.getMessage()), (Throwable)e3);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e2) {
                    Logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
                fos = null;
            }
        }
    }

    private void updateModule(String module) {
        if (module != null) {
            ModuleDeployerAccess mda = (ModuleDeployerAccess)NCLocator.getInstance().lookup(ModuleDeployerAccess.class.getName());
            mda.updateModule(module);
        }
    }
}

