/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.mobile;

import java.util.ArrayList;
import java.util.Map;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pub.mobile.ShortMessageService;
import nc.bs.pub.mobile.WirelessManager;
import nc.bs.pub.pf.tx.TxCompletionChecker;
import nc.bs.uap.scheduler.ITask;
import nc.bs.uap.scheduler.ITaskBody;
import nc.bs.uap.scheduler.ITaskJudger;
import nc.itf.uap.pf.IPFMessageMetaService;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.msg.MessageMetaVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.mobile.MobileMsg;
import nc.vo.pub.pf.Pfi18nTools;
import nc.vo.uap.scheduler.TaskStatus;
import nc.vo.uap.scheduler.TimeConfigVO;

public class PfMobileSendTask
implements ITask {
    private MobileMsg mobileMsg;
    private TimeConfigVO m_tc;

    public PfMobileSendTask(MobileMsg mobileVO) {
        this.mobileMsg = mobileVO;
    }

    public String getName() {
        return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "PfMobileSendTask-000000");
    }

    public String getType() {
        return "PfMobileSendTask";
    }

    public ITaskJudger getTaskJudger() {
        return null;
    }

    public ITaskBody getTaskBody() {
        return new PfMobileSendTaskBody();
    }

    public TimeConfigVO getTimeConfig() {
        if (this.m_tc == null) {
            this.m_tc = new TimeConfigVO();
            this.m_tc.setJustInTime(true);
        }
        return this.m_tc;
    }

    class PfMobileSendTaskBody
    implements ITaskBody {
        PfMobileSendTaskBody() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws BusinessException {
            Logger.debug((Object)">>\u77ed\u4fe1\u53d1\u9001\u4efb\u52a1\u4f53:PfMobileSendTaskBody.execute() called");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Logger.debug((Object)e.getMessage());
            }
            PfMobileSendTask.this.mobileMsg.loadInvocationInfo();
            String txMark = PfMobileSendTask.this.mobileMsg.getTxMark();
            if (!StringUtil.isEmptyWithTrim((String)txMark) && !TxCompletionChecker.getInstance().isTxCompleted(txMark)) {
                return;
            }
            ShortMessageService sms = WirelessManager.getSMS();
            if (sms == null) {
                Logger.error((Object)">>\u627e\u4e0d\u5230\u6d3b\u52a8\u7684\u77ed\u4fe1\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c\u65e0\u6cd5\u53d1\u9001\u548c\u63a5\u6536\u77ed\u4fe1");
                return;
            }
            if (!sms.initialize()) {
                Logger.error((Object)">>\u77ed\u4fe1\u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25");
                return;
            }
            ArrayList<MessageMetaVO> metaList = new ArrayList<MessageMetaVO>();
            Map<String, MessageMetaVO> userMetaMap = PfMobileSendTask.this.mobileMsg.getUserMetaMap();
            for (int i = 0; i < PfMobileSendTask.this.mobileMsg.getTargetPhones().length; ++i) {
                String phone = PfMobileSendTask.this.mobileMsg.getTargetPhones()[i];
                boolean needml = this.needMl(phone);
                String msg = PfMobileSendTask.this.mobileMsg.getMsg();
                String originLang = InvocationInfoProxy.getInstance().getLangCode();
                String user = PfMobileSendTask.this.mobileMsg.getPhoneUserMap().get(phone);
                MessageMetaVO meta = userMetaMap.get(user);
                try {
                    String[] sids;
                    if (needml) {
                        String langcode = Pfi18nTools.getLangcodeOfUser(user);
                        InvocationInfoProxy.getInstance().setLangCode(langcode);
                        msg = PfMobileSendTask.this.mobileMsg.getMsgCallback().getLocalizedMsg(user);
                    }
                    if ((sids = PfMobileSendTask.this.mobileMsg.getSerialNumbers()) == null || sids.length <= i) {
                        Logger.debug((Object)("**\u5c1d\u8bd5\u53d1\u9001\u77ed\u4fe1\uff1a\u624b\u673a\u53f7=" + PfMobileSendTask.this.mobileMsg.getTargetPhones()[i] + ";\u5185\u5bb9=" + PfMobileSendTask.this.mobileMsg.getMsg()));
                        msg = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WfTaskManager-0002", null, new String[]{msg});
                        sms.sendMessages(new String[]{PfMobileSendTask.this.mobileMsg.getTargetPhones()[i]}, msg);
                    } else {
                        Logger.debug((Object)("**\u5c1d\u8bd5\u53d1\u9001\u77ed\u4fe1\uff1a\u624b\u673a\u53f7=" + PfMobileSendTask.this.mobileMsg.getTargetPhones()[i] + ";\u5185\u5bb9=" + PfMobileSendTask.this.mobileMsg.getMsg() + ";\u4f1a\u8bddID=" + sids[i]));
                        sms.sendMessage(PfMobileSendTask.this.mobileMsg.getTargetPhones()[i], msg, sids[i]);
                    }
                    meta.setTitle(msg);
                    metaList.add(meta);
                    continue;
                }
                finally {
                    InvocationInfoProxy.getInstance().setLangCode(originLang);
                }
            }
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metaList);
            Logger.debug((Object)">>\u77ed\u4fe1\u53d1\u9001\u4efb\u52a1\u4f53:PfMobileSendTaskBody.execute() end");
        }

        private boolean needMl(String phone) {
            return PfMobileSendTask.this.mobileMsg.getMsgCallback() != null && PfMobileSendTask.this.mobileMsg.getPhoneUserMap() != null && PfMobileSendTask.this.mobileMsg.getPhoneUserMap().containsKey(phone);
        }

        public void cancelExecute() throws BusinessException {
        }

        public TaskStatus getStatus() {
            return null;
        }
    }
}

